/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.AddFileDialog;
import com.gallery.GalleryRemote.CoreUtils;
import com.gallery.GalleryRemote.DroppableList;
import com.gallery.GalleryRemote.GRApplet;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.GalleryRemoteCore;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusBar;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.UploadProgress;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GRAppletMini
extends GRApplet
implements GalleryRemoteCore,
ActionListener,
DocumentListener,
ListSelectionListener,
PreferenceNames {
    public static final String MODULE = "AppletMini";
    JButton jUpload;
    JButton jAdd;
    StatusBar jStatusBar;
    JScrollPane jScrollPane;
    DroppableList jPicturesList;
    JCheckBox jResize;
    JPanel jInspector;
    JLabel captionLabel;
    JTextArea jCaption;
    JSplitPane jDivider;
    DefaultComboBoxModel galleries = null;
    Album album = null;
    Gallery gallery = null;
    boolean inProgress = false;
    boolean hasHadPictures = false;

    public GRAppletMini() {
        this.coreClass = "com.gallery.GalleryRemote.GalleryRemoteMini";
    }

    public void initUI() {
        SwingUtilities.updateComponentTreeUI(this);
        if (GalleryRemote.IS_MAC_OS_X) {
            UIManager.put("Label.font", UIManager.getFont("TitledBorder.font"));
            UIManager.put("TextField.font", UIManager.getFont("TitledBorder.font"));
            UIManager.put("Button.font", UIManager.getFont("TitledBorder.font"));
            UIManager.put("CheckBox.font", UIManager.getFont("TitledBorder.font"));
            UIManager.put("ComboBox.font", UIManager.getFont("TitledBorder.font"));
        }
        this.jbInit();
    }

    public void startup() {
        this.galleries = new DefaultComboBoxModel();
        GRApplet.AppletInfo info = this.getGRAppletInfo();
        this.gallery = info.gallery;
        this.galleries.addElement(this.gallery);
        ImageUtils.deferredTasks();
        this.album = new Album(this.gallery);
        this.album.setName(info.albumName);
        this.gallery.createRootAlbum().add(this.album);
        this.jPicturesList.setModel(this.album);
        this.jPicturesList.setInputMap(1, null);
        this.jPicturesList.setInputMap(0, null);
        this.jPicturesList.setInputMap(2, null);
        this.jPicturesList.setCellRenderer(new CoreUtils.FileCellRenderer());
        this.jResize.setSelected(GalleryRemote._().properties.getBooleanProperty("resizeBeforeUpload"));
        this.jStatusBar.setStatus(GRI18n.getString("MainFrame", "selPicToAdd"));
    }

    public void shutdown() {
        if (this.hasStarted && GalleryRemote._() != null) {
            if (this.jDivider != null) {
                GalleryRemote._().properties.setIntProperty("appletDividerLocation", this.jDivider.getDividerLocation());
            }
            GalleryRemote._().properties.write();
            GalleryRemote.shutdownInstance();
        }
    }

    public void shutdown(boolean shutdownOs) {
        this.shutdown();
    }

    public void flushMemory() {
    }

    public void preloadThumbnails(Iterator pictures) {
    }

    public ImageIcon getThumbnail(Picture p) {
        return null;
    }

    public StatusUpdate getMainStatusUpdate() {
        return this.jStatusBar;
    }

    public DefaultComboBoxModel getGalleries() {
        return this.galleries;
    }

    public void thumbnailLoadedNotify() {
    }

    public void setInProgress(boolean inProgress) {
        this.jUpload.setEnabled(!inProgress);
        this.jAdd.setEnabled(!inProgress);
        this.jPicturesList.setEnabled(!inProgress);
        this.jCaption.setEnabled(!inProgress);
        this.jResize.setEnabled(!inProgress);
        this.inProgress = inProgress;
        if (!inProgress && this.hasHadPictures) {
            try {
                this.getAppletContext().showDocument(new URL(this.getCodeBase().toString() + "add_photos_refresh.php"), "hack");
            }
            catch (MalformedURLException e1) {
                Log.logException(1, MODULE, e1);
            }
            this.hasHadPictures = false;
        }
    }

    public void addPictures(File[] files, int index, boolean select) {
        this.album.addPictures(files, index);
    }

    public void addPictures(Picture[] pictures, int index, boolean select) {
        this.album.addPictures(Arrays.asList(pictures), index);
    }

    public Album getCurrentAlbum() {
        return this.album;
    }

    public JList getPicturesList() {
        return this.jPicturesList;
    }

    protected void jbInit() {
        this.jUpload = new JButton();
        this.jAdd = new JButton();
        this.jStatusBar = new StatusBar(75);
        this.jScrollPane = new JScrollPane();
        this.jPicturesList = new DroppableList();
        this.jResize = new JCheckBox();
        this.jInspector = new JPanel(new GridBagLayout());
        this.captionLabel = new JLabel();
        this.jCaption = new JTextArea();
        this.jDivider = new JSplitPane(1);
        this.jScrollPane.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(), GRI18n.getString(MODULE, "pictures")));
        this.jUpload.setText(GRI18n.getString(MODULE, "Upload"));
        this.jAdd.setText(GRI18n.getString(MODULE, "Add"));
        JPanel jButtonPanel = new JPanel();
        jButtonPanel.setLayout(new GridLayout(1, 2, 5, 0));
        jButtonPanel.add(this.jAdd);
        jButtonPanel.add(this.jUpload);
        this.jResize.setToolTipText("<html>Resize pictures before uploading them for a faster upload.<br>The high-resolution original will not be available online.</html>");
        this.jResize.setText("Resize pictures before upload");
        this.captionLabel.setText("Caption:            ");
        this.jScrollPane.getViewport().add((Component)this.jPicturesList, null);
        this.jCaption.setLineWrap(true);
        this.jCaption.setEditable(false);
        this.jCaption.setFont(UIManager.getFont("Label.font"));
        this.jCaption.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.jDivider.setBorder(null);
        this.jDivider.setOneTouchExpandable(true);
        this.jDivider.setDividerLocation(GalleryRemote._().properties.getIntProperty("appletDividerLocation"));
        this.jScrollPane.setMinimumSize(new Dimension(100, 0));
        this.jInspector.setMinimumSize(new Dimension(0, 0));
        this.jDivider.setLeftComponent(this.jScrollPane);
        this.jDivider.setRightComponent(this.jInspector);
        this.jInspector.add((Component)this.captionLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.jInspector.add((Component)this.jCaption, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.jDivider, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jResize, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)jButtonPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.jStatusBar, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jAdd.addActionListener(this);
        this.jUpload.addActionListener(this);
        this.jCaption.getDocument().addDocumentListener(this);
        this.jPicturesList.addListSelectionListener(this);
        this.jResize.addActionListener(this);
        this.jPicturesList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                GRAppletMini.this.jListKeyPressed(e);
            }
        });
    }

    public void jListKeyPressed(KeyEvent e) {
        if (!this.inProgress) {
            int vKey = e.getKeyCode();
            Log.log(3, MODULE, "Key pressed: " + vKey);
            switch (vKey) {
                case 8: 
                case 127: {
                    CoreUtils.deleteSelectedPictures();
                    break;
                }
                case 37: {
                    CoreUtils.movePicturesUp();
                    break;
                }
                case 39: {
                    CoreUtils.movePicturesDown();
                    break;
                }
                case 38: {
                    CoreUtils.selectPrevPicture();
                    break;
                }
                case 40: {
                    CoreUtils.selectNextPicture();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.jAdd) {
            this.jStatusBar.setStatus(GRI18n.getString("MainFrame", "selPicToAdd"));
            File[] files = AddFileDialog.addFiles(this);
            if (files != null) {
                this.addPictures(files, -1, false);
                this.hasHadPictures = true;
            }
        } else if (source == this.jUpload) {
            this.gallery.doUploadFiles(new UploadProgress(DialogUtil.findParentWindow(this)));
        } else if (source == this.jResize) {
            GalleryRemote._().properties.setBooleanProperty("resizeBeforeUpload", this.jResize.isSelected());
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.textUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.textUpdate(e);
    }

    public void changedUpdate(DocumentEvent e) {
        this.textUpdate(e);
    }

    public void textUpdate(DocumentEvent e) {
        Picture p = (Picture)this.jPicturesList.getSelectedValue();
        if (p != null && e.getDocument() == this.jCaption.getDocument()) {
            p.setCaption(this.jCaption.getText());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        Picture p = (Picture)this.jPicturesList.getSelectedValue();
        if (p == null) {
            this.jCaption.setText("");
            this.jCaption.setEditable(false);
            this.jCaption.setBackground(UIManager.getColor("TextField.inactiveBackground"));
        } else {
            this.jCaption.setText(p.getCaption());
            this.jCaption.setEditable(true);
            this.jCaption.setBackground(UIManager.getColor("TextField.background"));
        }
    }
}

