/*
 * Galaxium Messenger
 * 
 * Copyright (C) 2008 Paul Burton <paulburton89@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Text;
using System.Collections.Generic;

using Gtk;
using Gdk;
using GLib;

using Galaxium.Gui.GtkGui;
using Galaxium.Gui;
using Galaxium.Core;
using Galaxium.Client;

namespace Galaxium.Protocol.Msn.GtkGui
{
	public sealed class BasicContactTreeNodeBuilder : ITreeNodeBuilder<HintTreeNodeRenderer>
	{
		public string ContextMenuExtensionPoint
		{
			get { return "/Galaxium/Gui/MSN/BasicContactTree/ContextMenu/Contact"; }
		}
		
		public bool HasDynamicChildNodes (TreeNodeContext context)
		{
			return false;
		}

		public Type NodeType
		{
			get { return typeof (MsnContact); }
		}

		public void RenderIcon (TreeNodeContext context, HintTreeNodeRenderer renderer, ITreeNodeWidget widget)
		{
			DefaultTreeNodeWidget nodeWidget = widget as DefaultTreeNodeWidget;
			
			if (nodeWidget != null)
			{
				CellRendererPixbuf cell = nodeWidget.GetPixbufRenderer ();
				Pixbuf pixbuf = null;
				
				if (cell != null)
				{
					MsnContact contact = context.NodeObject as MsnContact;
					
					if (contact != null)
					{
						if (contact.Presence == MsnPresence.Idle)
							pixbuf = IconUtility.GetIcon ("galaxium-idle", IconSizes.Small);
						else if (contact.Presence == MsnPresence.Offline)
							pixbuf = IconUtility.GetIcon ("galaxium-offline", IconSizes.Small);
						else if (!contact.IsInList(MsnListType.Reverse))
							pixbuf = IconUtility.GetIcon ("galaxium-status-reverse", IconSizes.Small);
						else if (contact.IsBlocked)
							pixbuf = IconUtility.GetIcon ("galaxium-status-block", IconSizes.Small);
						else if (contact.Presence == MsnPresence.Away)
							pixbuf = IconUtility.GetIcon ("galaxium-status-away", IconSizes.Small);
						else if (contact.Presence == MsnPresence.Brb)
							pixbuf = IconUtility.GetIcon ("galaxium-status-brb", IconSizes.Small);
						else if (contact.Presence == MsnPresence.Busy)
							pixbuf = IconUtility.GetIcon ("galaxium-status-busy", IconSizes.Small);
						else if (contact.Presence == MsnPresence.Lunch)
							pixbuf = IconUtility.GetIcon ("galaxium-status-lunch", IconSizes.Small);
						else if (contact.Presence == MsnPresence.Online)
							pixbuf = IconUtility.GetIcon ("galaxium-online", IconSizes.Small);
						else if (contact.Presence == MsnPresence.Phone)
							pixbuf = IconUtility.GetIcon ("galaxium-status-phone", IconSizes.Small);
					}
					
					renderer.RenderIcon (cell, pixbuf, false);
				}
			}
		}

		public void RenderText (TreeNodeContext context, HintTreeNodeRenderer renderer, ITreeNodeWidget widget)
		{
			DefaultTreeNodeWidget nodeWidget = widget as DefaultTreeNodeWidget;
			
			if (nodeWidget != null)
			{
				CellRendererText cell = nodeWidget.GetTextRenderer ();
					                    
				if (cell != null)
				{
					MsnContact contact = context.NodeObject as MsnContact;

					renderer.RenderText (cell, Markup.EscapeText (contact.DisplayIdentifier), false);
				}
			}
		}

		public void BuildDynamicChildNodes (TreeNodeContext context)
		{
		}

		public void NodeActivated (TreeNodeContext context)
		{
		}

		public string GetComparableContent (TreeNodeContext context)
		{
			MsnContact contact = context.NodeObject as MsnContact;
			return contact.DisplayIdentifier;
		}
	}
}
