namespace Galago
{
	using System;
	using System.Collections;

	public class SignalArgs : EventArgs
	{
		private object _ret;
		private object[] _args;

		public SignalArgs(object retval, object[] args)
		{
			_ret  = retval;
			_args = args;
		}

		public SignalArgs(object retval)
			: this(retval, null)
		{
		}

		public SignalArgs()
			: this(null, null)
		{
		}

		public object[] Args
		{
			get { return _args;  }
			set { _args = value; }
		}

		public object RetVal
		{
			get { return _ret;  }
			set { _ret = value; }
		}
	}
}
