/**
 * @file shutdown-daemon.c Sends the ShutDown command to the daemon.
 *
 * @Copyright (C) 2004-2006 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <libgalago/galago.h>
#include <dbus/dbus.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int
main(int argc, char **argv)
{
	DBusMessage *message;
	DBusError error;
	DBusConnection *dbus_conn;

	dbus_error_init(&error);

	dbus_conn = dbus_bus_get(DBUS_BUS_SESSION, &error);

	if (dbus_conn == NULL)
	{
		fprintf(stderr, "Error connecting to session bus: %s\n",
				error.message);
		dbus_error_free(&error);

		exit(1);
	}

	message = dbus_message_new_method_call(GALAGO_DBUS_SERVICE,
										   GALAGO_DBUS_CORE_OBJECT,
										   GALAGO_DBUS_CORE_INTERFACE,
										   "ShutDown");

	dbus_connection_send(dbus_conn, message, NULL);
	dbus_connection_flush(dbus_conn);

	dbus_message_unref(message);

	return 0;
}
