 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Project: gafix                                                         *
 * File: communications.c                                                 *
 * Copyright: (c) 2007 Sebastian Reichel                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

 /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This program is free software; you can redistribute it and/or modidy   *
 * it under the terms of GNU Public License as published by               *
 * the Free Software Foundation; either version 2 of the License, or      *
 * (at your option) any later version.                                    *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <gtk/gtk.h>
#include <cafix.h>
#include <string.h>

#include "gafix.h"
#include "progress.h"
#include "statusbar.h"
#include "communication.h"
#include "convert.h"
#include "tab.h"

void
receive ( void )
{
	int fdev;
	cafixdata * data;

	statusbar_write("receiving data from %s", tty);

	/* show the progress window */
	enable_progress_window ();

	/* open device */
	if ((fdev = cafix_open(tty, 5)) < 0) {
		perror("cafix_open");
		return;
	}

	data = g_malloc(sizeof(cafixdata));

	while(progress_cancel == FALSE) {

		/* update gtk_main loop */
		while ( gtk_events_pending () )
			gtk_main_iteration ();

		if (cafix_handshake_receive(fdev, data) == 0) { //receive handshake
			while (cafix_receive(fdev, data, &show_status) == 0) { //receive data
				enable_progress_window ();
				if (data->datatype == DATA_PG) {
					statusbar_write("Received Program: %s", data->name);

					/* create new page with name and data */
					gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), new_tab("** unsaved **", raw_to_cat(data->name, data->data)->str));
				}
				else {
					statusbar_write("The received data is not valid!");
				}
			}
			
			disable_progress_window ();
		}

	}

}

void
transmit ( void )
{
	int fdev;
	cafixdata * data;
	gint page = gtk_notebook_get_current_page( GTK_NOTEBOOK(notebook) );
	GString * title;
	gchar * text;
	gint text_len;

	/* get informations from program */
	title = g_string_new(get_label_of_tab (page));
	text = cat_to_raw (get_text_of_tab (page));
	text_len = strlen (text);

	/* check text len to avoid Communication Errors */
	if(text_len == 0) {
		statusbar_write("There is no data to be sent!");
		return;
	}
	
	statusbar_write("transmitting data to %s", tty);

	/* show the progress window */
	enable_progress_window();
	
	/* open device */
	if ((fdev = cafix_open(tty, 5)) < 0) {
		perror("cafix_open");
		return;
	}
	
	/* init cafixdata strucure */
	data = g_malloc(sizeof(cafixdata));
	
	/* send header */
	if(cafix_handshake_send(fdev, data)) {
		statusbar_write("Failed - Error ID: %i", data->status);
		disable_progress_window ();
		return;
	}
	
	/* set datatype to PROGRAM */
	data->format = FMT_PROGRAM;
	data->datatype = DATA_PG;

	/* set title and text */
	data->name = title->str;
	data->data = text;
	data->length = text_len;
	
	/* send program to calculator */
	if (cafix_send(fdev, data, &show_status) == 0)
		statusbar_write("Failed - Error ID: %i", data->status);
			
	disable_progress_window ();
	
	/* set data to be End-Byte */
	data->format = FMT_END;
	
	/* send End-Byte data Package */
	if(cafix_send(fdev, data, &show_status))
		statusbar_write("Failed - Error ID: %i", data->status);
	else
		statusbar_write("Transmitted File!");
	
	/* free data structure */
	g_free(data);
}

int
show_status (cafixdata *data)
{
    int foo;

	/* get length */
    if (data->status == STAT_SENDING_HDR || data->status == STAT_RECEIVING_HDR) {
		foo = data->hlength;
		return 0;
	}
    else
		foo = data->length;

	/* make sure foo is not 0, because divisions through 0 are bad */
    if (foo < 1)
		foo = 1;

	/* set the progress window status */
	set_progress_window_status ( (data->transmitted * 100) / foo );

	/* update the window by doing a interrupt to gtk_main function */
	while (gtk_events_pending ())
		gtk_main_iteration ();

    if (data->status == STAT_OVERWRITE)
		return 1;

    return 0;
}
