// ---------------------------------------------------------------------
// $Id: BestFirst.hh,v 1.10 2007/03/28 09:47:10 daaugusto Exp $
//
//   BestFirst.hh (created on Sat Nov 19 18:00:35 BRT 2005)
// 
//   Genetic Algorithm File Fitter (gaffitter)
//
//   Copyright (C) 2005-2007 Douglas A. Augusto
// 
// This file is part of gaffitter.
// 
// gaffitter is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
// 
// gaffitter is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with gaffitter; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// ---------------------------------------------------------------------

#ifndef BestFirst_hh
#define BestFirst_hh

#include "../Optimizer.hh"

using namespace std;

// ---------------------------------------------------------------------
/**
 * Optimization via the Best First search (also known as "First Fit").
 */
class BestFirst: public Optimizer {
public:
   /**
    * Calls the base constructor and print some information if needed.
    */
   BestFirst(vector<SizeName>& sn, Params& p):Optimizer(sn,p) 
   {
      // sorts files by size (reverse order)
      sort(m_files.begin(), m_files.end(), SizeName::CmpSizeRev);
   }

   /**
    * Create a reasonable solution via "Best First Search", i.e., select
    * files from bigger to smaller until no more space left (lesser than
    * target size). This algorithm usually produces locally optimal
    * solutions, however, it is very fast!
    */
   void Evolve();

protected:
   /** 
    * Writes some information (like algorithm name and parameters) in
    * ostream object (usually cout).
    */
   ostream& Write(ostream&) const; 
};

// ---------------------------------------------------------------------

#endif
