/* GADMIN-SQUID - An easy to use GTK+ frontend for the Squid proxy server.
 * Copyright (C) 2006 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "show_info.h"
#include "chars_are_digits.h"
#include "functions.h"

extern int MAX_READ_POPEN;
extern int squid_mayor_version;


void set_version(struct w *widgets)
{
    FILE *fp;
    char *version;
    int i=0, ver_found=0;
    gchar *command;
    gchar *ver=NULL;
    gchar *utf8=NULL;
    gchar *info;

    command = g_strdup_printf("%s -v 2>&1", SQUID_BINARY);
    if((fp=popen(command, "r"))==NULL)
    {
        info = g_strdup_printf(_("Set version failed\n"));
        show_info(info);
        g_free(info);
        g_free(command);
        return;
    }

    g_free(command);    
    version = allocate(MAX_READ_POPEN);
    
    while(fgets(version, MAX_READ_POPEN, fp)!=NULL)
    {
	if( cmplowercase(version, "version ") && strlen(version) < 100 )
        {
    	    /* We cut out the first 16 chars and change '/' to '-' if any */
            ver = g_strdup_printf(_(" Information: Squid-%s"), &version[21]);
	    for(i=0; ver[i]!='\0'; i++)
	      if( ver[i]=='/' )
	          ver[i]='-';

	    utf8 = g_locale_to_utf8(ver, strlen(ver)-1, NULL, NULL, NULL);
            gtk_label_set_text(GTK_LABEL(widgets->version_label), utf8);
	    g_free(utf8);
	    ver_found = 1;
	  
	  /* Set squid_mayor_version globally for use with standard confs */
//	  for(i=0; version[i]!='\0'; i++)
//	  if( chars_are_digits(&version[i]) )
//	  {
//	      squid_mayor_version = atoi(&version[i]);
//	      break;
//	  }
	    break;	  	  
       }
    }

    if( ! ver_found )
    {
        ver = g_strdup_printf(_(" Squid is not installed or not in your path."));
	utf8 = g_locale_to_utf8(ver, strlen(ver), NULL, NULL, NULL);
        gtk_label_set_text(GTK_LABEL(widgets->version_label), utf8);
	g_free(utf8);
    }
    free(version);
    g_free(ver);
    pclose(fp);
}
