/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"


void show_help(struct w *widgets)
{
    gchar *help;
    help = g_strconcat(
    _("\n\n1. Adding scopes:\n"),
    _("	If eth0 has an address on the 192.168.0.0 net and you want to share\n"),
    _("	addresses in the range 192.168.0.1 to 192.168.0.254 you type the interface\n"),
    _("	name eth0 as the network card. Type 192.168.0.0 as the network address\n"),
    _("	and set 255.255.255.0 as the subnet mask and then click add.\n\n"),
    
    _("	Now you need to specify the address range to share, this is done in the\n"),
    _("	shared IP-address interval section. As range from you can specify\n"),
    _("	192.168.0.1 and as range to you can use 192.168.0.254 then click add.\n\n"),

    _("	Test the setup by clicking the activate button.\n"),
    _("	The deactivated state should now change to active.\n\n"),

    _("	Now you can supply the hosts with more information about this network.\n"),
    _("	This is done in the scope settings section.\n\n\n"),

    
    _("2. Adding single hosts:\n"),
    _("	Static IP-addresses are mostly used for servers and printers that\n"),
    _("	require a static location but can also be used for any dhcp client.\n\n"),
    _("	Supplying a host that has hardware address 00:20:AF:F7:AA:AA with a\n"),
    _("	hostname and IP-address can be done by adding a hostname and an\n"),
    _("	IP-address in the corresponding fields.\n"),
    _("	Type the network cards hardware address from the client in the hardware\n"),
    _("	address field and then click add.\n"),
    _("	(You can get the clients hardware addresses by running ifconfig on them)\n\n"),

    _("	Test the setup by clicking the activate button.\n"),
    _("	The deactivated state should now change to active.\n\n"),

    _("	Now you can supply this host with more information such as DNS servers\n"),
    _("	and gateways, this is done in the hosts settings section.\n\n\n"),

    _("3. Dynamic name server updates:\n"),
    _("	To allow clients to dynamically update their information with a DNS server\n"),
    _("	ddns update style should be set to ad-hoc or interim and the ddns updates\n"),
    _("	setting should be set to enabled in the settings window.\n"),
    _("	Client updates should be allowed if you want the clients to update their records.\n\n\n"),


    _("4. Current usage:\n"),
    _("	The leases tab shows currently active clients and what values such as the\n"),
    _("	IP-addresses, subnet masks and hardware addresses they currently use.\n"),

    "\n\n",

    _("5. Loadbalancing and failover setups:\n"),
    _("	First setup a basic scope and atleast one range.\n"),
    _("	Press the loadbalance button to add a loadbalancer for the selected subnet.\n"),
    _("	Standard values are automatically filled in and are most likely as they should be.\n"),
    _("	A unique loadbalance name must be specified and also this servers address.\n"),
    _("	Select primary or secondary server type.\n"),
    _("	You also need to specify a remote server address on the same subnet as this server.\n"),
    _("	Hit apply and youre done.\n\n"),

    _("	Change the loadbalancer by altering its settings and pressing apply.\n"),
    _("	\n"),

    "\n", NULL);

    show_info(help);
    g_free(help);
}
