/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: FindObjectWidget.h 353 2008-07-13 01:26:39Z vadim $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __FINDOBJECTWIDGET_H_
#define __FINDOBJECTWIDGET_H_

#include "../../config.h"
#include <ui_findobjectwidget_q.h>

#include "fwbuilder/FWObject.h"
#include "fwbuilder/RuleElement.h"
#include "fwbuilder/Firewall.h"

class QRegExp;
class ObjectDescriptor;
class QWidget;

class FindObjectWidget : public QWidget
{
    Q_OBJECT
 private:

    QString                   lastAttrSearch;
    libfwbuilder::FWObject   *lastFound;
    libfwbuilder::FWObject::tree_iterator   treeSeeker;
    libfwbuilder::Firewall* selectedFirewall;

    bool matchName(const QString &name);
    bool matchID(int id);
    bool matchAttr(libfwbuilder::FWObject* obj);
    bool validateReplaceObject();
    libfwbuilder::FWObject* _replaceCurrent();
    bool inSelectedFirewall( libfwbuilder::RuleElement* r);
    
 public:
    Ui::findObjectWidget_q *m_widget;
    FindObjectWidget(QWidget*p, const char * n = 0, Qt::WindowFlags f = 0);
    ~FindObjectWidget() { delete m_widget; };
    void findObject (libfwbuilder::FWObject *o);
    

public slots:
    virtual void hidePanel() {reset();emit close();}; 
    virtual void enableAll();
    virtual void disableAll();
    virtual void objectInserted();
    
    virtual void find();
    virtual void findNext();
    virtual void reset();
    virtual void findAttrChanged(const QString&);
    virtual void findPrev();
    virtual void replaceNext();
    
    virtual void replace();
    virtual void replaceAll();
    virtual void replaceEnable();
    virtual void replaceDisable();
    void showObject(libfwbuilder::FWObject* o);
    void init();
    void firewallOpened(libfwbuilder::Firewall *f);
    void scopeChanged();

 signals:
    void close();
};

#endif 
