/* 

                          Firewall Builder

                 Copyright (C) 2006 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: ActionsDialog.cpp,v 1.29 2007/06/14 02:55:29 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"
#include "definitions.h"

#include "ActionsDialog.h"
#include "ObjectManipulator.h"
#include "FWWindow.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/Interface.h"
#include "fwbuilder/FWException.h"
#include "fwbuilder/Rule.h"
#include "fwbuilder/Firewall.h"

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qwidgetstack.h>
#include <qcursor.h>
#include <qregexp.h>

#include <iostream>
#include <stdlib.h>

using namespace std;
using namespace libfwbuilder;

void ActionsDialog::loadFWObject(FWObject *o)
{
    setRule(PolicyRule::cast(o));    

}
    
void ActionsDialog::changed()
{
    //apply->setEnabled( true );
    emit changed_sign();
}

void ActionsDialog::validate(bool *res)
{
    FWOptions *ruleopt =rule->getOptionsObject();

    *res=true;

    if (platform=="iptables")
    {
        /*
         *  http://www.netfilter.org/projects/patch-o-matic/pom-extra.html#pom-extra-ROUTE
         *  says:
         *
         * "Note that --iif, --continue, and --tee, are mutually exclusive."
         */

        string iif  = ruleopt->getStr("ipt_iif");
        int    cont = ruleopt->getBool("ipt_continue");
        int    tee  = ruleopt->getBool("ipt_tee");

        if ( (int(!iif.empty()) + cont + tee) > 1)
        {
            *res=false;
            QMessageBox::critical(this, "Firewall Builder",
                                  tr("'Chabge inbound interface', 'Continue packet inspection' and 'Make a copy' options are mutually exclusive"),
                                  tr("&Continue"), 0, 0,
                                  0 );
        }
    }
}

void ActionsDialog::isChanged(bool *res)
{
    //*res=apply->isEnabled();
}


void ActionsDialog::applyChanges()
{
    if (platform=="iptables" && editor=="AccountingStr")
    {
        QString rn = accountingvalue_str->text();
/* rule name for accounting may contain only alphanumeric characters
 * and no white spaces or spec. characters
 */
        if (rn.contains(QRegExp("[^a-zA-Z0-9_]"))!=0)
        {
            QMessageBox::information(
                this,"Firewall Builder", 
                tr("Rule name for accounting is converted to the iptables\nchain name and therefore may not contain white space\nand special characters."),
                tr("&Continue"), QString::null,QString::null,
                0, 1 );

            return;
        }
    }

    
    data.saveAll();
    
    FWOptions *ropt = rule->getOptionsObject();

    if (editor=="BranchChain" || editor=="BranchAnchor")
    {
        mw->setPolicyBranchTabName(rule->getBranch());
    }

    if (useDummyNetPipe->isChecked())
        ropt->setInt("ipfw_classify_method",DUMMYNETPIPE);
    else
        ropt->setInt("ipfw_classify_method",DUMMYNETQUEUE);



    om->updateLastModifiedTimestampForAllFirewalls(rule);
}

void ActionsDialog::discardChanges()
{
}

void ActionsDialog::tagvalueChanged(int t)
{
    QString buf;
    buf.setNum(tagvalue_int->value());
    tagvalue_str->setText(buf);
}

void ActionsDialog::iptRouteContinueToggled()
{
    if (ipt_continue->isChecked())
    {
        ipt_iif->setCurrentItem(0);
        ipt_tee->setChecked(false);
    }
    ipt_iif->setEnabled( ! ipt_continue->isChecked() );
    ipt_tee->setEnabled( ! ipt_continue->isChecked() );
}

void ActionsDialog::setRule(PolicyRule *r )
{
    rule=r;
    FWObject *o = rule;
    while (o!=NULL && Firewall::cast(o)==NULL) o=o->getParent();
    assert(o!=NULL);

    FWOptions *ropt = rule->getOptionsObject();
    
    Firewall *f=Firewall::cast(o);
    firewall=f;
    
    platform=f->getStr("platform");
    QString title=QString("%1 / %2 (%3)")
        .arg(QString::fromUtf8(f->getName().c_str()))
        .arg(rule->getPosition())
        .arg(rule->getActionAsString().c_str());
    action->setText(title);
    
    string act=rule->getActionAsString();
    
    QStringList actionsOnReject=getActionsOnReject( platform.c_str() );
    rejectvalue->clear();
    rejectvalue->insertStringList( getScreenNames( actionsOnReject ) );

    fillInterfaces(ipt_iif);
    fillInterfaces(ipt_oif);
    fillInterfaces(ipf_route_opt_if);
    fillInterfaces(pf_route_opt_if);

    editor = Resources::getActionEditor(platform,act);

    branchNameInput = NULL;

    if (ropt->getInt("ipfw_classify_method") == DUMMYNETPIPE)
    {
        useDummyNetPipe->setChecked(1);
    } else {
        useDummyNetQueue->setChecked(1);
    }

    if (platform=="iptables")
    {
        classify_txt_1->show();
        classify_terminating->show();
        tag_txt_1->show();
        tag_terminating->show();

        if (firewall->getOptionsObject()->getBool ("classify_mark_terminating"))
        {
            classify_terminating->setText(tr("Emulation is currently ON, rule will be terminating") );
            tag_terminating->setText(tr("Emulation is currently ON, rule will be terminating") );
        } else
        {
            classify_terminating->setText(tr("Emulation is currently OFF, rule will be non-terminating") );
            tag_terminating->setText(tr("Emulation is currently OFF, rule will be non-terminating") );
        }

    } else
    {
        classify_txt_1->hide();
        classify_terminating->hide();
        tag_txt_1->hide();
        tag_terminating->hide();
    }

    data.clear();

    data.registerOption ( ipt_mark_connections, ropt , "ipt_mark_connections");
//    data.registerOption ( ipt_mark_prerouting , ropt , "ipt_mark_prerouting");
    data.registerOption ( accountingvalue_str , ropt , "rule_name_accounting");
    data.registerOption ( usePortNum          , ropt , "ipfw_pipe_queue_num");
    data.registerOption ( divertPortNum       , ropt , "ipfw_pipe_port_num");
    data.registerOption ( classify_str        , ropt , "classify_str");
    data.registerOption ( custom_str          , ropt , "custom_str");

    // ROUTE action:

    // build a map for combobox so visible combobox items can be localized
    QStringList route_options = getRouteOptions_pf_ipf( platform.c_str() );

    // iptables
    data.registerOption ( ipt_iif             , ropt , "ipt_iif" );
    data.registerOption ( ipt_oif             , ropt , "ipt_oif" );
    data.registerOption ( ipt_gw              , ropt , "ipt_gw" );
    data.registerOption ( ipt_continue        , ropt , "ipt_continue" );
    data.registerOption ( ipt_tee             , ropt , "ipt_tee");

    // ipfilter
    data.registerOption ( ipf_route_option    , ropt , "ipf_route_option",
                          route_options);
    data.registerOption ( ipf_route_opt_if    , ropt , "ipf_route_opt_if");
    data.registerOption ( ipf_route_opt_addr  , ropt , "ipf_route_opt_addr");

    // pf
    data.registerOption ( pf_fastroute        , ropt , "pf_fastroute"     ); 
    data.registerOption ( pf_route_option     , ropt , "pf_route_option",
                          route_options); 
    data.registerOption ( pf_route_opt_if     , ropt , "pf_route_opt_if"  ); 
    data.registerOption ( pf_route_opt_addr   , ropt , "pf_route_opt_addr"); 

    // REJECT action:
    data.registerOption ( rejectvalue         , ropt , "action_on_reject"); 
    
    QWidget *w=NonePage;
    if (editor=="Reject")
    {
        w=RejectPage;
    }
    else if (editor=="TagInt")
    {
        w=TagIntPage;
        data.registerOption(tagvalue_int , ropt , "tagvalue");
    }
    else if (editor=="TagStr")
    {
        w=TagStrPage;
        data.registerOption(tagvalue_str , ropt , "tagvalue");
    }
    else if (editor=="AccountingStr")
    {
        w=AccountingStrPage;
    }
    else if (editor=="ClassifyArgsIPFW")
    {
        w=ClassifyArgsIPFW;
    }
    else if (editor=="PipeArgsIPFW")
    {
        w=PipeArgsIPFW;
    }
    else if (editor=="ClassifyStr")
    {
        w=ClassifyStrPage;
    }
    else if (editor=="CustomStr")
    {
        w=CustomStrPage;
    }
    else if (editor=="BranchChain")
    {
        w=BranchChainPage;
        data.registerOption ( branchChainName     , ropt , "branch_name" );
        data.registerOption ( ipt_branch_in_mangle, ropt , "ipt_branch_in_mangle" );
    }
    else if (editor=="BranchAnchor")
    {
        w=BranchAnchorPage;
        data.registerOption ( branchAnchorName    , ropt , "branch_name" );
    }
    else if (editor=="RouteIPT")
    {
        w=RouteIPTPage;
    }
    else if (editor=="RouteIPF")
    {
        w=RouteIPFPage;
    }
    else if (editor=="RoutePF")
    {
        w=RoutePFPage;
    }
    
    widgetStack->raiseWidget ( w );
    
    //rejectvalue->setCurrentText( ropt->getStr("action_on_reject") ); 
    data.loadAll();

    iptRouteContinueToggled();
}

void ActionsDialog::fillInterfaces(QComboBox* cb)
{
    cb->clear();
    cb->insertItem("");
    
    FWObjectTypedChildIterator j=firewall->findByType(Interface::TYPENAME);
    for ( ; j!=j.end(); ++j )
    {
        cb->insertItem(QString::fromUtf8( (*j)->getName().c_str()) );
    }
    
}

void ActionsDialog::closeEvent(QCloseEvent *e)
{
    if (fwbdebug)
        qDebug("ActionsDialog::closeEvent  got close event: %p",e);
    emit close_sign(e);
    //hide();
}

