/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: SSHUnx.cpp,v 1.12.4.3 2005/09/01 06:07:28 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "config.h"
#include "global.h"
#include "utils.h"

#include "SSHUnx.h"

#include <qobject.h>
#include <qtimer.h>
#include <qregexp.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qeventloop.h>

#include <iostream>

using namespace std;

SSHUnx::SSHUnx(const QString &_h,
               const QStringList &args,
               const QString &_p,
               const QString &_ep,
               const QStringList &_in) : SSHSession(_h,args,_p,_ep,_in)
{
    normal_prompt="> ";
    enable_prompt="# ";
    pwd_prompt="'s password: ";
    epwd_prompt="Password: ";
    scp_pwd_prompt="Password: ";
    ssh_pwd_prompt="'s password: ";
    ssoft_config_prompt="> ";
    sudo_pwd_prompt="Password:";
    putty_pwd_prompt="Password: ";
    passphrase_prompt="Enter passphrase for key ";

    errorsInit.push_back("Permission denied");
    errorsInit.push_back("Invalid password");
    errorsInit.push_back("Unable to authenticate");
    errorsInit.push_back("Sorry, try again");
    errorsInit.push_back("Too many authentication failures");

    errorsLoggedin.push_back("No such file or directory");
    errorsLoggedin.push_back("Cannot allocate memory");

}

SSHUnx::~SSHUnx()
{
}

void SSHUnx::stateMachine()
{
    QStringList *errptr;

    switch (state)
    {
    case LOGGEDIN:  errptr= &errorsLoggedin; break;
    default:        errptr= &errorsInit;     break;
    }

    for (QStringList::const_iterator i=errptr->begin();
         i!=errptr->end(); ++i)
    {
        if ( stdoutBuffer.findRev(*i,-1)!=-1 )
        {
            emit printStdout_sign( tr("\n*** Fatal error :") );
            emit printStdout_sign( stdoutBuffer+"\n" );
            stdoutBuffer="";
            terminate();
            return;
        }
    }

 entry:
    switch (state)
    {
    case NONE:
    {
        if ( cmpPrompt(stdoutBuffer,scp_pwd_prompt) ||
             cmpPrompt(stdoutBuffer,ssh_pwd_prompt) ||
             cmpPrompt(stdoutBuffer,putty_pwd_prompt) ||
             stdoutBuffer.findRev(passphrase_prompt,-1)!=-1 ||

             cmpPrompt(stdoutBuffer,sudo_pwd_prompt) ||
             cmpPrompt(stderrBuffer,sudo_pwd_prompt) ) 
        {
            stdoutBuffer="";
            proc->writeToStdin( pwd );
            proc->writeToStdin( "\n" );
            break;
        }
/* we may get to LOGGEDIN state directly from NONE, for example when
 * password is supplied on command line to plink.exe
 */
        if (cmpPrompt(stdoutBuffer,normal_prompt) ||
            cmpPrompt(stdoutBuffer,fwb_prompt))
        {
            state=PUSHING_CONFIG;
            if (!quiet) emit printStdout_sign( tr("Logged in\n") );
            if (fwbdebug)
                qDebug("SSHUnx::stateMachine logged in");
//            proc->writeToStdin( "\n" );
//            stdoutBuffer="";
            goto push_files;
        }

        QString fingerprint;
        int n1,n2;
        if (stdoutBuffer.find(newKeyOpenSSH)!=-1 ||
            stdoutBuffer.find(newKeyPlink)!=-1   ||
            stdoutBuffer.find(newKeyVsh)!=-1)
        {
/* new key */

            n1=stdoutBuffer.find(fingerprintPrompt) + strlen(fingerprintPrompt);
            n2=stdoutBuffer.find(QRegExp("[^ 0-9a-f:]"), n1+4);
            fingerprint=stdoutBuffer.mid(n1,n2-n1);

            QString msg=newKeyMsg.arg(host).arg(fingerprint).arg(host);

/* TODO: need to use a reference to the main window or installer dialog  */
            int res =QMessageBox::warning( NULL, tr("New RSA key"), msg,
                                           tr("Yes"), tr("No"), 0,
                                           0, -1 );

            stdoutBuffer="";
            if (res==0)
            {
                if (ssh.find("vsh.exe")!=-1)
                    proc->writeToStdin( "y\n" );
                else
                    proc->writeToStdin( "yes\n" );
                break;
            } else
            {
                state=EXIT;
                goto entry;
            }
        }
    }
    break;

/* in this state we may need to enter sudo password */
    case PUSHING_CONFIG:
 push_files:
        if ( cmpPrompt(stdoutBuffer,sudo_pwd_prompt) ||
             cmpPrompt(stderrBuffer,sudo_pwd_prompt) ) 
        {
            stdoutBuffer="";
            proc->writeToStdin( pwd );
            proc->writeToStdin( "\n" );
            break;
        }
/*
        if (!quiet && !verbose) 
        {
            emit printStdout_sign( stdoutBuffer );
        }
*/
        stdoutBuffer="";

        if (input.size()!=0)
        {
            if (fwbdebug) qDebug("SSHUnx::stateMachine - sending a file");
            emit updateProgressBar_sign(input.size(),true);
            connect(proc,SIGNAL(wroteToStdin()),this,SLOT(readyToSend()));
            sendLine();
            break;
        }
        break;

/* we get to this state when previous ssh or scp command terminates */
    case FINISH:
        if ( proc->normalExit() && proc->exitStatus()==0)
        {
            emit printStdout_sign( "\n");
            emit printStdout_sign( tr("Done") );
            emit printStdout_sign( "\n");

            delete proc;
            proc=NULL;

            state=NONE;

            break;
        } else
        {
            emit printStdout_sign( "\n");
            emit printStdout_sign( tr("Error in SSH") );
            emit printStdout_sign( "\n");

            terminate();
            proc=NULL;
        }

        emit sessionFinished_sign();
        break;

    default: break;
    }
}

