
<!--

 Description:

 This script finds and prints IP address of the management interface of
 the firewall object whose name is given as a parameter "fwobject". 
 This script assumes the following structure of the XML file:

  Firewall
    Interface
      IPv4

 Management interface is the one with attribute 'mgmt' set to True. This XML
 tree corresponds to Firewall Builder DTD v1.18

 If by some reason no interface is marked as management, then script
 finds and returns a first address of the first interface of the firewall.

 This script can be used to aid external policy installation scripts that
 need to find an address they should be using while communicating with 
 the firewall.

 Usage:

 xsltproc \-\-param fwobject "'_FIREWALL_OBJ_NAME_'" fw_mgmt_addr.xslt x.xml

 
 Author: Vadim Kurland, <vadim@fwbuilder.org>


 -->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fwb="http://www.fwbuilder.org/1.0/">


<xsl:output method="text"/>
<xsl:strip-space elements="*"/>
<xsl:param name="fwobject"/>



<xsl:template name="Firewall" mode="copy">

  <xsl:if test="@name=$fwobject">

    <xsl:variable name="addr"
         select="fwb:Interface[attribute::mgmt='True']/fwb:IPv4/@address"/>

    <xsl:variable name="mgmt_address">
      <xsl:choose>
        <xsl:when test="$addr">
          <xsl:value-of select="$addr"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="fwb:Interface/fwb:IPv4/@address"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:value-of select="$mgmt_address"/>

  </xsl:if>

</xsl:template>



<xsl:template match="fwb:*" mode="copy">
  <xsl:choose>
    <xsl:when test="name()='Firewall'">
      <xsl:call-template name="Firewall"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="*" mode="copy"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>


<xsl:template match="*[attribute::id='root']">
  <xsl:apply-templates select="*" mode="copy"/>
</xsl:template>


</xsl:stylesheet>



