/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: AskPasswordDialog.cc,v 1.5 2003/10/10 06:37:03 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "AskPasswordDialog.hh"

#include <gtk--/main.h>

#include <gdk/gdkkeysyms.h>

#include <stdio.h>

AskPasswordDialog::AskPasswordDialog(dialog_type mode,const std::string &username)
{  
    if (mode==LOGIN_AND_PWD)
    {
/* login name and password  */
        prompt1->set_text( _("Login: ") );
        prompt2->set_text( _("Password: ") );
        prompt1->show();
        pwd1->show();
        hseparator1->show();
        prompt2->show();
        pwd2->show();
    }
    if (mode==ONLY_PWD)
    {
/* one password  */
        char str[128];
        sprintf(str,_("Password for '%s': "), username.c_str());
        prompt1->set_text( str );
        prompt1->show();
        pwd1->show();
        hseparator1->hide();
        prompt2->hide();
        pwd2->hide();
    }
    if (mode==PWD_AND_ENABLE)
    {
/* two passwords */
        char str[128];
        sprintf(str,_("Password for '%s': "), username.c_str());
        prompt1->set_text( str );
        prompt2->set_text( _("Enable password: ") );
        prompt1->show();
        pwd1->show();
        hseparator1->show();
        prompt2->show();
        pwd2->show();
    }

    pwd1->grab_focus();

    ok_button->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    ok_button->grab_default();

    hide.connect(Gtk::Main::quit.slot());
}

gint AskPasswordDialog::key_press_event_impl(GdkEventKey* p0)
{
    if ( p0->keyval == GDK_Escape ) hide();
    if ( p0->keyval == GDK_Return ) {res=true; hide(); }
    AskPasswordDialog_glade::key_press_event_impl(p0);
    return 0;
}


bool AskPasswordDialog::run()
{
    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);
    return res;
}

std::string AskPasswordDialog::getLine1()
{
    return pwd1->get_text();
}

std::string AskPasswordDialog::getLine2()
{
    return pwd2->get_text();
}

void AskPasswordDialog::on_ok_clicked()
{  
    res=true;
    hide();
}

void AskPasswordDialog::on_cancel_clicked()
{  
    res=false;
    hide();
}

gint AskPasswordDialog::on_delete_event(GdkEventAny* ev)
{
    hide();
    return true;
}
