/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: WhereUsedDialog.cc,v 1.8 2003/03/22 09:03:43 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "WhereUsedDialog.hh"
#include "FWObjectDatabaseGUI.hh"

#include "fwbuilder/FWReference.hh"

#include "gen_popup_menu.hh"
#include "main_window.hh"
#include "PixmapButton.hh"

#include <assert.h>

using namespace libfwbuilder;




WhereUsedDialog::WhereUsedDialog(main_window *mw,FWObject* obj,
				 set<FWObject*> &objects)
{
    main_w=mw;

    running=false;

    set_position(GTK_WIN_POS_CENTER);


    txt1->set_text(_("Groups and firewalls using object '") + 
		   obj->getName() +"' :");

    PixmapButton::addPixmapAndText( *button1 , "Close"    , _("Close")    );

    GroupIconList=manage(new  ListOfIcons(80,50,true));
    assert( GroupIconList!=NULL );

    GroupIconList->set_border(16);
    GroupIconList->set_row_spacing(8);
    GroupIconList->set_col_spacing(8);

    scrolledwindow->add_with_viewport( *GroupIconList);

    FWObject *o;
    set<FWObject*>::iterator m;
    for (m=objects.begin(); m!=objects.end(); ++m) {
	if ( (o=(*m))!=NULL ) {
	    if ( FWReference::cast(o)!=NULL) 
		o=( FWReference::cast(o) )->getPointer();

	    GroupIconList->addObject(o);
	}
    }

    GroupIconList->arrangeIcons();

    GroupIconList->show();

    GroupIconList->open_item.connect(SigC::slot(this,
					    &WhereUsedDialog::on_open_item));
    GroupIconList->popup_menu.connect(SigC::slot(this,
					    &WhereUsedDialog::on_popup_menu));
    delete_event.connect( SigC::slot(this, &WhereUsedDialog::on_delete) );

    button1->grab_focus();
}

void WhereUsedDialog::on_open_item(void *arg)
{
    string   *id = (string*)arg;
    if (id!=NULL)
    {
	FWObject *o  = FWObjectDatabaseGUI::db->getById(*id,true);
        main_w->schedule_open_object(*id, o->getLibrary());
    }
    if (running) {
	Gtk::Main::quit();
	running=false;
    }
}


void WhereUsedDialog::on_popup_menu(void *arg)
{
    string *id=(string*)arg;

    char **menu_items0;
    gen_popup_menu *gpm;

    menu_items0=new char*[6];
    menu_items0[0]=_("Open");

    menu_items0[1]=NULL;
    gpm=new gen_popup_menu( (const char**)menu_items0 );

    gpm->popup(0,0);
    gint menu_choice=gpm->run();
    delete gpm;

    delete menu_items0;
    
    if (menu_choice==0) 
    {
	FWObject *o  = FWObjectDatabaseGUI::db->getById(*id,true);
	main_w->schedule_open_object(*id, o->getLibrary());
  
	if (running) 
        {
	    Gtk::Main::quit();
	    running=false;
	}
    }
}


void WhereUsedDialog::run()
{
    Gtk::Main::grab_add(*this);
    running=true;

    Gtk::Main::run();
    running=false;

    Gtk::Main::grab_remove(*this);
    hide();
}

void WhereUsedDialog::on_ok_clicked()
{   
    if (running) {
	Gtk::Main::quit();
	running=false;
    }
}

gint WhereUsedDialog::on_delete(GdkEventAny* ev)
{
    if (running) {
	Gtk::Main::quit();
	running=false;
    }
    return(true);
}
