/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TCPServiceDialog.cc,v 1.18 2003/04/07 01:04:41 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "fwbuilder/libfwbuilder-config.h"

#include "TCPServiceDialog.hh"
#include "fwbuilder/TCPService.hh"
#include "MessageDialog.hh"
#include "helpers.hh"

using namespace libfwbuilder;

TCPServiceDialog::TCPServiceDialog(FWObject *obj) 
{ 
    object=obj;

    flag_widgets[TCPService::URG]=urg_flag;
    flag_widgets[TCPService::ACK]=ack_flag;
    flag_widgets[TCPService::PSH]=psh_flag;
    flag_widgets[TCPService::RST]=rst_flag;
    flag_widgets[TCPService::SYN]=syn_flag;
    flag_widgets[TCPService::FIN]=fin_flag;

    mask_widgets[TCPService::URG]=urg_flag_mask;
    mask_widgets[TCPService::ACK]=ack_flag_mask;
    mask_widgets[TCPService::PSH]=psh_flag_mask;
    mask_widgets[TCPService::RST]=rst_flag_mask;
    mask_widgets[TCPService::SYN]=syn_flag_mask;
    mask_widgets[TCPService::FIN]=fin_flag_mask;

    object_parameters.push_back( DialogOption( name      , "name"     ) );
    object_parameters.push_back( DialogOption( comment   , "comment"  ) );

    object_parameters.push_back( DialogOption( src_range_start  , "src_range_start" ) );
    object_parameters.push_back( DialogOption( src_range_end    , "src_range_end"   ) );
    object_parameters.push_back( DialogOption( dst_range_start  , "dst_range_start" ) );
    object_parameters.push_back( DialogOption( dst_range_end    , "dst_range_end"   ) );
}

void TCPServiceDialog::wrk2dlg()
{
    TCPService *tcp=TCPService::cast(object);

    loadPageOptions(object,  object_parameters );

    std::map<TCPService::TCPFlag, Gtk::CheckButton*>::iterator i;

    for (i=flag_widgets.begin(); i!=flag_widgets.end(); ++i)
        i->second->set_active( tcp->getTCPFlag( i->first ) );

    for (i=mask_widgets.begin(); i!=mask_widgets.end(); ++i)
        i->second->set_active( tcp->getTCPFlagMask( i->first ) );

    update_flags();

    name->grab_focus();
}

bool TCPServiceDialog::dlg2wrk()
{
    TCPService *tcp=TCPService::cast(object);

    if (dst_range_end->get_value_as_int()==0)
        dst_range_end->set_value( dst_range_start->get_value_as_int() );

    savePageOptions(object,  object_parameters );

    std::map<TCPService::TCPFlag, Gtk::CheckButton*>::iterator i;

    for (i=flag_widgets.begin(); i!=flag_widgets.end(); ++i)
        tcp->setTCPFlag( i->first , i->second->get_active() );

    for (i=mask_widgets.begin(); i!=mask_widgets.end(); ++i)
        tcp->setTCPFlagMask( i->first , i->second->get_active() );

    return(true);
}

void TCPServiceDialog::update_flags()
{
    syn_flag->set_sensitive( syn_flag_mask->get_active() );
    ack_flag->set_sensitive( ack_flag_mask->get_active() );
    fin_flag->set_sensitive( fin_flag_mask->get_active() );
    rst_flag->set_sensitive( rst_flag_mask->get_active() );
    psh_flag->set_sensitive( psh_flag_mask->get_active() );
    urg_flag->set_sensitive( urg_flag_mask->get_active() );
}

void TCPServiceDialog::on_changed()
{
    data_changed_flag(true);
}

void TCPServiceDialog::on_syn_mask_toggled() 
{ 
    syn_flag->set_sensitive( syn_flag_mask->get_active() );
}

void TCPServiceDialog::on_ack_mask_toggled() 
{ 
    ack_flag->set_sensitive( ack_flag_mask->get_active() );
}

void TCPServiceDialog::on_rst_mask_toggled() 
{ 
    rst_flag->set_sensitive( rst_flag_mask->get_active() );
}

void TCPServiceDialog::on_fin_mask_toggled() 
{
    fin_flag->set_sensitive( fin_flag_mask->get_active() );
}

void TCPServiceDialog::on_urg_mask_toggled() 
{ 
    urg_flag->set_sensitive( urg_flag_mask->get_active() );
}

void TCPServiceDialog::on_psh_mask_toggled() 
{ 
    psh_flag->set_sensitive( psh_flag_mask->get_active() );
}

