/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: RuleOptionsDialog.hh,v 1.12 2002/08/29 00:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _RULEOPTIONSDIALOG_HH
#  include "RuleOptionsDialog_glade.hh"
#  define _RULEOPTIONSDIALOG_HH

#include "config.h"

#include "glademm_support.hh"

#include <map>
#include <vector>

#include "fwbuilder/FWOptions.hh"

/*
 *  workaround for the bug in glademm
 */
#define GTK_FILLX GTK_FILL_X
#define GTK_FILLY GTK_FILL_Y


class RuleOptionsDialog : public RuleOptionsDialog_glade
{   
        
    friend class RuleOptionsDialog_glade;
    void on_ok_clicked();
    void on_cancel_clicked();

    bool       choice;
    libfwbuilder::FWOptions *options;

    std::map<string,int> notebook_pages;

    std::vector<string>  limit_suffixes;
    std::vector<string>  actions_on_reject;

    Gtk::Menu *addOptionsMenu( vector<string> &items , 
			       string &active_item);


    public:

    RuleOptionsDialog(libfwbuilder::FWOptions *opt);
    void run();
};

#endif





