/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PolicyList.hh,v 1.24 2002/11/14 08:11:56 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _POLICYLIST_HH
#define _POLICYLIST_HH

#include <gtk--.h>
#include <gtk--/layout.h>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/RuleSet.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/InterfacePolicy.hh"
#include "fwbuilder/NAT.hh"

class PolicyListItem;
class PolicyListElement;
class popupMenu;


class RuleSetList : public Gtk::VBox
{

    friend class PolicyListItem;
    friend class PolicyListElement;

private:

    Gtk::Table            *tbl;
    Gtk::HBox             *title_row;
    Gtk::ScrolledWindow   *swnd;
    Gtk::ScrolledWindow   *title_swnd;
    Gtk::Viewport         *title_vprt;
    Gtk::Layout           *title_lout;
    Gtk::Fixed            *title_fxd;
    list<Gtk::Widget*>     titles;

    gint    x,y,width, height;

    gint    last_x, last_y;
    gint    freeze_count;
    gint    last_w_set, last_h_set;

    popupMenu         *popup_menu;

    gint               current_selected_row;
    PolicyListElement *current_selected;

    bool    rebuild;
    int     activate_r;

  /*
    this does not work in GTK1.2 (see comment in gtk--/table.h):

       Gtk::Table_Helpers::TableList tbl=children();

    will keep track of all children widgets myself

    table_elements[row][col]= (PolicyListElement*)widget
   */
    map<int, map<int,Gtk::Widget*> >   table_elements;

    Gtk::EventBox  *bottom;
    
    void on_changed_event();
    void on_realize_event();
    gint on_button_release_event(GdkEventButton *ev);


    gint rebuild_when_idle();

    Gtk::Widget* _register_child(int row,int col,Gtk::Widget *c);
    void         _add_hseparator(gint row,gint col);
    void         _add_vseparator(gint row,gint col);

    void         on_size_allocate(GtkAllocation *all);
    void         on_tbl_size_allocate(GtkAllocation *all);
    void         on_title_size_allocate(GtkAllocation *all);

    void         on_hscrollbar_value_changed();

/**
 *  this method copies rule elements from rule src to rule dst. If
 *  some elements are missing, they will be recreated and filled with
 *  default values. This allows for copying rules from Interface
 *  Policy to Global Policy and vice versa
 */
    void         copyRuleContent(libfwbuilder::Rule *dst, libfwbuilder::Rule *src);

    virtual void create_popup_menu();
    virtual void show_popup_menu();
    virtual void popup_menu_callback(int n);

    protected:

    libfwbuilder::RuleSet   *ruleset;
    int     total_no_of_elements;

    bool supports_logging;
    bool supports_rule_options;
    bool supports_time;

    void attachTableElement(int row, int col,Gtk::Widget *pe,guint x_attach=GTK_FILL,guint y_attach=GTK_FILL);
    void clearTitles();
    void addTitleButton(const string &ttl);

/**
 * removes all widgets in the row row
 */
    void removeWidgetsInRow(int row);

/**
 * swaps rows row1 and row2
 */
    void swapWidgetsInRows(int row1, int row2);

/**
 * moves block of rules one row down, block starts from row first and
 * ends on the last. If last is -1, then move down all rows from
 * first to the end
 */
    void moveWidgetsDown(int first,int last=-1);

/**
 * moves block of rules one row up, block starts from row first and
 * ends on the last. If last is -1, then move up all rows from first
 * to the end
 */
    void moveWidgetsUp(int first,int last=-1);

    public:

    RuleSetList( libfwbuilder::RuleSet *p );
    virtual ~RuleSetList();

    static gint get_rule_by_row(gint row_n);
    static gint get_row_by_rule_num(gint rule_n);
  
    libfwbuilder::RuleSet*  getRuleSet() { return ruleset; }

    int  getX()      { return x;  }
    int  getY()      { return y;  }
    int  getWidth()  { return width;  }
    int  getHeight() { return height; }

    virtual void build();
    virtual void buildRule(int rule_no, libfwbuilder::FWObject* rule);
    virtual void buildTitles();
    virtual void buildTableBottom(int row);
    virtual int  countElements();

    void Clear();

    /**
     * resizes the table and returns new number of rows
     */
    int resizeTable();

    void renumberRules();

//    FWObject *getObject() { return object; }

    PolicyListElement *get_element(gint r,gint c);
    void               select_element(gint r,gint c);

    void               deselect_current();
    void               set_current_selected(PolicyListElement *pe);

    void request_focus();

    void move_focus(GtkDirectionType dir);

    void activate_row(gint r);
    void deactivate_row(gint r);
    
    void activate_rule(gint r);
    void deactivate_rule(gint r);

    void schedule_rebuild(int activate_row);

    //  void AddObject(libfwbuilder::FWObject *obj,gint row,gint col);

/**
 * inserts new rule at the beginning of ruleset
 */
    void insertRuleAtTop(libfwbuilder::Rule *r=NULL);
/**
 * inserts new rule before rule number rule_n
 * if rule_n is -1, then places new rule r before currently selected rule
 */
    void insertRuleBefore(gint rule_n=-1,libfwbuilder::Rule *r=NULL);
/**
 * appends new rule after rule number rule_n
 * if rule_n is -1, then places new rule r after currently selected rule
 */
    void appendRuleAfter(gint rule_n=-1,libfwbuilder::Rule *r=NULL);
/**
 * appends new rule at the bottom of ruleset
 */
    void appendRuleAtBottom(libfwbuilder::Rule *r=NULL);

    void delRule(gint rule_n=-1);

    void moveRuleUp(gint rule_n);
    void moveRuleDown(gint rule_n);
/**
 * moves rule rule1 to position before rule number rule2
 */
    void moveRuleTo(int rule1,int rule2);

    void disableRule(gint rule_n);
    void enableRule(gint rule_n);
    bool isRuleDisabled(gint rule_n);

    bool supportsLogging();
    bool supportsRuleOptions();

    void set_data_changed_flag(bool flag);
};

class PolicyList : public RuleSetList {

    public:
    PolicyList(libfwbuilder::Policy *p ) : RuleSetList(p) {};
    virtual ~PolicyList() {};

    virtual void buildRule(int rule_no, libfwbuilder::FWObject* rule);
    virtual void buildTitles();
    virtual int  countElements();
};

class InterfacePolicyList : public RuleSetList {

    public:
    InterfacePolicyList(libfwbuilder::InterfacePolicy *p ) : RuleSetList(p) {};
    virtual ~InterfacePolicyList() {};

    virtual void buildRule(int rule_no, libfwbuilder::FWObject* rule);
    virtual void buildTitles();
    virtual int  countElements();
};

class NATList : public RuleSetList {

    public:
    NATList(libfwbuilder::NAT *p ) : RuleSetList(p) {};
    virtual ~NATList() {};

    virtual void buildRule(int rule_no, libfwbuilder::FWObject* rule);
    virtual void buildTitles();
    virtual int  countElements();
};


#endif
