/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NewHostDruidP10Dialog.cc,v 1.3 2002/08/29 00:34:49 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "NewHostDruidP10Dialog.hh"
#include "MessageDialog.hh"
#include "helpers.hh"

#include "fwbuilder/dns.hh"

using namespace libfwbuilder;

NewHostDruidP10Dialog::NewHostDruidP10Dialog() 
{
    ((Gtk::Label*)(quick_create->get_child()))->set_justify(GTK_JUSTIFY_LEFT);
    ((Gtk::Label*)(multihomed_host->get_child()))->set_justify(GTK_JUSTIFY_LEFT);
}

void NewHostDruidP10Dialog::prepare()
{
    obj_name->grab_focus();
}

void NewHostDruidP10Dialog::on_quick_create_toggled()
{
    host_addr->set_sensitive( quick_create->get_active() );
    host_addr_label->set_sensitive( quick_create->get_active() );
    host_mac->set_sensitive( quick_create->get_active() );
    host_mac_label->set_sensitive( quick_create->get_active() );
    dns_lookup->set_sensitive( quick_create->get_active() );
}


void NewHostDruidP10Dialog::on_dns_clicked()
{  
    vector<IPAddress> addr;

    try {
        addr=DNS::getHostByName( obj_name->get_text() );
    } catch (FWException &e)
    {
        MessageDialog::Error( e.toString(), this );
        return;
    }

    host_addr->setAddress( addr.front() );
}
