/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FirewallDialog.hh,v 1.59 2003/09/29 05:17:09 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _FIREWALLDIALOG_HH
#  include "FirewallDialog_glade.hh"
#  define _FIREWALLDIALOG_HH
#include "glademm_support.hh"

/*
 *  workaround for the bug in glademm
 */
#define GTK_FILLX GTK_FILL_X
#define GTK_FILLY GTK_FILL_Y

#include "sigc++/slot.h"
#include "fwbuilder/FWObject.hh"
#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/Interface.hh"
#include "InterfaceListWidget.hh"

class IPAddressWidget;
class PolicyList;
class InterfacePolicyList;

class FirewallDialog : public FirewallDialog_glade
{   
        
    friend class FirewallDialog_glade;

    void on_ipfilter_log_level_changed();
    void on_fw_platform_changed();
    void on_host_os_changed();

    void on_find_compiler_clicked();
    void on_find_install_script_clicked();
    void on_snmp_get_descr_released();
    void on_switch_page(Gtk::Notebook_Helpers::Page* p0,guint p1);

    void on_mgmt_clear_fw_key_clicked();
    void on_mgmt_use_install_script_clicked();
    void on_mgmt_use_fwbd_clicked();

    void showDefaultCompiler(const std::string &platform);
    void showFirewallTab(const std::string &platform);
    void showOSTab(const std::string &os);
    void showChosenFirewallTab();
    void showChosenOSTab();
    void enableFWBDoptions();
    void disableFWBDoptions();

    void clearTargetFWDialog();
    void clearTargetOSDialog();

    string  getCertDescString(int no, const string& d);


    static  int              current_page;

    DialogPlugin             *targetFWDialog;
    DialogPlugin             *targetOSDialog;

    libfwbuilder::FWOptions  *options;

    map<string,string>        platforms;
    map<string,string>        host_os_menu;
    map<string,string>        on_off_menu;

    vector<class DialogOption> object_parameters;
    vector<class DialogOption> common_options;

    
public:

    FirewallDialog(libfwbuilder::FWObject *obj);
    ~FirewallDialog();

    void if2dlg();

    virtual void wrk2dlg();
    virtual bool dlg2wrk();
    virtual void updateMainMenu();

    void    fillListOfCertificates();

    void on_changed();
};
#endif
