/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FindDialog.cc,v 1.15 2002/11/06 07:47:28 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "FindDialog.hh"

#include "FWObjectDatabaseGUI.hh"
#include "fwbuilder/Group.hh"

#include "PixmapButton.hh"

#include "helpers.hh"
#include "main_window.hh"

using namespace libfwbuilder;


void FindDialog::on_find_clicked()
{   
    FWObject *o;

    string type = obj_type->get_value();
    string n    = obj_name->get_text();
    bool   mc   = match_case->get_active();


    o=_findObjectByName(FWObjectDatabaseGUI::db, n ,mc, true);


    if (o && (type=="Any" || (type == o->getTypeName())) ) {


	main_w->OpenObject(o->getId() , o->getLibrary() );
    }

}

void FindDialog::on_cancel_clicked()
{   
    hide();
    glademm_set_Widget("FindDialog", NULL);
}

FindDialog::FindDialog(main_window *mw)
{
    main_w=mw;

    glademm_set_Widget("FindDialog", this);

    set_position(GTK_WIN_POS_CENTER);

    delete_event.connect( SigC::slot(this,&FindDialog::on_delete_event));

    vector<string>  types;


    types.push_back("Any");
    types.push_back("Firewall");
    types.push_back("Host");
    types.push_back("Network");
    types.push_back("ObjectGroup");
    types.push_back("IPService");
    types.push_back("ICMPService");
    types.push_back("TCPService");
    types.push_back("UDPService");
    types.push_back("ServiceGroup");
    types.push_back("Time");

    obj_type->set_menu(types);
    obj_type->show_all();

    obj_name->grab_focus();

//    button40->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
//    button40->grab_default();


    PixmapButton::addPixmapAndText( *button41 , "Cancel"       , _("Cancel") );

    show_all();
#ifdef __MINGW32__
    __fwb_win32_loadIcon("FWBuilderWin32Ico",this);
#endif
}

gint FindDialog::on_delete_event(GdkEventAny* ev)
{
    glademm_set_Widget("FindDialog", NULL);
    return false;
}
