/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ExecDialog.cc,v 1.13 2003/07/02 07:11:15 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"

#include "ExecDialog.hh"
#include "ExecBgr.hh"

using namespace libfwbuilder;

#define QUOTE_NAME(name) \
   string( (name.find(' ')!=string::npos)?"\"":"")+ \
   name+                                            \
   string( (name.find(' ')!=string::npos)?"\"":"")  


ExecDialog::ExecDialog(const string &compiler, 
		       const string &args,
		       const string &file_name, 
		       const string &obj_name,
		       const string &wdir)
    : GenericBackgroundOpDialog( bow=manage(new BackgroundOpWidget( 
                                                ebgr=new ExecBgr(compiler, 
                                                                 string("-f ")+
                                                                 QUOTE_NAME(file_name) +
                                                                 (wdir.empty()?
                                                                  string(" "):(string(" -d ")+QUOTE_NAME(wdir) ))+
                                                                 " "+args+" "+
                                                                 QUOTE_NAME(obj_name)  )
                                            )
                                 )
    )
{
}

ExecDialog::ExecDialog(const string &command, const string &args)
    : GenericBackgroundOpDialog( bow=manage(new BackgroundOpWidget( 
                                                ebgr=new ExecBgr(command,args) 
                                            )
                                 )
    )
{
}

ExecDialog::~ExecDialog()
{
    bow->disconnect();
    delete ebgr;
}
