/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Druid.cc,v 1.9 2002/09/08 19:28:37 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "Druid.hh"

#include "StockButton.hh"
#include "SimplePixmap.hh"
#include "helpers.hh"

#include <algorithm>
#include <stdio.h>
#include <assert.h>


Druid::Druid(const string& _title, const string& _logo) : 
    Gtk::Window(GTK_WINDOW_TOPLEVEL)
{
    title=_title;
    logo=_logo;

    current_page=-1;
    start_page_id=finish_page_id=-1;

    Gtk::EventBox *dbgr=manage(new Gtk::EventBox());
    dbgr->set_name("DruidBackground");

    druid_title = manage(new class Gtk::Label(title));
    assert(druid_title!=NULL);

    druid_title->set_name ("DruidTitle");

    druid_pixmap = manage(new SimplePixmap(logo) );
    assert(druid_pixmap!=NULL);

    Gtk::HBox *hbox2 = manage(new class Gtk::HBox(false, 0));
   
    Gtk::Label *label1 = manage(new class Gtk::Label("  "));
    packer1 = manage(new class Gtk::Packer());

    Gtk::HSeparator *hseparator1 = manage(new class Gtk::HSeparator());

    back   = manage(new StockButton(StockButton::BACK));
    next   = manage(new StockButton(StockButton::NEXT));
    cancel = manage(new StockButton(StockButton::CANCEL));
    finish = NULL;

    hbox1 = manage(new class Gtk::HBox(false, 20));
    vbox1 = manage(new class Gtk::VBox(false, 0));

    druid_title->set_alignment(0, 0.5);
    druid_title->set_padding(20, 10);
    druid_pixmap->set_alignment(0.5, 0.5);
    druid_pixmap->set_padding(10, 10);

    hbox2->pack_start(*druid_title);
    hbox2->pack_start(*druid_pixmap, false, false, 0);

    Gtk::Label *left_side=manage(new Gtk::Label(""));

    left_side->set_usize(64, -1);

    packer1->add(*hbox2, GTK_SIDE_TOP, GTK_ANCHOR_CENTER, GTK_FILL_X);
    packer1->add(*left_side, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, GTK_FILL_Y);

    nbook=manage(new Gtk::Notebook());
    nbook->set_name("DruidPages");
    nbook->set_show_tabs( false );
    nbook->set_show_border( false );

    Gtk::EventBox *nbookbgr=manage(new Gtk::EventBox());
    nbookbgr->set_name("DruidPageBackground");
    nbookbgr->add(*nbook);

    packer1->add(*nbookbgr, GTK_SIDE_RIGHT, GTK_ANCHOR_CENTER, 
		 GTK_EXPAND|GTK_FILL_X|GTK_FILL_Y);

//    back->set_usize(80, -1);
//    next->set_usize(80, -1);
    label1->set_alignment(0.5, 0.5);
    label1->set_padding(0, 8);
//    cancel->set_usize(80, -1);

    hbox1->set_border_width(8);

    hbox1->pack_end(*cancel, false, false, 0);
    hbox1->pack_end(*label1, false, false, 0);
    hbox1->pack_end(*next, false, false, 0);
    hbox1->pack_end(*back, false, false, 0);

    dbgr->add(*packer1);
    vbox1->pack_start(*dbgr);
    vbox1->pack_start(*hseparator1, false, false, 0);
    vbox1->pack_start(*hbox1, false, false, 0);
    set_title(title);
    add(*vbox1);

    dbgr->show();
    druid_title->show();
    druid_pixmap->show();
    hbox2->show();
    left_side->show();
    nbookbgr->show();
    nbook->show();
    packer1->show();
    hseparator1->show();
    back->show();
    next->show();
    label1->show();
    cancel->show();
    hbox1->show();
    vbox1->show();
//    show();

    back->clicked.connect(SigC::slot(this,   &Druid::on_back_clicked));
    next->clicked.connect(SigC::slot(this,   &Druid::on_next_clicked));
    cancel->clicked.connect(SigC::slot(this, &Druid::on_cancel_clicked));
}

class cmp_ptr {
    Gtk::Widget* d;
    public:
    cmp_ptr(Gtk::Widget* _d) {d=_d;}
    bool operator()(pair<const int,Gtk::Widget*> _d) { return (d==_d.second); }
};


int   Druid::getPageID(Gtk::Widget* pid)
{
    map<int,Gtk::Widget*>::iterator i=std::find_if(druid_pages.begin(),
						   druid_pages.end(),
						   cmp_ptr(pid));
    return (i!=druid_pages.end())? (*i).first : -1;
}

void  Druid::setPage(int page_id)
{
    Gtk::Widget *new_page=druid_pages[page_id];

    nbook->set_page(  nbook->page_num( *new_page ) );
    nbook->get_current()->get_child()->show_all();

    if (current_page!=-1) {
	if (page_id==finish_page_id) {
	    if(next!=NULL)
		hbox1->remove(*next);
	    next=NULL;
	    finish   = manage(new StockButton(StockButton::FINISH));
//	    finish->set_usize(80, -1);
	    finish->clicked.connect(SigC::slot(this,&Druid::on_finish_clicked));
	    hbox1->pack_end(*finish, false, false, 0);
	    hbox1->reorder_child(*finish, 2);
	    finish->show();
	} 

	if (current_page==finish_page_id && page_id!=finish_page_id) {
	    if(finish!=NULL)
		hbox1->remove(*finish);
	    finish=NULL;
	    next   = manage(new StockButton(StockButton::NEXT));
//	    next->set_usize(80, -1);
	    next->clicked.connect(SigC::slot(this,   &Druid::on_next_clicked));
	    hbox1->pack_end(*next, false, false, 0);
	    hbox1->reorder_child(*next, 2);
	    next->show();
	}
    }

    if (page_id==start_page_id) 
	set_buttons_sensitive(false,true,true);
    else
	set_buttons_sensitive(true,true,true);


    current_page=page_id;

    on_prepare();
}

void         Druid::set_buttons_sensitive(bool _back,bool _next,bool _cancel)
{
    back->set_sensitive(_back);
    if (next)   next->set_sensitive(_next);
    if (finish) finish->set_sensitive(_next);
    cancel->set_sensitive(_cancel);
}


void         Druid::createStartPage(   int page_id,const char* text)
{
    Gtk::VBox *vbx=manage(new Gtk::VBox());
    druid_pages[page_id]=vbx;

    vbx->set_border_width(20);

    Gtk::Label *lbl=manage(new Gtk::Label(text));
    vbx->pack_start(*lbl, true, true, 0);
    lbl->set_justify(GTK_JUSTIFY_LEFT);
    lbl->set_alignment(0, 0.5);

    vbx->show_all();

    char str[32]; sprintf(str,"%d",page_id);
    nbook->pages().push_front(Gtk::Notebook_Helpers::TabElem( *vbx,str ) );

    start_page_id=page_id;

    if (current_page==-1)
	setPage(page_id);
}

Gtk::VBox*   Druid::createStandardPage(int page_id)
{
    Gtk::VBox *vbx=manage(new Gtk::VBox());
    druid_pages[page_id]=vbx;

    vbx->set_border_width(20);

    vbx->show();

    char str[32]; sprintf(str,"%d",page_id);
    nbook->pages().push_back(Gtk::Notebook_Helpers::TabElem( *vbx,str ) );

    return vbx;
}

void         Druid::createStandardPage(int page_id,Gtk::Widget *page)
{
    druid_pages[page_id]=page;

    page->show_all();

    char str[32]; sprintf(str,"%d",page_id);
    nbook->pages().push_back(Gtk::Notebook_Helpers::TabElem( *page,str ) );
}

void         Druid::createFinishPage(  int page_id,const char* text)
{
    Gtk::VBox *vbx=manage(new Gtk::VBox());
    druid_pages[page_id]=vbx;

    vbx->set_border_width(20);

    Gtk::Label *lbl=manage(new Gtk::Label(text));
    vbx->pack_start(*lbl, true, true, 0);
    lbl->set_justify(GTK_JUSTIFY_LEFT);
    lbl->set_alignment(0, 0.5);

    vbx->show_all();

    char str[32]; sprintf(str,"%d",page_id);
    nbook->pages().push_back(Gtk::Notebook_Helpers::TabElem( *vbx,str ) );

    finish_page_id=page_id;
}

void Druid::on_back_clicked()
{
    if ( on_back() ) return;
    int c=current_page;
    Gtk::Widget *w=druid_pages[--c];
    if (w!=NULL) 
	setPage(c);
}

void Druid::on_next_clicked()
{
    if ( on_next() ) return;
    int c=current_page;
    Gtk::Widget *w=druid_pages[++c];
    if (w!=NULL) 
	setPage(c);
}

void Druid::on_finish_clicked()
{
    on_finish();
}

void Druid::on_cancel_clicked()
{
    if ( on_cancel() ) return;
    destroy();
}

void Druid::on_prepare()
{

}

void Druid::on_finish()
{

}



