/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP35Dialog.cc,v 1.31 2002/08/29 00:34:48 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "DiscoveryDruidP35Dialog.hh"
#include "Preferences.hh"
#include "fwbuilder/dns.hh"

#include <Druid.hh>

#include <gtk--.h>

using namespace libfwbuilder;

DiscoveryDruidP35Dialog::DiscoveryDruidP35Dialog()
{
    p35_txt->set_line_wrap(true);
    data_ready=false;
    q=NULL;
    bow=NULL;
}

/*
 *  If page gets destroyed we need to check if there is any background
 *  operation in progress. If there is, we will stop it and disconnect
 *  signal from callback
 *
 *  This has been tested: this widget's destrutor is called when
 *  user clicks "Cancel" in druid or simply closes druid window. If
 *  operation is in progress at that moment, this widget must
 *  disconnect its callback before it dies
 *  
 *  (vk)
 */
DiscoveryDruidP35Dialog::~DiscoveryDruidP35Dialog()
{
    if (q!=NULL && q->isRunning()) {
	stop_operation();
        bow->disconnect();
        delete q;
    }
}

int DiscoveryDruidP35Dialog::execute(const string& domain_name,
				     const IPAddress& ns)
{
    data_ready=false;

    /*
     *  disable "Next" button
     */
    Gtk::Widget *dr = glademm_get_Widget("DiscoveryDruid");
    ((Druid*)dr)->set_buttons_sensitive(true,false,true);

    q=new DNS_findA_query();
    q->init(domain_name , ns,
            Preferences::global_prefs->getOptInt("/FWBuilderPreferences/Network/DNSRetries", RES_DFLRETRY),
            Preferences::global_prefs->getOptInt("/FWBuilderPreferences/Network/DNSTimeout", RES_TIMEOUT)
    );
    
    if (bow==NULL) {
        bow=manage(new BackgroundOpWidget() );
        op_progress_vbox->pack_start(*bow,true,true);
        op_progress_vbox->reorder_child(*bow,0);
    }

    bow->connect(q);

    bow->clear();
    bow->show();

    try
    {
        bow->execute();   // not modal, this just starts operation
        completed_conn=bow->completed.connect(SigC::slot(this,
				  &DiscoveryDruidP35Dialog::on_completed));
        interrupt->set_sensitive(true);

	status_str->set_text(_("Reading DNS zone ..."));


    } catch(const FWException &ex)
    {
        bow->disconnect();
        delete q;
        q=NULL;
    }
    return 0;
}

void DiscoveryDruidP35Dialog::on_interrupt_clicked()
{
    stop_operation();
    interrupt->set_sensitive(false);
}

void DiscoveryDruidP35Dialog::stop_operation()
{
    q->stop_operation();
    data_ready=false;
}


bool DiscoveryDruidP35Dialog::ready()
{
    return data_ready;
}

int DiscoveryDruidP35Dialog::on_completed(int arg)
{
    interrupt->set_sensitive(false);

    hosts.clear();

    map<string,set<IPAddress> > t = q->getResult();

    for(map<string,set<IPAddress> >::iterator j = t.begin(); 
	j!=t.end(); ++j) {

	ObjectDescriptor od;
	od.addr     = *((*j).second.begin());
	od.sysname  = (*j).first;

	hosts.push_back(od);
    }

    data_ready=true;
    completed_conn.disconnect();

    bow->disconnect();
    delete q;
    q=NULL;

    if (arg==0) {

	status_str->set_text(_("DNS query completed successfully, click 'Next' to continue"));


// enable "Next" button



	Gtk::Widget *dr= glademm_get_Widget("DiscoveryDruid");



	((Druid*)dr)->set_buttons_sensitive(true,true,true);
    } 
    else

	status_str->set_text(_("There has been an error running DNS query"));



    return 0;
}

