/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruid.cc,v 1.42 2002/08/29 00:34:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "main_window.hh"

#include "DiscoveryDruid.hh"
#include "MessageDialog.hh"

#include "DiscoveryDruidP05Dialog.hh"
#include "DiscoveryDruidP10Dialog.hh"
#include "DiscoveryDruidP20Dialog.hh"
#include "DiscoveryDruidP30Dialog.hh"
#include "DiscoveryDruidP35Dialog.hh"
#include "DiscoveryDruidP40Dialog.hh"

#include "DiscoveryDruidP50Dialog.hh"
#include "DiscoveryDruidP51Dialog.hh"
#include "DiscoveryDruidP53Dialog.hh"
#include "DiscoveryDruidP65Dialog.hh"
#include "DiscoveryDruidP70Dialog.hh"

#include "FWObjectBook.hh"
#include "FWObjectDatabaseGUI.hh"

#include <gtk--.h>

#include "glademm_support.hh"

using namespace libfwbuilder;


enum {
    PAGE_S,
    PAGE_05,
    PAGE_10,
    PAGE_20,
    PAGE_30,
    PAGE_35,
    PAGE_40,
    PAGE_50,
    PAGE_51,
    PAGE_53,
    PAGE_65,
    PAGE_70,
    PAGE_F
} DiscoveryDruidPages;

/*
     The structure of Druid pages:


          10   ----------------------------------------+
         /(hosts file)                                  \
        /                                                \
       /                                                  \
     05 -------> 20   --------> 30  -------> 35  --------> 40
      \    (domain name)   (name servers)  (running)     (final list)
       \                                                  /
        \                                                / 
         \                                              /  
	  50  --- 51 ---> 53  --------> 65 -----> 70 ----+
	(crawler     (crawler       (crawler  (list of
       parameters)    snmp param)    running)  networks)
*/

DiscoveryDruid::DiscoveryDruid(main_window *mw,
                               const string &t,
			       const string& l) : Druid(t,l)
{
    main_w=mw;

    set_default_size(600,600);
    set_position(GTK_WIN_POS_CENTER);


/************************************************************************
 *    Start Page 
 */

    createStartPage(PAGE_S,

_("This druid will help you create multiple objects for\nall parts of your network.\n\nClick 'Next' to begin"));




/************************************************************************
 *    Page #05
 */

    p05=manage(new DiscoveryDruidP05Dialog());
    createStandardPage(PAGE_05,p05);

/************************************************************************
 *    Page #10
 */

    p10=manage(new DiscoveryDruidP10Dialog());
    createStandardPage(PAGE_10,p10);

/************************************************************************
 *    Page #20
 */

    p20=manage(new DiscoveryDruidP20Dialog());
    createStandardPage(PAGE_20,p20);


/************************************************************************
 *    Page #30
 */

    p30=manage(new DiscoveryDruidP30Dialog());
    createStandardPage(PAGE_30,p30);


/************************************************************************
 *    Page #35
 */

    p35=manage(new DiscoveryDruidP35Dialog());
    createStandardPage(PAGE_35,p35);


/************************************************************************
 *    Page #40
 */

    p40=manage(new DiscoveryDruidP40Dialog());
    createStandardPage(PAGE_40,p40);


/************************************************************************
 *    Page #50
 */

    p50=manage(new DiscoveryDruidP50Dialog());
    createStandardPage(PAGE_50,p50);


/************************************************************************
 *    Page #51
 */

    p51=manage(new DiscoveryDruidP51Dialog());
    createStandardPage(PAGE_51,p51);


/************************************************************************
 *    Page #53
 */

    p53=manage(new DiscoveryDruidP53Dialog());
    createStandardPage(PAGE_53,p53);


/************************************************************************
 *    Page #65
 */

    p65=manage(new DiscoveryDruidP65Dialog());
    createStandardPage(PAGE_65,p65);


/************************************************************************
 *    Page #70
 */

    p70=manage(new DiscoveryDruidP70Dialog());
    createStandardPage(PAGE_70,p70);



/************************************************************************
 *    Final Page 
 */
 
    createFinishPage(PAGE_F,

 _("Click 'Finish' to create and file objects, click 'Cancel' to discard."));



    glademm_set_Widget("DiscoveryDruid", this);


}


void DiscoveryDruid::on_prepare()
{
    int current_page=get_current_page_id();

    switch (current_page) {

    case PAGE_05:	break;
    case PAGE_10:	p10->prepare();	break;
    case PAGE_20:	p20->prepare();	break;

    case PAGE_35:
    {
/*
 *   page 35 shows DNS zone transfer in progress. Start transfer here.
 */
	p40->clearList();
	p70->clearList();

	string domain_name = p20->domain_name->get_text();
	if (domain_name=="") return;
	try {
	    IPAddress ns       = p30->getNS();
	    p35->execute( domain_name , ns );
	} catch   ( FWException &ex ) {

	    MessageDialog::Error(_("Illegal address for the name server"),this);


	    return;
	}
	return;
    }

    case PAGE_40:	p40->prepare();	break;
    case PAGE_50:	p50->prepare();	break;
    case PAGE_51:	p51->prepare();	break;
    case PAGE_53:	p53->prepare();	break;

    case PAGE_65:
    {
	p40->clearList();
	p70->clearList();
/*
 *  page 65 shows network crawler progress. Start crawler here
 */
	bool   recursive_scan = p51->recursive_scan->get_active();
	bool   include_virtual= p51->include_virtual->get_active();
	bool   do_dns         = p51->do_dns->get_active();
	bool   follow_p2p     = p51->follow_p2p->get_active();

	string snmp_community = p53->snmp_community->get_text();
	int    snmp_retries   = p53->snmp_retries->get_value_as_int();
	int    snmp_timeout   = p53->snmp_timeout->get_value_as_int();
	int    dns_retries    = p53->dns_retries->get_value_as_int();
	int    dns_timeout    = p53->dns_timeout->get_value_as_int();
	int    dns_threads_num= p53->dns_threads_num->get_value_as_int();

	include_networks.clear();

	bool   use_incl = ( p50->scan_net_addr->getAsString() != "0.0.0.0" &&
			    p50->scan_net_nm->getAsString()   != "0.0.0.0" );

	if (use_incl) {
	    IPNetwork in(p50->scan_net_addr->getAsIPAddress() ,
			 Netmask(p50->scan_net_nm->getAsString()) );
	    include_networks.push_back(in);
	}

	p65->execute(p50->seed_host_addr,
		     snmp_community,
		     recursive_scan,
		     include_virtual, do_dns, follow_p2p,
		     snmp_retries,snmp_timeout,
		     dns_retries,dns_timeout,dns_threads_num,
		     (use_incl) ? &include_networks : NULL );

	return;
    }

    case PAGE_70:	p70->prepare();	break;

    }
}

gboolean DiscoveryDruid::on_next()
{
    int current_page=get_current_page_id();
    int next_page=current_page;

    switch (current_page) {

    case PAGE_S:
	setPage(PAGE_05);
	return true;

    case PAGE_05:
	if (p05->hosts_file->get_active())        next_page=PAGE_10;
	if (p05->dns->get_active())               next_page=PAGE_20;
	if (p05->network_discovery->get_active()) next_page=PAGE_50;
        setPage(next_page);
        return true;

    case PAGE_10:
    {
	try {
	    p10->scanHostsFile();
	} catch   ( FWException &ex ) {
	    MessageDialog::Error(ex.toString(),this);
	    return true;
	}

	p40->clearList();

	p40->addTypeChoice(_("Host"));

	p40->addTypeChoice(_("Network"));

	p40->addTypeChoice(_("Firewall"));


	p40->fillListOfObjects( p10->getHosts() , "" );

	setPage(PAGE_40);
	return true;
    }


    case PAGE_20:
    {
	string domain_name=p20->domain_name->get_text();
	if (domain_name=="") return true;

	try {
	    p30->runDNSQuery( domain_name );
	} catch (FWException &ex) {
	    return true;
	}
	setPage(PAGE_30);
	return true;
    }

    case PAGE_30:
/*
 *  before we go to the next page, check if we have sane NS to work with
 */
	try {
	    p30->getNS();
	} catch  ( FWException &ex ) {

	    MessageDialog::Error(_("Illegal address for the name server"),this);
	    return true;
	}

	setPage(PAGE_35);
	return true;

    case PAGE_35:
    {
	string domain_name=p20->domain_name->get_text();
	if (domain_name=="") return true;
	if (p35->ready()) {

	    p40->clearList();

	    p40->addTypeChoice(_("Host"));

	    p40->addTypeChoice(_("Network"));

	    p40->addTypeChoice(_("Firewall"));



	    p40->fillListOfObjects( p35->getHosts(), domain_name , 
				    p20->fqdn->get_active() );
	    setPage(PAGE_40);
	} else
	    p35->stop_operation();
	return true;
    }
    
    case PAGE_40:
	setPage(PAGE_F);
	return true;

    case PAGE_50:
	if (p50->checkData()) setPage(PAGE_51);
	return true;

    case PAGE_51:
	setPage(PAGE_53);
	return true;

    case PAGE_53:
	if (p53->checkData()) setPage(PAGE_65);
	return true;
	
    case PAGE_65:
	if ( ! p65->ready()) {
	    p65->stop_operation();
	    return true;
	}
	if ( p65->getNetworks().size()!=0 ) {
	    p70->fillListOfNetworks( p65->getNetworks() );
	    setPage(PAGE_70);
	    return true;
	} 
/* else : sneak in to the PAGE_70 processing code */


    case PAGE_70:
	p40->clearList();

	p40->addTypeChoice(_("Host"));

	p40->addTypeChoice(_("Firewall"));



	p40->fillListOfObjects( p65->getHosts() , "" );
	setPage(PAGE_40);
	return true;

    }

    return true;
}

gboolean DiscoveryDruid::on_back()
{
    int current_page=get_current_page_id();
    int next_page=current_page;

    switch (current_page) {

    case PAGE_05:
        return true;

    case PAGE_10:
	setPage(PAGE_05);
	return true;

    case PAGE_20:
	setPage(PAGE_05);
	return true;

    case PAGE_30:
	setPage(PAGE_20);
	return true;

    case PAGE_35:
	if (!p35->ready())
	    p35->stop_operation();
	setPage(PAGE_30);
	return true;

    case PAGE_40:
	if (p05->hosts_file->get_active())         next_page=PAGE_10;
	if (p05->dns->get_active())                next_page=PAGE_20;
	if (p05->network_discovery->get_active())  {
	    if ( p65->getNetworks().size()!=0 )    next_page=PAGE_70;
	    else                                   next_page=PAGE_53;
	}
	setPage(next_page);
	return true;

    case PAGE_50:
	setPage(PAGE_05);
	return true;

    case PAGE_51:
	setPage(PAGE_50);
	return true;

    case PAGE_53:
	setPage(PAGE_51);
	return true;

    case PAGE_65:
	if (!p65->ready())
	    p65->stop_operation();
	setPage(PAGE_53);
	return true;

    case PAGE_70:
	setPage(PAGE_53);
	return true;

    case PAGE_F:
	if (p05->hosts_file->get_active())         next_page=PAGE_10;
	if (p05->dns->get_active())                next_page=PAGE_20;
	if (p05->network_discovery->get_active())  next_page=PAGE_40;
	setPage(next_page);
	return true;

    }
    return  true;
}

gboolean DiscoveryDruid::on_cancel()
{
    destroy();
    return true;
}


void DiscoveryDruid::on_finish()
{
    p70->createObjects();
    p40->createObjects();

    main_window::refreshAllObjectBooks();

    destroy();
}

