/* ***** BEGIN LICENSE BLOCK *****
 * FW4SPL - Copyright (C) IRCAD, 2009-2016.
 * Distributed under the terms of the GNU Lesser General Public License (LGPL) as
 * published by the Free Software Foundation.
 * ****** END LICENSE BLOCK ****** */

#include <vector>

#include "fwServices/IService.hpp"
#include "fwServices/op/Get.hpp"

namespace fwServices
{

//------------------------------------------------------------------------------

::fwServices::IService::sptr get( ::fwData::Object::sptr obj, std::string serviceType )
{
    ::fwServices::IService::sptr service;
    auto services = ::fwServices::OSR::getServices( obj, serviceType );
    OSLM_ASSERT("Service "<<serviceType<<" is not unique, registered "<<services.size()<<" times",
                services.size() == 1);
    return *services.begin();
}

//------------------------------------------------------------------------------

::fwServices::IService::sptr get( std::string uid )
{
    OSLM_ASSERT("service does not exist with uid "<<uid, ::fwTools::fwID::exist(uid ));
    return ::fwServices::IService::dynamicCast( ::fwTools::fwID::getObject( uid ) );
}

//------------------------------------------------------------------------------

}

