| Branch |    Status |
|--------|-----------|
| Dev    | [![Build Status](https://travis-ci.org/fw4spl-org/fw4spl.svg?branch=dev)](https://travis-ci.org/fw4spl-org/fw4spl) |
| Master | [![Build Status](https://travis-ci.org/fw4spl-org/fw4spl.svg?branch=master)](https://travis-ci.org/fw4spl-org/fw4spl) |


Description
===========

**FW4SPL** is a framework for fast and easy creation of applications, mainly in the medical imaging field.
It includes various features such as 2D and 3D digital image processing, visualization, augmented reality and medical interaction simulation. It runs on many different environments (Windows, linux, OSX), is written in C++, and features rapid interface design using XML files.
It is freely available under open source license (LGPL).

See [documentation](http://fw4spl.readthedocs.org/) for more details.

Applications
============

*FW4SPL* comes with **VRRender**, a medical image and segmentation viewer. It supports many format including DICOM, vtk, inr, etc...

Lots of **tutorials** and **examples** can also be found in the *Samples/* directory. The tutorials can help you to learn smoothly how to use *FW4SPL*, detailed steps are described [here for **stable** version](http://fw4spl.readthedocs.io/en/master/Tutorials/index.html)  and [here for **latest** version](http://fw4spl.readthedocs.io/en/dev/Tutorials/index.html).

Install
=======

See how to install fw4spl :
 - [stable version](http://fw4spl.readthedocs.org/en/master/Installation/index.html)
 - [latest version](http://fw4spl.readthedocs.org/en/dev/Installation/index.html)

Documentation
=============

* **[Documentation](http://fw4spl.readthedocs.org/)**
* **Tutorials**
 * [stable](http://fw4spl.readthedocs.io/en/master/Tutorials/index.html)
 * [latest](http://fw4spl.readthedocs.io/en/dev/Tutorials/index.html)
* **[Doxygen](http://fw4spl-org.github.io/fw4spl-dox/)**
* **[Blog](http://fw4spl-org.github.io/fw4spl-blog/)**

Annex
=====

* [fw4spl-deps](https://github.com/fw4spl-org/fw4spl-deps): contains the scripts to compile the external libraries used by fw4spl (Boost, VTK, ITK, Qt, ...)
* [fw4spl-ar](https://github.com/fw4spl-org/fw4spl-ar): fw4spl repository that contains additional functionalities for Augmented Reality
* [fw4spl-droid](https://github.com/fw4spl-org/fw4spl-droid): fw4spl repository that brings Android support.
* [fw4spl-ogre](https://github.com/fw4spl-org/fw4spl-ogre): fw4spl repository that offers a new 3D rendering backend using [Ogre3D](http://www.ogre3d.org/).
* [fw4spl community](https://github.com/fw4spl-org): contains various repositories associated with fw4spl (extensions, dependencies, ...)
