# First draft 06/27/96    Jianjun

# constrct a FitsImage object
# FitsImage FitsImageObjName FitsFileObjName chdu 

class WFPC2Image {
    inherit FitsImage
    constructor {args} {
	eval FitsImage::constructor $args
    } {
	puts $args 
    }

    private method readInTable {} 
    private method saveTableToAscii  {win asciiFileName} 

    private method powMakeImage {} 
}



body WFPC2Image::readInTable { } {

    set DC(height)   20
    set DC(width)     [expr (int(log10($numRows))+6)*$charPix]
    set DC(headroom) 20
    set DC(footroom) 40
    set DC(vscrollsize) 15
    set DC(hscrollsize) 15
    set DC(rightspace) 6
    set DC(interline)    0
    set DC(tmar)         6
    set DC(lmar)         8
    set DC(tabspace)     0

# flag that the imageTable is being displayed
    set isImageTable 1

    if { $imgType == 0 } {
	set cellSize 8
    } elseif {$imgType == 1} {
	set cellSize 8
    } elseif {$imgType == 2} {
	set cellSize 16
    } elseif {$imgType == 3} {
	set cellSize 16
    } elseif {$imgType == 4} {
	set cellSize 20
    } else {
	set cellSize 8
    }

    set colSelList {}
    set dispCols $numCols
    set tabType Image

# use fits command setrowstate to initialize the rowState
# usage   setrowstate totalNumOfRos startRow endRow status 
# (0:normal, 1:selected, 2: deleted)
    setarray rowState 0 [expr $numRows-1] 0
    setarray colState 0 [expr $dispCols-1] 0

    set absXPos(0) [expr $DC(lmar) + $DC(width)/2]
    for {set i 0} {$i < $dispCols} {incr i} {
	set columnName($i) [expr $i+1]
	set columnType($i) " "
	set columnUnit($i) " "
	lappend colSelList [expr $i+1]
	set cellWidth($i) $cellSize 
	set cellPixWidth($i) [expr $charPix*(1+$cellWidth($i))]
	set absXPos([expr $i+1]) [expr $absXPos($i) + $cellPixWidth($i) \
				      +$DC(rightspace)] 
    }

}


body WFPC2Image::powMakeImage {} {
    global powWCS

    # get the pow widget 
    if { [winfo exist .pow.pow]!=1 } { 
	powInit .dummy
    }


    set cleanFileName [file tail $fileName]
    set imgIndex  ${cleanFileName}_[expr $chdu-1]
    set imgHandle ${cleanFileName}_[expr $chdu-1]

    for {set i 1} {$i <=4} {incr i} {
	set ii $i
	set dataAddress [$fFObj loadImageSlice $i [expr $i-1]] 
# the last param is for copying  data
	eval powCreateData ${imgHandle}_$ii $dataAddress $imgType \
		       [expr $numCols*$numRows] 1
	# free the data array
	$fFObj freeImage $dataAddress
    }
    # get the wcs info and pass them to pow
    # for WFPC images, the wcs info are stored in the second extension.
#    $fFObj move +1
#    set crval1 [$fFObj get table crval1]
#    set crval2 [$fFObj get table crval2]
#    set crpix1 [$fFObj get table crpix1]
#    set crpix2 [$fFObj get table crpix2]
#    set cd1_1  [$fFObj get table cd1_1 ]
#    set cd1_2  [$fFObj get table cd1_2 ]
#    set cd2_1  [$fFObj get table cd1_1 ]
#    set cd2_2  [$fFObj get table cd1_2 ]
    

    set x_0 1
    set y_0 1
    set incrx 1
    set incry 1
    set x_label ""
    set y_label ""
    set x_unit "pixels"
    set y_unit "pixels"


    # Get the WCS info (if needed) and pass them to pow

    if { $fvPref::ifWCSInfo } {

       set wcsinfo [$fFObj getWcs]
       set powWCS($imgIndex) $wcsinfo
       set x_label [lindex [lindex $wcsinfo 3] 0]
       set y_label [lindex [lindex $wcsinfo 3] 1]
       if { $x_unit=="pixels" } {set x_unit NULL}
       if { $y_unit=="pixels" } {set y_unit NULL}

    } else {
       set powWCS($imgIndex) ""
    }


    for {set i 1} {$i <=4} {incr i} {
# position the frames
#    2 1
#    3 4
	switch $i {
	    "1" {
		set x_0 [expr 1+$numCols]
		set y_0 [expr 1+$numRows]
		set incrx 1
		set incry 1
	    }
	    "2" {
		set x_0 1
		set y_0 [expr 1+$numRows]
		set incrx 1
		set incry 1
	    }
	    "3" {
		set x_0 1
		set y_0 1
	    }
	    "4" {
		set x_0 [expr 1+$numCols]
		set y_0 1 
		set incrx 1
		set incry 1

	    }
	}

	set ii $i
	powCreateImage ${imgHandle}_$ii ${imgHandle}_$ii 0 0\
		       $numCols $numRows $x_0 \
		       $incrx $y_0 $incry $x_label $y_label counts
	set powRBmin(${imgHandle}_$ii) 0
	set powRBmax(${imgHandle}_$ii) 1000
    }

    powCreateGraph $imgHandle NULL \
	[list ${imgHandle}_1  ${imgHandle}_2 ${imgHandle}_3 ${imgHandle}_4] \
		   $x_unit $y_unit \
		   $x_label $y_label \
		   [lindex $fvPref::graphDispSize 0] [lindex $fvPref::graphDispSize 1] 
}

body WFPC2Image::saveTableToAscii  {win asciiFileName} {

# setup the grouping 
  set tmpWidth  $cellSize
  set tmpFirstCol(0) 1
  set groupCount  0  

  for {set  n 0} {$n < $numCols-1} {incr n} {
      set tmpWidth [expr  $tmpWidth + $cellSize]
      if { $tmpWidth > $asciiColWidth} {
      incr groupCount 
      set tmpWidth  $cellSize;
	  set tmpFirstCol($groupCount) [expr  $n+2]
    }
  }
  incr groupCount
  set tmpFirstCol($groupCount) [expr 1+$numCols]

  $win.f.fb configure -steps $groupCount
  for {set k 0} {$k< $groupCount} {incr k} {
      set nCols  [expr $tmpFirstCol([expr $k+1])-$tmpFirstCol($k)]
      $fFObj saveImgToASCII $asciiFileName $k \
	  1 $numRows $tmpFirstCol($k) $nCols $cellSize
      if {[catch {$win.f.fb step}] == 1} {
	  file delete $asciiFileName
	  return
      }
  }
  destroy $win

}


















