/* settings.c: Handling configuration settings
   Copyright (c) 2002 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

   Author contact information:

   E-mail: philip-fuse@shadowmagic.org.uk

*/
#line 62"./settings.pl"

/* This file is autogenerated from settings.dat by settings.pl.
   Do not edit unless you know what will happen! */

#include <config.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#ifdef HAVE_GETOPT_LONG		/* Did our libc include getopt_long? */
#include <getopt.h>
#elif defined AMIGA || defined __MORPHOS__            /* #ifdef HAVE_GETOPT_LONG */
/* The platform uses GNU getopt, but not getopt_long, so we get
   symbol clashes on this platform. Just use getopt */
#else				/* #ifdef HAVE_GETOPT_LONG */
#include "compat.h"		/* If not, use ours */
#endif				/* #ifdef HAVE_GETOPT_LONG */

#ifdef HAVE_LIB_XML2
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#endif				/* #ifdef HAVE_LIB_XML2 */

#include "fuse.h"
#include "infrastructure/startup_manager.h"
#include "machine.h"
#include "settings.h"
#include "spectrum.h"
#include "ui/ui.h"
#include "utils.h"

/* The name of our configuration file */
#ifdef WIN32
#define CONFIG_FILE_NAME "fuse.cfg"
#else				/* #ifdef WIN32 */
#define CONFIG_FILE_NAME ".fuserc"
#endif				/* #ifdef WIN32 */

/* The current settings of options, etc */
settings_info settings_current;

/* The default settings of options, etc */
settings_info settings_default = {
  /* accelerate_loader */ 1,
  /* aspect_hint */ 1,
  /* auto_load */ 1,
  /* autosave_settings */ 0,
  /* beta128 */ 0,
  /* beta128_48boot */ 1,
  /* betadisk_file */ (char *)NULL,
  /* bw_tv */ 0,
  /* competition_code */ 0,
  /* competition_mode */ 0,
  /* confirm_actions */ 1,
  /* covox */ 0,
  /* dck_file */ (char *)NULL,
  /* debugger_command */ (char *)NULL,
  /* detect_loader */ 1,
  /* didaktik80 */ 0,
  /* didaktik80disk_file */ (char *)NULL,
  /* disciple */ 0,
  /* discipledisk_file */ (char *)NULL,
  /* disk_ask_merge */ 1,
  /* disk_try_merge */ (char *)NULL,
  /* divide_enabled */ 0,
  /* divide_master_file */ (char *)NULL,
  /* divide_slave_file */ (char *)NULL,
  /* divide_wp */ 0,
  /* doublescan_mode */ 1,
  /* drive_40_max_track */ 42,
  /* drive_80_max_track */ 84,
  /* drive_beta128a_type */ (char *)NULL,
  /* drive_beta128b_type */ (char *)NULL,
  /* drive_beta128c_type */ (char *)NULL,
  /* drive_beta128d_type */ (char *)NULL,
  /* drive_didaktik80a_type */ (char *)NULL,
  /* drive_didaktik80b_type */ (char *)NULL,
  /* drive_disciple1_type */ (char *)NULL,
  /* drive_disciple2_type */ (char *)NULL,
  /* drive_opus1_type */ (char *)NULL,
  /* drive_opus2_type */ (char *)NULL,
  /* drive_plus3a_type */ (char *)NULL,
  /* drive_plus3b_type */ (char *)NULL,
  /* drive_plusd1_type */ (char *)NULL,
  /* drive_plusd2_type */ (char *)NULL,
  /* embed_snapshot */ 1,
  /* emulation_speed */ 100,
  /* fastload */ 1,
  /* fb_mode */ 320,
  /* frame_rate */ 1,
  /* full_screen */ 0,
  /* fuller */ 0,
  /* if2_file */ (char *)NULL,
  /* interface1 */ 0,
  /* interface2 */ 1,
  /* issue2 */ 0,
  /* joy_kempston */ 0,
  /* joy_prompt */ 0,
  /* joystick_1 */ (char *)NULL,
  /* joystick_1_fire_1 */ 4096,
  /* joystick_1_fire_10 */ 4096,
  /* joystick_1_fire_11 */ 4096,
  /* joystick_1_fire_12 */ 4096,
  /* joystick_1_fire_13 */ 4096,
  /* joystick_1_fire_14 */ 4096,
  /* joystick_1_fire_15 */ 4096,
  /* joystick_1_fire_2 */ 4096,
  /* joystick_1_fire_3 */ 4096,
  /* joystick_1_fire_4 */ 4096,
  /* joystick_1_fire_5 */ 4096,
  /* joystick_1_fire_6 */ 4096,
  /* joystick_1_fire_7 */ 4096,
  /* joystick_1_fire_8 */ 4096,
  /* joystick_1_fire_9 */ 4096,
  /* joystick_1_output */ 0,
  /* joystick_2 */ (char *)NULL,
  /* joystick_2_fire_1 */ 4096,
  /* joystick_2_fire_10 */ 4096,
  /* joystick_2_fire_11 */ 4096,
  /* joystick_2_fire_12 */ 4096,
  /* joystick_2_fire_13 */ 4096,
  /* joystick_2_fire_14 */ 4096,
  /* joystick_2_fire_15 */ 4096,
  /* joystick_2_fire_2 */ 4096,
  /* joystick_2_fire_3 */ 4096,
  /* joystick_2_fire_4 */ 4096,
  /* joystick_2_fire_5 */ 4096,
  /* joystick_2_fire_6 */ 4096,
  /* joystick_2_fire_7 */ 4096,
  /* joystick_2_fire_8 */ 4096,
  /* joystick_2_fire_9 */ 4096,
  /* joystick_2_output */ 0,
  /* joystick_keyboard_down */ 97,
  /* joystick_keyboard_fire */ 32,
  /* joystick_keyboard_left */ 111,
  /* joystick_keyboard_output */ 0,
  /* joystick_keyboard_right */ 112,
  /* joystick_keyboard_up */ 113,
  /* kempston_mouse */ 0,
  /* keyboard_arrows_shifted */ 1,
  /* late_timings */ 0,
  /* mdr_file */ (char *)NULL,
  /* mdr_file2 */ (char *)NULL,
  /* mdr_file3 */ (char *)NULL,
  /* mdr_file4 */ (char *)NULL,
  /* mdr_file5 */ (char *)NULL,
  /* mdr_file6 */ (char *)NULL,
  /* mdr_file7 */ (char *)NULL,
  /* mdr_file8 */ (char *)NULL,
  /* mdr_len */ 180,
  /* mdr_random_len */ 1,
  /* melodik */ 0,
  /* mouse_swap_buttons */ 0,
  /* movie_compr */ (char *)NULL,
  /* movie_start */ (char *)NULL,
  /* movie_stop_after_rzx */ 1,
  /* multiface1 */ 0,
  /* multiface128 */ 0,
  /* multiface1_stealth */ 0,
  /* multiface3 */ 0,
  /* opus */ 0,
  /* opusdisk_file */ (char *)NULL,
  /* pal_tv2x */ 0,
  /* playback_file */ (char *)NULL,
  /* plus3_detect_speedlock */ 1,
  /* plus3disk_file */ (char *)NULL,
  /* plusd */ 0,
  /* plusddisk_file */ (char *)NULL,
  /* printer */ 0,
  /* printer_graphics_filename */ (char *)"printout.pbm",
  /* printer_text_filename */ (char *)"printout.txt",
  /* raw_s_net */ 0,
  /* record_file */ (char *)NULL,
  /* recreated_spectrum */ 0,
  /* rom_128_0 */ (char *)"128-0.rom",
  /* rom_128_1 */ (char *)"128-1.rom",
  /* rom_16 */ (char *)"48.rom",
  /* rom_48 */ (char *)"48.rom",
  /* rom_beta128 */ (char *)"trdos.rom",
  /* rom_didaktik80 */ (char *)"didaktik80.rom",
  /* rom_disciple */ (char *)"disciple.rom",
  /* rom_interface_1 */ (char *)"if1-2.rom",
  /* rom_multiface1 */ (char *)"mf1.rom",
  /* rom_multiface128 */ (char *)"mf128.rom",
  /* rom_multiface3 */ (char *)"mf3.rom",
  /* rom_opus */ (char *)"opus.rom",
  /* rom_pentagon1024_0 */ (char *)"128p-0.rom",
  /* rom_pentagon1024_1 */ (char *)"128p-1.rom",
  /* rom_pentagon1024_2 */ (char *)"trdos.rom",
  /* rom_pentagon1024_3 */ (char *)"gluck.rom",
  /* rom_pentagon512_0 */ (char *)"128p-0.rom",
  /* rom_pentagon512_1 */ (char *)"128p-1.rom",
  /* rom_pentagon512_2 */ (char *)"trdos.rom",
  /* rom_pentagon512_3 */ (char *)"gluck.rom",
  /* rom_pentagon_0 */ (char *)"128p-0.rom",
  /* rom_pentagon_1 */ (char *)"128p-1.rom",
  /* rom_pentagon_2 */ (char *)"trdos.rom",
  /* rom_plus2_0 */ (char *)"plus2-0.rom",
  /* rom_plus2_1 */ (char *)"plus2-1.rom",
  /* rom_plus2a_0 */ (char *)"plus3-0.rom",
  /* rom_plus2a_1 */ (char *)"plus3-1.rom",
  /* rom_plus2a_2 */ (char *)"plus3-2.rom",
  /* rom_plus2a_3 */ (char *)"plus3-3.rom",
  /* rom_plus3_0 */ (char *)"plus3-0.rom",
  /* rom_plus3_1 */ (char *)"plus3-1.rom",
  /* rom_plus3_2 */ (char *)"plus3-2.rom",
  /* rom_plus3_3 */ (char *)"plus3-3.rom",
  /* rom_plus3e_0 */ (char *)"plus3e-0.rom",
  /* rom_plus3e_1 */ (char *)"plus3e-1.rom",
  /* rom_plus3e_2 */ (char *)"plus3e-2.rom",
  /* rom_plus3e_3 */ (char *)"plus3e-3.rom",
  /* rom_plusd */ (char *)"plusd.rom",
  /* rom_scorpion_0 */ (char *)"256s-0.rom",
  /* rom_scorpion_1 */ (char *)"256s-1.rom",
  /* rom_scorpion_2 */ (char *)"256s-2.rom",
  /* rom_scorpion_3 */ (char *)"256s-3.rom",
  /* rom_spec_se_0 */ (char *)"se-0.rom",
  /* rom_spec_se_1 */ (char *)"se-1.rom",
  /* rom_speccyboot */ (char *)"speccyboot-1.4.rom",
  /* rom_tc2048 */ (char *)"tc2048.rom",
  /* rom_tc2068_0 */ (char *)"tc2068-0.rom",
  /* rom_tc2068_1 */ (char *)"tc2068-1.rom",
  /* rom_ts2068_0 */ (char *)"tc2068-0.rom",
  /* rom_ts2068_1 */ (char *)"tc2068-1.rom",
  /* rom_usource */ (char *)"usource.rom",
  /* rs232_handshake */ 0,
  /* rs232_rx */ (char *)NULL,
  /* rs232_tx */ (char *)NULL,
  /* rzx_autosaves */ 1,
  /* rzx_compression */ 1,
  /* simpleide_active */ 0,
  /* simpleide_master_file */ (char *)NULL,
  /* simpleide_slave_file */ (char *)NULL,
  /* slt_traps */ 1,
  /* snapshot */ (char *)NULL,
  /* snet */ (char *)NULL,
  /* sound */ 1,
  /* sound_device */ (char *)NULL,
  /* sound_force_8bit */ 0,
  /* sound_freq */ 32000,
  /* sound_load */ 1,
  /* speaker_type */ (char *)NULL,
  /* speccyboot */ 0,
  /* speccyboot_tap */ (char *)"tap0",
  /* specdrum */ 0,
  /* spectranet */ 0,
  /* spectranet_disable */ 0,
  /* start_machine */ (char *)"48",
  /* start_scaler_mode */ (char *)"normal",
  /* statusbar */ 1,
  /* stereo_ay */ (char *)NULL,
  /* strict_aspect_hint */ 0,
  /* svga_modes */ (char *)NULL,
  /* tape_file */ (char *)NULL,
  /* tape_traps */ 1,
  /* unittests */ 0,
  /* usource */ 0,
  /* volume_ay */ 100,
  /* volume_beeper */ 100,
  /* volume_covox */ 100,
  /* volume_specdrum */ 100,
  /* writable_roms */ 0,
  /* z80_is_cmos */ 0,
  /* zxatasp_active */ 0,
  /* zxatasp_master_file */ (char *)NULL,
  /* zxatasp_slave_file */ (char *)NULL,
  /* zxatasp_upload */ 0,
  /* zxatasp_wp */ 0,
  /* zxcf_active */ 0,
  /* zxcf_pri_file */ (char *)NULL,
  /* zxcf_upload */ 0,
  /* zxprinter */ 1,
#line 122"./settings.pl"
  /* show_help */ 0,
  /* show_version */ 0,
};

static int read_config_file( settings_info *settings );

#ifdef HAVE_LIB_XML2
static int parse_xml( xmlDocPtr doc, settings_info *settings );
#else				/* #ifdef HAVE_LIB_XML2 */
static int parse_ini( utils_file *file, settings_info *settings );
#endif				/* #ifdef HAVE_LIB_XML2 */

static int settings_command_line( settings_info *settings, int *first_arg,
				  int argc, char **argv );

static void settings_copy_internal( settings_info *dest, settings_info *src );

/* Called on emulator startup */
int
settings_init( int *first_arg, int argc, char **argv )
{
  int error;

  settings_defaults( &settings_current );

  error = read_config_file( &settings_current );
  if( error ) return error;

  error = settings_command_line( &settings_current, first_arg, argc, argv );
  if( error ) return error;

  return 0;
}

/* Fill the settings structure with sensible defaults */
void settings_defaults( settings_info *settings )
{
  settings_copy_internal( settings, &settings_default );
}

#ifdef HAVE_LIB_XML2

/* Read options from the config file (if libxml2 is available) */

static int
read_config_file( settings_info *settings )
{
  const char *home; char path[ PATH_MAX ];

  xmlDocPtr doc;

  home = compat_get_home_path(); if( !home ) return 1;

  snprintf( path, PATH_MAX, "%s/%s", home, CONFIG_FILE_NAME );

  /* See if the file exists; if doesn't, it's not a problem */
  if( !compat_file_exists( path ) ) {
      return 0;
  }

  doc = xmlReadFile( path, NULL, 0 );
  if( !doc ) {
    ui_error( UI_ERROR_ERROR, "error reading config file" );
    return 1;
  }

  if( parse_xml( doc, settings ) ) {
    xmlFreeDoc( doc );
    return 1;
  }

  xmlFreeDoc( doc );

  return 0;
}

static int
parse_xml( xmlDocPtr doc, settings_info *settings )
{
  xmlNodePtr node;
  xmlChar *xmlstring;

  node = xmlDocGetRootElement( doc );
  if( xmlStrcmp( node->name, (const xmlChar*)"settings" ) ) {
    ui_error( UI_ERROR_ERROR, "config file's root node is not 'settings'" );
    return 1;
  }

  node = node->xmlChildrenNode;
  while( node ) {

    if( !strcmp( (const char*)node->name, "accelerateloader" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->accelerate_loader = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "aspecthint" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->aspect_hint = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "autoload" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->auto_load = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "autosavesettings" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->autosave_settings = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "beta128" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->beta128 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "beta12848boot" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->beta128_48boot = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "betadisk" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->betadisk_file );
        settings->betadisk_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "bwtv" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->bw_tv = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "competitioncode" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->competition_code = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "competitionmode" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->competition_mode = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "confirmactions" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->confirm_actions = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "covox" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->covox = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "dock" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->dck_file );
        settings->dck_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "debuggercommand" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->debugger_command );
        settings->debugger_command = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "detectloader" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->detect_loader = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "didaktik80" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->didaktik80 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "didaktik80disk" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->didaktik80disk_file );
        settings->didaktik80disk_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "disciple" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->disciple = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "discipledisk" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->discipledisk_file );
        settings->discipledisk_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "diskaskmerge" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->disk_ask_merge = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "disktrymerge" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->disk_try_merge );
        settings->disk_try_merge = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "divide" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->divide_enabled = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "dividemasterfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->divide_master_file );
        settings->divide_master_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "divideslavefile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->divide_slave_file );
        settings->divide_slave_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "dividewriteprotect" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->divide_wp = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "doublescreen" ) ) {
      /* Do nothing */
    } else
    if( !strcmp( (const char*)node->name, "doublescanmode" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->doublescan_mode = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "drive40maxtrack" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->drive_40_max_track = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "drive80maxtrack" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->drive_80_max_track = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "drivebeta128atype" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_beta128a_type );
        settings->drive_beta128a_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "drivebeta128btype" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_beta128b_type );
        settings->drive_beta128b_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "drivebeta128ctype" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_beta128c_type );
        settings->drive_beta128c_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "drivebeta128dtype" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_beta128d_type );
        settings->drive_beta128d_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "drivedidaktik80atype" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_didaktik80a_type );
        settings->drive_didaktik80a_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "drivedidaktik80btype" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_didaktik80b_type );
        settings->drive_didaktik80b_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "drivedisciple1type" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_disciple1_type );
        settings->drive_disciple1_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "drivedisciple2type" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_disciple2_type );
        settings->drive_disciple2_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "driveopus1type" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_opus1_type );
        settings->drive_opus1_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "driveopus2type" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_opus2_type );
        settings->drive_opus2_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "driveplus3atype" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_plus3a_type );
        settings->drive_plus3a_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "driveplus3btype" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_plus3b_type );
        settings->drive_plus3b_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "driveplusd1type" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_plusd1_type );
        settings->drive_plusd1_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "driveplusd2type" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->drive_plusd2_type );
        settings->drive_plusd2_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "embedsnapshot" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->embed_snapshot = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "speed" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->emulation_speed = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "fastload" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->fastload = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "fbmode" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->fb_mode = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rate" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->frame_rate = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "fullscreen" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->full_screen = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "fuller" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->fuller = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "if2cart" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->if2_file );
        settings->if2_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "interface1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->interface1 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "interface2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->interface2 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "issue2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->issue2 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "kempston" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joy_kempston = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystickprompt" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joy_prompt = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->joystick_1 );
        settings->joystick_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_1 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire10" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_10 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire11" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_11 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire12" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_12 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire13" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_13 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire14" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_14 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire15" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_15 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_2 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_3 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire4" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_4 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire5" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_5 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire6" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_6 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire7" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_7 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire8" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_8 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1fire9" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_fire_9 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick1output" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_1_output = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->joystick_2 );
        settings->joystick_2 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_1 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire10" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_10 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire11" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_11 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire12" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_12 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire13" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_13 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire14" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_14 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire15" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_15 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_2 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_3 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire4" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_4 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire5" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_5 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire6" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_6 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire7" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_7 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire8" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_8 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2fire9" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_fire_9 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystick2output" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_2_output = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboarddown" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_keyboard_down = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboardfire" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_keyboard_fire = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboardleft" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_keyboard_left = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboardoutput" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_keyboard_output = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboardright" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_keyboard_right = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "joystickkeyboardup" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->joystick_keyboard_up = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "kempstonmouse" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->kempston_mouse = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "keyboardarrowsshifted" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->keyboard_arrows_shifted = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "latetimings" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->late_timings = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "microdrivefile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->mdr_file );
        settings->mdr_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "microdrive2file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->mdr_file2 );
        settings->mdr_file2 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "microdrive3file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->mdr_file3 );
        settings->mdr_file3 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "microdrive4file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->mdr_file4 );
        settings->mdr_file4 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "microdrive5file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->mdr_file5 );
        settings->mdr_file5 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "microdrive6file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->mdr_file6 );
        settings->mdr_file6 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "microdrive7file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->mdr_file7 );
        settings->mdr_file7 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "microdrive8file" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->mdr_file8 );
        settings->mdr_file8 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "mdrlen" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->mdr_len = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "mdrrandomlen" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->mdr_random_len = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "melodik" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->melodik = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "mouseswapbuttons" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->mouse_swap_buttons = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "moviecompr" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->movie_compr );
        settings->movie_compr = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "moviestart" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->movie_start );
        settings->movie_start = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "moviestopafterrzx" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->movie_stop_after_rzx = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "multiface1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->multiface1 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "multiface128" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->multiface128 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "multiface1stealth" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->multiface1_stealth = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "multiface3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->multiface3 = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "opus" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->opus = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "opusdisk" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->opusdisk_file );
        settings->opusdisk_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "paltv2x" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->pal_tv2x = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "playbackfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->playback_file );
        settings->playback_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "plus3detectspeedlock" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->plus3_detect_speedlock = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "plus3disk" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->plus3disk_file );
        settings->plus3disk_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "plusd" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->plusd = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "plusddisk" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->plusddisk_file );
        settings->plusddisk_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "printer" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->printer = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "graphicsfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->printer_graphics_filename );
        settings->printer_graphics_filename = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "textfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->printer_text_filename );
        settings->printer_text_filename = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rawrs232" ) ) {
      /* Do nothing */
    } else
    if( !strcmp( (const char*)node->name, "rawsnet" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->raw_s_net = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "recordfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->record_file );
        settings->record_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "recreatedspectrum" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->recreated_spectrum = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rom1280" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_128_0 );
        settings->rom_128_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rom1281" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_128_1 );
        settings->rom_128_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rom16" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_16 );
        settings->rom_16 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rom48" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_48 );
        settings->rom_48 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rombeta128" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_beta128 );
        settings->rom_beta128 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romdidaktik80" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_didaktik80 );
        settings->rom_didaktik80 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romdisciple" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_disciple );
        settings->rom_disciple = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rominterfacei" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_interface_1 );
        settings->rom_interface_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rommultiface1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_multiface1 );
        settings->rom_multiface1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rommultiface128" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_multiface128 );
        settings->rom_multiface128 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rommultiface3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_multiface3 );
        settings->rom_multiface3 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romopus" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_opus );
        settings->rom_opus = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon10240" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon1024_0 );
        settings->rom_pentagon1024_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon10241" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon1024_1 );
        settings->rom_pentagon1024_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon10242" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon1024_2 );
        settings->rom_pentagon1024_2 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon10243" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon1024_3 );
        settings->rom_pentagon1024_3 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon5120" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon512_0 );
        settings->rom_pentagon512_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon5121" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon512_1 );
        settings->rom_pentagon512_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon5122" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon512_2 );
        settings->rom_pentagon512_2 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon5123" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon512_3 );
        settings->rom_pentagon512_3 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon0" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon_0 );
        settings->rom_pentagon_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon_1 );
        settings->rom_pentagon_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rompentagon2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_pentagon_2 );
        settings->rom_pentagon_2 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus20" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus2_0 );
        settings->rom_plus2_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus21" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus2_1 );
        settings->rom_plus2_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus2a0" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus2a_0 );
        settings->rom_plus2a_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus2a1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus2a_1 );
        settings->rom_plus2a_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus2a2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus2a_2 );
        settings->rom_plus2a_2 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus2a3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus2a_3 );
        settings->rom_plus2a_3 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus30" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus3_0 );
        settings->rom_plus3_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus31" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus3_1 );
        settings->rom_plus3_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus32" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus3_2 );
        settings->rom_plus3_2 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus33" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus3_3 );
        settings->rom_plus3_3 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus3e0" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus3e_0 );
        settings->rom_plus3e_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus3e1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus3e_1 );
        settings->rom_plus3e_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus3e2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus3e_2 );
        settings->rom_plus3e_2 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplus3e3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plus3e_3 );
        settings->rom_plus3e_3 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romplusd" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_plusd );
        settings->rom_plusd = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romscorpion0" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_scorpion_0 );
        settings->rom_scorpion_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romscorpion1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_scorpion_1 );
        settings->rom_scorpion_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romscorpion2" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_scorpion_2 );
        settings->rom_scorpion_2 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romscorpion3" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_scorpion_3 );
        settings->rom_scorpion_3 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romspecse0" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_spec_se_0 );
        settings->rom_spec_se_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romspecse1" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_spec_se_1 );
        settings->rom_spec_se_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romspeccyboot" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_speccyboot );
        settings->rom_speccyboot = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romtc2048" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_tc2048 );
        settings->rom_tc2048 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romtc20680" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_tc2068_0 );
        settings->rom_tc2068_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romtc20681" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_tc2068_1 );
        settings->rom_tc2068_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romts20680" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_ts2068_0 );
        settings->rom_ts2068_0 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romts20681" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_ts2068_1 );
        settings->rom_ts2068_1 = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "romusource" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rom_usource );
        settings->rom_usource = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rs232handshake" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->rs232_handshake = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rs232rx" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rs232_rx );
        settings->rs232_rx = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rs232tx" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->rs232_tx );
        settings->rs232_tx = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "rzxautosaves" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->rzx_autosaves = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "compressrzx" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->rzx_compression = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "simpleide" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->simpleide_active = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "simpleidemasterfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->simpleide_master_file );
        settings->simpleide_master_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "simpleideslavefile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->simpleide_slave_file );
        settings->simpleide_slave_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "slttraps" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->slt_traps = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "snapsasz80" ) ) {
      /* Do nothing */
    } else
    if( !strcmp( (const char*)node->name, "snapshot" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->snapshot );
        settings->snapshot = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "snet" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->snet );
        settings->snet = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "sound" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->sound = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "sounddevice" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->sound_device );
        settings->sound_device = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "soundforce8bit" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->sound_force_8bit = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "soundfreq" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->sound_freq = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "loadingsound" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->sound_load = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "speakertype" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->speaker_type );
        settings->speaker_type = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "speccyboot" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->speccyboot = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "speccyboottap" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->speccyboot_tap );
        settings->speccyboot_tap = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "specdrum" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->specdrum = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "spectranet" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->spectranet = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "spectranetdisable" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->spectranet_disable = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "machine" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->start_machine );
        settings->start_machine = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "graphicsfilter" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->start_scaler_mode );
        settings->start_scaler_mode = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "statusbar" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->statusbar = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "separation" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->stereo_ay );
        settings->stereo_ay = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "strictaspecthint" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->strict_aspect_hint = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "svgamodes" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->svga_modes );
        settings->svga_modes = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "tapefile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->tape_file );
        settings->tape_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "tapetraps" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->tape_traps = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "unittests" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->unittests = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "usource" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->usource = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "volumeay" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->volume_ay = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "volumebeeper" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->volume_beeper = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "volumecovox" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->volume_covox = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "volumespecdrum" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->volume_specdrum = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "writableroms" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->writable_roms = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "cmosz80" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->z80_is_cmos = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "zxatasp" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->zxatasp_active = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "zxataspmasterfile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->zxatasp_master_file );
        settings->zxatasp_master_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "zxataspslavefile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->zxatasp_slave_file );
        settings->zxatasp_slave_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "zxataspupload" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->zxatasp_upload = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "zxataspwriteprotect" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->zxatasp_wp = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "zxcf" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->zxcf_active = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "zxcfcffile" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        libspectrum_free( settings->zxcf_pri_file );
        settings->zxcf_pri_file = utils_safe_strdup( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "zxcfupload" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->zxcf_upload = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
    if( !strcmp( (const char*)node->name, "zxprinter" ) ) {
      xmlstring = xmlNodeListGetString( doc, node->xmlChildrenNode, 1 );
      if( xmlstring ) {
        settings->zxprinter = atoi( (char*)xmlstring );
        xmlFree( xmlstring );
      }
    } else
#line 258"./settings.pl"
    if( !strcmp( (const char*)node->name, "text" ) ) {
      /* Do nothing */
    } else {
      ui_error( UI_ERROR_WARNING, "Unknown setting '%s' in config file",
		node->name );
    }

    node = node->next;
  }

  return 0;
}

int
settings_write_config( settings_info *settings )
{
  const char *home; char path[ PATH_MAX ], buffer[80]; 

  xmlDocPtr doc; xmlNodePtr root;

  home = compat_get_home_path(); if( !home ) return 1;

  snprintf( path, PATH_MAX, "%s/%s", home, CONFIG_FILE_NAME );

  /* Create the XML document */
  doc = xmlNewDoc( (const xmlChar*)"1.0" );

  root = xmlNewNode( NULL, (const xmlChar*)"settings" );
  xmlDocSetRootElement( doc, root );
  xmlNewTextChild( root, NULL, (const xmlChar*)"accelerateloader", (const xmlChar*)(settings->accelerate_loader ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"aspecthint", (const xmlChar*)(settings->aspect_hint ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"autoload", (const xmlChar*)(settings->auto_load ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"autosavesettings", (const xmlChar*)(settings->autosave_settings ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"beta128", (const xmlChar*)(settings->beta128 ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"beta12848boot", (const xmlChar*)(settings->beta128_48boot ? "1" : "0") );
  if( settings->betadisk_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"betadisk", (const xmlChar*)settings->betadisk_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"bwtv", (const xmlChar*)(settings->bw_tv ? "1" : "0") );
  snprintf( buffer, 80, "%d", settings->competition_code );
  xmlNewTextChild( root, NULL, (const xmlChar*)"competitioncode", (const xmlChar*)buffer );
  xmlNewTextChild( root, NULL, (const xmlChar*)"competitionmode", (const xmlChar*)(settings->competition_mode ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"confirmactions", (const xmlChar*)(settings->confirm_actions ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"covox", (const xmlChar*)(settings->covox ? "1" : "0") );
  if( settings->dck_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"dock", (const xmlChar*)settings->dck_file );
  if( settings->debugger_command )
    xmlNewTextChild( root, NULL, (const xmlChar*)"debuggercommand", (const xmlChar*)settings->debugger_command );
  xmlNewTextChild( root, NULL, (const xmlChar*)"detectloader", (const xmlChar*)(settings->detect_loader ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"didaktik80", (const xmlChar*)(settings->didaktik80 ? "1" : "0") );
  if( settings->didaktik80disk_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"didaktik80disk", (const xmlChar*)settings->didaktik80disk_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"disciple", (const xmlChar*)(settings->disciple ? "1" : "0") );
  if( settings->discipledisk_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"discipledisk", (const xmlChar*)settings->discipledisk_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"diskaskmerge", (const xmlChar*)(settings->disk_ask_merge ? "1" : "0") );
  if( settings->disk_try_merge )
    xmlNewTextChild( root, NULL, (const xmlChar*)"disktrymerge", (const xmlChar*)settings->disk_try_merge );
  xmlNewTextChild( root, NULL, (const xmlChar*)"divide", (const xmlChar*)(settings->divide_enabled ? "1" : "0") );
  if( settings->divide_master_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"dividemasterfile", (const xmlChar*)settings->divide_master_file );
  if( settings->divide_slave_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"divideslavefile", (const xmlChar*)settings->divide_slave_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"dividewriteprotect", (const xmlChar*)(settings->divide_wp ? "1" : "0") );
  snprintf( buffer, 80, "%d", settings->doublescan_mode );
  xmlNewTextChild( root, NULL, (const xmlChar*)"doublescanmode", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->drive_40_max_track );
  xmlNewTextChild( root, NULL, (const xmlChar*)"drive40maxtrack", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->drive_80_max_track );
  xmlNewTextChild( root, NULL, (const xmlChar*)"drive80maxtrack", (const xmlChar*)buffer );
  if( settings->drive_beta128a_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"drivebeta128atype", (const xmlChar*)settings->drive_beta128a_type );
  if( settings->drive_beta128b_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"drivebeta128btype", (const xmlChar*)settings->drive_beta128b_type );
  if( settings->drive_beta128c_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"drivebeta128ctype", (const xmlChar*)settings->drive_beta128c_type );
  if( settings->drive_beta128d_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"drivebeta128dtype", (const xmlChar*)settings->drive_beta128d_type );
  if( settings->drive_didaktik80a_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"drivedidaktik80atype", (const xmlChar*)settings->drive_didaktik80a_type );
  if( settings->drive_didaktik80b_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"drivedidaktik80btype", (const xmlChar*)settings->drive_didaktik80b_type );
  if( settings->drive_disciple1_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"drivedisciple1type", (const xmlChar*)settings->drive_disciple1_type );
  if( settings->drive_disciple2_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"drivedisciple2type", (const xmlChar*)settings->drive_disciple2_type );
  if( settings->drive_opus1_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"driveopus1type", (const xmlChar*)settings->drive_opus1_type );
  if( settings->drive_opus2_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"driveopus2type", (const xmlChar*)settings->drive_opus2_type );
  if( settings->drive_plus3a_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"driveplus3atype", (const xmlChar*)settings->drive_plus3a_type );
  if( settings->drive_plus3b_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"driveplus3btype", (const xmlChar*)settings->drive_plus3b_type );
  if( settings->drive_plusd1_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"driveplusd1type", (const xmlChar*)settings->drive_plusd1_type );
  if( settings->drive_plusd2_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"driveplusd2type", (const xmlChar*)settings->drive_plusd2_type );
  xmlNewTextChild( root, NULL, (const xmlChar*)"embedsnapshot", (const xmlChar*)(settings->embed_snapshot ? "1" : "0") );
  snprintf( buffer, 80, "%d", settings->emulation_speed );
  xmlNewTextChild( root, NULL, (const xmlChar*)"speed", (const xmlChar*)buffer );
  xmlNewTextChild( root, NULL, (const xmlChar*)"fastload", (const xmlChar*)(settings->fastload ? "1" : "0") );
  snprintf( buffer, 80, "%d", settings->fb_mode );
  xmlNewTextChild( root, NULL, (const xmlChar*)"fbmode", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->frame_rate );
  xmlNewTextChild( root, NULL, (const xmlChar*)"rate", (const xmlChar*)buffer );
  xmlNewTextChild( root, NULL, (const xmlChar*)"fullscreen", (const xmlChar*)(settings->full_screen ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"fuller", (const xmlChar*)(settings->fuller ? "1" : "0") );
  if( settings->if2_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"if2cart", (const xmlChar*)settings->if2_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"interface1", (const xmlChar*)(settings->interface1 ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"interface2", (const xmlChar*)(settings->interface2 ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"issue2", (const xmlChar*)(settings->issue2 ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"kempston", (const xmlChar*)(settings->joy_kempston ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystickprompt", (const xmlChar*)(settings->joy_prompt ? "1" : "0") );
  if( settings->joystick_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1", (const xmlChar*)settings->joystick_1 );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_1 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire1", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_10 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire10", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_11 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire11", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_12 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire12", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_13 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire13", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_14 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire14", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_15 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire15", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_2 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire2", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_3 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire3", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_4 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire4", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_5 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire5", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_6 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire6", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_7 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire7", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_8 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire8", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_fire_9 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1fire9", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_1_output );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick1output", (const xmlChar*)buffer );
  if( settings->joystick_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2", (const xmlChar*)settings->joystick_2 );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_1 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire1", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_10 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire10", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_11 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire11", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_12 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire12", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_13 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire13", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_14 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire14", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_15 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire15", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_2 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire2", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_3 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire3", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_4 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire4", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_5 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire5", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_6 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire6", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_7 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire7", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_8 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire8", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_fire_9 );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2fire9", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_2_output );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystick2output", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_keyboard_down );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboarddown", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_keyboard_fire );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboardfire", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_keyboard_left );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboardleft", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_keyboard_output );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboardoutput", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_keyboard_right );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboardright", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->joystick_keyboard_up );
  xmlNewTextChild( root, NULL, (const xmlChar*)"joystickkeyboardup", (const xmlChar*)buffer );
  xmlNewTextChild( root, NULL, (const xmlChar*)"kempstonmouse", (const xmlChar*)(settings->kempston_mouse ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"keyboardarrowsshifted", (const xmlChar*)(settings->keyboard_arrows_shifted ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"latetimings", (const xmlChar*)(settings->late_timings ? "1" : "0") );
  if( settings->mdr_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrivefile", (const xmlChar*)settings->mdr_file );
  if( settings->mdr_file2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive2file", (const xmlChar*)settings->mdr_file2 );
  if( settings->mdr_file3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive3file", (const xmlChar*)settings->mdr_file3 );
  if( settings->mdr_file4 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive4file", (const xmlChar*)settings->mdr_file4 );
  if( settings->mdr_file5 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive5file", (const xmlChar*)settings->mdr_file5 );
  if( settings->mdr_file6 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive6file", (const xmlChar*)settings->mdr_file6 );
  if( settings->mdr_file7 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive7file", (const xmlChar*)settings->mdr_file7 );
  if( settings->mdr_file8 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"microdrive8file", (const xmlChar*)settings->mdr_file8 );
  snprintf( buffer, 80, "%d", settings->mdr_len );
  xmlNewTextChild( root, NULL, (const xmlChar*)"mdrlen", (const xmlChar*)buffer );
  xmlNewTextChild( root, NULL, (const xmlChar*)"mdrrandomlen", (const xmlChar*)(settings->mdr_random_len ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"melodik", (const xmlChar*)(settings->melodik ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"mouseswapbuttons", (const xmlChar*)(settings->mouse_swap_buttons ? "1" : "0") );
  if( settings->movie_compr )
    xmlNewTextChild( root, NULL, (const xmlChar*)"moviecompr", (const xmlChar*)settings->movie_compr );
  if( settings->movie_start )
    xmlNewTextChild( root, NULL, (const xmlChar*)"moviestart", (const xmlChar*)settings->movie_start );
  xmlNewTextChild( root, NULL, (const xmlChar*)"moviestopafterrzx", (const xmlChar*)(settings->movie_stop_after_rzx ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"multiface1", (const xmlChar*)(settings->multiface1 ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"multiface128", (const xmlChar*)(settings->multiface128 ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"multiface1stealth", (const xmlChar*)(settings->multiface1_stealth ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"multiface3", (const xmlChar*)(settings->multiface3 ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"opus", (const xmlChar*)(settings->opus ? "1" : "0") );
  if( settings->opusdisk_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"opusdisk", (const xmlChar*)settings->opusdisk_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"paltv2x", (const xmlChar*)(settings->pal_tv2x ? "1" : "0") );
  if( settings->playback_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"playbackfile", (const xmlChar*)settings->playback_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"plus3detectspeedlock", (const xmlChar*)(settings->plus3_detect_speedlock ? "1" : "0") );
  if( settings->plus3disk_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"plus3disk", (const xmlChar*)settings->plus3disk_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"plusd", (const xmlChar*)(settings->plusd ? "1" : "0") );
  if( settings->plusddisk_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"plusddisk", (const xmlChar*)settings->plusddisk_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"printer", (const xmlChar*)(settings->printer ? "1" : "0") );
  if( settings->printer_graphics_filename )
    xmlNewTextChild( root, NULL, (const xmlChar*)"graphicsfile", (const xmlChar*)settings->printer_graphics_filename );
  if( settings->printer_text_filename )
    xmlNewTextChild( root, NULL, (const xmlChar*)"textfile", (const xmlChar*)settings->printer_text_filename );
  xmlNewTextChild( root, NULL, (const xmlChar*)"rawsnet", (const xmlChar*)(settings->raw_s_net ? "1" : "0") );
  if( settings->record_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"recordfile", (const xmlChar*)settings->record_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"recreatedspectrum", (const xmlChar*)(settings->recreated_spectrum ? "1" : "0") );
  if( settings->rom_128_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rom1280", (const xmlChar*)settings->rom_128_0 );
  if( settings->rom_128_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rom1281", (const xmlChar*)settings->rom_128_1 );
  if( settings->rom_16 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rom16", (const xmlChar*)settings->rom_16 );
  if( settings->rom_48 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rom48", (const xmlChar*)settings->rom_48 );
  if( settings->rom_beta128 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rombeta128", (const xmlChar*)settings->rom_beta128 );
  if( settings->rom_didaktik80 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romdidaktik80", (const xmlChar*)settings->rom_didaktik80 );
  if( settings->rom_disciple )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romdisciple", (const xmlChar*)settings->rom_disciple );
  if( settings->rom_interface_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rominterfacei", (const xmlChar*)settings->rom_interface_1 );
  if( settings->rom_multiface1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rommultiface1", (const xmlChar*)settings->rom_multiface1 );
  if( settings->rom_multiface128 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rommultiface128", (const xmlChar*)settings->rom_multiface128 );
  if( settings->rom_multiface3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rommultiface3", (const xmlChar*)settings->rom_multiface3 );
  if( settings->rom_opus )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romopus", (const xmlChar*)settings->rom_opus );
  if( settings->rom_pentagon1024_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon10240", (const xmlChar*)settings->rom_pentagon1024_0 );
  if( settings->rom_pentagon1024_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon10241", (const xmlChar*)settings->rom_pentagon1024_1 );
  if( settings->rom_pentagon1024_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon10242", (const xmlChar*)settings->rom_pentagon1024_2 );
  if( settings->rom_pentagon1024_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon10243", (const xmlChar*)settings->rom_pentagon1024_3 );
  if( settings->rom_pentagon512_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon5120", (const xmlChar*)settings->rom_pentagon512_0 );
  if( settings->rom_pentagon512_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon5121", (const xmlChar*)settings->rom_pentagon512_1 );
  if( settings->rom_pentagon512_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon5122", (const xmlChar*)settings->rom_pentagon512_2 );
  if( settings->rom_pentagon512_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon5123", (const xmlChar*)settings->rom_pentagon512_3 );
  if( settings->rom_pentagon_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon0", (const xmlChar*)settings->rom_pentagon_0 );
  if( settings->rom_pentagon_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon1", (const xmlChar*)settings->rom_pentagon_1 );
  if( settings->rom_pentagon_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rompentagon2", (const xmlChar*)settings->rom_pentagon_2 );
  if( settings->rom_plus2_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus20", (const xmlChar*)settings->rom_plus2_0 );
  if( settings->rom_plus2_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus21", (const xmlChar*)settings->rom_plus2_1 );
  if( settings->rom_plus2a_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus2a0", (const xmlChar*)settings->rom_plus2a_0 );
  if( settings->rom_plus2a_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus2a1", (const xmlChar*)settings->rom_plus2a_1 );
  if( settings->rom_plus2a_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus2a2", (const xmlChar*)settings->rom_plus2a_2 );
  if( settings->rom_plus2a_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus2a3", (const xmlChar*)settings->rom_plus2a_3 );
  if( settings->rom_plus3_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus30", (const xmlChar*)settings->rom_plus3_0 );
  if( settings->rom_plus3_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus31", (const xmlChar*)settings->rom_plus3_1 );
  if( settings->rom_plus3_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus32", (const xmlChar*)settings->rom_plus3_2 );
  if( settings->rom_plus3_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus33", (const xmlChar*)settings->rom_plus3_3 );
  if( settings->rom_plus3e_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus3e0", (const xmlChar*)settings->rom_plus3e_0 );
  if( settings->rom_plus3e_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus3e1", (const xmlChar*)settings->rom_plus3e_1 );
  if( settings->rom_plus3e_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus3e2", (const xmlChar*)settings->rom_plus3e_2 );
  if( settings->rom_plus3e_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplus3e3", (const xmlChar*)settings->rom_plus3e_3 );
  if( settings->rom_plusd )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romplusd", (const xmlChar*)settings->rom_plusd );
  if( settings->rom_scorpion_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romscorpion0", (const xmlChar*)settings->rom_scorpion_0 );
  if( settings->rom_scorpion_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romscorpion1", (const xmlChar*)settings->rom_scorpion_1 );
  if( settings->rom_scorpion_2 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romscorpion2", (const xmlChar*)settings->rom_scorpion_2 );
  if( settings->rom_scorpion_3 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romscorpion3", (const xmlChar*)settings->rom_scorpion_3 );
  if( settings->rom_spec_se_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romspecse0", (const xmlChar*)settings->rom_spec_se_0 );
  if( settings->rom_spec_se_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romspecse1", (const xmlChar*)settings->rom_spec_se_1 );
  if( settings->rom_speccyboot )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romspeccyboot", (const xmlChar*)settings->rom_speccyboot );
  if( settings->rom_tc2048 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romtc2048", (const xmlChar*)settings->rom_tc2048 );
  if( settings->rom_tc2068_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romtc20680", (const xmlChar*)settings->rom_tc2068_0 );
  if( settings->rom_tc2068_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romtc20681", (const xmlChar*)settings->rom_tc2068_1 );
  if( settings->rom_ts2068_0 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romts20680", (const xmlChar*)settings->rom_ts2068_0 );
  if( settings->rom_ts2068_1 )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romts20681", (const xmlChar*)settings->rom_ts2068_1 );
  if( settings->rom_usource )
    xmlNewTextChild( root, NULL, (const xmlChar*)"romusource", (const xmlChar*)settings->rom_usource );
  xmlNewTextChild( root, NULL, (const xmlChar*)"rs232handshake", (const xmlChar*)(settings->rs232_handshake ? "1" : "0") );
  if( settings->rs232_rx )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rs232rx", (const xmlChar*)settings->rs232_rx );
  if( settings->rs232_tx )
    xmlNewTextChild( root, NULL, (const xmlChar*)"rs232tx", (const xmlChar*)settings->rs232_tx );
  xmlNewTextChild( root, NULL, (const xmlChar*)"rzxautosaves", (const xmlChar*)(settings->rzx_autosaves ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"compressrzx", (const xmlChar*)(settings->rzx_compression ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"simpleide", (const xmlChar*)(settings->simpleide_active ? "1" : "0") );
  if( settings->simpleide_master_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"simpleidemasterfile", (const xmlChar*)settings->simpleide_master_file );
  if( settings->simpleide_slave_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"simpleideslavefile", (const xmlChar*)settings->simpleide_slave_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"slttraps", (const xmlChar*)(settings->slt_traps ? "1" : "0") );
  if( settings->snapshot )
    xmlNewTextChild( root, NULL, (const xmlChar*)"snapshot", (const xmlChar*)settings->snapshot );
  if( settings->snet )
    xmlNewTextChild( root, NULL, (const xmlChar*)"snet", (const xmlChar*)settings->snet );
  xmlNewTextChild( root, NULL, (const xmlChar*)"sound", (const xmlChar*)(settings->sound ? "1" : "0") );
  if( settings->sound_device )
    xmlNewTextChild( root, NULL, (const xmlChar*)"sounddevice", (const xmlChar*)settings->sound_device );
  xmlNewTextChild( root, NULL, (const xmlChar*)"soundforce8bit", (const xmlChar*)(settings->sound_force_8bit ? "1" : "0") );
  snprintf( buffer, 80, "%d", settings->sound_freq );
  xmlNewTextChild( root, NULL, (const xmlChar*)"soundfreq", (const xmlChar*)buffer );
  xmlNewTextChild( root, NULL, (const xmlChar*)"loadingsound", (const xmlChar*)(settings->sound_load ? "1" : "0") );
  if( settings->speaker_type )
    xmlNewTextChild( root, NULL, (const xmlChar*)"speakertype", (const xmlChar*)settings->speaker_type );
  xmlNewTextChild( root, NULL, (const xmlChar*)"speccyboot", (const xmlChar*)(settings->speccyboot ? "1" : "0") );
  if( settings->speccyboot_tap )
    xmlNewTextChild( root, NULL, (const xmlChar*)"speccyboottap", (const xmlChar*)settings->speccyboot_tap );
  xmlNewTextChild( root, NULL, (const xmlChar*)"specdrum", (const xmlChar*)(settings->specdrum ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"spectranet", (const xmlChar*)(settings->spectranet ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"spectranetdisable", (const xmlChar*)(settings->spectranet_disable ? "1" : "0") );
  if( settings->start_machine )
    xmlNewTextChild( root, NULL, (const xmlChar*)"machine", (const xmlChar*)settings->start_machine );
  if( settings->start_scaler_mode )
    xmlNewTextChild( root, NULL, (const xmlChar*)"graphicsfilter", (const xmlChar*)settings->start_scaler_mode );
  xmlNewTextChild( root, NULL, (const xmlChar*)"statusbar", (const xmlChar*)(settings->statusbar ? "1" : "0") );
  if( settings->stereo_ay )
    xmlNewTextChild( root, NULL, (const xmlChar*)"separation", (const xmlChar*)settings->stereo_ay );
  xmlNewTextChild( root, NULL, (const xmlChar*)"strictaspecthint", (const xmlChar*)(settings->strict_aspect_hint ? "1" : "0") );
  if( settings->svga_modes )
    xmlNewTextChild( root, NULL, (const xmlChar*)"svgamodes", (const xmlChar*)settings->svga_modes );
  if( settings->tape_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"tapefile", (const xmlChar*)settings->tape_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"tapetraps", (const xmlChar*)(settings->tape_traps ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"unittests", (const xmlChar*)(settings->unittests ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"usource", (const xmlChar*)(settings->usource ? "1" : "0") );
  snprintf( buffer, 80, "%d", settings->volume_ay );
  xmlNewTextChild( root, NULL, (const xmlChar*)"volumeay", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->volume_beeper );
  xmlNewTextChild( root, NULL, (const xmlChar*)"volumebeeper", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->volume_covox );
  xmlNewTextChild( root, NULL, (const xmlChar*)"volumecovox", (const xmlChar*)buffer );
  snprintf( buffer, 80, "%d", settings->volume_specdrum );
  xmlNewTextChild( root, NULL, (const xmlChar*)"volumespecdrum", (const xmlChar*)buffer );
  xmlNewTextChild( root, NULL, (const xmlChar*)"writableroms", (const xmlChar*)(settings->writable_roms ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"cmosz80", (const xmlChar*)(settings->z80_is_cmos ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxatasp", (const xmlChar*)(settings->zxatasp_active ? "1" : "0") );
  if( settings->zxatasp_master_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"zxataspmasterfile", (const xmlChar*)settings->zxatasp_master_file );
  if( settings->zxatasp_slave_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"zxataspslavefile", (const xmlChar*)settings->zxatasp_slave_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxataspupload", (const xmlChar*)(settings->zxatasp_upload ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxataspwriteprotect", (const xmlChar*)(settings->zxatasp_wp ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxcf", (const xmlChar*)(settings->zxcf_active ? "1" : "0") );
  if( settings->zxcf_pri_file )
    xmlNewTextChild( root, NULL, (const xmlChar*)"zxcfcffile", (const xmlChar*)settings->zxcf_pri_file );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxcfupload", (const xmlChar*)(settings->zxcf_upload ? "1" : "0") );
  xmlNewTextChild( root, NULL, (const xmlChar*)"zxprinter", (const xmlChar*)(settings->zxprinter ? "1" : "0") );
#line 315"./settings.pl"

  xmlSaveFormatFile( path, doc, 1 );

  xmlFreeDoc( doc );

  return 0;
}

#else				/* #ifdef HAVE_LIB_XML2 */

/* Read options from the config file as ini file (if libxml2 is not available) */

static int
read_config_file( settings_info *settings )
{
  const char *home; char path[ PATH_MAX ];
  struct stat stat_info;
  int error;

  utils_file file;

  home = compat_get_home_path(); if( !home ) return 1;

  snprintf( path, PATH_MAX, "%s/%s", home, CONFIG_FILE_NAME );

  /* See if the file exists; if doesn't, it's not a problem */
  if( stat( path, &stat_info ) ) {
    if( errno == ENOENT ) {
      return 0;
    } else {
      ui_error( UI_ERROR_ERROR, "couldn't stat '%s': %s", path,
		strerror( errno ) );
      return 1;
    }
  }

  error = utils_read_file( path, &file );
  if( error ) {
    ui_error( UI_ERROR_ERROR, "error reading config file" );
    return 1;
  }

  if( parse_ini( &file, settings ) ) { utils_close_file( &file ); return 1; }

  utils_close_file( &file );

  return 0;
}

static int
settings_var( settings_info *settings, unsigned char *name, unsigned char *last,
              int **val_int, char ***val_char, unsigned char **next  )
{
  unsigned char* cpos;
  size_t n;

  *val_int = NULL;
  *val_char = NULL;

  *next = name;
  while( name < last && ( *name == ' ' || *name == '\t' || *name == '\r' ||
                          *name == '\n' ) ) {
    *next = ++name;					/* seek to first char */
  }
  cpos = name;

  while( cpos < last && ( *cpos != '=' && *cpos != ' ' && *cpos != '\t' &&
                          *cpos != '\r' && *cpos != '\n' ) ) cpos++;
  *next = cpos;
  n = cpos - name;		/* length of name */

  while( *next < last && **next != '=' ) {		/* search for '=' */
    if( **next != ' ' && **next != '\t' && **next != '\r' && **next != '\n' )
      return 1;	/* error in value */
    (*next)++;
  }
  if( *next < last) (*next)++;		/* set after '=' */
/*  ui_error( UI_ERROR_WARNING, "Config: (%5s): ", name ); */

  if( n == 16 && !strncmp( (const char *)name, "accelerateloader", n ) ) {
    *val_int = &settings->accelerate_loader;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "aspecthint", n ) ) {
    *val_int = &settings->aspect_hint;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "autoload", n ) ) {
    *val_int = &settings->auto_load;
    return 0;
  }
  if( n == 16 && !strncmp( (const char *)name, "autosavesettings", n ) ) {
    *val_int = &settings->autosave_settings;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "beta128", n ) ) {
    *val_int = &settings->beta128;
    return 0;
  }
  if( n == 13 && !strncmp( (const char *)name, "beta12848boot", n ) ) {
    *val_int = &settings->beta128_48boot;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "betadisk", n ) ) {
    *val_char = &settings->betadisk_file;
    return 0;
  }
  if( n == 4 && !strncmp( (const char *)name, "bwtv", n ) ) {
    *val_int = &settings->bw_tv;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "competitioncode", n ) ) {
    *val_int = &settings->competition_code;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "competitionmode", n ) ) {
    *val_int = &settings->competition_mode;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "confirmactions", n ) ) {
    *val_int = &settings->confirm_actions;
    return 0;
  }
  if( n == 5 && !strncmp( (const char *)name, "covox", n ) ) {
    *val_int = &settings->covox;
    return 0;
  }
  if( n == 4 && !strncmp( (const char *)name, "dock", n ) ) {
    *val_char = &settings->dck_file;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "debuggercommand", n ) ) {
    *val_char = &settings->debugger_command;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "detectloader", n ) ) {
    *val_int = &settings->detect_loader;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "didaktik80", n ) ) {
    *val_int = &settings->didaktik80;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "didaktik80disk", n ) ) {
    *val_char = &settings->didaktik80disk_file;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "disciple", n ) ) {
    *val_int = &settings->disciple;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "discipledisk", n ) ) {
    *val_char = &settings->discipledisk_file;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "diskaskmerge", n ) ) {
    *val_int = &settings->disk_ask_merge;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "disktrymerge", n ) ) {
    *val_char = &settings->disk_try_merge;
    return 0;
  }
  if( n == 6 && !strncmp( (const char *)name, "divide", n ) ) {
    *val_int = &settings->divide_enabled;
    return 0;
  }
  if( n == 16 && !strncmp( (const char *)name, "dividemasterfile", n ) ) {
    *val_char = &settings->divide_master_file;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "divideslavefile", n ) ) {
    *val_char = &settings->divide_slave_file;
    return 0;
  }
  if( n == 18 && !strncmp( (const char *)name, "dividewriteprotect", n ) ) {
    *val_int = &settings->divide_wp;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "doublescreen", n ) ) {
/*    *val_null = &settings->double_screen; */
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "doublescanmode", n ) ) {
    *val_int = &settings->doublescan_mode;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "drive40maxtrack", n ) ) {
    *val_int = &settings->drive_40_max_track;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "drive80maxtrack", n ) ) {
    *val_int = &settings->drive_80_max_track;
    return 0;
  }
  if( n == 17 && !strncmp( (const char *)name, "drivebeta128atype", n ) ) {
    *val_char = &settings->drive_beta128a_type;
    return 0;
  }
  if( n == 17 && !strncmp( (const char *)name, "drivebeta128btype", n ) ) {
    *val_char = &settings->drive_beta128b_type;
    return 0;
  }
  if( n == 17 && !strncmp( (const char *)name, "drivebeta128ctype", n ) ) {
    *val_char = &settings->drive_beta128c_type;
    return 0;
  }
  if( n == 17 && !strncmp( (const char *)name, "drivebeta128dtype", n ) ) {
    *val_char = &settings->drive_beta128d_type;
    return 0;
  }
  if( n == 20 && !strncmp( (const char *)name, "drivedidaktik80atype", n ) ) {
    *val_char = &settings->drive_didaktik80a_type;
    return 0;
  }
  if( n == 20 && !strncmp( (const char *)name, "drivedidaktik80btype", n ) ) {
    *val_char = &settings->drive_didaktik80b_type;
    return 0;
  }
  if( n == 18 && !strncmp( (const char *)name, "drivedisciple1type", n ) ) {
    *val_char = &settings->drive_disciple1_type;
    return 0;
  }
  if( n == 18 && !strncmp( (const char *)name, "drivedisciple2type", n ) ) {
    *val_char = &settings->drive_disciple2_type;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "driveopus1type", n ) ) {
    *val_char = &settings->drive_opus1_type;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "driveopus2type", n ) ) {
    *val_char = &settings->drive_opus2_type;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "driveplus3atype", n ) ) {
    *val_char = &settings->drive_plus3a_type;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "driveplus3btype", n ) ) {
    *val_char = &settings->drive_plus3b_type;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "driveplusd1type", n ) ) {
    *val_char = &settings->drive_plusd1_type;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "driveplusd2type", n ) ) {
    *val_char = &settings->drive_plusd2_type;
    return 0;
  }
  if( n == 13 && !strncmp( (const char *)name, "embedsnapshot", n ) ) {
    *val_int = &settings->embed_snapshot;
    return 0;
  }
  if( n == 5 && !strncmp( (const char *)name, "speed", n ) ) {
    *val_int = &settings->emulation_speed;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "fastload", n ) ) {
    *val_int = &settings->fastload;
    return 0;
  }
  if( n == 6 && !strncmp( (const char *)name, "fbmode", n ) ) {
    *val_int = &settings->fb_mode;
    return 0;
  }
  if( n == 4 && !strncmp( (const char *)name, "rate", n ) ) {
    *val_int = &settings->frame_rate;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "fullscreen", n ) ) {
    *val_int = &settings->full_screen;
    return 0;
  }
  if( n == 6 && !strncmp( (const char *)name, "fuller", n ) ) {
    *val_int = &settings->fuller;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "if2cart", n ) ) {
    *val_char = &settings->if2_file;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "interface1", n ) ) {
    *val_int = &settings->interface1;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "interface2", n ) ) {
    *val_int = &settings->interface2;
    return 0;
  }
  if( n == 6 && !strncmp( (const char *)name, "issue2", n ) ) {
    *val_int = &settings->issue2;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "kempston", n ) ) {
    *val_int = &settings->joy_kempston;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystickprompt", n ) ) {
    *val_int = &settings->joy_prompt;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "joystick1", n ) ) {
    *val_char = &settings->joystick_1;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick1fire1", n ) ) {
    *val_int = &settings->joystick_1_fire_1;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick1fire10", n ) ) {
    *val_int = &settings->joystick_1_fire_10;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick1fire11", n ) ) {
    *val_int = &settings->joystick_1_fire_11;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick1fire12", n ) ) {
    *val_int = &settings->joystick_1_fire_12;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick1fire13", n ) ) {
    *val_int = &settings->joystick_1_fire_13;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick1fire14", n ) ) {
    *val_int = &settings->joystick_1_fire_14;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick1fire15", n ) ) {
    *val_int = &settings->joystick_1_fire_15;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick1fire2", n ) ) {
    *val_int = &settings->joystick_1_fire_2;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick1fire3", n ) ) {
    *val_int = &settings->joystick_1_fire_3;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick1fire4", n ) ) {
    *val_int = &settings->joystick_1_fire_4;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick1fire5", n ) ) {
    *val_int = &settings->joystick_1_fire_5;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick1fire6", n ) ) {
    *val_int = &settings->joystick_1_fire_6;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick1fire7", n ) ) {
    *val_int = &settings->joystick_1_fire_7;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick1fire8", n ) ) {
    *val_int = &settings->joystick_1_fire_8;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick1fire9", n ) ) {
    *val_int = &settings->joystick_1_fire_9;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick1output", n ) ) {
    *val_int = &settings->joystick_1_output;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "joystick2", n ) ) {
    *val_char = &settings->joystick_2;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick2fire1", n ) ) {
    *val_int = &settings->joystick_2_fire_1;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick2fire10", n ) ) {
    *val_int = &settings->joystick_2_fire_10;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick2fire11", n ) ) {
    *val_int = &settings->joystick_2_fire_11;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick2fire12", n ) ) {
    *val_int = &settings->joystick_2_fire_12;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick2fire13", n ) ) {
    *val_int = &settings->joystick_2_fire_13;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick2fire14", n ) ) {
    *val_int = &settings->joystick_2_fire_14;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick2fire15", n ) ) {
    *val_int = &settings->joystick_2_fire_15;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick2fire2", n ) ) {
    *val_int = &settings->joystick_2_fire_2;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick2fire3", n ) ) {
    *val_int = &settings->joystick_2_fire_3;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick2fire4", n ) ) {
    *val_int = &settings->joystick_2_fire_4;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick2fire5", n ) ) {
    *val_int = &settings->joystick_2_fire_5;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick2fire6", n ) ) {
    *val_int = &settings->joystick_2_fire_6;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick2fire7", n ) ) {
    *val_int = &settings->joystick_2_fire_7;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick2fire8", n ) ) {
    *val_int = &settings->joystick_2_fire_8;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "joystick2fire9", n ) ) {
    *val_int = &settings->joystick_2_fire_9;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "joystick2output", n ) ) {
    *val_int = &settings->joystick_2_output;
    return 0;
  }
  if( n == 20 && !strncmp( (const char *)name, "joystickkeyboarddown", n ) ) {
    *val_int = &settings->joystick_keyboard_down;
    return 0;
  }
  if( n == 20 && !strncmp( (const char *)name, "joystickkeyboardfire", n ) ) {
    *val_int = &settings->joystick_keyboard_fire;
    return 0;
  }
  if( n == 20 && !strncmp( (const char *)name, "joystickkeyboardleft", n ) ) {
    *val_int = &settings->joystick_keyboard_left;
    return 0;
  }
  if( n == 22 && !strncmp( (const char *)name, "joystickkeyboardoutput", n ) ) {
    *val_int = &settings->joystick_keyboard_output;
    return 0;
  }
  if( n == 21 && !strncmp( (const char *)name, "joystickkeyboardright", n ) ) {
    *val_int = &settings->joystick_keyboard_right;
    return 0;
  }
  if( n == 18 && !strncmp( (const char *)name, "joystickkeyboardup", n ) ) {
    *val_int = &settings->joystick_keyboard_up;
    return 0;
  }
  if( n == 13 && !strncmp( (const char *)name, "kempstonmouse", n ) ) {
    *val_int = &settings->kempston_mouse;
    return 0;
  }
  if( n == 21 && !strncmp( (const char *)name, "keyboardarrowsshifted", n ) ) {
    *val_int = &settings->keyboard_arrows_shifted;
    return 0;
  }
  if( n == 11 && !strncmp( (const char *)name, "latetimings", n ) ) {
    *val_int = &settings->late_timings;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "microdrivefile", n ) ) {
    *val_char = &settings->mdr_file;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "microdrive2file", n ) ) {
    *val_char = &settings->mdr_file2;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "microdrive3file", n ) ) {
    *val_char = &settings->mdr_file3;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "microdrive4file", n ) ) {
    *val_char = &settings->mdr_file4;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "microdrive5file", n ) ) {
    *val_char = &settings->mdr_file5;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "microdrive6file", n ) ) {
    *val_char = &settings->mdr_file6;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "microdrive7file", n ) ) {
    *val_char = &settings->mdr_file7;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "microdrive8file", n ) ) {
    *val_char = &settings->mdr_file8;
    return 0;
  }
  if( n == 6 && !strncmp( (const char *)name, "mdrlen", n ) ) {
    *val_int = &settings->mdr_len;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "mdrrandomlen", n ) ) {
    *val_int = &settings->mdr_random_len;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "melodik", n ) ) {
    *val_int = &settings->melodik;
    return 0;
  }
  if( n == 16 && !strncmp( (const char *)name, "mouseswapbuttons", n ) ) {
    *val_int = &settings->mouse_swap_buttons;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "moviecompr", n ) ) {
    *val_char = &settings->movie_compr;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "moviestart", n ) ) {
    *val_char = &settings->movie_start;
    return 0;
  }
  if( n == 17 && !strncmp( (const char *)name, "moviestopafterrzx", n ) ) {
    *val_int = &settings->movie_stop_after_rzx;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "multiface1", n ) ) {
    *val_int = &settings->multiface1;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "multiface128", n ) ) {
    *val_int = &settings->multiface128;
    return 0;
  }
  if( n == 17 && !strncmp( (const char *)name, "multiface1stealth", n ) ) {
    *val_int = &settings->multiface1_stealth;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "multiface3", n ) ) {
    *val_int = &settings->multiface3;
    return 0;
  }
  if( n == 4 && !strncmp( (const char *)name, "opus", n ) ) {
    *val_int = &settings->opus;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "opusdisk", n ) ) {
    *val_char = &settings->opusdisk_file;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "paltv2x", n ) ) {
    *val_int = &settings->pal_tv2x;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "playbackfile", n ) ) {
    *val_char = &settings->playback_file;
    return 0;
  }
  if( n == 20 && !strncmp( (const char *)name, "plus3detectspeedlock", n ) ) {
    *val_int = &settings->plus3_detect_speedlock;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "plus3disk", n ) ) {
    *val_char = &settings->plus3disk_file;
    return 0;
  }
  if( n == 5 && !strncmp( (const char *)name, "plusd", n ) ) {
    *val_int = &settings->plusd;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "plusddisk", n ) ) {
    *val_char = &settings->plusddisk_file;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "printer", n ) ) {
    *val_int = &settings->printer;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "graphicsfile", n ) ) {
    *val_char = &settings->printer_graphics_filename;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "textfile", n ) ) {
    *val_char = &settings->printer_text_filename;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "rawrs232", n ) ) {
/*    *val_null = &settings->raw_rs232; */
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "rawsnet", n ) ) {
    *val_int = &settings->raw_s_net;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "recordfile", n ) ) {
    *val_char = &settings->record_file;
    return 0;
  }
  if( n == 17 && !strncmp( (const char *)name, "recreatedspectrum", n ) ) {
    *val_int = &settings->recreated_spectrum;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "rom1280", n ) ) {
    *val_char = &settings->rom_128_0;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "rom1281", n ) ) {
    *val_char = &settings->rom_128_1;
    return 0;
  }
  if( n == 5 && !strncmp( (const char *)name, "rom16", n ) ) {
    *val_char = &settings->rom_16;
    return 0;
  }
  if( n == 5 && !strncmp( (const char *)name, "rom48", n ) ) {
    *val_char = &settings->rom_48;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "rombeta128", n ) ) {
    *val_char = &settings->rom_beta128;
    return 0;
  }
  if( n == 13 && !strncmp( (const char *)name, "romdidaktik80", n ) ) {
    *val_char = &settings->rom_didaktik80;
    return 0;
  }
  if( n == 11 && !strncmp( (const char *)name, "romdisciple", n ) ) {
    *val_char = &settings->rom_disciple;
    return 0;
  }
  if( n == 13 && !strncmp( (const char *)name, "rominterfacei", n ) ) {
    *val_char = &settings->rom_interface_1;
    return 0;
  }
  if( n == 13 && !strncmp( (const char *)name, "rommultiface1", n ) ) {
    *val_char = &settings->rom_multiface1;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "rommultiface128", n ) ) {
    *val_char = &settings->rom_multiface128;
    return 0;
  }
  if( n == 13 && !strncmp( (const char *)name, "rommultiface3", n ) ) {
    *val_char = &settings->rom_multiface3;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "romopus", n ) ) {
    *val_char = &settings->rom_opus;
    return 0;
  }
  if( n == 16 && !strncmp( (const char *)name, "rompentagon10240", n ) ) {
    *val_char = &settings->rom_pentagon1024_0;
    return 0;
  }
  if( n == 16 && !strncmp( (const char *)name, "rompentagon10241", n ) ) {
    *val_char = &settings->rom_pentagon1024_1;
    return 0;
  }
  if( n == 16 && !strncmp( (const char *)name, "rompentagon10242", n ) ) {
    *val_char = &settings->rom_pentagon1024_2;
    return 0;
  }
  if( n == 16 && !strncmp( (const char *)name, "rompentagon10243", n ) ) {
    *val_char = &settings->rom_pentagon1024_3;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "rompentagon5120", n ) ) {
    *val_char = &settings->rom_pentagon512_0;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "rompentagon5121", n ) ) {
    *val_char = &settings->rom_pentagon512_1;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "rompentagon5122", n ) ) {
    *val_char = &settings->rom_pentagon512_2;
    return 0;
  }
  if( n == 15 && !strncmp( (const char *)name, "rompentagon5123", n ) ) {
    *val_char = &settings->rom_pentagon512_3;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "rompentagon0", n ) ) {
    *val_char = &settings->rom_pentagon_0;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "rompentagon1", n ) ) {
    *val_char = &settings->rom_pentagon_1;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "rompentagon2", n ) ) {
    *val_char = &settings->rom_pentagon_2;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "romplus20", n ) ) {
    *val_char = &settings->rom_plus2_0;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "romplus21", n ) ) {
    *val_char = &settings->rom_plus2_1;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romplus2a0", n ) ) {
    *val_char = &settings->rom_plus2a_0;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romplus2a1", n ) ) {
    *val_char = &settings->rom_plus2a_1;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romplus2a2", n ) ) {
    *val_char = &settings->rom_plus2a_2;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romplus2a3", n ) ) {
    *val_char = &settings->rom_plus2a_3;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "romplus30", n ) ) {
    *val_char = &settings->rom_plus3_0;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "romplus31", n ) ) {
    *val_char = &settings->rom_plus3_1;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "romplus32", n ) ) {
    *val_char = &settings->rom_plus3_2;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "romplus33", n ) ) {
    *val_char = &settings->rom_plus3_3;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romplus3e0", n ) ) {
    *val_char = &settings->rom_plus3e_0;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romplus3e1", n ) ) {
    *val_char = &settings->rom_plus3e_1;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romplus3e2", n ) ) {
    *val_char = &settings->rom_plus3e_2;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romplus3e3", n ) ) {
    *val_char = &settings->rom_plus3e_3;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "romplusd", n ) ) {
    *val_char = &settings->rom_plusd;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "romscorpion0", n ) ) {
    *val_char = &settings->rom_scorpion_0;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "romscorpion1", n ) ) {
    *val_char = &settings->rom_scorpion_1;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "romscorpion2", n ) ) {
    *val_char = &settings->rom_scorpion_2;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "romscorpion3", n ) ) {
    *val_char = &settings->rom_scorpion_3;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romspecse0", n ) ) {
    *val_char = &settings->rom_spec_se_0;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romspecse1", n ) ) {
    *val_char = &settings->rom_spec_se_1;
    return 0;
  }
  if( n == 13 && !strncmp( (const char *)name, "romspeccyboot", n ) ) {
    *val_char = &settings->rom_speccyboot;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "romtc2048", n ) ) {
    *val_char = &settings->rom_tc2048;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romtc20680", n ) ) {
    *val_char = &settings->rom_tc2068_0;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romtc20681", n ) ) {
    *val_char = &settings->rom_tc2068_1;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romts20680", n ) ) {
    *val_char = &settings->rom_ts2068_0;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romts20681", n ) ) {
    *val_char = &settings->rom_ts2068_1;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "romusource", n ) ) {
    *val_char = &settings->rom_usource;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "rs232handshake", n ) ) {
    *val_int = &settings->rs232_handshake;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "rs232rx", n ) ) {
    *val_char = &settings->rs232_rx;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "rs232tx", n ) ) {
    *val_char = &settings->rs232_tx;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "rzxautosaves", n ) ) {
    *val_int = &settings->rzx_autosaves;
    return 0;
  }
  if( n == 11 && !strncmp( (const char *)name, "compressrzx", n ) ) {
    *val_int = &settings->rzx_compression;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "simpleide", n ) ) {
    *val_int = &settings->simpleide_active;
    return 0;
  }
  if( n == 19 && !strncmp( (const char *)name, "simpleidemasterfile", n ) ) {
    *val_char = &settings->simpleide_master_file;
    return 0;
  }
  if( n == 18 && !strncmp( (const char *)name, "simpleideslavefile", n ) ) {
    *val_char = &settings->simpleide_slave_file;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "slttraps", n ) ) {
    *val_int = &settings->slt_traps;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "snapsasz80", n ) ) {
/*    *val_null = &settings->snapsasz80; */
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "snapshot", n ) ) {
    *val_char = &settings->snapshot;
    return 0;
  }
  if( n == 4 && !strncmp( (const char *)name, "snet", n ) ) {
    *val_char = &settings->snet;
    return 0;
  }
  if( n == 5 && !strncmp( (const char *)name, "sound", n ) ) {
    *val_int = &settings->sound;
    return 0;
  }
  if( n == 11 && !strncmp( (const char *)name, "sounddevice", n ) ) {
    *val_char = &settings->sound_device;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "soundforce8bit", n ) ) {
    *val_int = &settings->sound_force_8bit;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "soundfreq", n ) ) {
    *val_int = &settings->sound_freq;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "loadingsound", n ) ) {
    *val_int = &settings->sound_load;
    return 0;
  }
  if( n == 11 && !strncmp( (const char *)name, "speakertype", n ) ) {
    *val_char = &settings->speaker_type;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "speccyboot", n ) ) {
    *val_int = &settings->speccyboot;
    return 0;
  }
  if( n == 13 && !strncmp( (const char *)name, "speccyboottap", n ) ) {
    *val_char = &settings->speccyboot_tap;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "specdrum", n ) ) {
    *val_int = &settings->specdrum;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "spectranet", n ) ) {
    *val_int = &settings->spectranet;
    return 0;
  }
  if( n == 17 && !strncmp( (const char *)name, "spectranetdisable", n ) ) {
    *val_int = &settings->spectranet_disable;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "machine", n ) ) {
    *val_char = &settings->start_machine;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "graphicsfilter", n ) ) {
    *val_char = &settings->start_scaler_mode;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "statusbar", n ) ) {
    *val_int = &settings->statusbar;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "separation", n ) ) {
    *val_char = &settings->stereo_ay;
    return 0;
  }
  if( n == 16 && !strncmp( (const char *)name, "strictaspecthint", n ) ) {
    *val_int = &settings->strict_aspect_hint;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "svgamodes", n ) ) {
    *val_char = &settings->svga_modes;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "tapefile", n ) ) {
    *val_char = &settings->tape_file;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "tapetraps", n ) ) {
    *val_int = &settings->tape_traps;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "unittests", n ) ) {
    *val_int = &settings->unittests;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "usource", n ) ) {
    *val_int = &settings->usource;
    return 0;
  }
  if( n == 8 && !strncmp( (const char *)name, "volumeay", n ) ) {
    *val_int = &settings->volume_ay;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "volumebeeper", n ) ) {
    *val_int = &settings->volume_beeper;
    return 0;
  }
  if( n == 11 && !strncmp( (const char *)name, "volumecovox", n ) ) {
    *val_int = &settings->volume_covox;
    return 0;
  }
  if( n == 14 && !strncmp( (const char *)name, "volumespecdrum", n ) ) {
    *val_int = &settings->volume_specdrum;
    return 0;
  }
  if( n == 12 && !strncmp( (const char *)name, "writableroms", n ) ) {
    *val_int = &settings->writable_roms;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "cmosz80", n ) ) {
    *val_int = &settings->z80_is_cmos;
    return 0;
  }
  if( n == 7 && !strncmp( (const char *)name, "zxatasp", n ) ) {
    *val_int = &settings->zxatasp_active;
    return 0;
  }
  if( n == 17 && !strncmp( (const char *)name, "zxataspmasterfile", n ) ) {
    *val_char = &settings->zxatasp_master_file;
    return 0;
  }
  if( n == 16 && !strncmp( (const char *)name, "zxataspslavefile", n ) ) {
    *val_char = &settings->zxatasp_slave_file;
    return 0;
  }
  if( n == 13 && !strncmp( (const char *)name, "zxataspupload", n ) ) {
    *val_int = &settings->zxatasp_upload;
    return 0;
  }
  if( n == 19 && !strncmp( (const char *)name, "zxataspwriteprotect", n ) ) {
    *val_int = &settings->zxatasp_wp;
    return 0;
  }
  if( n == 4 && !strncmp( (const char *)name, "zxcf", n ) ) {
    *val_int = &settings->zxcf_active;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "zxcfcffile", n ) ) {
    *val_char = &settings->zxcf_pri_file;
    return 0;
  }
  if( n == 10 && !strncmp( (const char *)name, "zxcfupload", n ) ) {
    *val_int = &settings->zxcf_upload;
    return 0;
  }
  if( n == 9 && !strncmp( (const char *)name, "zxprinter", n ) ) {
    *val_int = &settings->zxprinter;
    return 0;
  }
  return 1;
}

static int
parse_ini( utils_file *file, settings_info *settings )
{
  unsigned char *cpos, *cpos_new;
  int *val_int;
  char **val_char;

  cpos = file->buffer;

  /* Read until the end of file */
  while( cpos < file->buffer + file->length ) {
    if( settings_var( settings, cpos, file->buffer + file->length, &val_int,
                      &val_char, &cpos_new ) ) {
      /* error in name or something else ... */
      cpos = cpos_new + 1;
      ui_error( UI_ERROR_WARNING,
                "Unknown and/or invalid setting '%s' in config file", cpos );
      continue;
    }
    cpos = cpos_new;
    if( val_int ) {
	*val_int = atoi( (char *)cpos );
	while( cpos < file->buffer + file->length && 
		( *cpos != '\0' && *cpos != '\r' && *cpos != '\n' ) ) cpos++;
    } else if( val_char ) {
	char *value = (char *)cpos;
	size_t n = 0;
	while( cpos < file->buffer + file->length && 
		( *cpos != '\0' && *cpos != '\r' && *cpos != '\n' ) ) cpos++;
	n = (char *)cpos - value;
	if( n > 0 ) {
	  if( *val_char != NULL ) {
	    libspectrum_free( *val_char );
	    *val_char = NULL;
	  }
	  *val_char = libspectrum_new( char, n + 1 );
	  (*val_char)[n] = '\0';
	  memcpy( *val_char, value, n );
	}
    }
    /* skip 'new line' like chars */
    while( ( cpos < ( file->buffer + file->length ) ) &&
           ( *cpos == '\r' || *cpos == '\n' ) ) cpos++;

#line 460"./settings.pl"
  }

  return 0;
}

static int
settings_file_write( compat_fd fd, const char *buffer, size_t length )
{
  return compat_file_write( fd, (const unsigned char *)buffer, length );
}

static int
settings_string_write( compat_fd doc, const char* name, const char* config )
{
  if( config != NULL &&
      ( settings_file_write( doc, name, strlen( name ) ) ||
        settings_file_write( doc, "=", 1 ) ||
        settings_file_write( doc, config, strlen( config ) ) ||
        settings_file_write( doc, FUSE_EOL, strlen( FUSE_EOL ) ) ) )
    return 1;
  return 0;
}

static int
settings_boolean_write( compat_fd doc, const char* name, int config )
{
  return settings_string_write( doc, name, config ? "1" : "0" );
}

static int
settings_numeric_write( compat_fd doc, const char* name, int config )
{
  char buffer[80]; 
  snprintf( buffer, sizeof( buffer ), "%d", config );
  return settings_string_write( doc, name, buffer );
}

int
settings_write_config( settings_info *settings )
{
  const char *home; char path[ PATH_MAX ];

  compat_fd doc;

  home = compat_get_home_path(); if( !home ) return 1;

  snprintf( path, PATH_MAX, "%s/%s", home, CONFIG_FILE_NAME );

  doc = compat_file_open( path, 1 );
  if( doc == COMPAT_FILE_OPEN_FAILED ) {
    ui_error( UI_ERROR_ERROR, "couldn't open `%s' for writing: %s\n",
	      path, strerror( errno ) );
    return 1;
  }

  if( settings_boolean_write( doc, "accelerateloader",
                              settings->accelerate_loader ) )
    goto error;
  if( settings_boolean_write( doc, "aspecthint",
                              settings->aspect_hint ) )
    goto error;
  if( settings_boolean_write( doc, "autoload",
                              settings->auto_load ) )
    goto error;
  if( settings_boolean_write( doc, "autosavesettings",
                              settings->autosave_settings ) )
    goto error;
  if( settings_boolean_write( doc, "beta128",
                              settings->beta128 ) )
    goto error;
  if( settings_boolean_write( doc, "beta12848boot",
                              settings->beta128_48boot ) )
    goto error;
  if( settings_string_write( doc, "betadisk",
                             settings->betadisk_file ) )
    goto error;
  if( settings_boolean_write( doc, "bwtv",
                              settings->bw_tv ) )
    goto error;
  if( settings_numeric_write( doc, "competitioncode",
                              settings->competition_code ) )
    goto error;
  if( settings_boolean_write( doc, "competitionmode",
                              settings->competition_mode ) )
    goto error;
  if( settings_boolean_write( doc, "confirmactions",
                              settings->confirm_actions ) )
    goto error;
  if( settings_boolean_write( doc, "covox",
                              settings->covox ) )
    goto error;
  if( settings_string_write( doc, "dock",
                             settings->dck_file ) )
    goto error;
  if( settings_string_write( doc, "debuggercommand",
                             settings->debugger_command ) )
    goto error;
  if( settings_boolean_write( doc, "detectloader",
                              settings->detect_loader ) )
    goto error;
  if( settings_boolean_write( doc, "didaktik80",
                              settings->didaktik80 ) )
    goto error;
  if( settings_string_write( doc, "didaktik80disk",
                             settings->didaktik80disk_file ) )
    goto error;
  if( settings_boolean_write( doc, "disciple",
                              settings->disciple ) )
    goto error;
  if( settings_string_write( doc, "discipledisk",
                             settings->discipledisk_file ) )
    goto error;
  if( settings_boolean_write( doc, "diskaskmerge",
                              settings->disk_ask_merge ) )
    goto error;
  if( settings_string_write( doc, "disktrymerge",
                             settings->disk_try_merge ) )
    goto error;
  if( settings_boolean_write( doc, "divide",
                              settings->divide_enabled ) )
    goto error;
  if( settings_string_write( doc, "dividemasterfile",
                             settings->divide_master_file ) )
    goto error;
  if( settings_string_write( doc, "divideslavefile",
                             settings->divide_slave_file ) )
    goto error;
  if( settings_boolean_write( doc, "dividewriteprotect",
                              settings->divide_wp ) )
    goto error;
  if( settings_numeric_write( doc, "doublescanmode",
                              settings->doublescan_mode ) )
    goto error;
  if( settings_numeric_write( doc, "drive40maxtrack",
                              settings->drive_40_max_track ) )
    goto error;
  if( settings_numeric_write( doc, "drive80maxtrack",
                              settings->drive_80_max_track ) )
    goto error;
  if( settings_string_write( doc, "drivebeta128atype",
                             settings->drive_beta128a_type ) )
    goto error;
  if( settings_string_write( doc, "drivebeta128btype",
                             settings->drive_beta128b_type ) )
    goto error;
  if( settings_string_write( doc, "drivebeta128ctype",
                             settings->drive_beta128c_type ) )
    goto error;
  if( settings_string_write( doc, "drivebeta128dtype",
                             settings->drive_beta128d_type ) )
    goto error;
  if( settings_string_write( doc, "drivedidaktik80atype",
                             settings->drive_didaktik80a_type ) )
    goto error;
  if( settings_string_write( doc, "drivedidaktik80btype",
                             settings->drive_didaktik80b_type ) )
    goto error;
  if( settings_string_write( doc, "drivedisciple1type",
                             settings->drive_disciple1_type ) )
    goto error;
  if( settings_string_write( doc, "drivedisciple2type",
                             settings->drive_disciple2_type ) )
    goto error;
  if( settings_string_write( doc, "driveopus1type",
                             settings->drive_opus1_type ) )
    goto error;
  if( settings_string_write( doc, "driveopus2type",
                             settings->drive_opus2_type ) )
    goto error;
  if( settings_string_write( doc, "driveplus3atype",
                             settings->drive_plus3a_type ) )
    goto error;
  if( settings_string_write( doc, "driveplus3btype",
                             settings->drive_plus3b_type ) )
    goto error;
  if( settings_string_write( doc, "driveplusd1type",
                             settings->drive_plusd1_type ) )
    goto error;
  if( settings_string_write( doc, "driveplusd2type",
                             settings->drive_plusd2_type ) )
    goto error;
  if( settings_boolean_write( doc, "embedsnapshot",
                              settings->embed_snapshot ) )
    goto error;
  if( settings_numeric_write( doc, "speed",
                              settings->emulation_speed ) )
    goto error;
  if( settings_boolean_write( doc, "fastload",
                              settings->fastload ) )
    goto error;
  if( settings_numeric_write( doc, "fbmode",
                              settings->fb_mode ) )
    goto error;
  if( settings_numeric_write( doc, "rate",
                              settings->frame_rate ) )
    goto error;
  if( settings_boolean_write( doc, "fullscreen",
                              settings->full_screen ) )
    goto error;
  if( settings_boolean_write( doc, "fuller",
                              settings->fuller ) )
    goto error;
  if( settings_string_write( doc, "if2cart",
                             settings->if2_file ) )
    goto error;
  if( settings_boolean_write( doc, "interface1",
                              settings->interface1 ) )
    goto error;
  if( settings_boolean_write( doc, "interface2",
                              settings->interface2 ) )
    goto error;
  if( settings_boolean_write( doc, "issue2",
                              settings->issue2 ) )
    goto error;
  if( settings_boolean_write( doc, "kempston",
                              settings->joy_kempston ) )
    goto error;
  if( settings_boolean_write( doc, "joystickprompt",
                              settings->joy_prompt ) )
    goto error;
  if( settings_string_write( doc, "joystick1",
                             settings->joystick_1 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire1",
                              settings->joystick_1_fire_1 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire10",
                              settings->joystick_1_fire_10 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire11",
                              settings->joystick_1_fire_11 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire12",
                              settings->joystick_1_fire_12 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire13",
                              settings->joystick_1_fire_13 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire14",
                              settings->joystick_1_fire_14 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire15",
                              settings->joystick_1_fire_15 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire2",
                              settings->joystick_1_fire_2 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire3",
                              settings->joystick_1_fire_3 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire4",
                              settings->joystick_1_fire_4 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire5",
                              settings->joystick_1_fire_5 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire6",
                              settings->joystick_1_fire_6 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire7",
                              settings->joystick_1_fire_7 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire8",
                              settings->joystick_1_fire_8 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1fire9",
                              settings->joystick_1_fire_9 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick1output",
                              settings->joystick_1_output ) )
    goto error;
  if( settings_string_write( doc, "joystick2",
                             settings->joystick_2 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire1",
                              settings->joystick_2_fire_1 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire10",
                              settings->joystick_2_fire_10 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire11",
                              settings->joystick_2_fire_11 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire12",
                              settings->joystick_2_fire_12 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire13",
                              settings->joystick_2_fire_13 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire14",
                              settings->joystick_2_fire_14 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire15",
                              settings->joystick_2_fire_15 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire2",
                              settings->joystick_2_fire_2 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire3",
                              settings->joystick_2_fire_3 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire4",
                              settings->joystick_2_fire_4 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire5",
                              settings->joystick_2_fire_5 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire6",
                              settings->joystick_2_fire_6 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire7",
                              settings->joystick_2_fire_7 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire8",
                              settings->joystick_2_fire_8 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2fire9",
                              settings->joystick_2_fire_9 ) )
    goto error;
  if( settings_numeric_write( doc, "joystick2output",
                              settings->joystick_2_output ) )
    goto error;
  if( settings_numeric_write( doc, "joystickkeyboarddown",
                              settings->joystick_keyboard_down ) )
    goto error;
  if( settings_numeric_write( doc, "joystickkeyboardfire",
                              settings->joystick_keyboard_fire ) )
    goto error;
  if( settings_numeric_write( doc, "joystickkeyboardleft",
                              settings->joystick_keyboard_left ) )
    goto error;
  if( settings_numeric_write( doc, "joystickkeyboardoutput",
                              settings->joystick_keyboard_output ) )
    goto error;
  if( settings_numeric_write( doc, "joystickkeyboardright",
                              settings->joystick_keyboard_right ) )
    goto error;
  if( settings_numeric_write( doc, "joystickkeyboardup",
                              settings->joystick_keyboard_up ) )
    goto error;
  if( settings_boolean_write( doc, "kempstonmouse",
                              settings->kempston_mouse ) )
    goto error;
  if( settings_boolean_write( doc, "keyboardarrowsshifted",
                              settings->keyboard_arrows_shifted ) )
    goto error;
  if( settings_boolean_write( doc, "latetimings",
                              settings->late_timings ) )
    goto error;
  if( settings_string_write( doc, "microdrivefile",
                             settings->mdr_file ) )
    goto error;
  if( settings_string_write( doc, "microdrive2file",
                             settings->mdr_file2 ) )
    goto error;
  if( settings_string_write( doc, "microdrive3file",
                             settings->mdr_file3 ) )
    goto error;
  if( settings_string_write( doc, "microdrive4file",
                             settings->mdr_file4 ) )
    goto error;
  if( settings_string_write( doc, "microdrive5file",
                             settings->mdr_file5 ) )
    goto error;
  if( settings_string_write( doc, "microdrive6file",
                             settings->mdr_file6 ) )
    goto error;
  if( settings_string_write( doc, "microdrive7file",
                             settings->mdr_file7 ) )
    goto error;
  if( settings_string_write( doc, "microdrive8file",
                             settings->mdr_file8 ) )
    goto error;
  if( settings_numeric_write( doc, "mdrlen",
                              settings->mdr_len ) )
    goto error;
  if( settings_boolean_write( doc, "mdrrandomlen",
                              settings->mdr_random_len ) )
    goto error;
  if( settings_boolean_write( doc, "melodik",
                              settings->melodik ) )
    goto error;
  if( settings_boolean_write( doc, "mouseswapbuttons",
                              settings->mouse_swap_buttons ) )
    goto error;
  if( settings_string_write( doc, "moviecompr",
                             settings->movie_compr ) )
    goto error;
  if( settings_string_write( doc, "moviestart",
                             settings->movie_start ) )
    goto error;
  if( settings_boolean_write( doc, "moviestopafterrzx",
                              settings->movie_stop_after_rzx ) )
    goto error;
  if( settings_boolean_write( doc, "multiface1",
                              settings->multiface1 ) )
    goto error;
  if( settings_boolean_write( doc, "multiface128",
                              settings->multiface128 ) )
    goto error;
  if( settings_boolean_write( doc, "multiface1stealth",
                              settings->multiface1_stealth ) )
    goto error;
  if( settings_boolean_write( doc, "multiface3",
                              settings->multiface3 ) )
    goto error;
  if( settings_boolean_write( doc, "opus",
                              settings->opus ) )
    goto error;
  if( settings_string_write( doc, "opusdisk",
                             settings->opusdisk_file ) )
    goto error;
  if( settings_boolean_write( doc, "paltv2x",
                              settings->pal_tv2x ) )
    goto error;
  if( settings_string_write( doc, "playbackfile",
                             settings->playback_file ) )
    goto error;
  if( settings_boolean_write( doc, "plus3detectspeedlock",
                              settings->plus3_detect_speedlock ) )
    goto error;
  if( settings_string_write( doc, "plus3disk",
                             settings->plus3disk_file ) )
    goto error;
  if( settings_boolean_write( doc, "plusd",
                              settings->plusd ) )
    goto error;
  if( settings_string_write( doc, "plusddisk",
                             settings->plusddisk_file ) )
    goto error;
  if( settings_boolean_write( doc, "printer",
                              settings->printer ) )
    goto error;
  if( settings_string_write( doc, "graphicsfile",
                             settings->printer_graphics_filename ) )
    goto error;
  if( settings_string_write( doc, "textfile",
                             settings->printer_text_filename ) )
    goto error;
  if( settings_boolean_write( doc, "rawsnet",
                              settings->raw_s_net ) )
    goto error;
  if( settings_string_write( doc, "recordfile",
                             settings->record_file ) )
    goto error;
  if( settings_boolean_write( doc, "recreatedspectrum",
                              settings->recreated_spectrum ) )
    goto error;
  if( settings_string_write( doc, "rom1280",
                             settings->rom_128_0 ) )
    goto error;
  if( settings_string_write( doc, "rom1281",
                             settings->rom_128_1 ) )
    goto error;
  if( settings_string_write( doc, "rom16",
                             settings->rom_16 ) )
    goto error;
  if( settings_string_write( doc, "rom48",
                             settings->rom_48 ) )
    goto error;
  if( settings_string_write( doc, "rombeta128",
                             settings->rom_beta128 ) )
    goto error;
  if( settings_string_write( doc, "romdidaktik80",
                             settings->rom_didaktik80 ) )
    goto error;
  if( settings_string_write( doc, "romdisciple",
                             settings->rom_disciple ) )
    goto error;
  if( settings_string_write( doc, "rominterfacei",
                             settings->rom_interface_1 ) )
    goto error;
  if( settings_string_write( doc, "rommultiface1",
                             settings->rom_multiface1 ) )
    goto error;
  if( settings_string_write( doc, "rommultiface128",
                             settings->rom_multiface128 ) )
    goto error;
  if( settings_string_write( doc, "rommultiface3",
                             settings->rom_multiface3 ) )
    goto error;
  if( settings_string_write( doc, "romopus",
                             settings->rom_opus ) )
    goto error;
  if( settings_string_write( doc, "rompentagon10240",
                             settings->rom_pentagon1024_0 ) )
    goto error;
  if( settings_string_write( doc, "rompentagon10241",
                             settings->rom_pentagon1024_1 ) )
    goto error;
  if( settings_string_write( doc, "rompentagon10242",
                             settings->rom_pentagon1024_2 ) )
    goto error;
  if( settings_string_write( doc, "rompentagon10243",
                             settings->rom_pentagon1024_3 ) )
    goto error;
  if( settings_string_write( doc, "rompentagon5120",
                             settings->rom_pentagon512_0 ) )
    goto error;
  if( settings_string_write( doc, "rompentagon5121",
                             settings->rom_pentagon512_1 ) )
    goto error;
  if( settings_string_write( doc, "rompentagon5122",
                             settings->rom_pentagon512_2 ) )
    goto error;
  if( settings_string_write( doc, "rompentagon5123",
                             settings->rom_pentagon512_3 ) )
    goto error;
  if( settings_string_write( doc, "rompentagon0",
                             settings->rom_pentagon_0 ) )
    goto error;
  if( settings_string_write( doc, "rompentagon1",
                             settings->rom_pentagon_1 ) )
    goto error;
  if( settings_string_write( doc, "rompentagon2",
                             settings->rom_pentagon_2 ) )
    goto error;
  if( settings_string_write( doc, "romplus20",
                             settings->rom_plus2_0 ) )
    goto error;
  if( settings_string_write( doc, "romplus21",
                             settings->rom_plus2_1 ) )
    goto error;
  if( settings_string_write( doc, "romplus2a0",
                             settings->rom_plus2a_0 ) )
    goto error;
  if( settings_string_write( doc, "romplus2a1",
                             settings->rom_plus2a_1 ) )
    goto error;
  if( settings_string_write( doc, "romplus2a2",
                             settings->rom_plus2a_2 ) )
    goto error;
  if( settings_string_write( doc, "romplus2a3",
                             settings->rom_plus2a_3 ) )
    goto error;
  if( settings_string_write( doc, "romplus30",
                             settings->rom_plus3_0 ) )
    goto error;
  if( settings_string_write( doc, "romplus31",
                             settings->rom_plus3_1 ) )
    goto error;
  if( settings_string_write( doc, "romplus32",
                             settings->rom_plus3_2 ) )
    goto error;
  if( settings_string_write( doc, "romplus33",
                             settings->rom_plus3_3 ) )
    goto error;
  if( settings_string_write( doc, "romplus3e0",
                             settings->rom_plus3e_0 ) )
    goto error;
  if( settings_string_write( doc, "romplus3e1",
                             settings->rom_plus3e_1 ) )
    goto error;
  if( settings_string_write( doc, "romplus3e2",
                             settings->rom_plus3e_2 ) )
    goto error;
  if( settings_string_write( doc, "romplus3e3",
                             settings->rom_plus3e_3 ) )
    goto error;
  if( settings_string_write( doc, "romplusd",
                             settings->rom_plusd ) )
    goto error;
  if( settings_string_write( doc, "romscorpion0",
                             settings->rom_scorpion_0 ) )
    goto error;
  if( settings_string_write( doc, "romscorpion1",
                             settings->rom_scorpion_1 ) )
    goto error;
  if( settings_string_write( doc, "romscorpion2",
                             settings->rom_scorpion_2 ) )
    goto error;
  if( settings_string_write( doc, "romscorpion3",
                             settings->rom_scorpion_3 ) )
    goto error;
  if( settings_string_write( doc, "romspecse0",
                             settings->rom_spec_se_0 ) )
    goto error;
  if( settings_string_write( doc, "romspecse1",
                             settings->rom_spec_se_1 ) )
    goto error;
  if( settings_string_write( doc, "romspeccyboot",
                             settings->rom_speccyboot ) )
    goto error;
  if( settings_string_write( doc, "romtc2048",
                             settings->rom_tc2048 ) )
    goto error;
  if( settings_string_write( doc, "romtc20680",
                             settings->rom_tc2068_0 ) )
    goto error;
  if( settings_string_write( doc, "romtc20681",
                             settings->rom_tc2068_1 ) )
    goto error;
  if( settings_string_write( doc, "romts20680",
                             settings->rom_ts2068_0 ) )
    goto error;
  if( settings_string_write( doc, "romts20681",
                             settings->rom_ts2068_1 ) )
    goto error;
  if( settings_string_write( doc, "romusource",
                             settings->rom_usource ) )
    goto error;
  if( settings_boolean_write( doc, "rs232handshake",
                              settings->rs232_handshake ) )
    goto error;
  if( settings_string_write( doc, "rs232rx",
                             settings->rs232_rx ) )
    goto error;
  if( settings_string_write( doc, "rs232tx",
                             settings->rs232_tx ) )
    goto error;
  if( settings_boolean_write( doc, "rzxautosaves",
                              settings->rzx_autosaves ) )
    goto error;
  if( settings_boolean_write( doc, "compressrzx",
                              settings->rzx_compression ) )
    goto error;
  if( settings_boolean_write( doc, "simpleide",
                              settings->simpleide_active ) )
    goto error;
  if( settings_string_write( doc, "simpleidemasterfile",
                             settings->simpleide_master_file ) )
    goto error;
  if( settings_string_write( doc, "simpleideslavefile",
                             settings->simpleide_slave_file ) )
    goto error;
  if( settings_boolean_write( doc, "slttraps",
                              settings->slt_traps ) )
    goto error;
  if( settings_string_write( doc, "snapshot",
                             settings->snapshot ) )
    goto error;
  if( settings_string_write( doc, "snet",
                             settings->snet ) )
    goto error;
  if( settings_boolean_write( doc, "sound",
                              settings->sound ) )
    goto error;
  if( settings_string_write( doc, "sounddevice",
                             settings->sound_device ) )
    goto error;
  if( settings_boolean_write( doc, "soundforce8bit",
                              settings->sound_force_8bit ) )
    goto error;
  if( settings_numeric_write( doc, "soundfreq",
                              settings->sound_freq ) )
    goto error;
  if( settings_boolean_write( doc, "loadingsound",
                              settings->sound_load ) )
    goto error;
  if( settings_string_write( doc, "speakertype",
                             settings->speaker_type ) )
    goto error;
  if( settings_boolean_write( doc, "speccyboot",
                              settings->speccyboot ) )
    goto error;
  if( settings_string_write( doc, "speccyboottap",
                             settings->speccyboot_tap ) )
    goto error;
  if( settings_boolean_write( doc, "specdrum",
                              settings->specdrum ) )
    goto error;
  if( settings_boolean_write( doc, "spectranet",
                              settings->spectranet ) )
    goto error;
  if( settings_boolean_write( doc, "spectranetdisable",
                              settings->spectranet_disable ) )
    goto error;
  if( settings_string_write( doc, "machine",
                             settings->start_machine ) )
    goto error;
  if( settings_string_write( doc, "graphicsfilter",
                             settings->start_scaler_mode ) )
    goto error;
  if( settings_boolean_write( doc, "statusbar",
                              settings->statusbar ) )
    goto error;
  if( settings_string_write( doc, "separation",
                             settings->stereo_ay ) )
    goto error;
  if( settings_boolean_write( doc, "strictaspecthint",
                              settings->strict_aspect_hint ) )
    goto error;
  if( settings_string_write( doc, "svgamodes",
                             settings->svga_modes ) )
    goto error;
  if( settings_string_write( doc, "tapefile",
                             settings->tape_file ) )
    goto error;
  if( settings_boolean_write( doc, "tapetraps",
                              settings->tape_traps ) )
    goto error;
  if( settings_boolean_write( doc, "unittests",
                              settings->unittests ) )
    goto error;
  if( settings_boolean_write( doc, "usource",
                              settings->usource ) )
    goto error;
  if( settings_numeric_write( doc, "volumeay",
                              settings->volume_ay ) )
    goto error;
  if( settings_numeric_write( doc, "volumebeeper",
                              settings->volume_beeper ) )
    goto error;
  if( settings_numeric_write( doc, "volumecovox",
                              settings->volume_covox ) )
    goto error;
  if( settings_numeric_write( doc, "volumespecdrum",
                              settings->volume_specdrum ) )
    goto error;
  if( settings_boolean_write( doc, "writableroms",
                              settings->writable_roms ) )
    goto error;
  if( settings_boolean_write( doc, "cmosz80",
                              settings->z80_is_cmos ) )
    goto error;
  if( settings_boolean_write( doc, "zxatasp",
                              settings->zxatasp_active ) )
    goto error;
  if( settings_string_write( doc, "zxataspmasterfile",
                             settings->zxatasp_master_file ) )
    goto error;
  if( settings_string_write( doc, "zxataspslavefile",
                             settings->zxatasp_slave_file ) )
    goto error;
  if( settings_boolean_write( doc, "zxataspupload",
                              settings->zxatasp_upload ) )
    goto error;
  if( settings_boolean_write( doc, "zxataspwriteprotect",
                              settings->zxatasp_wp ) )
    goto error;
  if( settings_boolean_write( doc, "zxcf",
                              settings->zxcf_active ) )
    goto error;
  if( settings_string_write( doc, "zxcfcffile",
                             settings->zxcf_pri_file ) )
    goto error;
  if( settings_boolean_write( doc, "zxcfupload",
                              settings->zxcf_upload ) )
    goto error;
  if( settings_boolean_write( doc, "zxprinter",
                              settings->zxprinter ) )
    goto error;
#line 552"./settings.pl"

  compat_file_close( doc );

  return 0;
error:
  compat_file_close( doc );

  return 1;
}

#endif				/* #ifdef HAVE_LIB_XML2 */

/* Read options from the command line */
static int
settings_command_line( settings_info *settings, int *first_arg,
                       int argc, char **argv )
{
#ifdef GEKKO
  /* No argv on the Wii. Just return */
  return 0;
#endif

#if !defined AMIGA && !defined __MORPHOS__

  struct option long_options[] = {

    {    "accelerate-loader", 0, &(settings->accelerate_loader), 1 },
    { "no-accelerate-loader", 0, &(settings->accelerate_loader), 0 },
    {    "aspect-hint", 0, &(settings->aspect_hint), 1 },
    { "no-aspect-hint", 0, &(settings->aspect_hint), 0 },
    {    "auto-load", 0, &(settings->auto_load), 1 },
    { "no-auto-load", 0, &(settings->auto_load), 0 },
    {    "autosave-settings", 0, &(settings->autosave_settings), 1 },
    { "no-autosave-settings", 0, &(settings->autosave_settings), 0 },
    {    "beta128", 0, &(settings->beta128), 1 },
    { "no-beta128", 0, &(settings->beta128), 0 },
    {    "beta128-48boot", 0, &(settings->beta128_48boot), 1 },
    { "no-beta128-48boot", 0, &(settings->beta128_48boot), 0 },
    { "betadisk", 1, NULL, 256 },
    {    "bw-tv", 0, &(settings->bw_tv), 1 },
    { "no-bw-tv", 0, &(settings->bw_tv), 0 },
    { "competition-code", 1, NULL, 257 },
    {    "competition-mode", 0, &(settings->competition_mode), 1 },
    { "no-competition-mode", 0, &(settings->competition_mode), 0 },
    {    "confirm-actions", 0, &(settings->confirm_actions), 1 },
    { "no-confirm-actions", 0, &(settings->confirm_actions), 0 },
    {    "covox", 0, &(settings->covox), 1 },
    { "no-covox", 0, &(settings->covox), 0 },
    { "dock", 1, NULL, 258 },
    { "debugger-command", 1, NULL, 259 },
    {    "detect-loader", 0, &(settings->detect_loader), 1 },
    { "no-detect-loader", 0, &(settings->detect_loader), 0 },
    {    "didaktik80", 0, &(settings->didaktik80), 1 },
    { "no-didaktik80", 0, &(settings->didaktik80), 0 },
    { "didaktik80disk", 1, NULL, 260 },
    {    "disciple", 0, &(settings->disciple), 1 },
    { "no-disciple", 0, &(settings->disciple), 0 },
    { "discipledisk", 1, NULL, 261 },
    {    "disk-ask-merge", 0, &(settings->disk_ask_merge), 1 },
    { "no-disk-ask-merge", 0, &(settings->disk_ask_merge), 0 },
    { "disk-try-merge", 1, NULL, 262 },
    {    "divide", 0, &(settings->divide_enabled), 1 },
    { "no-divide", 0, &(settings->divide_enabled), 0 },
    { "divide-masterfile", 1, NULL, 263 },
    { "divide-slavefile", 1, NULL, 264 },
    {    "divide-write-protect", 0, &(settings->divide_wp), 1 },
    { "no-divide-write-protect", 0, &(settings->divide_wp), 0 },
    { "doublescan-mode", 1, NULL, 'D' },
    { "drive-40-max-track", 1, NULL, 266 },
    { "drive-80-max-track", 1, NULL, 267 },
    { "drive-beta128a-type", 1, NULL, 268 },
    { "drive-beta128b-type", 1, NULL, 269 },
    { "drive-beta128c-type", 1, NULL, 270 },
    { "drive-beta128d-type", 1, NULL, 271 },
    { "drive-didaktik80a-type", 1, NULL, 272 },
    { "drive-didaktik80b-type", 1, NULL, 273 },
    { "drive-disciple1-type", 1, NULL, 274 },
    { "drive-disciple2-type", 1, NULL, 275 },
    { "drive-opus1-type", 1, NULL, 276 },
    { "drive-opus2-type", 1, NULL, 277 },
    { "drive-plus3a-type", 1, NULL, 278 },
    { "drive-plus3b-type", 1, NULL, 279 },
    { "drive-plusd1-type", 1, NULL, 280 },
    { "drive-plusd2-type", 1, NULL, 281 },
    {    "embed-snapshot", 0, &(settings->embed_snapshot), 1 },
    { "no-embed-snapshot", 0, &(settings->embed_snapshot), 0 },
    { "speed", 1, NULL, 282 },
    {    "fastload", 0, &(settings->fastload), 1 },
    { "no-fastload", 0, &(settings->fastload), 0 },
    { "fbmode", 1, NULL, 'v' },
    { "rate", 1, NULL, 283 },
    {    "full-screen", 0, &(settings->full_screen), 1 },
    { "no-full-screen", 0, &(settings->full_screen), 0 },
    {    "fuller", 0, &(settings->fuller), 1 },
    { "no-fuller", 0, &(settings->fuller), 0 },
    { "if2cart", 1, NULL, 284 },
    {    "interface1", 0, &(settings->interface1), 1 },
    { "no-interface1", 0, &(settings->interface1), 0 },
    {    "interface2", 0, &(settings->interface2), 1 },
    { "no-interface2", 0, &(settings->interface2), 0 },
    {    "issue2", 0, &(settings->issue2), 1 },
    { "no-issue2", 0, &(settings->issue2), 0 },
    {    "kempston", 0, &(settings->joy_kempston), 1 },
    { "no-kempston", 0, &(settings->joy_kempston), 0 },
    {    "joystick-prompt", 0, &(settings->joy_prompt), 1 },
    { "no-joystick-prompt", 0, &(settings->joy_prompt), 0 },
    { "joystick-1", 1, NULL, 'j' },
    { "joystick-1-fire-1", 1, NULL, 285 },
    { "joystick-1-fire-10", 1, NULL, 286 },
    { "joystick-1-fire-11", 1, NULL, 287 },
    { "joystick-1-fire-12", 1, NULL, 288 },
    { "joystick-1-fire-13", 1, NULL, 289 },
    { "joystick-1-fire-14", 1, NULL, 290 },
    { "joystick-1-fire-15", 1, NULL, 291 },
    { "joystick-1-fire-2", 1, NULL, 292 },
    { "joystick-1-fire-3", 1, NULL, 293 },
    { "joystick-1-fire-4", 1, NULL, 294 },
    { "joystick-1-fire-5", 1, NULL, 295 },
    { "joystick-1-fire-6", 1, NULL, 296 },
    { "joystick-1-fire-7", 1, NULL, 297 },
    { "joystick-1-fire-8", 1, NULL, 298 },
    { "joystick-1-fire-9", 1, NULL, 299 },
    { "joystick-1-output", 1, NULL, 300 },
    { "joystick-2", 1, NULL, 301 },
    { "joystick-2-fire-1", 1, NULL, 302 },
    { "joystick-2-fire-10", 1, NULL, 303 },
    { "joystick-2-fire-11", 1, NULL, 304 },
    { "joystick-2-fire-12", 1, NULL, 305 },
    { "joystick-2-fire-13", 1, NULL, 306 },
    { "joystick-2-fire-14", 1, NULL, 307 },
    { "joystick-2-fire-15", 1, NULL, 308 },
    { "joystick-2-fire-2", 1, NULL, 309 },
    { "joystick-2-fire-3", 1, NULL, 310 },
    { "joystick-2-fire-4", 1, NULL, 311 },
    { "joystick-2-fire-5", 1, NULL, 312 },
    { "joystick-2-fire-6", 1, NULL, 313 },
    { "joystick-2-fire-7", 1, NULL, 314 },
    { "joystick-2-fire-8", 1, NULL, 315 },
    { "joystick-2-fire-9", 1, NULL, 316 },
    { "joystick-2-output", 1, NULL, 317 },
    { "joystick-keyboard-down", 1, NULL, 318 },
    { "joystick-keyboard-fire", 1, NULL, 319 },
    { "joystick-keyboard-left", 1, NULL, 320 },
    { "joystick-keyboard-output", 1, NULL, 321 },
    { "joystick-keyboard-right", 1, NULL, 322 },
    { "joystick-keyboard-up", 1, NULL, 323 },
    {    "kempston-mouse", 0, &(settings->kempston_mouse), 1 },
    { "no-kempston-mouse", 0, &(settings->kempston_mouse), 0 },
    {    "keyboard-arrows-shifted", 0, &(settings->keyboard_arrows_shifted), 1 },
    { "no-keyboard-arrows-shifted", 0, &(settings->keyboard_arrows_shifted), 0 },
    {    "late-timings", 0, &(settings->late_timings), 1 },
    { "no-late-timings", 0, &(settings->late_timings), 0 },
    { "microdrive-file", 1, NULL, 324 },
    { "microdrive-2-file", 1, NULL, 325 },
    { "microdrive-3-file", 1, NULL, 326 },
    { "microdrive-4-file", 1, NULL, 327 },
    { "microdrive-5-file", 1, NULL, 328 },
    { "microdrive-6-file", 1, NULL, 329 },
    { "microdrive-7-file", 1, NULL, 330 },
    { "microdrive-8-file", 1, NULL, 331 },
    { "mdr-len", 1, NULL, 332 },
    {    "mdr-random-len", 0, &(settings->mdr_random_len), 1 },
    { "no-mdr-random-len", 0, &(settings->mdr_random_len), 0 },
    {    "melodik", 0, &(settings->melodik), 1 },
    { "no-melodik", 0, &(settings->melodik), 0 },
    {    "mouse-swap-buttons", 0, &(settings->mouse_swap_buttons), 1 },
    { "no-mouse-swap-buttons", 0, &(settings->mouse_swap_buttons), 0 },
    { "movie-compr", 1, NULL, 333 },
    { "movie-start", 1, NULL, 334 },
    {    "movie-stop-after-rzx", 0, &(settings->movie_stop_after_rzx), 1 },
    { "no-movie-stop-after-rzx", 0, &(settings->movie_stop_after_rzx), 0 },
    {    "multiface1", 0, &(settings->multiface1), 1 },
    { "no-multiface1", 0, &(settings->multiface1), 0 },
    {    "multiface128", 0, &(settings->multiface128), 1 },
    { "no-multiface128", 0, &(settings->multiface128), 0 },
    {    "multiface1-stealth", 0, &(settings->multiface1_stealth), 1 },
    { "no-multiface1-stealth", 0, &(settings->multiface1_stealth), 0 },
    {    "multiface3", 0, &(settings->multiface3), 1 },
    { "no-multiface3", 0, &(settings->multiface3), 0 },
    {    "opus", 0, &(settings->opus), 1 },
    { "no-opus", 0, &(settings->opus), 0 },
    { "opusdisk", 1, NULL, 335 },
    {    "pal-tv2x", 0, &(settings->pal_tv2x), 1 },
    { "no-pal-tv2x", 0, &(settings->pal_tv2x), 0 },
    { "playback", 1, NULL, 'p' },
    {    "plus3-detect-speedlock", 0, &(settings->plus3_detect_speedlock), 1 },
    { "no-plus3-detect-speedlock", 0, &(settings->plus3_detect_speedlock), 0 },
    { "plus3disk", 1, NULL, 336 },
    {    "plusd", 0, &(settings->plusd), 1 },
    { "no-plusd", 0, &(settings->plusd), 0 },
    { "plusddisk", 1, NULL, 337 },
    {    "printer", 0, &(settings->printer), 1 },
    { "no-printer", 0, &(settings->printer), 0 },
    { "graphicsfile", 1, NULL, 338 },
    { "textfile", 1, NULL, 339 },
    {    "raw-s-net", 0, &(settings->raw_s_net), 1 },
    { "no-raw-s-net", 0, &(settings->raw_s_net), 0 },
    { "record", 1, NULL, 'r' },
    {    "recreated-spectrum", 0, &(settings->recreated_spectrum), 1 },
    { "no-recreated-spectrum", 0, &(settings->recreated_spectrum), 0 },
    { "rom-128-0", 1, NULL, 341 },
    { "rom-128-1", 1, NULL, 342 },
    { "rom-16", 1, NULL, 343 },
    { "rom-48", 1, NULL, 344 },
    { "rom-beta128", 1, NULL, 345 },
    { "rom-didaktik80", 1, NULL, 346 },
    { "rom-disciple", 1, NULL, 347 },
    { "rom-interface-1", 1, NULL, 348 },
    { "rom-multiface1", 1, NULL, 349 },
    { "rom-multiface128", 1, NULL, 350 },
    { "rom-multiface3", 1, NULL, 351 },
    { "rom-opus", 1, NULL, 352 },
    { "rom-pentagon1024-0", 1, NULL, 353 },
    { "rom-pentagon1024-1", 1, NULL, 354 },
    { "rom-pentagon1024-2", 1, NULL, 355 },
    { "rom-pentagon1024-3", 1, NULL, 356 },
    { "rom-pentagon512-0", 1, NULL, 357 },
    { "rom-pentagon512-1", 1, NULL, 358 },
    { "rom-pentagon512-2", 1, NULL, 359 },
    { "rom-pentagon512-3", 1, NULL, 360 },
    { "rom-pentagon-0", 1, NULL, 361 },
    { "rom-pentagon-1", 1, NULL, 362 },
    { "rom-pentagon-2", 1, NULL, 363 },
    { "rom-plus2-0", 1, NULL, 364 },
    { "rom-plus2-1", 1, NULL, 365 },
    { "rom-plus2a-0", 1, NULL, 366 },
    { "rom-plus2a-1", 1, NULL, 367 },
    { "rom-plus2a-2", 1, NULL, 368 },
    { "rom-plus2a-3", 1, NULL, 369 },
    { "rom-plus3-0", 1, NULL, 370 },
    { "rom-plus3-1", 1, NULL, 371 },
    { "rom-plus3-2", 1, NULL, 372 },
    { "rom-plus3-3", 1, NULL, 373 },
    { "rom-plus3e-0", 1, NULL, 374 },
    { "rom-plus3e-1", 1, NULL, 375 },
    { "rom-plus3e-2", 1, NULL, 376 },
    { "rom-plus3e-3", 1, NULL, 377 },
    { "rom-plusd", 1, NULL, 378 },
    { "rom-scorpion-0", 1, NULL, 379 },
    { "rom-scorpion-1", 1, NULL, 380 },
    { "rom-scorpion-2", 1, NULL, 381 },
    { "rom-scorpion-3", 1, NULL, 382 },
    { "rom-spec-se-0", 1, NULL, 383 },
    { "rom-spec-se-1", 1, NULL, 384 },
    { "rom-speccyboot", 1, NULL, 385 },
    { "rom-tc2048", 1, NULL, 386 },
    { "rom-tc2068-0", 1, NULL, 387 },
    { "rom-tc2068-1", 1, NULL, 388 },
    { "rom-ts2068-0", 1, NULL, 389 },
    { "rom-ts2068-1", 1, NULL, 390 },
    { "rom-usource", 1, NULL, 391 },
    {    "rs232-handshake", 0, &(settings->rs232_handshake), 1 },
    { "no-rs232-handshake", 0, &(settings->rs232_handshake), 0 },
    { "rs232-rx", 1, NULL, 392 },
    { "rs232-tx", 1, NULL, 393 },
    {    "rzx-autosaves", 0, &(settings->rzx_autosaves), 1 },
    { "no-rzx-autosaves", 0, &(settings->rzx_autosaves), 0 },
    {    "compress-rzx", 0, &(settings->rzx_compression), 1 },
    { "no-compress-rzx", 0, &(settings->rzx_compression), 0 },
    {    "simpleide", 0, &(settings->simpleide_active), 1 },
    { "no-simpleide", 0, &(settings->simpleide_active), 0 },
    { "simpleide-masterfile", 1, NULL, 394 },
    { "simpleide-slavefile", 1, NULL, 395 },
    {    "slt", 0, &(settings->slt_traps), 1 },
    { "no-slt", 0, &(settings->slt_traps), 0 },
    { "snapshot", 1, NULL, 's' },
    { "snet", 1, NULL, 397 },
    {    "sound", 0, &(settings->sound), 1 },
    { "no-sound", 0, &(settings->sound), 0 },
    { "sound-device", 1, NULL, 'd' },
    {    "sound-force-8bit", 0, &(settings->sound_force_8bit), 1 },
    { "no-sound-force-8bit", 0, &(settings->sound_force_8bit), 0 },
    { "sound-freq", 1, NULL, 'f' },
    {    "loading-sound", 0, &(settings->sound_load), 1 },
    { "no-loading-sound", 0, &(settings->sound_load), 0 },
    { "speaker-type", 1, NULL, 398 },
    {    "speccyboot", 0, &(settings->speccyboot), 1 },
    { "no-speccyboot", 0, &(settings->speccyboot), 0 },
    { "speccyboot-tap", 1, NULL, 399 },
    {    "specdrum", 0, &(settings->specdrum), 1 },
    { "no-specdrum", 0, &(settings->specdrum), 0 },
    {    "spectranet", 0, &(settings->spectranet), 1 },
    { "no-spectranet", 0, &(settings->spectranet), 0 },
    {    "spectranet-disable", 0, &(settings->spectranet_disable), 1 },
    { "no-spectranet-disable", 0, &(settings->spectranet_disable), 0 },
    { "machine", 1, NULL, 'm' },
    { "graphics-filter", 1, NULL, 'g' },
    {    "statusbar", 0, &(settings->statusbar), 1 },
    { "no-statusbar", 0, &(settings->statusbar), 0 },
    { "separation", 1, NULL, 400 },
    {    "strict-aspect-hint", 0, &(settings->strict_aspect_hint), 1 },
    { "no-strict-aspect-hint", 0, &(settings->strict_aspect_hint), 0 },
    { "svga-modes", 1, NULL, 401 },
    { "tape", 1, NULL, 't' },
    {    "traps", 0, &(settings->tape_traps), 1 },
    { "no-traps", 0, &(settings->tape_traps), 0 },
    {    "unittests", 0, &(settings->unittests), 1 },
    { "no-unittests", 0, &(settings->unittests), 0 },
    {    "usource", 0, &(settings->usource), 1 },
    { "no-usource", 0, &(settings->usource), 0 },
    { "volume-ay", 1, NULL, 402 },
    { "volume-beeper", 1, NULL, 403 },
    { "volume-covox", 1, NULL, 404 },
    { "volume-specdrum", 1, NULL, 405 },
    {    "writable-roms", 0, &(settings->writable_roms), 1 },
    { "no-writable-roms", 0, &(settings->writable_roms), 0 },
    {    "cmos-z80", 0, &(settings->z80_is_cmos), 1 },
    { "no-cmos-z80", 0, &(settings->z80_is_cmos), 0 },
    {    "zxatasp", 0, &(settings->zxatasp_active), 1 },
    { "no-zxatasp", 0, &(settings->zxatasp_active), 0 },
    { "zxatasp-masterfile", 1, NULL, 406 },
    { "zxatasp-slavefile", 1, NULL, 407 },
    {    "zxatasp-upload", 0, &(settings->zxatasp_upload), 1 },
    { "no-zxatasp-upload", 0, &(settings->zxatasp_upload), 0 },
    {    "zxatasp-write-protect", 0, &(settings->zxatasp_wp), 1 },
    { "no-zxatasp-write-protect", 0, &(settings->zxatasp_wp), 0 },
    {    "zxcf", 0, &(settings->zxcf_active), 1 },
    { "no-zxcf", 0, &(settings->zxcf_active), 0 },
    { "zxcf-cffile", 1, NULL, 408 },
    {    "zxcf-upload", 0, &(settings->zxcf_upload), 1 },
    { "no-zxcf-upload", 0, &(settings->zxcf_upload), 0 },
    {    "zxprinter", 0, &(settings->zxprinter), 1 },
    { "no-zxprinter", 0, &(settings->zxprinter), 0 },
#line 607"./settings.pl"

    { "help", 0, NULL, 'h' },
    { "version", 0, NULL, 'V' },

    { 0, 0, 0, 0 }		/* End marker: DO NOT REMOVE */
  };

#endif      /* #ifndef AMIGA */

  while( 1 ) {

    int c;

#if defined AMIGA || defined __MORPHOS__
    c = getopt( argc, argv, "d:hm:o:p:f:r:s:t:v:g:j:V" );
#else                    /* #ifdef AMIGA */
    c = getopt_long( argc, argv, "d:hm:o:p:f:r:s:t:v:g:j:V", long_options, NULL );
#endif                   /* #ifdef AMIGA */

    if( c == -1 ) break;	/* End of option list */

    switch( c ) {

    case 0: break;	/* Used for long option returns */

    case 256: settings_set_string( &settings->betadisk_file, optarg ); break;
    case 257: settings->competition_code = atoi( optarg ); break;
    case 258: settings_set_string( &settings->dck_file, optarg ); break;
    case 259: settings_set_string( &settings->debugger_command, optarg ); break;
    case 260: settings_set_string( &settings->didaktik80disk_file, optarg ); break;
    case 261: settings_set_string( &settings->discipledisk_file, optarg ); break;
    case 262: settings_set_string( &settings->disk_try_merge, optarg ); break;
    case 263: settings_set_string( &settings->divide_master_file, optarg ); break;
    case 264: settings_set_string( &settings->divide_slave_file, optarg ); break;
    case 'D': settings->doublescan_mode = atoi( optarg ); break;
    case 266: settings->drive_40_max_track = atoi( optarg ); break;
    case 267: settings->drive_80_max_track = atoi( optarg ); break;
    case 268: settings_set_string( &settings->drive_beta128a_type, optarg ); break;
    case 269: settings_set_string( &settings->drive_beta128b_type, optarg ); break;
    case 270: settings_set_string( &settings->drive_beta128c_type, optarg ); break;
    case 271: settings_set_string( &settings->drive_beta128d_type, optarg ); break;
    case 272: settings_set_string( &settings->drive_didaktik80a_type, optarg ); break;
    case 273: settings_set_string( &settings->drive_didaktik80b_type, optarg ); break;
    case 274: settings_set_string( &settings->drive_disciple1_type, optarg ); break;
    case 275: settings_set_string( &settings->drive_disciple2_type, optarg ); break;
    case 276: settings_set_string( &settings->drive_opus1_type, optarg ); break;
    case 277: settings_set_string( &settings->drive_opus2_type, optarg ); break;
    case 278: settings_set_string( &settings->drive_plus3a_type, optarg ); break;
    case 279: settings_set_string( &settings->drive_plus3b_type, optarg ); break;
    case 280: settings_set_string( &settings->drive_plusd1_type, optarg ); break;
    case 281: settings_set_string( &settings->drive_plusd2_type, optarg ); break;
    case 282: settings->emulation_speed = atoi( optarg ); break;
    case 'v': settings->fb_mode = atoi( optarg ); break;
    case 283: settings->frame_rate = atoi( optarg ); break;
    case 284: settings_set_string( &settings->if2_file, optarg ); break;
    case 'j': settings_set_string( &settings->joystick_1, optarg ); break;
    case 285: settings->joystick_1_fire_1 = atoi( optarg ); break;
    case 286: settings->joystick_1_fire_10 = atoi( optarg ); break;
    case 287: settings->joystick_1_fire_11 = atoi( optarg ); break;
    case 288: settings->joystick_1_fire_12 = atoi( optarg ); break;
    case 289: settings->joystick_1_fire_13 = atoi( optarg ); break;
    case 290: settings->joystick_1_fire_14 = atoi( optarg ); break;
    case 291: settings->joystick_1_fire_15 = atoi( optarg ); break;
    case 292: settings->joystick_1_fire_2 = atoi( optarg ); break;
    case 293: settings->joystick_1_fire_3 = atoi( optarg ); break;
    case 294: settings->joystick_1_fire_4 = atoi( optarg ); break;
    case 295: settings->joystick_1_fire_5 = atoi( optarg ); break;
    case 296: settings->joystick_1_fire_6 = atoi( optarg ); break;
    case 297: settings->joystick_1_fire_7 = atoi( optarg ); break;
    case 298: settings->joystick_1_fire_8 = atoi( optarg ); break;
    case 299: settings->joystick_1_fire_9 = atoi( optarg ); break;
    case 300: settings->joystick_1_output = atoi( optarg ); break;
    case 301: settings_set_string( &settings->joystick_2, optarg ); break;
    case 302: settings->joystick_2_fire_1 = atoi( optarg ); break;
    case 303: settings->joystick_2_fire_10 = atoi( optarg ); break;
    case 304: settings->joystick_2_fire_11 = atoi( optarg ); break;
    case 305: settings->joystick_2_fire_12 = atoi( optarg ); break;
    case 306: settings->joystick_2_fire_13 = atoi( optarg ); break;
    case 307: settings->joystick_2_fire_14 = atoi( optarg ); break;
    case 308: settings->joystick_2_fire_15 = atoi( optarg ); break;
    case 309: settings->joystick_2_fire_2 = atoi( optarg ); break;
    case 310: settings->joystick_2_fire_3 = atoi( optarg ); break;
    case 311: settings->joystick_2_fire_4 = atoi( optarg ); break;
    case 312: settings->joystick_2_fire_5 = atoi( optarg ); break;
    case 313: settings->joystick_2_fire_6 = atoi( optarg ); break;
    case 314: settings->joystick_2_fire_7 = atoi( optarg ); break;
    case 315: settings->joystick_2_fire_8 = atoi( optarg ); break;
    case 316: settings->joystick_2_fire_9 = atoi( optarg ); break;
    case 317: settings->joystick_2_output = atoi( optarg ); break;
    case 318: settings->joystick_keyboard_down = atoi( optarg ); break;
    case 319: settings->joystick_keyboard_fire = atoi( optarg ); break;
    case 320: settings->joystick_keyboard_left = atoi( optarg ); break;
    case 321: settings->joystick_keyboard_output = atoi( optarg ); break;
    case 322: settings->joystick_keyboard_right = atoi( optarg ); break;
    case 323: settings->joystick_keyboard_up = atoi( optarg ); break;
    case 324: settings_set_string( &settings->mdr_file, optarg ); break;
    case 325: settings_set_string( &settings->mdr_file2, optarg ); break;
    case 326: settings_set_string( &settings->mdr_file3, optarg ); break;
    case 327: settings_set_string( &settings->mdr_file4, optarg ); break;
    case 328: settings_set_string( &settings->mdr_file5, optarg ); break;
    case 329: settings_set_string( &settings->mdr_file6, optarg ); break;
    case 330: settings_set_string( &settings->mdr_file7, optarg ); break;
    case 331: settings_set_string( &settings->mdr_file8, optarg ); break;
    case 332: settings->mdr_len = atoi( optarg ); break;
    case 333: settings_set_string( &settings->movie_compr, optarg ); break;
    case 334: settings_set_string( &settings->movie_start, optarg ); break;
    case 335: settings_set_string( &settings->opusdisk_file, optarg ); break;
    case 'p': settings_set_string( &settings->playback_file, optarg ); break;
    case 336: settings_set_string( &settings->plus3disk_file, optarg ); break;
    case 337: settings_set_string( &settings->plusddisk_file, optarg ); break;
    case 338: settings_set_string( &settings->printer_graphics_filename, optarg ); break;
    case 339: settings_set_string( &settings->printer_text_filename, optarg ); break;
    case 'r': settings_set_string( &settings->record_file, optarg ); break;
    case 341: settings_set_string( &settings->rom_128_0, optarg ); break;
    case 342: settings_set_string( &settings->rom_128_1, optarg ); break;
    case 343: settings_set_string( &settings->rom_16, optarg ); break;
    case 344: settings_set_string( &settings->rom_48, optarg ); break;
    case 345: settings_set_string( &settings->rom_beta128, optarg ); break;
    case 346: settings_set_string( &settings->rom_didaktik80, optarg ); break;
    case 347: settings_set_string( &settings->rom_disciple, optarg ); break;
    case 348: settings_set_string( &settings->rom_interface_1, optarg ); break;
    case 349: settings_set_string( &settings->rom_multiface1, optarg ); break;
    case 350: settings_set_string( &settings->rom_multiface128, optarg ); break;
    case 351: settings_set_string( &settings->rom_multiface3, optarg ); break;
    case 352: settings_set_string( &settings->rom_opus, optarg ); break;
    case 353: settings_set_string( &settings->rom_pentagon1024_0, optarg ); break;
    case 354: settings_set_string( &settings->rom_pentagon1024_1, optarg ); break;
    case 355: settings_set_string( &settings->rom_pentagon1024_2, optarg ); break;
    case 356: settings_set_string( &settings->rom_pentagon1024_3, optarg ); break;
    case 357: settings_set_string( &settings->rom_pentagon512_0, optarg ); break;
    case 358: settings_set_string( &settings->rom_pentagon512_1, optarg ); break;
    case 359: settings_set_string( &settings->rom_pentagon512_2, optarg ); break;
    case 360: settings_set_string( &settings->rom_pentagon512_3, optarg ); break;
    case 361: settings_set_string( &settings->rom_pentagon_0, optarg ); break;
    case 362: settings_set_string( &settings->rom_pentagon_1, optarg ); break;
    case 363: settings_set_string( &settings->rom_pentagon_2, optarg ); break;
    case 364: settings_set_string( &settings->rom_plus2_0, optarg ); break;
    case 365: settings_set_string( &settings->rom_plus2_1, optarg ); break;
    case 366: settings_set_string( &settings->rom_plus2a_0, optarg ); break;
    case 367: settings_set_string( &settings->rom_plus2a_1, optarg ); break;
    case 368: settings_set_string( &settings->rom_plus2a_2, optarg ); break;
    case 369: settings_set_string( &settings->rom_plus2a_3, optarg ); break;
    case 370: settings_set_string( &settings->rom_plus3_0, optarg ); break;
    case 371: settings_set_string( &settings->rom_plus3_1, optarg ); break;
    case 372: settings_set_string( &settings->rom_plus3_2, optarg ); break;
    case 373: settings_set_string( &settings->rom_plus3_3, optarg ); break;
    case 374: settings_set_string( &settings->rom_plus3e_0, optarg ); break;
    case 375: settings_set_string( &settings->rom_plus3e_1, optarg ); break;
    case 376: settings_set_string( &settings->rom_plus3e_2, optarg ); break;
    case 377: settings_set_string( &settings->rom_plus3e_3, optarg ); break;
    case 378: settings_set_string( &settings->rom_plusd, optarg ); break;
    case 379: settings_set_string( &settings->rom_scorpion_0, optarg ); break;
    case 380: settings_set_string( &settings->rom_scorpion_1, optarg ); break;
    case 381: settings_set_string( &settings->rom_scorpion_2, optarg ); break;
    case 382: settings_set_string( &settings->rom_scorpion_3, optarg ); break;
    case 383: settings_set_string( &settings->rom_spec_se_0, optarg ); break;
    case 384: settings_set_string( &settings->rom_spec_se_1, optarg ); break;
    case 385: settings_set_string( &settings->rom_speccyboot, optarg ); break;
    case 386: settings_set_string( &settings->rom_tc2048, optarg ); break;
    case 387: settings_set_string( &settings->rom_tc2068_0, optarg ); break;
    case 388: settings_set_string( &settings->rom_tc2068_1, optarg ); break;
    case 389: settings_set_string( &settings->rom_ts2068_0, optarg ); break;
    case 390: settings_set_string( &settings->rom_ts2068_1, optarg ); break;
    case 391: settings_set_string( &settings->rom_usource, optarg ); break;
    case 392: settings_set_string( &settings->rs232_rx, optarg ); break;
    case 393: settings_set_string( &settings->rs232_tx, optarg ); break;
    case 394: settings_set_string( &settings->simpleide_master_file, optarg ); break;
    case 395: settings_set_string( &settings->simpleide_slave_file, optarg ); break;
    case 's': settings_set_string( &settings->snapshot, optarg ); break;
    case 397: settings_set_string( &settings->snet, optarg ); break;
    case 'd': settings_set_string( &settings->sound_device, optarg ); break;
    case 'f': settings->sound_freq = atoi( optarg ); break;
    case 398: settings_set_string( &settings->speaker_type, optarg ); break;
    case 399: settings_set_string( &settings->speccyboot_tap, optarg ); break;
    case 'm': settings_set_string( &settings->start_machine, optarg ); break;
    case 'g': settings_set_string( &settings->start_scaler_mode, optarg ); break;
    case 400: settings_set_string( &settings->stereo_ay, optarg ); break;
    case 401: settings_set_string( &settings->svga_modes, optarg ); break;
    case 't': settings_set_string( &settings->tape_file, optarg ); break;
    case 402: settings->volume_ay = atoi( optarg ); break;
    case 403: settings->volume_beeper = atoi( optarg ); break;
    case 404: settings->volume_covox = atoi( optarg ); break;
    case 405: settings->volume_specdrum = atoi( optarg ); break;
    case 406: settings_set_string( &settings->zxatasp_master_file, optarg ); break;
    case 407: settings_set_string( &settings->zxatasp_slave_file, optarg ); break;
    case 408: settings_set_string( &settings->zxcf_pri_file, optarg ); break;
#line 657"./settings.pl"

    case 'h': settings->show_help = 1; break;
    case 'V': settings->show_version = 1; break;

    case ':':
    case '?':
      break;

    default:
      fprintf( stderr, "%s: getopt_long returned `%c'\n",
	       fuse_progname, (char)c );
      break;

    }
  }

  /* Store the location of the first non-option argument */
  *first_arg = optind;

  return 0;
}

/* Copy one settings object to another */
static void
settings_copy_internal( settings_info *dest, settings_info *src )
{
  settings_free( dest );

  dest->accelerate_loader = src->accelerate_loader;
  dest->aspect_hint = src->aspect_hint;
  dest->auto_load = src->auto_load;
  dest->autosave_settings = src->autosave_settings;
  dest->beta128 = src->beta128;
  dest->beta128_48boot = src->beta128_48boot;
  dest->betadisk_file = NULL;
  if( src->betadisk_file ) {
    dest->betadisk_file = utils_safe_strdup( src->betadisk_file );
  }
  dest->bw_tv = src->bw_tv;
  dest->competition_code = src->competition_code;
  dest->competition_mode = src->competition_mode;
  dest->confirm_actions = src->confirm_actions;
  dest->covox = src->covox;
  dest->dck_file = NULL;
  if( src->dck_file ) {
    dest->dck_file = utils_safe_strdup( src->dck_file );
  }
  dest->debugger_command = NULL;
  if( src->debugger_command ) {
    dest->debugger_command = utils_safe_strdup( src->debugger_command );
  }
  dest->detect_loader = src->detect_loader;
  dest->didaktik80 = src->didaktik80;
  dest->didaktik80disk_file = NULL;
  if( src->didaktik80disk_file ) {
    dest->didaktik80disk_file = utils_safe_strdup( src->didaktik80disk_file );
  }
  dest->disciple = src->disciple;
  dest->discipledisk_file = NULL;
  if( src->discipledisk_file ) {
    dest->discipledisk_file = utils_safe_strdup( src->discipledisk_file );
  }
  dest->disk_ask_merge = src->disk_ask_merge;
  dest->disk_try_merge = NULL;
  if( src->disk_try_merge ) {
    dest->disk_try_merge = utils_safe_strdup( src->disk_try_merge );
  }
  dest->divide_enabled = src->divide_enabled;
  dest->divide_master_file = NULL;
  if( src->divide_master_file ) {
    dest->divide_master_file = utils_safe_strdup( src->divide_master_file );
  }
  dest->divide_slave_file = NULL;
  if( src->divide_slave_file ) {
    dest->divide_slave_file = utils_safe_strdup( src->divide_slave_file );
  }
  dest->divide_wp = src->divide_wp;
  dest->doublescan_mode = src->doublescan_mode;
  dest->drive_40_max_track = src->drive_40_max_track;
  dest->drive_80_max_track = src->drive_80_max_track;
  dest->drive_beta128a_type = NULL;
  if( src->drive_beta128a_type ) {
    dest->drive_beta128a_type = utils_safe_strdup( src->drive_beta128a_type );
  }
  dest->drive_beta128b_type = NULL;
  if( src->drive_beta128b_type ) {
    dest->drive_beta128b_type = utils_safe_strdup( src->drive_beta128b_type );
  }
  dest->drive_beta128c_type = NULL;
  if( src->drive_beta128c_type ) {
    dest->drive_beta128c_type = utils_safe_strdup( src->drive_beta128c_type );
  }
  dest->drive_beta128d_type = NULL;
  if( src->drive_beta128d_type ) {
    dest->drive_beta128d_type = utils_safe_strdup( src->drive_beta128d_type );
  }
  dest->drive_didaktik80a_type = NULL;
  if( src->drive_didaktik80a_type ) {
    dest->drive_didaktik80a_type = utils_safe_strdup( src->drive_didaktik80a_type );
  }
  dest->drive_didaktik80b_type = NULL;
  if( src->drive_didaktik80b_type ) {
    dest->drive_didaktik80b_type = utils_safe_strdup( src->drive_didaktik80b_type );
  }
  dest->drive_disciple1_type = NULL;
  if( src->drive_disciple1_type ) {
    dest->drive_disciple1_type = utils_safe_strdup( src->drive_disciple1_type );
  }
  dest->drive_disciple2_type = NULL;
  if( src->drive_disciple2_type ) {
    dest->drive_disciple2_type = utils_safe_strdup( src->drive_disciple2_type );
  }
  dest->drive_opus1_type = NULL;
  if( src->drive_opus1_type ) {
    dest->drive_opus1_type = utils_safe_strdup( src->drive_opus1_type );
  }
  dest->drive_opus2_type = NULL;
  if( src->drive_opus2_type ) {
    dest->drive_opus2_type = utils_safe_strdup( src->drive_opus2_type );
  }
  dest->drive_plus3a_type = NULL;
  if( src->drive_plus3a_type ) {
    dest->drive_plus3a_type = utils_safe_strdup( src->drive_plus3a_type );
  }
  dest->drive_plus3b_type = NULL;
  if( src->drive_plus3b_type ) {
    dest->drive_plus3b_type = utils_safe_strdup( src->drive_plus3b_type );
  }
  dest->drive_plusd1_type = NULL;
  if( src->drive_plusd1_type ) {
    dest->drive_plusd1_type = utils_safe_strdup( src->drive_plusd1_type );
  }
  dest->drive_plusd2_type = NULL;
  if( src->drive_plusd2_type ) {
    dest->drive_plusd2_type = utils_safe_strdup( src->drive_plusd2_type );
  }
  dest->embed_snapshot = src->embed_snapshot;
  dest->emulation_speed = src->emulation_speed;
  dest->fastload = src->fastload;
  dest->fb_mode = src->fb_mode;
  dest->frame_rate = src->frame_rate;
  dest->full_screen = src->full_screen;
  dest->fuller = src->fuller;
  dest->if2_file = NULL;
  if( src->if2_file ) {
    dest->if2_file = utils_safe_strdup( src->if2_file );
  }
  dest->interface1 = src->interface1;
  dest->interface2 = src->interface2;
  dest->issue2 = src->issue2;
  dest->joy_kempston = src->joy_kempston;
  dest->joy_prompt = src->joy_prompt;
  dest->joystick_1 = NULL;
  if( src->joystick_1 ) {
    dest->joystick_1 = utils_safe_strdup( src->joystick_1 );
  }
  dest->joystick_1_fire_1 = src->joystick_1_fire_1;
  dest->joystick_1_fire_10 = src->joystick_1_fire_10;
  dest->joystick_1_fire_11 = src->joystick_1_fire_11;
  dest->joystick_1_fire_12 = src->joystick_1_fire_12;
  dest->joystick_1_fire_13 = src->joystick_1_fire_13;
  dest->joystick_1_fire_14 = src->joystick_1_fire_14;
  dest->joystick_1_fire_15 = src->joystick_1_fire_15;
  dest->joystick_1_fire_2 = src->joystick_1_fire_2;
  dest->joystick_1_fire_3 = src->joystick_1_fire_3;
  dest->joystick_1_fire_4 = src->joystick_1_fire_4;
  dest->joystick_1_fire_5 = src->joystick_1_fire_5;
  dest->joystick_1_fire_6 = src->joystick_1_fire_6;
  dest->joystick_1_fire_7 = src->joystick_1_fire_7;
  dest->joystick_1_fire_8 = src->joystick_1_fire_8;
  dest->joystick_1_fire_9 = src->joystick_1_fire_9;
  dest->joystick_1_output = src->joystick_1_output;
  dest->joystick_2 = NULL;
  if( src->joystick_2 ) {
    dest->joystick_2 = utils_safe_strdup( src->joystick_2 );
  }
  dest->joystick_2_fire_1 = src->joystick_2_fire_1;
  dest->joystick_2_fire_10 = src->joystick_2_fire_10;
  dest->joystick_2_fire_11 = src->joystick_2_fire_11;
  dest->joystick_2_fire_12 = src->joystick_2_fire_12;
  dest->joystick_2_fire_13 = src->joystick_2_fire_13;
  dest->joystick_2_fire_14 = src->joystick_2_fire_14;
  dest->joystick_2_fire_15 = src->joystick_2_fire_15;
  dest->joystick_2_fire_2 = src->joystick_2_fire_2;
  dest->joystick_2_fire_3 = src->joystick_2_fire_3;
  dest->joystick_2_fire_4 = src->joystick_2_fire_4;
  dest->joystick_2_fire_5 = src->joystick_2_fire_5;
  dest->joystick_2_fire_6 = src->joystick_2_fire_6;
  dest->joystick_2_fire_7 = src->joystick_2_fire_7;
  dest->joystick_2_fire_8 = src->joystick_2_fire_8;
  dest->joystick_2_fire_9 = src->joystick_2_fire_9;
  dest->joystick_2_output = src->joystick_2_output;
  dest->joystick_keyboard_down = src->joystick_keyboard_down;
  dest->joystick_keyboard_fire = src->joystick_keyboard_fire;
  dest->joystick_keyboard_left = src->joystick_keyboard_left;
  dest->joystick_keyboard_output = src->joystick_keyboard_output;
  dest->joystick_keyboard_right = src->joystick_keyboard_right;
  dest->joystick_keyboard_up = src->joystick_keyboard_up;
  dest->kempston_mouse = src->kempston_mouse;
  dest->keyboard_arrows_shifted = src->keyboard_arrows_shifted;
  dest->late_timings = src->late_timings;
  dest->mdr_file = NULL;
  if( src->mdr_file ) {
    dest->mdr_file = utils_safe_strdup( src->mdr_file );
  }
  dest->mdr_file2 = NULL;
  if( src->mdr_file2 ) {
    dest->mdr_file2 = utils_safe_strdup( src->mdr_file2 );
  }
  dest->mdr_file3 = NULL;
  if( src->mdr_file3 ) {
    dest->mdr_file3 = utils_safe_strdup( src->mdr_file3 );
  }
  dest->mdr_file4 = NULL;
  if( src->mdr_file4 ) {
    dest->mdr_file4 = utils_safe_strdup( src->mdr_file4 );
  }
  dest->mdr_file5 = NULL;
  if( src->mdr_file5 ) {
    dest->mdr_file5 = utils_safe_strdup( src->mdr_file5 );
  }
  dest->mdr_file6 = NULL;
  if( src->mdr_file6 ) {
    dest->mdr_file6 = utils_safe_strdup( src->mdr_file6 );
  }
  dest->mdr_file7 = NULL;
  if( src->mdr_file7 ) {
    dest->mdr_file7 = utils_safe_strdup( src->mdr_file7 );
  }
  dest->mdr_file8 = NULL;
  if( src->mdr_file8 ) {
    dest->mdr_file8 = utils_safe_strdup( src->mdr_file8 );
  }
  dest->mdr_len = src->mdr_len;
  dest->mdr_random_len = src->mdr_random_len;
  dest->melodik = src->melodik;
  dest->mouse_swap_buttons = src->mouse_swap_buttons;
  dest->movie_compr = NULL;
  if( src->movie_compr ) {
    dest->movie_compr = utils_safe_strdup( src->movie_compr );
  }
  dest->movie_start = NULL;
  if( src->movie_start ) {
    dest->movie_start = utils_safe_strdup( src->movie_start );
  }
  dest->movie_stop_after_rzx = src->movie_stop_after_rzx;
  dest->multiface1 = src->multiface1;
  dest->multiface128 = src->multiface128;
  dest->multiface1_stealth = src->multiface1_stealth;
  dest->multiface3 = src->multiface3;
  dest->opus = src->opus;
  dest->opusdisk_file = NULL;
  if( src->opusdisk_file ) {
    dest->opusdisk_file = utils_safe_strdup( src->opusdisk_file );
  }
  dest->pal_tv2x = src->pal_tv2x;
  dest->playback_file = NULL;
  if( src->playback_file ) {
    dest->playback_file = utils_safe_strdup( src->playback_file );
  }
  dest->plus3_detect_speedlock = src->plus3_detect_speedlock;
  dest->plus3disk_file = NULL;
  if( src->plus3disk_file ) {
    dest->plus3disk_file = utils_safe_strdup( src->plus3disk_file );
  }
  dest->plusd = src->plusd;
  dest->plusddisk_file = NULL;
  if( src->plusddisk_file ) {
    dest->plusddisk_file = utils_safe_strdup( src->plusddisk_file );
  }
  dest->printer = src->printer;
  dest->printer_graphics_filename = NULL;
  if( src->printer_graphics_filename ) {
    dest->printer_graphics_filename = utils_safe_strdup( src->printer_graphics_filename );
  }
  dest->printer_text_filename = NULL;
  if( src->printer_text_filename ) {
    dest->printer_text_filename = utils_safe_strdup( src->printer_text_filename );
  }
  dest->raw_s_net = src->raw_s_net;
  dest->record_file = NULL;
  if( src->record_file ) {
    dest->record_file = utils_safe_strdup( src->record_file );
  }
  dest->recreated_spectrum = src->recreated_spectrum;
  dest->rom_128_0 = NULL;
  if( src->rom_128_0 ) {
    dest->rom_128_0 = utils_safe_strdup( src->rom_128_0 );
  }
  dest->rom_128_1 = NULL;
  if( src->rom_128_1 ) {
    dest->rom_128_1 = utils_safe_strdup( src->rom_128_1 );
  }
  dest->rom_16 = NULL;
  if( src->rom_16 ) {
    dest->rom_16 = utils_safe_strdup( src->rom_16 );
  }
  dest->rom_48 = NULL;
  if( src->rom_48 ) {
    dest->rom_48 = utils_safe_strdup( src->rom_48 );
  }
  dest->rom_beta128 = NULL;
  if( src->rom_beta128 ) {
    dest->rom_beta128 = utils_safe_strdup( src->rom_beta128 );
  }
  dest->rom_didaktik80 = NULL;
  if( src->rom_didaktik80 ) {
    dest->rom_didaktik80 = utils_safe_strdup( src->rom_didaktik80 );
  }
  dest->rom_disciple = NULL;
  if( src->rom_disciple ) {
    dest->rom_disciple = utils_safe_strdup( src->rom_disciple );
  }
  dest->rom_interface_1 = NULL;
  if( src->rom_interface_1 ) {
    dest->rom_interface_1 = utils_safe_strdup( src->rom_interface_1 );
  }
  dest->rom_multiface1 = NULL;
  if( src->rom_multiface1 ) {
    dest->rom_multiface1 = utils_safe_strdup( src->rom_multiface1 );
  }
  dest->rom_multiface128 = NULL;
  if( src->rom_multiface128 ) {
    dest->rom_multiface128 = utils_safe_strdup( src->rom_multiface128 );
  }
  dest->rom_multiface3 = NULL;
  if( src->rom_multiface3 ) {
    dest->rom_multiface3 = utils_safe_strdup( src->rom_multiface3 );
  }
  dest->rom_opus = NULL;
  if( src->rom_opus ) {
    dest->rom_opus = utils_safe_strdup( src->rom_opus );
  }
  dest->rom_pentagon1024_0 = NULL;
  if( src->rom_pentagon1024_0 ) {
    dest->rom_pentagon1024_0 = utils_safe_strdup( src->rom_pentagon1024_0 );
  }
  dest->rom_pentagon1024_1 = NULL;
  if( src->rom_pentagon1024_1 ) {
    dest->rom_pentagon1024_1 = utils_safe_strdup( src->rom_pentagon1024_1 );
  }
  dest->rom_pentagon1024_2 = NULL;
  if( src->rom_pentagon1024_2 ) {
    dest->rom_pentagon1024_2 = utils_safe_strdup( src->rom_pentagon1024_2 );
  }
  dest->rom_pentagon1024_3 = NULL;
  if( src->rom_pentagon1024_3 ) {
    dest->rom_pentagon1024_3 = utils_safe_strdup( src->rom_pentagon1024_3 );
  }
  dest->rom_pentagon512_0 = NULL;
  if( src->rom_pentagon512_0 ) {
    dest->rom_pentagon512_0 = utils_safe_strdup( src->rom_pentagon512_0 );
  }
  dest->rom_pentagon512_1 = NULL;
  if( src->rom_pentagon512_1 ) {
    dest->rom_pentagon512_1 = utils_safe_strdup( src->rom_pentagon512_1 );
  }
  dest->rom_pentagon512_2 = NULL;
  if( src->rom_pentagon512_2 ) {
    dest->rom_pentagon512_2 = utils_safe_strdup( src->rom_pentagon512_2 );
  }
  dest->rom_pentagon512_3 = NULL;
  if( src->rom_pentagon512_3 ) {
    dest->rom_pentagon512_3 = utils_safe_strdup( src->rom_pentagon512_3 );
  }
  dest->rom_pentagon_0 = NULL;
  if( src->rom_pentagon_0 ) {
    dest->rom_pentagon_0 = utils_safe_strdup( src->rom_pentagon_0 );
  }
  dest->rom_pentagon_1 = NULL;
  if( src->rom_pentagon_1 ) {
    dest->rom_pentagon_1 = utils_safe_strdup( src->rom_pentagon_1 );
  }
  dest->rom_pentagon_2 = NULL;
  if( src->rom_pentagon_2 ) {
    dest->rom_pentagon_2 = utils_safe_strdup( src->rom_pentagon_2 );
  }
  dest->rom_plus2_0 = NULL;
  if( src->rom_plus2_0 ) {
    dest->rom_plus2_0 = utils_safe_strdup( src->rom_plus2_0 );
  }
  dest->rom_plus2_1 = NULL;
  if( src->rom_plus2_1 ) {
    dest->rom_plus2_1 = utils_safe_strdup( src->rom_plus2_1 );
  }
  dest->rom_plus2a_0 = NULL;
  if( src->rom_plus2a_0 ) {
    dest->rom_plus2a_0 = utils_safe_strdup( src->rom_plus2a_0 );
  }
  dest->rom_plus2a_1 = NULL;
  if( src->rom_plus2a_1 ) {
    dest->rom_plus2a_1 = utils_safe_strdup( src->rom_plus2a_1 );
  }
  dest->rom_plus2a_2 = NULL;
  if( src->rom_plus2a_2 ) {
    dest->rom_plus2a_2 = utils_safe_strdup( src->rom_plus2a_2 );
  }
  dest->rom_plus2a_3 = NULL;
  if( src->rom_plus2a_3 ) {
    dest->rom_plus2a_3 = utils_safe_strdup( src->rom_plus2a_3 );
  }
  dest->rom_plus3_0 = NULL;
  if( src->rom_plus3_0 ) {
    dest->rom_plus3_0 = utils_safe_strdup( src->rom_plus3_0 );
  }
  dest->rom_plus3_1 = NULL;
  if( src->rom_plus3_1 ) {
    dest->rom_plus3_1 = utils_safe_strdup( src->rom_plus3_1 );
  }
  dest->rom_plus3_2 = NULL;
  if( src->rom_plus3_2 ) {
    dest->rom_plus3_2 = utils_safe_strdup( src->rom_plus3_2 );
  }
  dest->rom_plus3_3 = NULL;
  if( src->rom_plus3_3 ) {
    dest->rom_plus3_3 = utils_safe_strdup( src->rom_plus3_3 );
  }
  dest->rom_plus3e_0 = NULL;
  if( src->rom_plus3e_0 ) {
    dest->rom_plus3e_0 = utils_safe_strdup( src->rom_plus3e_0 );
  }
  dest->rom_plus3e_1 = NULL;
  if( src->rom_plus3e_1 ) {
    dest->rom_plus3e_1 = utils_safe_strdup( src->rom_plus3e_1 );
  }
  dest->rom_plus3e_2 = NULL;
  if( src->rom_plus3e_2 ) {
    dest->rom_plus3e_2 = utils_safe_strdup( src->rom_plus3e_2 );
  }
  dest->rom_plus3e_3 = NULL;
  if( src->rom_plus3e_3 ) {
    dest->rom_plus3e_3 = utils_safe_strdup( src->rom_plus3e_3 );
  }
  dest->rom_plusd = NULL;
  if( src->rom_plusd ) {
    dest->rom_plusd = utils_safe_strdup( src->rom_plusd );
  }
  dest->rom_scorpion_0 = NULL;
  if( src->rom_scorpion_0 ) {
    dest->rom_scorpion_0 = utils_safe_strdup( src->rom_scorpion_0 );
  }
  dest->rom_scorpion_1 = NULL;
  if( src->rom_scorpion_1 ) {
    dest->rom_scorpion_1 = utils_safe_strdup( src->rom_scorpion_1 );
  }
  dest->rom_scorpion_2 = NULL;
  if( src->rom_scorpion_2 ) {
    dest->rom_scorpion_2 = utils_safe_strdup( src->rom_scorpion_2 );
  }
  dest->rom_scorpion_3 = NULL;
  if( src->rom_scorpion_3 ) {
    dest->rom_scorpion_3 = utils_safe_strdup( src->rom_scorpion_3 );
  }
  dest->rom_spec_se_0 = NULL;
  if( src->rom_spec_se_0 ) {
    dest->rom_spec_se_0 = utils_safe_strdup( src->rom_spec_se_0 );
  }
  dest->rom_spec_se_1 = NULL;
  if( src->rom_spec_se_1 ) {
    dest->rom_spec_se_1 = utils_safe_strdup( src->rom_spec_se_1 );
  }
  dest->rom_speccyboot = NULL;
  if( src->rom_speccyboot ) {
    dest->rom_speccyboot = utils_safe_strdup( src->rom_speccyboot );
  }
  dest->rom_tc2048 = NULL;
  if( src->rom_tc2048 ) {
    dest->rom_tc2048 = utils_safe_strdup( src->rom_tc2048 );
  }
  dest->rom_tc2068_0 = NULL;
  if( src->rom_tc2068_0 ) {
    dest->rom_tc2068_0 = utils_safe_strdup( src->rom_tc2068_0 );
  }
  dest->rom_tc2068_1 = NULL;
  if( src->rom_tc2068_1 ) {
    dest->rom_tc2068_1 = utils_safe_strdup( src->rom_tc2068_1 );
  }
  dest->rom_ts2068_0 = NULL;
  if( src->rom_ts2068_0 ) {
    dest->rom_ts2068_0 = utils_safe_strdup( src->rom_ts2068_0 );
  }
  dest->rom_ts2068_1 = NULL;
  if( src->rom_ts2068_1 ) {
    dest->rom_ts2068_1 = utils_safe_strdup( src->rom_ts2068_1 );
  }
  dest->rom_usource = NULL;
  if( src->rom_usource ) {
    dest->rom_usource = utils_safe_strdup( src->rom_usource );
  }
  dest->rs232_handshake = src->rs232_handshake;
  dest->rs232_rx = NULL;
  if( src->rs232_rx ) {
    dest->rs232_rx = utils_safe_strdup( src->rs232_rx );
  }
  dest->rs232_tx = NULL;
  if( src->rs232_tx ) {
    dest->rs232_tx = utils_safe_strdup( src->rs232_tx );
  }
  dest->rzx_autosaves = src->rzx_autosaves;
  dest->rzx_compression = src->rzx_compression;
  dest->simpleide_active = src->simpleide_active;
  dest->simpleide_master_file = NULL;
  if( src->simpleide_master_file ) {
    dest->simpleide_master_file = utils_safe_strdup( src->simpleide_master_file );
  }
  dest->simpleide_slave_file = NULL;
  if( src->simpleide_slave_file ) {
    dest->simpleide_slave_file = utils_safe_strdup( src->simpleide_slave_file );
  }
  dest->slt_traps = src->slt_traps;
  dest->snapshot = NULL;
  if( src->snapshot ) {
    dest->snapshot = utils_safe_strdup( src->snapshot );
  }
  dest->snet = NULL;
  if( src->snet ) {
    dest->snet = utils_safe_strdup( src->snet );
  }
  dest->sound = src->sound;
  dest->sound_device = NULL;
  if( src->sound_device ) {
    dest->sound_device = utils_safe_strdup( src->sound_device );
  }
  dest->sound_force_8bit = src->sound_force_8bit;
  dest->sound_freq = src->sound_freq;
  dest->sound_load = src->sound_load;
  dest->speaker_type = NULL;
  if( src->speaker_type ) {
    dest->speaker_type = utils_safe_strdup( src->speaker_type );
  }
  dest->speccyboot = src->speccyboot;
  dest->speccyboot_tap = NULL;
  if( src->speccyboot_tap ) {
    dest->speccyboot_tap = utils_safe_strdup( src->speccyboot_tap );
  }
  dest->specdrum = src->specdrum;
  dest->spectranet = src->spectranet;
  dest->spectranet_disable = src->spectranet_disable;
  dest->start_machine = NULL;
  if( src->start_machine ) {
    dest->start_machine = utils_safe_strdup( src->start_machine );
  }
  dest->start_scaler_mode = NULL;
  if( src->start_scaler_mode ) {
    dest->start_scaler_mode = utils_safe_strdup( src->start_scaler_mode );
  }
  dest->statusbar = src->statusbar;
  dest->stereo_ay = NULL;
  if( src->stereo_ay ) {
    dest->stereo_ay = utils_safe_strdup( src->stereo_ay );
  }
  dest->strict_aspect_hint = src->strict_aspect_hint;
  dest->svga_modes = NULL;
  if( src->svga_modes ) {
    dest->svga_modes = utils_safe_strdup( src->svga_modes );
  }
  dest->tape_file = NULL;
  if( src->tape_file ) {
    dest->tape_file = utils_safe_strdup( src->tape_file );
  }
  dest->tape_traps = src->tape_traps;
  dest->unittests = src->unittests;
  dest->usource = src->usource;
  dest->volume_ay = src->volume_ay;
  dest->volume_beeper = src->volume_beeper;
  dest->volume_covox = src->volume_covox;
  dest->volume_specdrum = src->volume_specdrum;
  dest->writable_roms = src->writable_roms;
  dest->z80_is_cmos = src->z80_is_cmos;
  dest->zxatasp_active = src->zxatasp_active;
  dest->zxatasp_master_file = NULL;
  if( src->zxatasp_master_file ) {
    dest->zxatasp_master_file = utils_safe_strdup( src->zxatasp_master_file );
  }
  dest->zxatasp_slave_file = NULL;
  if( src->zxatasp_slave_file ) {
    dest->zxatasp_slave_file = utils_safe_strdup( src->zxatasp_slave_file );
  }
  dest->zxatasp_upload = src->zxatasp_upload;
  dest->zxatasp_wp = src->zxatasp_wp;
  dest->zxcf_active = src->zxcf_active;
  dest->zxcf_pri_file = NULL;
  if( src->zxcf_pri_file ) {
    dest->zxcf_pri_file = utils_safe_strdup( src->zxcf_pri_file );
  }
  dest->zxcf_upload = src->zxcf_upload;
  dest->zxprinter = src->zxprinter;
#line 704"./settings.pl"
}

/* Copy one settings object to another */
void settings_copy( settings_info *dest, settings_info *src )
{
  settings_defaults( dest );
  settings_copy_internal( dest, src );
}

char **
settings_get_rom_setting( settings_info *settings, size_t which,
			  int is_peripheral )
{
  if( !is_peripheral ) {
    switch( which ) {
    case  0: return &( settings->rom_16       );
    case  1: return &( settings->rom_48       );
    case  2: return &( settings->rom_128_0    );
    case  3: return &( settings->rom_128_1    );
    case  4: return &( settings->rom_plus2_0  );
    case  5: return &( settings->rom_plus2_1  );
    case  6: return &( settings->rom_plus2a_0 );
    case  7: return &( settings->rom_plus2a_1 );
    case  8: return &( settings->rom_plus2a_2 );
    case  9: return &( settings->rom_plus2a_3 );
    case 10: return &( settings->rom_plus3_0  );
    case 11: return &( settings->rom_plus3_1  );
    case 12: return &( settings->rom_plus3_2  );
    case 13: return &( settings->rom_plus3_3  );
    case 14: return &( settings->rom_plus3e_0 );
    case 15: return &( settings->rom_plus3e_1 );
    case 16: return &( settings->rom_plus3e_2 );
    case 17: return &( settings->rom_plus3e_3 );
    case 18: return &( settings->rom_tc2048   );
    case 19: return &( settings->rom_tc2068_0 );
    case 20: return &( settings->rom_tc2068_1 );
    case 21: return &( settings->rom_ts2068_0 );
    case 22: return &( settings->rom_ts2068_1 );
    case 23: return &( settings->rom_pentagon_0 );
    case 24: return &( settings->rom_pentagon_1 );
    case 25: return &( settings->rom_pentagon_2 );
    case 26: return &( settings->rom_pentagon512_0 );
    case 27: return &( settings->rom_pentagon512_1 );
    case 28: return &( settings->rom_pentagon512_2 );
    case 29: return &( settings->rom_pentagon512_3 );
    case 30: return &( settings->rom_pentagon1024_0 );
    case 31: return &( settings->rom_pentagon1024_1 );
    case 32: return &( settings->rom_pentagon1024_2 );
    case 33: return &( settings->rom_pentagon1024_3 );
    case 34: return &( settings->rom_scorpion_0 );
    case 35: return &( settings->rom_scorpion_1 );
    case 36: return &( settings->rom_scorpion_2 );
    case 37: return &( settings->rom_scorpion_3 );
    case 38: return &( settings->rom_spec_se_0 );
    case 39: return &( settings->rom_spec_se_1 );
    default: return NULL;
    }
  } else {
    switch( which ) {
    case  0: return &( settings->rom_interface_1 );
    case  1: return &( settings->rom_beta128 );
    case  2: return &( settings->rom_plusd );
    case  3: return &( settings->rom_didaktik80 );
    case  4: return &( settings->rom_disciple );
    case  5: return &( settings->rom_multiface1 );
    case  6: return &( settings->rom_multiface128 );
    case  7: return &( settings->rom_multiface3 );
    case  8: return &( settings->rom_opus );
    case  9: return &( settings->rom_speccyboot );
    case 10: return &( settings->rom_usource );
    default: return NULL;
    }
  }
}

void
settings_set_string( char **string_setting, const char *value )
{
  /* No need to do anything if the two strings are in fact the
     same pointer */
  if( *string_setting == value ) return;

  if( *string_setting ) libspectrum_free( *string_setting );
  *string_setting = utils_safe_strdup( value );
}

int
settings_free( settings_info *settings )
{
  if( settings->betadisk_file ) libspectrum_free( settings->betadisk_file );
  if( settings->dck_file ) libspectrum_free( settings->dck_file );
  if( settings->debugger_command ) libspectrum_free( settings->debugger_command );
  if( settings->didaktik80disk_file ) libspectrum_free( settings->didaktik80disk_file );
  if( settings->discipledisk_file ) libspectrum_free( settings->discipledisk_file );
  if( settings->disk_try_merge ) libspectrum_free( settings->disk_try_merge );
  if( settings->divide_master_file ) libspectrum_free( settings->divide_master_file );
  if( settings->divide_slave_file ) libspectrum_free( settings->divide_slave_file );
  if( settings->drive_beta128a_type ) libspectrum_free( settings->drive_beta128a_type );
  if( settings->drive_beta128b_type ) libspectrum_free( settings->drive_beta128b_type );
  if( settings->drive_beta128c_type ) libspectrum_free( settings->drive_beta128c_type );
  if( settings->drive_beta128d_type ) libspectrum_free( settings->drive_beta128d_type );
  if( settings->drive_didaktik80a_type ) libspectrum_free( settings->drive_didaktik80a_type );
  if( settings->drive_didaktik80b_type ) libspectrum_free( settings->drive_didaktik80b_type );
  if( settings->drive_disciple1_type ) libspectrum_free( settings->drive_disciple1_type );
  if( settings->drive_disciple2_type ) libspectrum_free( settings->drive_disciple2_type );
  if( settings->drive_opus1_type ) libspectrum_free( settings->drive_opus1_type );
  if( settings->drive_opus2_type ) libspectrum_free( settings->drive_opus2_type );
  if( settings->drive_plus3a_type ) libspectrum_free( settings->drive_plus3a_type );
  if( settings->drive_plus3b_type ) libspectrum_free( settings->drive_plus3b_type );
  if( settings->drive_plusd1_type ) libspectrum_free( settings->drive_plusd1_type );
  if( settings->drive_plusd2_type ) libspectrum_free( settings->drive_plusd2_type );
  if( settings->if2_file ) libspectrum_free( settings->if2_file );
  if( settings->joystick_1 ) libspectrum_free( settings->joystick_1 );
  if( settings->joystick_2 ) libspectrum_free( settings->joystick_2 );
  if( settings->mdr_file ) libspectrum_free( settings->mdr_file );
  if( settings->mdr_file2 ) libspectrum_free( settings->mdr_file2 );
  if( settings->mdr_file3 ) libspectrum_free( settings->mdr_file3 );
  if( settings->mdr_file4 ) libspectrum_free( settings->mdr_file4 );
  if( settings->mdr_file5 ) libspectrum_free( settings->mdr_file5 );
  if( settings->mdr_file6 ) libspectrum_free( settings->mdr_file6 );
  if( settings->mdr_file7 ) libspectrum_free( settings->mdr_file7 );
  if( settings->mdr_file8 ) libspectrum_free( settings->mdr_file8 );
  if( settings->movie_compr ) libspectrum_free( settings->movie_compr );
  if( settings->movie_start ) libspectrum_free( settings->movie_start );
  if( settings->opusdisk_file ) libspectrum_free( settings->opusdisk_file );
  if( settings->playback_file ) libspectrum_free( settings->playback_file );
  if( settings->plus3disk_file ) libspectrum_free( settings->plus3disk_file );
  if( settings->plusddisk_file ) libspectrum_free( settings->plusddisk_file );
  if( settings->printer_graphics_filename ) libspectrum_free( settings->printer_graphics_filename );
  if( settings->printer_text_filename ) libspectrum_free( settings->printer_text_filename );
  if( settings->record_file ) libspectrum_free( settings->record_file );
  if( settings->rom_128_0 ) libspectrum_free( settings->rom_128_0 );
  if( settings->rom_128_1 ) libspectrum_free( settings->rom_128_1 );
  if( settings->rom_16 ) libspectrum_free( settings->rom_16 );
  if( settings->rom_48 ) libspectrum_free( settings->rom_48 );
  if( settings->rom_beta128 ) libspectrum_free( settings->rom_beta128 );
  if( settings->rom_didaktik80 ) libspectrum_free( settings->rom_didaktik80 );
  if( settings->rom_disciple ) libspectrum_free( settings->rom_disciple );
  if( settings->rom_interface_1 ) libspectrum_free( settings->rom_interface_1 );
  if( settings->rom_multiface1 ) libspectrum_free( settings->rom_multiface1 );
  if( settings->rom_multiface128 ) libspectrum_free( settings->rom_multiface128 );
  if( settings->rom_multiface3 ) libspectrum_free( settings->rom_multiface3 );
  if( settings->rom_opus ) libspectrum_free( settings->rom_opus );
  if( settings->rom_pentagon1024_0 ) libspectrum_free( settings->rom_pentagon1024_0 );
  if( settings->rom_pentagon1024_1 ) libspectrum_free( settings->rom_pentagon1024_1 );
  if( settings->rom_pentagon1024_2 ) libspectrum_free( settings->rom_pentagon1024_2 );
  if( settings->rom_pentagon1024_3 ) libspectrum_free( settings->rom_pentagon1024_3 );
  if( settings->rom_pentagon512_0 ) libspectrum_free( settings->rom_pentagon512_0 );
  if( settings->rom_pentagon512_1 ) libspectrum_free( settings->rom_pentagon512_1 );
  if( settings->rom_pentagon512_2 ) libspectrum_free( settings->rom_pentagon512_2 );
  if( settings->rom_pentagon512_3 ) libspectrum_free( settings->rom_pentagon512_3 );
  if( settings->rom_pentagon_0 ) libspectrum_free( settings->rom_pentagon_0 );
  if( settings->rom_pentagon_1 ) libspectrum_free( settings->rom_pentagon_1 );
  if( settings->rom_pentagon_2 ) libspectrum_free( settings->rom_pentagon_2 );
  if( settings->rom_plus2_0 ) libspectrum_free( settings->rom_plus2_0 );
  if( settings->rom_plus2_1 ) libspectrum_free( settings->rom_plus2_1 );
  if( settings->rom_plus2a_0 ) libspectrum_free( settings->rom_plus2a_0 );
  if( settings->rom_plus2a_1 ) libspectrum_free( settings->rom_plus2a_1 );
  if( settings->rom_plus2a_2 ) libspectrum_free( settings->rom_plus2a_2 );
  if( settings->rom_plus2a_3 ) libspectrum_free( settings->rom_plus2a_3 );
  if( settings->rom_plus3_0 ) libspectrum_free( settings->rom_plus3_0 );
  if( settings->rom_plus3_1 ) libspectrum_free( settings->rom_plus3_1 );
  if( settings->rom_plus3_2 ) libspectrum_free( settings->rom_plus3_2 );
  if( settings->rom_plus3_3 ) libspectrum_free( settings->rom_plus3_3 );
  if( settings->rom_plus3e_0 ) libspectrum_free( settings->rom_plus3e_0 );
  if( settings->rom_plus3e_1 ) libspectrum_free( settings->rom_plus3e_1 );
  if( settings->rom_plus3e_2 ) libspectrum_free( settings->rom_plus3e_2 );
  if( settings->rom_plus3e_3 ) libspectrum_free( settings->rom_plus3e_3 );
  if( settings->rom_plusd ) libspectrum_free( settings->rom_plusd );
  if( settings->rom_scorpion_0 ) libspectrum_free( settings->rom_scorpion_0 );
  if( settings->rom_scorpion_1 ) libspectrum_free( settings->rom_scorpion_1 );
  if( settings->rom_scorpion_2 ) libspectrum_free( settings->rom_scorpion_2 );
  if( settings->rom_scorpion_3 ) libspectrum_free( settings->rom_scorpion_3 );
  if( settings->rom_spec_se_0 ) libspectrum_free( settings->rom_spec_se_0 );
  if( settings->rom_spec_se_1 ) libspectrum_free( settings->rom_spec_se_1 );
  if( settings->rom_speccyboot ) libspectrum_free( settings->rom_speccyboot );
  if( settings->rom_tc2048 ) libspectrum_free( settings->rom_tc2048 );
  if( settings->rom_tc2068_0 ) libspectrum_free( settings->rom_tc2068_0 );
  if( settings->rom_tc2068_1 ) libspectrum_free( settings->rom_tc2068_1 );
  if( settings->rom_ts2068_0 ) libspectrum_free( settings->rom_ts2068_0 );
  if( settings->rom_ts2068_1 ) libspectrum_free( settings->rom_ts2068_1 );
  if( settings->rom_usource ) libspectrum_free( settings->rom_usource );
  if( settings->rs232_rx ) libspectrum_free( settings->rs232_rx );
  if( settings->rs232_tx ) libspectrum_free( settings->rs232_tx );
  if( settings->simpleide_master_file ) libspectrum_free( settings->simpleide_master_file );
  if( settings->simpleide_slave_file ) libspectrum_free( settings->simpleide_slave_file );
  if( settings->snapshot ) libspectrum_free( settings->snapshot );
  if( settings->snet ) libspectrum_free( settings->snet );
  if( settings->sound_device ) libspectrum_free( settings->sound_device );
  if( settings->speaker_type ) libspectrum_free( settings->speaker_type );
  if( settings->speccyboot_tap ) libspectrum_free( settings->speccyboot_tap );
  if( settings->start_machine ) libspectrum_free( settings->start_machine );
  if( settings->start_scaler_mode ) libspectrum_free( settings->start_scaler_mode );
  if( settings->stereo_ay ) libspectrum_free( settings->stereo_ay );
  if( settings->svga_modes ) libspectrum_free( settings->svga_modes );
  if( settings->tape_file ) libspectrum_free( settings->tape_file );
  if( settings->zxatasp_master_file ) libspectrum_free( settings->zxatasp_master_file );
  if( settings->zxatasp_slave_file ) libspectrum_free( settings->zxatasp_slave_file );
  if( settings->zxcf_pri_file ) libspectrum_free( settings->zxcf_pri_file );
#line 802"./settings.pl"

  return 0;
}

static void
settings_end( void )
{
  if( settings_current.autosave_settings )
    settings_write_config( &settings_current );

  settings_free( &settings_current );

#ifdef HAVE_LIB_XML2
  xmlCleanupParser();
#endif				/* #ifdef HAVE_LIB_XML2 */
}

void
settings_register_startup( void )
{
  /* settings_init not yet managed by the startup manager */

  startup_manager_module dependencies[] = {
  /* Fuse for OS X requires that settings_end is called before memory is
     deallocated as settings need to look up machine names etc */
    /* STARTUP_MANAGER_MODULE_MEMORY, */
    STARTUP_MANAGER_MODULE_SETUID,
  };
  startup_manager_register( STARTUP_MANAGER_MODULE_SETTINGS_END, dependencies,
                            ARRAY_SIZE( dependencies ), NULL, NULL,
                            settings_end );
}

