/*
 *
 * Copyright (c) 2003 The Regents of the University of California.  All 
 * rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Neither the name of the University nor the names of its
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
 

/*

  opentest.c 

  tests open, close call

 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/wait.h>
#include <signal.h>
#include <string.h>

#include "fusd.h"

void done(int signo)
{
  int status;
  pid_t pid = waitpid(-1, &status, WNOHANG);

  if (pid <= 0)
    fprintf(stderr, "child error\n");
  else if (WEXITSTATUS(status))
    fprintf(stderr, "TEST FAILED\n");
  else
    fprintf(stderr, "TEST PASSED\n");
  exit(1);
}


int testnums[5] = {12,34,56,78,0};
int counter = 0;

int _open(struct fusd_file_info *file)
{
  if (0 && (counter == 0)) {
    fusd_return(file, -testnums[0]);
    counter++;
    return -FUSD_NOREPLY;
  }
  
  else
    return -testnums[counter++];
}


int _close(struct fusd_file_info *file)
{
  if (counter == 5) {
    fusd_return(file, -testnums[0]);
    counter++;
    return -FUSD_NOREPLY;
  }
  
  else
    return -testnums[counter++ - 5];
}



int main(int argc, char *argv[])
{
  int f;

  if (argc != 2) {
    fprintf(stderr, "usage: %s <devfs path> <device class> <device name> \n", argv[0]);
    exit(0);
  }

  if (strncmp(argv[1], "/dev/", 5)) {
    fprintf(stderr, "devname must start with /dev/\n");
    exit(0);
  }

  /* fork into client and server */
  f = fork();
  if (f<0) {
    perror("Fork failed");
    exit(1);
  }

  /* server */
  if (f) {
    // init function table
    fusd_file_operations_t
      fops = {
	open: _open, 
	close: _close
      };

    int fd;
    if ((fd = fusd_register(argv[1], argv[2], argv[3], 0666, 0, &fops)) < 0) {
      perror("Register failed");
    } 
    
    else {
      signal(SIGCHLD, done);
      fusd_run();
    }
  }

  /* client */
  else {
    int i;
    int fd;
    int error = 0;
    int j;

    sleep(1);

    /* opens */
    for (i=0; i<5; i++) {
      fd = open(argv[1], O_RDWR);

      if (i != 4) {
	fprintf(stderr, "Open call returned errno %d (%m), should be %d.\n",
		errno, testnums[i]);
	if (errno != testnums[i])
	  error = 1;
      }
      else {
	fprintf(stderr, "Open call return fd = %d, should be nonnegative.\n", fd);
	if (fd < 0) error = 1;
      }
      
    }

    /* close */
    j = close(fd);
    fprintf(stderr, "Close call returned %d, should be 0.\n", j);
    if (j != 0) error = 1;

    close(fd);
    fprintf(stderr, "Close call returned %d, should be 9.\n", errno);
    if (errno != 9) error = 1;
    
    if (error)
      exit(1);
    else 
      exit(0);
  }

  exit(0);
}


