/* channel.c generated by valac 0.16.1, the Vala compiler
 * generated from channel.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsotransport.h>
#include <fsogsm.h>
#include <radio.h>
#include <fsosystem.h>
#include <freesmartphone.h>
#include <fsobasics.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <fsoframework.h>


#define SAMSUNG_TYPE_IPC_CHANNEL (samsung_ipc_channel_get_type ())
#define SAMSUNG_IPC_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SAMSUNG_TYPE_IPC_CHANNEL, SamsungIpcChannel))
#define SAMSUNG_IPC_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SAMSUNG_TYPE_IPC_CHANNEL, SamsungIpcChannelClass))
#define SAMSUNG_IS_IPC_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SAMSUNG_TYPE_IPC_CHANNEL))
#define SAMSUNG_IS_IPC_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SAMSUNG_TYPE_IPC_CHANNEL))
#define SAMSUNG_IPC_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SAMSUNG_TYPE_IPC_CHANNEL, SamsungIpcChannelClass))

typedef struct _SamsungIpcChannel SamsungIpcChannel;
typedef struct _SamsungIpcChannelClass SamsungIpcChannelClass;
typedef struct _SamsungIpcChannelPrivate SamsungIpcChannelPrivate;

#define SAMSUNG_TYPE_UNSOLICITED_RESPONSE_HANDLER (samsung_unsolicited_response_handler_get_type ())
#define SAMSUNG_UNSOLICITED_RESPONSE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SAMSUNG_TYPE_UNSOLICITED_RESPONSE_HANDLER, SamsungUnsolicitedResponseHandler))
#define SAMSUNG_UNSOLICITED_RESPONSE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SAMSUNG_TYPE_UNSOLICITED_RESPONSE_HANDLER, SamsungUnsolicitedResponseHandlerClass))
#define SAMSUNG_IS_UNSOLICITED_RESPONSE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SAMSUNG_TYPE_UNSOLICITED_RESPONSE_HANDLER))
#define SAMSUNG_IS_UNSOLICITED_RESPONSE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SAMSUNG_TYPE_UNSOLICITED_RESPONSE_HANDLER))
#define SAMSUNG_UNSOLICITED_RESPONSE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SAMSUNG_TYPE_UNSOLICITED_RESPONSE_HANDLER, SamsungUnsolicitedResponseHandlerClass))

typedef struct _SamsungUnsolicitedResponseHandler SamsungUnsolicitedResponseHandler;
typedef struct _SamsungUnsolicitedResponseHandlerClass SamsungUnsolicitedResponseHandlerClass;
#define _ipc_client_free0(var) ((var == NULL) ? NULL : (var = (ipc_client_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SAMSUNG_TYPE_COMMAND_HANDLER (samsung_command_handler_get_type ())
#define SAMSUNG_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SAMSUNG_TYPE_COMMAND_HANDLER, SamsungCommandHandler))
#define SAMSUNG_COMMAND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SAMSUNG_TYPE_COMMAND_HANDLER, SamsungCommandHandlerClass))
#define SAMSUNG_IS_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SAMSUNG_TYPE_COMMAND_HANDLER))
#define SAMSUNG_IS_COMMAND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SAMSUNG_TYPE_COMMAND_HANDLER))
#define SAMSUNG_COMMAND_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SAMSUNG_TYPE_COMMAND_HANDLER, SamsungCommandHandlerClass))

typedef struct _SamsungCommandHandler SamsungCommandHandler;
typedef struct _SamsungCommandHandlerClass SamsungCommandHandlerClass;
typedef struct _SamsungCommandHandlerPrivate SamsungCommandHandlerPrivate;
#define _fso_framework_abstract_command_handler_unref0(var) ((var == NULL) ? NULL : (var = (fso_framework_abstract_command_handler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _SamsungIpcChannelInitializeData SamsungIpcChannelInitializeData;
typedef struct _SamsungIpcChannelRequestUsageServiceData SamsungIpcChannelRequestUsageServiceData;
typedef struct _SamsungIpcChannelSetModemPowerStateData SamsungIpcChannelSetModemPowerStateData;
typedef struct _SamsungIpcChannelOpenData SamsungIpcChannelOpenData;
typedef struct _SamsungIpcChannelCloseData SamsungIpcChannelCloseData;
typedef struct _SamsungIpcChannelEnqueueAsyncData SamsungIpcChannelEnqueueAsyncData;
typedef struct _Block2Data Block2Data;
typedef struct _SamsungIpcChannelSuspendData SamsungIpcChannelSuspendData;
typedef struct _SamsungIpcChannelResumeData SamsungIpcChannelResumeData;
typedef struct _SamsungIpcChannelUpdateModemPowerStateData SamsungIpcChannelUpdateModemPowerStateData;

struct _SamsungIpcChannel {
	FsoFrameworkAbstractCommandQueue parent_instance;
	SamsungIpcChannelPrivate * priv;
};

struct _SamsungIpcChannelClass {
	FsoFrameworkAbstractCommandQueueClass parent_class;
};

struct _SamsungIpcChannelPrivate {
	struct ipc_client* fmtclient;
	guint8 current_request_id;
	gboolean initialized;
	gboolean suspended;
	FsoFrameworkWakelock* wakelock;
	FreeSmartphoneUsageSync* usage_sync;
	guint suspend_lock;
	FsoGsmModemStatus current_modem_status;
	FsoGsmModem* modem;
	SamsungUnsolicitedResponseHandler* _urchandler;
	gchar* _name;
	gint16 _phone_pwr_state;
};

struct _SamsungCommandHandler {
	FsoFrameworkAbstractCommandHandler parent_instance;
	SamsungCommandHandlerPrivate * priv;
	struct ipc_client* client;
	guint8 id;
	int request_type;
	unsigned short message_type;
	guint8* data;
	gint data_length1;
	struct ipc_message_info response;
	gboolean timed_out;
};

struct _SamsungCommandHandlerClass {
	FsoFrameworkAbstractCommandHandlerClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	SamsungIpcChannel * self;
	SamsungCommandHandler* handler;
};

struct _SamsungIpcChannelInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungIpcChannel* self;
	gboolean _tmp0_;
};

struct _SamsungIpcChannelRequestUsageServiceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungIpcChannel* self;
	FreeSmartphoneUsageSync* _tmp0_;
	FreeSmartphoneUsageSync* _tmp1_;
	GError* err;
	FsoFrameworkLogger* _tmp2_;
	GError * _inner_error_;
};

struct _SamsungIpcChannelSetModemPowerStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungIpcChannel* self;
	gint16 state;
	gboolean result;
	struct ipc_message_info* response;
	gint16 _tmp0_;
	guint8* _tmp1_;
	guint8* sb;
	gint sb_length1;
	gint _sb_size_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint16 _tmp3_;
	guint8 _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint16 _tmp6_;
	guint8 _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	struct ipc_message_info* _tmp9_;
	struct ipc_message_info* _tmp10_;
	FsoFrameworkLogger* _tmp11_;
	gint16 _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
};

struct _SamsungIpcChannelOpenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungIpcChannel* self;
	gboolean result;
	gboolean _result_;
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	struct ipc_client* _tmp4_;
};

struct _SamsungIpcChannelCloseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungIpcChannel* self;
	struct ipc_client* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkTransport* _tmp2_;
};

struct _SamsungIpcChannelEnqueueAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungIpcChannel* self;
	int type;
	unsigned short command;
	guint8* data;
	gint data_length1;
	gint retry;
	gint timeout;
	struct ipc_message_info* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	FsoFrameworkLogger* _tmp4_;
	FsoFrameworkLogger* _tmp5_;
	int _tmp6_;
	const gchar* _tmp7_;
	unsigned short _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	SamsungCommandHandler* _tmp13_;
	SamsungCommandHandler* handler;
	SamsungCommandHandler* _tmp14_;
	struct ipc_client* _tmp15_;
	SamsungCommandHandler* _tmp16_;
	guint8 _tmp17_;
	SamsungCommandHandler* _tmp18_;
	SamsungCommandHandler* _tmp19_;
	gint _tmp20_;
	SamsungCommandHandler* _tmp21_;
	gint _tmp22_;
	SamsungCommandHandler* _tmp23_;
	unsigned short _tmp24_;
	SamsungCommandHandler* _tmp25_;
	int _tmp26_;
	SamsungCommandHandler* _tmp27_;
	guint8* _tmp28_;
	gint _tmp28__length1;
	guint8* _tmp29_;
	gint _tmp29__length1;
	guint _tmp30_;
	SamsungCommandHandler* _tmp31_;
	guint _tmp32_;
	SamsungCommandHandler* _tmp33_;
	gboolean _tmp34_;
	FsoFrameworkLogger* _tmp35_;
	unsigned short _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	SamsungCommandHandler* _tmp40_;
	struct ipc_message_info _tmp41_;
};

typedef void (*SamsungIpcChannelUnsolicitedHandler) (const gchar* prefix, const gchar* response, const gchar* pdu, void* user_data);
struct _Block2Data {
	int _ref_count_;
	SamsungIpcChannel * self;
	gpointer _async_data_;
};

struct _SamsungIpcChannelSuspendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungIpcChannel* self;
	gboolean result;
	Block2Data* _data2_;
};

struct _SamsungIpcChannelResumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungIpcChannel* self;
	gboolean result;
};

struct _SamsungIpcChannelUpdateModemPowerStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungIpcChannel* self;
	gint16 state;
	gboolean result;
	gint16 _tmp0_;
	gint16 _tmp1_;
	gint16 _tmp2_;
	gboolean _tmp3_;
};


static gpointer samsung_ipc_channel_parent_class = NULL;
extern gint32 samsung_modem_state_network_signal_strength;
static FsoGsmChannelIface* samsung_ipc_channel_fso_gsm_channel_parent_iface = NULL;
static GType samsung_ipc_channel_type_id = 0;

GType samsung_ipc_channel_get_type (void) G_GNUC_CONST;
GType samsung_ipc_channel_register_type (GTypeModule * module);
GType samsung_unsolicited_response_handler_get_type (void) G_GNUC_CONST;
GType samsung_unsolicited_response_handler_register_type (GTypeModule * module);
#define SAMSUNG_IPC_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SAMSUNG_TYPE_IPC_CHANNEL, SamsungIpcChannelPrivate))
enum  {
	SAMSUNG_IPC_CHANNEL_DUMMY_PROPERTY,
	SAMSUNG_IPC_CHANNEL_URCHANDLER,
	SAMSUNG_IPC_CHANNEL_NAME,
	SAMSUNG_IPC_CHANNEL_PHONE_PWR_STATE
};
static guint8 samsung_ipc_channel_next_request_id (SamsungIpcChannel* self);
static void samsung_ipc_channel_onModemStatusChanged (SamsungIpcChannel* self, FsoGsmModem* modem, FsoGsmModemStatus status);
static void samsung_ipc_channel_initialize (SamsungIpcChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void samsung_ipc_channel_initialize_finish (SamsungIpcChannel* self, GAsyncResult* _res_);
void samsung_modem_state_reset_network_data (void);
static void samsung_ipc_channel_real_onReadFromTransport (FsoFrameworkAbstractCommandQueue* base, FsoFrameworkTransport* t);
const gchar* samsung_ipc_response_type_to_string (unsigned char self);
static const char* _samsung_ipc_response_type_to_string (unsigned char value);
const gchar* samsung_ipc_message_type_to_string (unsigned short self);
static const char* _samsung_ipc_message_type_to_string (unsigned short value);
static void samsung_ipc_channel_handle_response_in_suspend_mode (SamsungIpcChannel* self, struct ipc_message_info* response);
SamsungUnsolicitedResponseHandler* samsung_ipc_channel_get_urchandler (SamsungIpcChannel* self);
void samsung_unsolicited_response_handler_process (SamsungUnsolicitedResponseHandler* self, struct ipc_message_info* response);
static void samsung_ipc_channel_handle_solicited_response (SamsungIpcChannel* self, struct ipc_message_info* response);
static void samsung_ipc_channel_wakeup_system (SamsungIpcChannel* self, const gchar* reason);
GType samsung_command_handler_get_type (void) G_GNUC_CONST;
GType samsung_command_handler_register_type (GTypeModule * module);
static void samsung_ipc_channel_real_onResponseTimeout (FsoFrameworkAbstractCommandQueue* base, FsoFrameworkAbstractCommandHandler* ach);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda3_ (Block1Data* _data1_);
static gboolean ___lambda3__gsource_func (gpointer self);
gint samsung_ipc_channel_modem_read_request (SamsungIpcChannel* self, guint8* data, int data_length1);
gint samsung_ipc_channel_modem_write_request (SamsungIpcChannel* self, guint8* data, int data_length1);
static void samsung_ipc_channel_initialize_data_free (gpointer _data);
static gboolean samsung_ipc_channel_initialize_co (SamsungIpcChannelInitializeData* _data_);
static void samsung_ipc_channel_set_modem_power_state (SamsungIpcChannel* self, gint16 state, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_ipc_channel_set_modem_power_state_finish (SamsungIpcChannel* self, GAsyncResult* _res_);
static void samsung_ipc_channel_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void samsung_ipc_channel_request_usage_service_data_free (gpointer _data);
static void samsung_ipc_channel_request_usage_service (SamsungIpcChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void samsung_ipc_channel_request_usage_service_finish (SamsungIpcChannel* self, GAsyncResult* _res_);
static gboolean samsung_ipc_channel_request_usage_service_co (SamsungIpcChannelRequestUsageServiceData* _data_);
static void samsung_ipc_channel_request_usage_service_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void samsung_ipc_channel_set_modem_power_state_data_free (gpointer _data);
static gboolean samsung_ipc_channel_set_modem_power_state_co (SamsungIpcChannelSetModemPowerStateData* _data_);
static void samsung_ipc_channel_set_phone_pwr_state (SamsungIpcChannel* self, gint16 value);
void samsung_ipc_channel_enqueue_async (SamsungIpcChannel* self, int type, unsigned short command, guint8* data, int data_length1, gint retry, gint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_);
struct ipc_message_info* samsung_ipc_channel_enqueue_finish (SamsungIpcChannel* self, GAsyncResult* _res_);
static void samsung_ipc_channel_set_modem_power_state_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* samsung_ipc_power_phone_state_to_string (gint16 self);
static const char* _samsung_ipc_power_phone_state_to_string (gint16 value);
SamsungIpcChannel* samsung_ipc_channel_new (FsoGsmModem* modem, const gchar* name, FsoFrameworkTransport* transport);
SamsungIpcChannel* samsung_ipc_channel_construct (GType object_type, FsoGsmModem* modem, const gchar* name, FsoFrameworkTransport* transport);
static void samsung_ipc_channel_set_name (SamsungIpcChannel* self, const gchar* value);
SamsungUnsolicitedResponseHandler* samsung_unsolicited_response_handler_new (FsoGsmModem* modem);
SamsungUnsolicitedResponseHandler* samsung_unsolicited_response_handler_construct (GType object_type, FsoGsmModem* modem);
static void samsung_ipc_channel_set_urchandler (SamsungIpcChannel* self, SamsungUnsolicitedResponseHandler* value);
static gboolean __lambda4_ (SamsungIpcChannel* self);
static gboolean ___lambda4__gsource_func (gpointer self);
static void _samsung_ipc_channel_onModemStatusChanged_fso_gsm_modem_signal_status_changed (FsoGsmModem* _sender, FsoGsmModemStatus status, gpointer self);
static void __lambda5_ (SamsungIpcChannel* self, const gchar* message);
static void ___lambda5__samsung_ipc_log_handler_cb (const gchar* message, gpointer self);
static gint _samsung_ipc_channel_modem_read_request_samsung_ipc_transport_cb (guint8* data, int data_length1, gpointer self);
static gint _samsung_ipc_channel_modem_write_request_samsung_ipc_transport_cb (guint8* data, int data_length1, gpointer self);
static void samsung_ipc_channel_real_open_data_free (gpointer _data);
static void samsung_ipc_channel_real_open (FsoFrameworkAbstractCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_ipc_channel_real_open_co (SamsungIpcChannelOpenData* _data_);
static void samsung_ipc_channel_open_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void samsung_ipc_channel_real_close_data_free (gpointer _data);
static void samsung_ipc_channel_real_close (FsoFrameworkAbstractCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_ipc_channel_real_close_co (SamsungIpcChannelCloseData* _data_);
static void samsung_ipc_channel_enqueue_async_data_free (gpointer _data);
static gboolean samsung_ipc_channel_enqueue_async_co (SamsungIpcChannelEnqueueAsyncData* _data_);
const gchar* samsung_ipc_request_type_to_string (int self);
static const char* _samsung_ipc_request_type_to_string (int value);
SamsungCommandHandler* samsung_command_handler_new (void);
SamsungCommandHandler* samsung_command_handler_construct (GType object_type);
static gboolean _samsung_ipc_channel_enqueue_async_co_gsource_func (gpointer self);
static guint8* _vala_array_dup1 (guint8* self, int length);
void samsung_ipc_channel_registerUnsolicitedHandler (SamsungIpcChannel* self, SamsungIpcChannelUnsolicitedHandler urchandler, void* urchandler_target);
static void samsung_ipc_channel_real_injectResponse (FsoGsmChannel* base, const gchar* response);
static void samsung_ipc_channel_real_suspend_data_free (gpointer _data);
static void samsung_ipc_channel_real_suspend (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_ipc_channel_real_suspend_co (SamsungIpcChannelSuspendData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block2Data* _data2_);
static gboolean ___lambda6__gsource_func (gpointer self);
static void samsung_ipc_channel_real_resume_data_free (gpointer _data);
static void samsung_ipc_channel_real_resume (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_ipc_channel_real_resume_co (SamsungIpcChannelResumeData* _data_);
static void samsung_ipc_channel_update_modem_power_state_data_free (gpointer _data);
void samsung_ipc_channel_update_modem_power_state (SamsungIpcChannel* self, gint16 state, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean samsung_ipc_channel_update_modem_power_state_finish (SamsungIpcChannel* self, GAsyncResult* _res_);
static gboolean samsung_ipc_channel_update_modem_power_state_co (SamsungIpcChannelUpdateModemPowerStateData* _data_);
gint16 samsung_ipc_channel_get_phone_pwr_state (SamsungIpcChannel* self);
static void samsung_ipc_channel_update_modem_power_state_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* samsung_ipc_channel_get_name (SamsungIpcChannel* self);
static void samsung_ipc_channel_finalize (GObject* obj);
static void _vala_samsung_ipc_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_samsung_ipc_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Generating a new request id. A valid request is in the range of 1 - 255.
     **/
static guint8 samsung_ipc_channel_next_request_id (SamsungIpcChannel* self) {
	guint8 result = 0U;
	gint _tmp0_ = 0;
	guint8 _tmp1_;
	gint _tmp3_;
	guint8 _tmp4_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = self->priv->current_request_id;
	if (((gint) _tmp1_) >= 255) {
		_tmp0_ = 1;
	} else {
		guint8 _tmp2_;
		_tmp2_ = self->priv->current_request_id;
		_tmp0_ = _tmp2_ + 1;
	}
	_tmp3_ = _tmp0_;
	self->priv->current_request_id = (guint8) _tmp3_;
	_tmp4_ = self->priv->current_request_id;
	result = _tmp4_;
	return result;
}


static void samsung_ipc_channel_onModemStatusChanged (SamsungIpcChannel* self, FsoGsmModem* modem, FsoGsmModemStatus status) {
	FsoGsmModemStatus _tmp0_;
	FsoGsmModemStatus _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (modem != NULL);
	_tmp0_ = status;
	switch (_tmp0_) {
		case FSO_GSM_MODEM_STATUS_INITIALIZING:
		{
			samsung_ipc_channel_initialize (self, NULL, NULL);
			break;
		}
		case FSO_GSM_MODEM_STATUS_ALIVE_SIM_READY:
		{
			FsoGsmModemStatus _tmp1_;
			_tmp1_ = self->priv->current_modem_status;
			if (_tmp1_ == FSO_GSM_MODEM_STATUS_ALIVE_REGISTERED) {
				FsoGsmModem* _tmp2_;
				gpointer _tmp3_ = NULL;
				FreeSmartphoneGSMNetwork* obj;
				FreeSmartphoneGSMNetwork* _tmp4_;
				gint32 _tmp5_;
				samsung_modem_state_reset_network_data ();
				_tmp2_ = modem;
				_tmp3_ = fso_gsm_modem_theDevice (_tmp2_, FREE_SMARTPHONE_GSM_TYPE_NETWORK, (GBoxedCopyFunc) g_object_ref, g_object_unref);
				obj = (FreeSmartphoneGSMNetwork*) _tmp3_;
				_tmp4_ = obj;
				_tmp5_ = samsung_modem_state_network_signal_strength;
				g_signal_emit_by_name (_tmp4_, "signal-strength", (gint) _tmp5_);
				_g_object_unref0 (obj);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp6_ = status;
	self->priv->current_modem_status = _tmp6_;
}


static const char* _samsung_ipc_response_type_to_string (unsigned char value) {
	switch (value) {
		case IPC_TYPE_INDI:
		return "IPC_TYPE_INDI";
		case IPC_TYPE_RESP:
		return "IPC_TYPE_RESP";
		case IPC_TYPE_NOTI:
		return "IPC_TYPE_NOTI";
	}
	return NULL;
}


static unsigned short samsung_ipc_response_get_command (struct ipc_message_info* self) {
	unsigned short result;
	guint8 _tmp0_;
	guint8 _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = (*self).group;
	_tmp1_ = (*self).index;
	result = (unsigned short) ((_tmp0_ << 8) | _tmp1_);
	return result;
}


static void samsung_ipc_response_set_command (struct ipc_message_info* self, unsigned short value) {
	unsigned short _tmp0_;
	unsigned short _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	(*self).group = (guint8) (_tmp0_ >> 8);
	_tmp1_ = value;
	(*self).index = (guint8) (_tmp1_ & 0xff);
}


static const char* _samsung_ipc_message_type_to_string (unsigned short value) {
	switch (value) {
		case IPC_PWR_PHONE_PWR_OFF:
		return "IPC_PWR_PHONE_PWR_OFF";
		case IPC_PWR_PHONE_PWR_UP:
		return "IPC_PWR_PHONE_PWR_UP";
		case IPC_PWR_PHONE_RESET:
		return "IPC_PWR_PHONE_RESET";
		case IPC_PWR_BATT_STATUS:
		return "IPC_PWR_BATT_STATUS";
		case IPC_PWR_BATT_TYPE:
		return "IPC_PWR_BATT_TYPE";
		case IPC_PWR_BATT_COMP:
		return "IPC_PWR_BATT_COMP";
		case IPC_PWR_PHONE_STATE:
		return "IPC_PWR_PHONE_STATE";
		case IPC_PB_ACCESS:
		return "IPC_PB_ACCESS";
		case IPC_PB_STORAGE:
		return "IPC_PB_STORAGE";
		case IPC_PB_STORAGE_LIST:
		return "IPC_PB_STORAGE_LIST";
		case IPC_PB_ENTRY_INFO:
		return "IPC_PB_ENTRY_INFO";
		case IPC_PB_CAPABILITY_INFO:
		return "IPC_PB_CAPABILITY_INFO";
		case IPC_SS_WAITING:
		return "IPC_SS_WAITING";
		case IPC_SS_CLI:
		return "IPC_SS_CLI";
		case IPC_SS_BARRING:
		return "IPC_SS_BARRING";
		case IPC_SS_BARRING_PW:
		return "IPC_SS_BARRING_PW";
		case IPC_SS_FORWARDING:
		return "IPC_SS_FORWARDING";
		case IPC_SS_INFO:
		return "IPC_SS_INFO";
		case IPC_SS_MANAGE_CALL:
		return "IPC_SS_MANAGE_CALL";
		case IPC_SS_USSD:
		return "IPC_SS_USSD";
		case IPC_SS_AOC:
		return "IPC_SS_AOC";
		case IPC_SS_RELEASE_COMPLETE:
		return "IPC_SS_RELEASE_COMPLETE";
		case IPC_GPRS_DEFINE_PDP_CONTEXT:
		return "IPC_GPRS_DEFINE_PDP_CONTEXT";
		case IPC_GPRS_QOS:
		return "IPC_GPRS_QOS";
		case IPC_GPRS_PS:
		return "IPC_GPRS_PS";
		case IPC_GPRS_PDP_CONTEXT:
		return "IPC_GPRS_PDP_CONTEXT";
		case IPC_GPRS_SHOW_PDP_ADDR:
		return "IPC_GPRS_SHOW_PDP_ADDR";
		case IPC_GPRS_3G_QUAL_SERVICE_PROFILE:
		return "IPC_GPRS_3G_QUAL_SERVICE_PROFILE";
		case IPC_GPRS_IP_CONFIGURATION:
		return "IPC_GPRS_IP_CONFIGURATION";
		case IPC_GPRS_DEFINE_SEC_PDP_CONTEXT:
		return "IPC_GPRS_DEFINE_SEC_PDP_CONTEXT";
		case IPC_GPRS_TFT:
		return "IPC_GPRS_TFT";
		case IPC_GPRS_HSDPA_STATUS:
		return "IPC_GPRS_HSDPA_STATUS";
		case IPC_GPRS_CURRENT_SESSION_DATA_COUNT:
		return "IPC_GPRS_CURRENT_SESSION_DATA_COUNT";
		case IPC_GPRS_DATA_DORMANT:
		return "IPC_GPRS_DATA_DORMANT";
		case IPC_GPRS_DUN_PIN_CTRL:
		return "IPC_GPRS_DUN_PIN_CTRL";
		case IPC_GPRS_CALL_STATUS:
		return "IPC_GPRS_CALL_STATUS";
		case IPC_SAT_PROFILE_DOWNLOAD:
		return "IPC_SAT_PROFILE_DOWNLOAD";
		case IPC_SAT_ENVELOPE_CMD:
		return "IPC_SAT_ENVELOPE_CMD";
		case IPC_SAT_PROACTIVE_CMD:
		return "IPC_SAT_PROACTIVE_CMD";
		case IPC_SAT_TERMINATE_USAT_SESSION:
		return "IPC_SAT_TERMINATE_USAT_SESSION";
		case IPC_SAT_EVENT_DOWNLOAD:
		return "IPC_SAT_EVENT_DOWNLOAD";
		case IPC_SAT_PROVIDE_LOCAL_INFO:
		return "IPC_SAT_PROVIDE_LOCAL_INFO";
		case IPC_SAT_POLLING:
		return "IPC_SAT_POLLING";
		case IPC_SAT_REFRESH:
		return "IPC_SAT_REFRESH";
		case IPC_SAT_SETUP_EVENT_LIST:
		return "IPC_SAT_SETUP_EVENT_LIST";
		case IPC_SAT_CALL_CONTROL_RESULT:
		return "IPC_SAT_CALL_CONTROL_RESULT";
		case IPC_SAT_IMAGE_CLUT:
		return "IPC_SAT_IMAGE_CLUT";
		case IPC_SAT_CALL_PROCESSING:
		return "IPC_SAT_CALL_PROCESSING";
		case IPC_IMEI_START:
		return "IPC_IMEI_START";
		case IPC_IMEI_CHECK_DEVICE_INFO:
		return "IPC_IMEI_CHECK_DEVICE_INFO";
		case IPC_CALL_OUTGOING:
		return "IPC_CALL_OUTGOING";
		case IPC_CALL_INCOMING:
		return "IPC_CALL_INCOMING";
		case IPC_CALL_RELEASE:
		return "IPC_CALL_RELEASE";
		case IPC_CALL_ANSWER:
		return "IPC_CALL_ANSWER";
		case IPC_CALL_STATUS:
		return "IPC_CALL_STATUS";
		case IPC_CALL_LIST:
		return "IPC_CALL_LIST";
		case IPC_CALL_BURST_DTMF:
		return "IPC_CALL_BURST_DTMF";
		case IPC_CALL_CONT_DTMF:
		return "IPC_CALL_CONT_DTMF";
		case IPC_CALL_WAITING:
		return "IPC_CALL_WAITING";
		case IPC_CALL_LINE_ID:
		return "IPC_CALL_LINE_ID";
		case IPC_DISP_ICON_INFO:
		return "IPC_DISP_ICON_INFO";
		case IPC_DISP_HOMEZONE_INFO:
		return "IPC_DISP_HOMEZONE_INFO";
		case IPC_DISP_RSSI_INFO:
		return "IPC_DISP_RSSI_INFO";
		case IPC_SEC_PIN_STATUS:
		return "IPC_SEC_PIN_STATUS";
		case IPC_SEC_PHONE_LOCK:
		return "IPC_SEC_PHONE_LOCK";
		case IPC_SEC_CHANGE_LOCKING_PW:
		return "IPC_SEC_CHANGE_LOCKING_PW";
		case IPC_SEC_SIM_LANG:
		return "IPC_SEC_SIM_LANG";
		case IPC_SEC_RSIM_ACCESS:
		return "IPC_SEC_RSIM_ACCESS";
		case IPC_SEC_GSIM_ACCESS:
		return "IPC_SEC_GSIM_ACCESS";
		case IPC_SEC_SIM_ICC_TYPE:
		return "IPC_SEC_SIM_ICC_TYPE";
		case IPC_SEC_LOCK_INFO:
		return "IPC_SEC_LOCK_INFO";
		case IPC_SEC_ISIM_AUTH:
		return "IPC_SEC_ISIM_AUTH";
		case IPC_NET_PREF_PLMN:
		return "IPC_NET_PREF_PLMN";
		case IPC_NET_PLMN_SEL:
		return "IPC_NET_PLMN_SEL";
		case IPC_NET_CURRENT_PLMN:
		return "IPC_NET_CURRENT_PLMN";
		case IPC_NET_PLMN_LIST:
		return "IPC_NET_PLMN_LIST";
		case IPC_NET_REGIST:
		return "IPC_NET_REGIST";
		case IPC_NET_SUBSCRIBER_NUM:
		return "IPC_NET_SUBSCRIBER_NUM";
		case IPC_NET_BAND_SEL:
		return "IPC_NET_BAND_SEL";
		case IPC_NET_SERVICE_DOMAIN_CONFIG:
		return "IPC_NET_SERVICE_DOMAIN_CONFIG";
		case IPC_NET_POWERON_ATTACH:
		return "IPC_NET_POWERON_ATTACH";
		case IPC_NET_MODE_SEL:
		return "IPC_NET_MODE_SEL";
		case IPC_NET_ACQ_ORDER:
		return "IPC_NET_ACQ_ORDER";
		case IPC_NET_IDENTITY:
		return "IPC_NET_IDENTITY";
		case IPC_NET_CURRENT_RRC_STATUS:
		return "IPC_NET_CURRENT_RRC_STATUS";
		case IPC_GEN_PHONE_RES:
		return "IPC_GEN_PHONE_RES";
		case IPC_MISC_ME_VERSION:
		return "IPC_MISC_ME_VERSION";
		case IPC_MISC_ME_IMSI:
		return "IPC_MISC_ME_IMSI";
		case IPC_MISC_ME_SN:
		return "IPC_MISC_ME_SN";
		case IPC_MISC_TIME_INFO:
		return "IPC_MISC_TIME_INFO";
		case IPC_SMS_SEND_MSG:
		return "IPC_SMS_SEND_MSG";
		case IPC_SMS_INCOMING_MSG:
		return "IPC_SMS_INCOMING_MSG";
		case IPC_SMS_READ_MSG:
		return "IPC_SMS_READ_MSG";
		case IPC_SMS_SAVE_MSG:
		return "IPC_SMS_SAVE_MSG";
		case IPC_SMS_DEL_MSG:
		return "IPC_SMS_DEL_MSG";
		case IPC_SMS_DELIVER_REPORT:
		return "IPC_SMS_DELIVER_REPORT";
		case IPC_SMS_DEVICE_READY:
		return "IPC_SMS_DEVICE_READY";
		case IPC_SMS_SEL_MEM:
		return "IPC_SMS_SEL_MEM";
		case IPC_SMS_STORED_MSG_COUNT:
		return "IPC_SMS_STORED_MSG_COUNT";
		case IPC_SMS_SVC_CENTER_ADDR:
		return "IPC_SMS_SVC_CENTER_ADDR";
		case IPC_SMS_SVC_OPTION:
		return "IPC_SMS_SVC_OPTION";
		case IPC_SMS_MEM_STATUS:
		return "IPC_SMS_MEM_STATUS";
		case IPC_SMS_CBS_MSG:
		return "IPC_SMS_CBS_MSG";
		case IPC_SMS_CBS_CONFIG:
		return "IPC_SMS_CBS_CONFIG";
		case IPC_SMS_STORED_MSG_STATUS:
		return "IPC_SMS_STORED_MSG_STATUS";
		case IPC_SMS_PARAM_COUNT:
		return "IPC_SMS_PARAM_COUNT";
		case IPC_SMS_PARAM:
		return "IPC_SMS_PARAM";
		case IPC_SND_SPKR_VOLUME_CTRL:
		return "IPC_SND_SPKR_VOLUME_CTRL";
		case IPC_SND_MIC_MUTE_CTRL:
		return "IPC_SND_MIC_MUTE_CTRL";
		case IPC_SND_AUDIO_PATH_CTRL:
		return "IPC_SND_AUDIO_PATH_CTRL";
		case IPC_SND_RINGBACK_TONE_CTRL:
		return "IPC_SND_RINGBACK_TONE_CTRL";
		case IPC_SND_CLOCK_CTRL:
		return "IPC_SND_CLOCK_CTRL";
		case IPC_RFS_NV_READ_ITEM:
		return "IPC_RFS_NV_READ_ITEM";
		case IPC_RFS_NV_WRITE_ITEM:
		return "IPC_RFS_NV_WRITE_ITEM";
	}
	return NULL;
}


static void samsung_ipc_channel_real_onReadFromTransport (FsoFrameworkAbstractCommandQueue* base, FsoFrameworkTransport* t) {
	SamsungIpcChannel * self;
	struct ipc_message_info response = {0};
	FsoFrameworkWakelock* _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	gboolean _tmp2_ = FALSE;
	struct ipc_client* _tmp3_;
	struct ipc_message_info _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint rc;
	gint _tmp6_;
	FsoFrameworkLogger* _tmp8_;
	struct ipc_message_info _tmp9_;
	unsigned char _tmp10_;
	const gchar* _tmp11_ = NULL;
	struct ipc_message_info _tmp12_;
	unsigned short _tmp13_;
	unsigned short _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	FsoFrameworkLogger* _tmp19_;
	struct ipc_message_info _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	gboolean _tmp26_ = FALSE;
	FsoFrameworkLogger* _tmp27_;
	struct ipc_message_info _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_;
	struct ipc_message_info _tmp38_;
	unsigned char _tmp39_;
	struct ipc_message_info _tmp43_;
	guint8* _tmp44_;
	gint _tmp44__length1;
	FsoFrameworkLogger* _tmp45_;
	gboolean _tmp46_ = FALSE;
	FsoFrameworkWakelock* _tmp47_;
	self = (SamsungIpcChannel*) base;
	g_return_if_fail (t != NULL);
	memset (&response, 0, sizeof (struct ipc_message_info));
	_tmp0_ = self->priv->wakelock;
	fso_framework_wakelock_acquire (_tmp0_);
	_tmp1_ = fso_framework_theLogger;
	_tmp2_ = fso_framework_logger_debug (_tmp1_, "Received data from modem; start processing ...");
	g_assert (_tmp2_);
	_tmp3_ = self->priv->fmtclient;
	_tmp5_ = ipc_client_recv (_tmp3_, &_tmp4_);
	 (&response);
	response = _tmp4_;
	rc = _tmp5_;
	_tmp6_ = rc;
	if (_tmp6_ != 0) {
		FsoFrameworkLogger* _tmp7_;
		_tmp7_ = fso_framework_theLogger;
		fso_framework_logger_error (_tmp7_, "Something went wrong while receiving data from the modem ... discardin" \
"g this request!");
		 (&response);
		return;
	}
	_tmp8_ = fso_framework_theLogger;
	_tmp9_ = response;
	_tmp10_ = _tmp9_.type;
	_tmp11_ = _samsung_ipc_response_type_to_string (_tmp10_);
	_tmp12_ = response;
	_tmp13_ = samsung_ipc_response_get_command (&_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _samsung_ipc_message_type_to_string (_tmp14_);
	_tmp16_ = g_strconcat ("Got response from modem: type = ", _tmp11_, ", command = ", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = fso_framework_logger_debug (_tmp8_, _tmp17_);
	g_assert (_tmp18_);
	_g_free0 (_tmp17_);
	_tmp19_ = fso_framework_theLogger;
	_tmp20_ = response;
	_tmp21_ = _tmp20_.data;
	_tmp21__length1 = _tmp20_.length;
	_tmp22_ = g_strdup_printf ("%i", _tmp21__length1);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat ("response data (length = ", _tmp23_, "):", NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = fso_framework_logger_debug (_tmp19_, _tmp25_);
	g_assert (_tmp26_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_tmp27_ = fso_framework_theLogger;
	_tmp28_ = response;
	_tmp29_ = _tmp28_.data;
	_tmp29__length1 = _tmp28_.length;
	_tmp30_ = fso_framework_string_handling_hexdump (_tmp29_, _tmp29__length1, 16, "", (guchar) '?');
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat ("\n", _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	_tmp34_ = fso_framework_logger_debug (_tmp27_, _tmp33_);
	g_assert (_tmp34_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_tmp35_ = self->priv->suspended;
	if (_tmp35_) {
		struct ipc_message_info _tmp36_;
		FsoFrameworkWakelock* _tmp37_;
		_tmp36_ = response;
		samsung_ipc_channel_handle_response_in_suspend_mode (self, &_tmp36_);
		_tmp37_ = self->priv->wakelock;
		fso_framework_wakelock_release (_tmp37_);
		 (&response);
		return;
	}
	_tmp38_ = response;
	_tmp39_ = _tmp38_.type;
	switch (_tmp39_) {
		case IPC_TYPE_NOTI:
		{
			SamsungUnsolicitedResponseHandler* _tmp40_;
			struct ipc_message_info _tmp41_;
			_tmp40_ = self->priv->_urchandler;
			_tmp41_ = response;
			samsung_unsolicited_response_handler_process (_tmp40_, &_tmp41_);
			break;
		}
		case IPC_TYPE_INDI:
		{
			break;
		}
		case IPC_TYPE_RESP:
		{
			struct ipc_message_info _tmp42_;
			_tmp42_ = response;
			samsung_ipc_channel_handle_solicited_response (self, &_tmp42_);
			break;
		}
		default:
		break;
	}
	_tmp43_ = response;
	_tmp44_ = _tmp43_.data;
	_tmp44__length1 = _tmp43_.length;
	g_free (_tmp44_);
	_tmp45_ = fso_framework_theLogger;
	_tmp46_ = fso_framework_logger_debug (_tmp45_, "Handled response from modem successfully!");
	g_assert (_tmp46_);
	_tmp47_ = self->priv->wakelock;
	fso_framework_wakelock_release (_tmp47_);
	 (&response);
}


/**
     * When the system is suspended and we're running a kernel with android extensions
     * things are a bit ... what should I say: different :)
     * The usage subsystem disables all resources but each resource can decide on it's own
     * if it accepts the the suspend action internally.
     * In our case we're disabling as much as possible but still watching for incoming
     * messages from the modem. If the modems sends a notification for an incoming call
     * we will wake up the system first and then process the message.
     **/
static void samsung_ipc_channel_handle_response_in_suspend_mode (SamsungIpcChannel* self, struct ipc_message_info* response) {
	FsoFrameworkLogger* _tmp0_;
	struct ipc_message_info _tmp1_;
	unsigned char _tmp2_;
	const gchar* _tmp3_ = NULL;
	struct ipc_message_info _tmp4_;
	unsigned short _tmp5_;
	unsigned short _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	struct ipc_message_info _tmp11_;
	unsigned char _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (response != NULL);
	_tmp0_ = fso_framework_theLogger;
	_tmp1_ = *response;
	_tmp2_ = _tmp1_.type;
	_tmp3_ = _samsung_ipc_response_type_to_string (_tmp2_);
	_tmp4_ = *response;
	_tmp5_ = samsung_ipc_response_get_command (&_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _samsung_ipc_message_type_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("Got message from modem while in suspend mode: type = ", _tmp3_, ", command = ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = fso_framework_logger_debug (_tmp0_, _tmp9_);
	g_assert (_tmp10_);
	_g_free0 (_tmp9_);
	_tmp11_ = *response;
	_tmp12_ = _tmp11_.type;
	if (_tmp12_ == IPC_TYPE_NOTI) {
		struct ipc_message_info _tmp13_;
		unsigned short _tmp14_;
		unsigned short _tmp15_;
		_tmp13_ = *response;
		_tmp14_ = samsung_ipc_response_get_command (&_tmp13_);
		_tmp15_ = _tmp14_;
		switch (_tmp15_) {
			case IPC_CALL_INCOMING:
			{
				FsoFrameworkLogger* _tmp16_;
				gboolean _tmp17_ = FALSE;
				SamsungUnsolicitedResponseHandler* _tmp18_;
				struct ipc_message_info _tmp19_;
				_tmp16_ = fso_framework_theLogger;
				_tmp17_ = fso_framework_logger_debug (_tmp16_, "Got notification for incoming call; leaving suspend ...");
				g_assert (_tmp17_);
				samsung_ipc_channel_wakeup_system (self, "incoming-call");
				_tmp18_ = self->priv->_urchandler;
				_tmp19_ = *response;
				samsung_unsolicited_response_handler_process (_tmp18_, &_tmp19_);
				break;
			}
			default:
			{
				FsoFrameworkLogger* _tmp20_;
				struct ipc_message_info _tmp21_;
				unsigned short _tmp22_;
				unsigned short _tmp23_;
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_;
				gboolean _tmp27_ = FALSE;
				_tmp20_ = fso_framework_theLogger;
				_tmp21_ = *response;
				_tmp22_ = samsung_ipc_response_get_command (&_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = _samsung_ipc_message_type_to_string (_tmp23_);
				_tmp25_ = g_strconcat ("Got ", _tmp24_, " urc which is not evaluated while we're suspended", NULL);
				_tmp26_ = _tmp25_;
				_tmp27_ = fso_framework_logger_debug (_tmp20_, _tmp26_);
				g_assert (_tmp27_);
				_g_free0 (_tmp26_);
				break;
			}
		}
	}
}


/**
     * Waking up the system from suspend or alive state to fully awake we need to run
     * several steps like telling the usage subsystem to resume all suspended resources.
     * When this method returns the system should be completely awake.
     */
static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void samsung_ipc_channel_wakeup_system (SamsungIpcChannel* self, const gchar* reason) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (reason != NULL);
	{
		FreeSmartphoneUsageSync* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->usage_sync;
		_tmp1_ = reason;
		free_smartphone_usage_sync_resume (_tmp0_, "Modem", _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		FsoFrameworkLogger* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = fso_framework_theLogger;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Can't wake up the system; assuming we're already alive: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		fso_framework_logger_error (_tmp2_, _tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gpointer _fso_framework_abstract_command_handler_ref0 (gpointer self) {
	return self ? fso_framework_abstract_command_handler_ref (self) : NULL;
}


static void samsung_ipc_channel_handle_solicited_response (SamsungIpcChannel* self, struct ipc_message_info* response) {
	FsoFrameworkAbstractCommandHandler* _tmp0_;
	SamsungCommandHandler* _tmp1_;
	SamsungCommandHandler* ch;
	gboolean _tmp2_ = FALSE;
	FsoFrameworkAbstractCommandHandler* _tmp3_;
	gboolean _tmp8_;
	SamsungCommandHandler* _tmp16_;
	struct ipc_message_info _tmp17_;
	SamsungCommandHandler* _tmp18_;
	GSourceFunc _tmp19_;
	void* _tmp19__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (response != NULL);
	fso_framework_abstract_command_queue_resetTimeout ((FsoFrameworkAbstractCommandQueue*) self);
	_tmp0_ = ((FsoFrameworkAbstractCommandQueue*) self)->current;
	_tmp1_ = _fso_framework_abstract_command_handler_ref0 (SAMSUNG_COMMAND_HANDLER (_tmp0_));
	ch = _tmp1_;
	_tmp3_ = ((FsoFrameworkAbstractCommandQueue*) self)->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		SamsungCommandHandler* _tmp4_;
		guint8 _tmp5_;
		struct ipc_message_info _tmp6_;
		guint8 _tmp7_;
		_tmp4_ = ch;
		_tmp5_ = _tmp4_->id;
		_tmp6_ = *response;
		_tmp7_ = _tmp6_.aseq;
		_tmp2_ = _tmp5_ != _tmp7_;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		FsoFrameworkLogger* _tmp9_;
		struct ipc_message_info _tmp10_;
		guint8 _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp9_ = fso_framework_theLogger;
		_tmp10_ = *response;
		_tmp11_ = _tmp10_.aseq;
		_tmp12_ = g_strdup_printf ("%hhu", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat ("Got response with id = ", _tmp13_, " which does not belong to any pending request!", NULL);
		_tmp15_ = _tmp14_;
		fso_framework_logger_error (_tmp9_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_fso_framework_abstract_command_handler_unref0 (ch);
		return;
	}
	_tmp16_ = ch;
	_tmp17_ = *response;
	_tmp16_->response = _tmp17_;
	_tmp18_ = ch;
	_tmp19_ = ((FsoFrameworkAbstractCommandHandler*) _tmp18_)->callback;
	_tmp19__target = ((FsoFrameworkAbstractCommandHandler*) _tmp18_)->callback_target;
	_tmp19_ (_tmp19__target);
	_fso_framework_abstract_command_handler_unref0 (ch);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SamsungIpcChannel * self;
		self = _data1_->self;
		_fso_framework_abstract_command_handler_unref0 (_data1_->handler);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda3_ (Block1Data* _data1_) {
	SamsungIpcChannel * self;
	gboolean result = FALSE;
	GSourceFunc _tmp0_;
	void* _tmp0__target;
	self = _data1_->self;
	_tmp0_ = ((FsoFrameworkAbstractCommandHandler*) _data1_->handler)->callback;
	_tmp0__target = ((FsoFrameworkAbstractCommandHandler*) _data1_->handler)->callback_target;
	_tmp0_ (_tmp0__target);
	result = FALSE;
	return result;
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
	return result;
}


static void samsung_ipc_channel_real_onResponseTimeout (FsoFrameworkAbstractCommandQueue* base, FsoFrameworkAbstractCommandHandler* ach) {
	SamsungIpcChannel * self;
	Block1Data* _data1_;
	FsoFrameworkAbstractCommandHandler* _tmp0_;
	SamsungCommandHandler* _tmp1_;
	FsoFrameworkLogger* _tmp2_;
	guint8 _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	self = (SamsungIpcChannel*) base;
	g_return_if_fail (ach != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = ach;
	_tmp1_ = _fso_framework_abstract_command_handler_ref0 (SAMSUNG_COMMAND_HANDLER (_tmp0_));
	_data1_->handler = _tmp1_;
	_tmp2_ = fso_framework_theLogger;
	_tmp3_ = _data1_->handler->id;
	_tmp4_ = g_strdup_printf ("%hhu", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Command with id = ", _tmp5_, " timed out while trying to send it to the modem!", NULL);
	_tmp7_ = _tmp6_;
	fso_framework_logger_warning (_tmp2_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_data1_->handler->timed_out = TRUE;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda3__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


gint samsung_ipc_channel_modem_read_request (SamsungIpcChannel* self, guint8* data, int data_length1) {
	gint result = 0;
	guint8* _tmp0_;
	gint _tmp0__length1;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkTransport* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	if (_tmp0_ == NULL) {
		result = 0;
		return result;
	}
	_tmp1_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = data;
	_tmp4__length1 = data_length1;
	_tmp5_ = fso_framework_transport_read (_tmp2_, _tmp3_, _tmp4__length1);
	result = _tmp5_;
	return result;
}


gint samsung_ipc_channel_modem_write_request (SamsungIpcChannel* self, guint8* data, int data_length1) {
	gint result = 0;
	guint8* _tmp0_;
	gint _tmp0__length1;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkTransport* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	if (_tmp0_ == NULL) {
		result = 0;
		return result;
	}
	_tmp1_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = data;
	_tmp4__length1 = data_length1;
	_tmp5_ = fso_framework_transport_write (_tmp2_, _tmp3_, _tmp4__length1);
	result = _tmp5_;
	return result;
}


static void samsung_ipc_channel_initialize_data_free (gpointer _data) {
	SamsungIpcChannelInitializeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungIpcChannelInitializeData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void samsung_ipc_channel_initialize (SamsungIpcChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungIpcChannelInitializeData* _data_;
	SamsungIpcChannel* _tmp0_;
	_data_ = g_slice_new0 (SamsungIpcChannelInitializeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_ipc_channel_initialize);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_ipc_channel_initialize_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_ipc_channel_initialize_co (_data_);
}


static void samsung_ipc_channel_initialize_finish (SamsungIpcChannel* self, GAsyncResult* _res_) {
	SamsungIpcChannelInitializeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void samsung_ipc_channel_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SamsungIpcChannelInitializeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_ipc_channel_initialize_co (_data_);
}


static gboolean samsung_ipc_channel_initialize_co (SamsungIpcChannelInitializeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	samsung_ipc_channel_set_modem_power_state (_data_->self, IPC_PWR_PHONE_STATE_LPM, samsung_ipc_channel_initialize_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = samsung_ipc_channel_set_modem_power_state_finish (_data_->self, _data_->_res_);
	_data_->self->priv->initialized = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_ipc_channel_request_usage_service_data_free (gpointer _data) {
	SamsungIpcChannelRequestUsageServiceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungIpcChannelRequestUsageServiceData, _data_);
}


static void samsung_ipc_channel_request_usage_service (SamsungIpcChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungIpcChannelRequestUsageServiceData* _data_;
	SamsungIpcChannel* _tmp0_;
	_data_ = g_slice_new0 (SamsungIpcChannelRequestUsageServiceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_ipc_channel_request_usage_service);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_ipc_channel_request_usage_service_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_ipc_channel_request_usage_service_co (_data_);
}


static void samsung_ipc_channel_request_usage_service_finish (SamsungIpcChannel* self, GAsyncResult* _res_) {
	SamsungIpcChannelRequestUsageServiceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void samsung_ipc_channel_request_usage_service_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SamsungIpcChannelRequestUsageServiceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_ipc_channel_request_usage_service_co (_data_);
}


static gboolean samsung_ipc_channel_request_usage_service_co (SamsungIpcChannelRequestUsageServiceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (FREE_SMARTPHONE_TYPE_USAGE_SYNC_PROXY, 0, NULL, samsung_ipc_channel_request_usage_service_ready, _data_, "g-flags", 0, "g-name", FSO_FRAMEWORK_USAGE_ServiceDBusName, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", FSO_FRAMEWORK_USAGE_ServicePathPrefix, "g-interface-name", "org.freesmartphone.Usage", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp1_ = (FreeSmartphoneUsageSync*) _data_->_tmp0_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_g_object_unref0 (_data_->self->priv->usage_sync);
		_data_->self->priv->usage_sync = _data_->_tmp1_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp2_ = fso_framework_theLogger;
		fso_framework_logger_error (_data_->_tmp2_, "Can't request proxy for usage subsystem; suspend handling will be not " \
"available!");
		_g_error_free0 (_data_->err);
	}
	__finally1:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_ipc_channel_set_modem_power_state_data_free (gpointer _data) {
	SamsungIpcChannelSetModemPowerStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungIpcChannelSetModemPowerStateData, _data_);
}


static void samsung_ipc_channel_set_modem_power_state (SamsungIpcChannel* self, gint16 state, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungIpcChannelSetModemPowerStateData* _data_;
	SamsungIpcChannel* _tmp0_;
	gint16 _tmp1_;
	_data_ = g_slice_new0 (SamsungIpcChannelSetModemPowerStateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_ipc_channel_set_modem_power_state);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_ipc_channel_set_modem_power_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = state;
	_data_->state = _tmp1_;
	samsung_ipc_channel_set_modem_power_state_co (_data_);
}


static gboolean samsung_ipc_channel_set_modem_power_state_finish (SamsungIpcChannel* self, GAsyncResult* _res_) {
	gboolean result;
	SamsungIpcChannelSetModemPowerStateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void samsung_ipc_channel_set_modem_power_state_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SamsungIpcChannelSetModemPowerStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_ipc_channel_set_modem_power_state_co (_data_);
}


static const char* _samsung_ipc_power_phone_state_to_string (gint16 value) {
	switch (value) {
		case IPC_PWR_PHONE_STATE_LPM:
		return "IPC_PWR_PHONE_STATE_LPM";
		case IPC_PWR_PHONE_STATE_NORMAL:
		return "IPC_PWR_PHONE_STATE_NORMAL";
	}
	return NULL;
}


static gboolean samsung_ipc_channel_set_modem_power_state_co (SamsungIpcChannelSetModemPowerStateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->response = NULL;
	_data_->_tmp0_ = _data_->state;
	samsung_ipc_channel_set_phone_pwr_state (_data_->self, _data_->_tmp0_);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_new0 (guint8, 2);
	_data_->sb = _data_->_tmp1_;
	_data_->sb_length1 = 2;
	_data_->_sb_size_ = _data_->sb_length1;
	_data_->_tmp2_ = _data_->sb;
	_data_->_tmp2__length1 = _data_->sb_length1;
	_data_->_tmp3_ = _data_->state;
	_data_->_tmp2_[0] = (guint8) (_data_->_tmp3_ & 0x00ff);
	_data_->_tmp4_ = _data_->_tmp2_[0];
	_data_->_tmp5_ = _data_->sb;
	_data_->_tmp5__length1 = _data_->sb_length1;
	_data_->_tmp6_ = _data_->state;
	_data_->_tmp5_[1] = (guint8) ((_data_->_tmp6_ & 0xff00) >> 8);
	_data_->_tmp7_ = _data_->_tmp5_[1];
	_data_->_tmp8_ = _data_->sb;
	_data_->_tmp8__length1 = _data_->sb_length1;
	_data_->_state_ = 1;
	samsung_ipc_channel_enqueue_async (_data_->self, IPC_TYPE_EXEC, IPC_PWR_PHONE_STATE, _data_->_tmp8_, _data_->_tmp8__length1, 0, 5, samsung_ipc_channel_set_modem_power_state_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = samsung_ipc_channel_enqueue_finish (_data_->self, _data_->_res_);
	_data_->response = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->response;
	if (_data_->_tmp10_ == NULL) {
		_data_->_tmp11_ = fso_framework_theLogger;
		_data_->_tmp12_ = _data_->state;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _samsung_ipc_power_phone_state_to_string (_data_->_tmp12_);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = g_strconcat ("Could not put modem into ", _data_->_tmp13_, " power state!", NULL);
		_data_->_tmp15_ = _data_->_tmp14_;
		fso_framework_logger_error (_data_->_tmp11_, _data_->_tmp15_);
		_g_free0 (_data_->_tmp15_);
		_data_->result = FALSE;
		_data_->sb = (g_free (_data_->sb), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	_data_->sb = (g_free (_data_->sb), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->sb = (g_free (_data_->sb), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean __lambda4_ (SamsungIpcChannel* self) {
	gboolean result = FALSE;
	samsung_ipc_channel_request_usage_service (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean ___lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda4_ (self);
	return result;
}


static void _samsung_ipc_channel_onModemStatusChanged_fso_gsm_modem_signal_status_changed (FsoGsmModem* _sender, FsoGsmModemStatus status, gpointer self) {
	samsung_ipc_channel_onModemStatusChanged (self, _sender, status);
}


static void __lambda5_ (SamsungIpcChannel* self, const gchar* message) {
	FsoFrameworkLogger* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (message != NULL);
	_tmp0_ = fso_framework_theLogger;
	_tmp1_ = message;
	fso_framework_logger_debug (_tmp0_, _tmp1_);
}


static void ___lambda5__samsung_ipc_log_handler_cb (const gchar* message, gpointer self) {
	__lambda5_ (self, message);
}


static gint _samsung_ipc_channel_modem_read_request_samsung_ipc_transport_cb (guint8* data, int data_length1, gpointer self) {
	gint result;
	result = samsung_ipc_channel_modem_read_request (self, data, data_length1);
	return result;
}


static gint _samsung_ipc_channel_modem_write_request_samsung_ipc_transport_cb (guint8* data, int data_length1, gpointer self) {
	gint result;
	result = samsung_ipc_channel_modem_write_request (self, data, data_length1);
	return result;
}


SamsungIpcChannel* samsung_ipc_channel_construct (GType object_type, FsoGsmModem* modem, const gchar* name, FsoFrameworkTransport* transport) {
	SamsungIpcChannel * self = NULL;
	FsoFrameworkTransport* _tmp0_;
	FsoGsmModem* _tmp1_;
	FsoGsmModem* _tmp2_;
	const gchar* _tmp3_;
	FsoGsmModem* _tmp4_;
	SamsungUnsolicitedResponseHandler* _tmp5_;
	SamsungUnsolicitedResponseHandler* _tmp6_;
	FsoFrameworkWakelock* _tmp7_;
	FsoGsmModem* _tmp8_;
	const gchar* _tmp9_;
	FsoGsmModem* _tmp10_;
	struct ipc_client* _tmp11_;
	struct ipc_client* _tmp12_;
	struct ipc_client* _tmp13_;
	g_return_val_if_fail (modem != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = transport;
	self = (SamsungIpcChannel*) fso_framework_abstract_command_queue_construct (object_type, _tmp0_);
	_tmp1_ = modem;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->modem);
	self->priv->modem = _tmp2_;
	_tmp3_ = name;
	samsung_ipc_channel_set_name (self, _tmp3_);
	_tmp4_ = self->priv->modem;
	_tmp5_ = samsung_unsolicited_response_handler_new (_tmp4_);
	_tmp6_ = _tmp5_;
	samsung_ipc_channel_set_urchandler (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = fso_framework_wakelock_new ("fsogsmd-modem-samsung");
	_g_object_unref0 (self->priv->wakelock);
	self->priv->wakelock = _tmp7_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
	_tmp8_ = modem;
	_tmp9_ = name;
	fso_gsm_modem_registerChannel (_tmp8_, _tmp9_, (FsoGsmChannel*) self);
	_tmp10_ = modem;
	g_signal_connect_object (_tmp10_, "signal-status-changed", (GCallback) _samsung_ipc_channel_onModemStatusChanged_fso_gsm_modem_signal_status_changed, self, 0);
	_tmp11_ = ipc_client_new (IPC_CLIENT_TYPE_FMT);
	_ipc_client_free0 (self->priv->fmtclient);
	self->priv->fmtclient = _tmp11_;
	_tmp12_ = self->priv->fmtclient;
	ipc_client_set_log_handler (_tmp12_, ___lambda5__samsung_ipc_log_handler_cb, self);
	_tmp13_ = self->priv->fmtclient;
	ipc_client_set_io_handlers (_tmp13_, _samsung_ipc_channel_modem_read_request_samsung_ipc_transport_cb, self, _samsung_ipc_channel_modem_write_request_samsung_ipc_transport_cb, self);
	return self;
}


SamsungIpcChannel* samsung_ipc_channel_new (FsoGsmModem* modem, const gchar* name, FsoFrameworkTransport* transport) {
	return samsung_ipc_channel_construct (SAMSUNG_TYPE_IPC_CHANNEL, modem, name, transport);
}


static void samsung_ipc_channel_real_open_data_free (gpointer _data) {
	SamsungIpcChannelOpenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungIpcChannelOpenData, _data_);
}


static void samsung_ipc_channel_real_open (FsoFrameworkAbstractCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungIpcChannel * self;
	SamsungIpcChannelOpenData* _data_;
	SamsungIpcChannel* _tmp0_;
	self = (SamsungIpcChannel*) base;
	_data_ = g_slice_new0 (SamsungIpcChannelOpenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_ipc_channel_real_open);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_ipc_channel_real_open_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_ipc_channel_real_open_co (_data_);
}


static gboolean samsung_ipc_channel_real_open_finish (FsoFrameworkAbstractCommandQueue* base, GAsyncResult* _res_) {
	gboolean result;
	SamsungIpcChannelOpenData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void samsung_ipc_channel_open_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SamsungIpcChannelOpenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_ipc_channel_real_open_co (_data_);
}


static gboolean samsung_ipc_channel_real_open_co (SamsungIpcChannelOpenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_result_ = TRUE;
	_data_->_tmp0_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	fso_framework_transport_openAsync (_data_->_tmp1_, samsung_ipc_channel_open_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = fso_framework_transport_openAsync_finish (_data_->_tmp1_, _data_->_res_);
	_data_->_result_ = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->_result_;
	if (!_data_->_tmp3_) {
		_data_->result = FALSE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->fmtclient;
	ipc_client_open (_data_->_tmp4_);
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_ipc_channel_real_close_data_free (gpointer _data) {
	SamsungIpcChannelCloseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungIpcChannelCloseData, _data_);
}


static void samsung_ipc_channel_real_close (FsoFrameworkAbstractCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungIpcChannel * self;
	SamsungIpcChannelCloseData* _data_;
	SamsungIpcChannel* _tmp0_;
	self = (SamsungIpcChannel*) base;
	_data_ = g_slice_new0 (SamsungIpcChannelCloseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_ipc_channel_real_close);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_ipc_channel_real_close_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_ipc_channel_real_close_co (_data_);
}


static void samsung_ipc_channel_real_close_finish (FsoFrameworkAbstractCommandQueue* base, GAsyncResult* _res_) {
	SamsungIpcChannelCloseData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean samsung_ipc_channel_real_close_co (SamsungIpcChannelCloseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->fmtclient;
	ipc_client_close (_data_->_tmp0_);
	_data_->_tmp1_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	fso_framework_transport_close (_data_->_tmp2_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_ipc_channel_enqueue_async_data_free (gpointer _data) {
	SamsungIpcChannelEnqueueAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungIpcChannelEnqueueAsyncData, _data_);
}


void samsung_ipc_channel_enqueue_async (SamsungIpcChannel* self, int type, unsigned short command, guint8* data, int data_length1, gint retry, gint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungIpcChannelEnqueueAsyncData* _data_;
	SamsungIpcChannel* _tmp0_;
	int _tmp1_;
	unsigned short _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint _tmp5_;
	_data_ = g_slice_new0 (SamsungIpcChannelEnqueueAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_ipc_channel_enqueue_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_ipc_channel_enqueue_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = type;
	_data_->type = _tmp1_;
	_tmp2_ = command;
	_data_->command = _tmp2_;
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_data_->data = _tmp3_;
	_data_->data_length1 = _tmp3__length1;
	_tmp4_ = retry;
	_data_->retry = _tmp4_;
	_tmp5_ = timeout;
	_data_->timeout = _tmp5_;
	samsung_ipc_channel_enqueue_async_co (_data_);
}


struct ipc_message_info* samsung_ipc_channel_enqueue_finish (SamsungIpcChannel* self, GAsyncResult* _res_) {
	struct ipc_message_info* result;
	SamsungIpcChannelEnqueueAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Send a new response to the modem and wait until we get the response back.
     *
     * @param type Type of the request (see {@link SamsungIpc.RequestType})
     * @param command Type of the command we're sending
     * @param data Data of the request
     * @param retries Number of times the request should resend when sending fails
     * @param timeout Time to wait until the request receives (zero means an unlimited timeout)
     * @return Response message received for the request or null if sending is not possible or a timeout occured
     **/
static const char* _samsung_ipc_request_type_to_string (int value) {
	switch (value) {
		case IPC_TYPE_EXEC:
		return "IPC_TYPE_EXEC";
		case IPC_TYPE_GET:
		return "IPC_TYPE_GET";
		case IPC_TYPE_SET:
		return "IPC_TYPE_SET";
		case IPC_TYPE_CFRM:
		return "IPC_TYPE_CFRM";
		case IPC_TYPE_EVENT:
		return "IPC_TYPE_EVENT";
	}
	return NULL;
}


static gboolean _samsung_ipc_channel_enqueue_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = samsung_ipc_channel_enqueue_async_co (self);
	return result;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gboolean samsung_ipc_channel_enqueue_async_co (SamsungIpcChannelEnqueueAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->initialized;
	if (_data_->_tmp1_) {
		_data_->_tmp2_ = _data_->self->priv->suspended;
		_data_->_tmp0_ = _data_->_tmp2_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	if (_data_->_tmp3_) {
		_data_->_tmp4_ = fso_framework_theLogger;
		fso_framework_logger_error (_data_->_tmp4_, "We can not send a request to the modem when we're suspended!");
		_data_->result = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = fso_framework_theLogger;
	_data_->_tmp6_ = _data_->type;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _samsung_ipc_request_type_to_string (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->command;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _samsung_ipc_message_type_to_string (_data_->_tmp8_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strconcat ("Enqueue a new command: type = ", _data_->_tmp7_, ", command = ", _data_->_tmp9_, NULL);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = FALSE;
	_data_->_tmp12_ = fso_framework_logger_debug (_data_->_tmp5_, _data_->_tmp11_);
	g_assert (_data_->_tmp12_);
	_g_free0 (_data_->_tmp11_);
	_data_->_tmp13_ = samsung_command_handler_new ();
	_data_->handler = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->handler;
	_data_->_tmp15_ = _data_->self->priv->fmtclient;
	_data_->_tmp14_->client = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->handler;
	_data_->_tmp17_ = 0U;
	_data_->_tmp17_ = samsung_ipc_channel_next_request_id (_data_->self);
	_data_->_tmp16_->id = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->handler;
	(((FsoFrameworkAbstractCommandHandler*) _data_->_tmp18_)->callback_target_destroy_notify == NULL) ? NULL : (((FsoFrameworkAbstractCommandHandler*) _data_->_tmp18_)->callback_target_destroy_notify (((FsoFrameworkAbstractCommandHandler*) _data_->_tmp18_)->callback_target), NULL);
	((FsoFrameworkAbstractCommandHandler*) _data_->_tmp18_)->callback = NULL;
	((FsoFrameworkAbstractCommandHandler*) _data_->_tmp18_)->callback_target = NULL;
	((FsoFrameworkAbstractCommandHandler*) _data_->_tmp18_)->callback_target_destroy_notify = NULL;
	((FsoFrameworkAbstractCommandHandler*) _data_->_tmp18_)->callback = _samsung_ipc_channel_enqueue_async_co_gsource_func;
	((FsoFrameworkAbstractCommandHandler*) _data_->_tmp18_)->callback_target = _data_;
	((FsoFrameworkAbstractCommandHandler*) _data_->_tmp18_)->callback_target_destroy_notify = NULL;
	_data_->_tmp19_ = _data_->handler;
	_data_->_tmp20_ = _data_->retry;
	((FsoFrameworkAbstractCommandHandler*) _data_->_tmp19_)->retry = (guint) _data_->_tmp20_;
	_data_->_tmp21_ = _data_->handler;
	_data_->_tmp22_ = _data_->timeout;
	((FsoFrameworkAbstractCommandHandler*) _data_->_tmp21_)->timeout = (guint) _data_->_tmp22_;
	_data_->_tmp23_ = _data_->handler;
	_data_->_tmp24_ = _data_->command;
	_data_->_tmp23_->message_type = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->handler;
	_data_->_tmp26_ = _data_->type;
	_data_->_tmp25_->request_type = _data_->_tmp26_;
	_data_->_tmp27_ = _data_->handler;
	_data_->_tmp28_ = _data_->data;
	_data_->_tmp28__length1 = _data_->data_length1;
	_data_->_tmp29_ = (_data_->_tmp28_ != NULL) ? _vala_array_dup1 (_data_->_tmp28_, _data_->_tmp28__length1) : ((gpointer) _data_->_tmp28_);
	_data_->_tmp29__length1 = _data_->_tmp28__length1;
	_data_->_tmp27_->data = (g_free (_data_->_tmp27_->data), NULL);
	_data_->_tmp27_->data = _data_->_tmp29_;
	_data_->_tmp27_->data_length1 = _data_->_tmp29__length1;
	_data_->_tmp30_ = _data_->self->priv->suspend_lock;
	_data_->self->priv->suspend_lock = _data_->_tmp30_ + 1;
	_data_->_tmp31_ = _data_->handler;
	fso_framework_abstract_command_queue_enqueueCommand ((FsoFrameworkAbstractCommandQueue*) _data_->self, (FsoFrameworkAbstractCommandHandler*) _data_->_tmp31_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp32_ = _data_->self->priv->suspend_lock;
	_data_->self->priv->suspend_lock = _data_->_tmp32_ - 1;
	_fso_framework_abstract_command_handler_unref0 (((FsoFrameworkAbstractCommandQueue*) _data_->self)->current);
	((FsoFrameworkAbstractCommandQueue*) _data_->self)->current = NULL;
	_data_->_tmp33_ = _data_->handler;
	_data_->_tmp34_ = _data_->_tmp33_->timed_out;
	if (_data_->_tmp34_) {
		_data_->_tmp35_ = fso_framework_theLogger;
		_data_->_tmp36_ = _data_->command;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = _samsung_ipc_message_type_to_string (_data_->_tmp36_);
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = g_strconcat ("Received a timeout while sending command ", _data_->_tmp37_, "!", NULL);
		_data_->_tmp39_ = _data_->_tmp38_;
		fso_framework_logger_error (_data_->_tmp35_, _data_->_tmp39_);
		_g_free0 (_data_->_tmp39_);
		_data_->result = NULL;
		_fso_framework_abstract_command_handler_unref0 (_data_->handler);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp40_ = _data_->handler;
	_data_->_tmp41_ = _data_->_tmp40_->response;
	_data_->result = &_data_->_tmp41_;
	_fso_framework_abstract_command_handler_unref0 (_data_->handler);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_fso_framework_abstract_command_handler_unref0 (_data_->handler);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void samsung_ipc_channel_registerUnsolicitedHandler (SamsungIpcChannel* self, SamsungIpcChannelUnsolicitedHandler urchandler, void* urchandler_target) {
	g_return_if_fail (self != NULL);
}


static void samsung_ipc_channel_real_injectResponse (FsoGsmChannel* base, const gchar* response) {
	SamsungIpcChannel * self;
	self = (SamsungIpcChannel*) base;
	g_return_if_fail (response != NULL);
	g_assert_not_reached ();
}


static void samsung_ipc_channel_real_suspend_data_free (gpointer _data) {
	SamsungIpcChannelSuspendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungIpcChannelSuspendData, _data_);
}


static void samsung_ipc_channel_real_suspend (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungIpcChannel * self;
	SamsungIpcChannelSuspendData* _data_;
	SamsungIpcChannel* _tmp0_;
	self = (SamsungIpcChannel*) base;
	_data_ = g_slice_new0 (SamsungIpcChannelSuspendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_ipc_channel_real_suspend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_ipc_channel_real_suspend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_ipc_channel_real_suspend_co (_data_);
}


static gboolean samsung_ipc_channel_real_suspend_finish (FsoGsmChannel* base, GAsyncResult* _res_) {
	gboolean result;
	SamsungIpcChannelSuspendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SamsungIpcChannel * self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean __lambda6_ (Block2Data* _data2_) {
	SamsungIpcChannel * self;
	gboolean result = FALSE;
	FsoFrameworkLogger* _tmp0_;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
	FsoFrameworkLogger* _tmp5_;
	gboolean _tmp6_ = FALSE;
	self = _data2_->self;
	_tmp0_ = fso_framework_theLogger;
	_tmp1_ = fso_framework_logger_debug (_tmp0_, "Checking wether we have pending requests to send to the modem ...");
	g_assert (_tmp1_);
	_tmp2_ = self->priv->suspend_lock;
	if (_tmp2_ == ((guint) 0)) {
		FsoFrameworkLogger* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = fso_framework_theLogger;
		_tmp4_ = fso_framework_logger_debug (_tmp3_, "We have no pending requests; suspending ...");
		g_assert (_tmp4_);
		samsung_ipc_channel_real_suspend_co (_data2_->_async_data_);
		result = FALSE;
		return result;
	}
	_tmp5_ = fso_framework_theLogger;
	_tmp6_ = fso_framework_logger_debug (_tmp5_, "We have pending requests; can't suspend now!");
	g_assert (_tmp6_);
	result = TRUE;
	return result;
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ (self);
	return result;
}


static gboolean samsung_ipc_channel_real_suspend_co (SamsungIpcChannelSuspendData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda6__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->self->priv->suspended = TRUE;
	_data_->result = TRUE;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_ipc_channel_real_resume_data_free (gpointer _data) {
	SamsungIpcChannelResumeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungIpcChannelResumeData, _data_);
}


static void samsung_ipc_channel_real_resume (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungIpcChannel * self;
	SamsungIpcChannelResumeData* _data_;
	SamsungIpcChannel* _tmp0_;
	self = (SamsungIpcChannel*) base;
	_data_ = g_slice_new0 (SamsungIpcChannelResumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_ipc_channel_real_resume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_ipc_channel_real_resume_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_ipc_channel_real_resume_co (_data_);
}


static gboolean samsung_ipc_channel_real_resume_finish (FsoGsmChannel* base, GAsyncResult* _res_) {
	gboolean result;
	SamsungIpcChannelResumeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean samsung_ipc_channel_real_resume_co (SamsungIpcChannelResumeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->suspended = FALSE;
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_ipc_channel_update_modem_power_state_data_free (gpointer _data) {
	SamsungIpcChannelUpdateModemPowerStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungIpcChannelUpdateModemPowerStateData, _data_);
}


void samsung_ipc_channel_update_modem_power_state (SamsungIpcChannel* self, gint16 state, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungIpcChannelUpdateModemPowerStateData* _data_;
	SamsungIpcChannel* _tmp0_;
	gint16 _tmp1_;
	_data_ = g_slice_new0 (SamsungIpcChannelUpdateModemPowerStateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_ipc_channel_update_modem_power_state);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_ipc_channel_update_modem_power_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = state;
	_data_->state = _tmp1_;
	samsung_ipc_channel_update_modem_power_state_co (_data_);
}


gboolean samsung_ipc_channel_update_modem_power_state_finish (SamsungIpcChannel* self, GAsyncResult* _res_) {
	gboolean result;
	SamsungIpcChannelUpdateModemPowerStateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void samsung_ipc_channel_update_modem_power_state_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SamsungIpcChannelUpdateModemPowerStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_ipc_channel_update_modem_power_state_co (_data_);
}


static gboolean samsung_ipc_channel_update_modem_power_state_co (SamsungIpcChannelUpdateModemPowerStateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->state;
	_data_->_tmp1_ = _data_->self->priv->_phone_pwr_state;
	if (_data_->_tmp0_ != _data_->_tmp1_) {
		_data_->_tmp2_ = _data_->state;
		_data_->_state_ = 1;
		samsung_ipc_channel_set_modem_power_state (_data_->self, _data_->_tmp2_, samsung_ipc_channel_update_modem_power_state_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = FALSE;
		_data_->_tmp3_ = samsung_ipc_channel_set_modem_power_state_finish (_data_->self, _data_->_res_);
		_data_->result = _data_->_tmp3_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


SamsungUnsolicitedResponseHandler* samsung_ipc_channel_get_urchandler (SamsungIpcChannel* self) {
	SamsungUnsolicitedResponseHandler* result;
	SamsungUnsolicitedResponseHandler* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_urchandler;
	result = _tmp0_;
	return result;
}


static void samsung_ipc_channel_set_urchandler (SamsungIpcChannel* self, SamsungUnsolicitedResponseHandler* value) {
	SamsungUnsolicitedResponseHandler* _tmp0_;
	SamsungUnsolicitedResponseHandler* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_urchandler);
	self->priv->_urchandler = _tmp1_;
	g_object_notify ((GObject *) self, "urchandler");
}


const gchar* samsung_ipc_channel_get_name (SamsungIpcChannel* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void samsung_ipc_channel_set_name (SamsungIpcChannel* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


gint16 samsung_ipc_channel_get_phone_pwr_state (SamsungIpcChannel* self) {
	gint16 result;
	gint16 _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_phone_pwr_state;
	result = _tmp0_;
	return result;
}


static void samsung_ipc_channel_set_phone_pwr_state (SamsungIpcChannel* self, gint16 value) {
	gint16 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_phone_pwr_state = _tmp0_;
	g_object_notify ((GObject *) self, "phone-pwr-state");
}


static void samsung_ipc_channel_class_init (SamsungIpcChannelClass * klass) {
	samsung_ipc_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SamsungIpcChannelPrivate));
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->onReadFromTransport = samsung_ipc_channel_real_onReadFromTransport;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->onResponseTimeout = samsung_ipc_channel_real_onResponseTimeout;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->open = samsung_ipc_channel_real_open;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->open_finish = samsung_ipc_channel_real_open_finish;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->close = samsung_ipc_channel_real_close;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->close_finish = samsung_ipc_channel_real_close_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_samsung_ipc_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_samsung_ipc_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = samsung_ipc_channel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SAMSUNG_IPC_CHANNEL_URCHANDLER, g_param_spec_object ("urchandler", "urchandler", "urchandler", SAMSUNG_TYPE_UNSOLICITED_RESPONSE_HANDLER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SAMSUNG_IPC_CHANNEL_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SAMSUNG_IPC_CHANNEL_PHONE_PWR_STATE, g_param_spec_int ("phone-pwr-state", "phone-pwr-state", "phone-pwr-state", G_MININT, G_MAXINT, IPC_PWR_PHONE_STATE_LPM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void samsung_ipc_channel_fso_gsm_channel_interface_init (FsoGsmChannelIface * iface) {
	samsung_ipc_channel_fso_gsm_channel_parent_iface = g_type_interface_peek_parent (iface);
	iface->injectResponse = (void (*)(FsoGsmChannel*, const gchar*)) samsung_ipc_channel_real_injectResponse;
	iface->suspend = (gboolean (*)(FsoGsmChannel*)) samsung_ipc_channel_real_suspend;
	iface->suspend_finish = samsung_ipc_channel_real_suspend_finish;
	iface->resume = (gboolean (*)(FsoGsmChannel*)) samsung_ipc_channel_real_resume;
	iface->resume_finish = samsung_ipc_channel_real_resume_finish;
}


static void samsung_ipc_channel_instance_init (SamsungIpcChannel * self) {
	self->priv = SAMSUNG_IPC_CHANNEL_GET_PRIVATE (self);
	self->priv->current_request_id = (guint8) 1;
	self->priv->initialized = FALSE;
	self->priv->suspended = FALSE;
	self->priv->suspend_lock = (guint) 0;
	self->priv->current_modem_status = FSO_GSM_MODEM_STATUS_UNKNOWN;
	self->priv->_phone_pwr_state = IPC_PWR_PHONE_STATE_LPM;
}


static void samsung_ipc_channel_finalize (GObject* obj) {
	SamsungIpcChannel * self;
	self = SAMSUNG_IPC_CHANNEL (obj);
	_ipc_client_free0 (self->priv->fmtclient);
	_g_object_unref0 (self->priv->wakelock);
	_g_object_unref0 (self->priv->usage_sync);
	_g_object_unref0 (self->priv->modem);
	_g_object_unref0 (self->priv->_urchandler);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (samsung_ipc_channel_parent_class)->finalize (obj);
}


GType samsung_ipc_channel_get_type (void) {
	return samsung_ipc_channel_type_id;
}


GType samsung_ipc_channel_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (SamsungIpcChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) samsung_ipc_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SamsungIpcChannel), 0, (GInstanceInitFunc) samsung_ipc_channel_instance_init, NULL };
	static const GInterfaceInfo fso_gsm_channel_info = { (GInterfaceInitFunc) samsung_ipc_channel_fso_gsm_channel_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	samsung_ipc_channel_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_QUEUE, "SamsungIpcChannel", &g_define_type_info, 0);
	g_type_module_add_interface (module, samsung_ipc_channel_type_id, FSO_GSM_TYPE_CHANNEL, &fso_gsm_channel_info);
	return samsung_ipc_channel_type_id;
}


static void _vala_samsung_ipc_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SamsungIpcChannel * self;
	self = SAMSUNG_IPC_CHANNEL (object);
	switch (property_id) {
		case SAMSUNG_IPC_CHANNEL_URCHANDLER:
		g_value_set_object (value, samsung_ipc_channel_get_urchandler (self));
		break;
		case SAMSUNG_IPC_CHANNEL_NAME:
		g_value_set_string (value, samsung_ipc_channel_get_name (self));
		break;
		case SAMSUNG_IPC_CHANNEL_PHONE_PWR_STATE:
		g_value_set_int (value, samsung_ipc_channel_get_phone_pwr_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_samsung_ipc_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SamsungIpcChannel * self;
	self = SAMSUNG_IPC_CHANNEL (object);
	switch (property_id) {
		case SAMSUNG_IPC_CHANNEL_URCHANDLER:
		samsung_ipc_channel_set_urchandler (self, g_value_get_object (value));
		break;
		case SAMSUNG_IPC_CHANNEL_NAME:
		samsung_ipc_channel_set_name (self, g_value_get_string (value));
		break;
		case SAMSUNG_IPC_CHANNEL_PHONE_PWR_STATE:
		samsung_ipc_channel_set_phone_pwr_state (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



