# This file is part of the Frescobaldi project, http://www.frescobaldi.org/
#
# Copyright (c) 2008, 2009  Wilbert Berendsen
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# See http://www.gnu.org/licenses/ for more information.

""" Routines dealing with LilyPond fonts """

import os, ly, xml.dom.minidom

class SvgFont(object):
    """
    Can load a SVG font and provide information about the glyphs and
    their unicode values.
    """
    def __init__(self, filename):
        self.name2unicode = {}
        doc = xml.dom.minidom.parse(filename)
        glyphs = doc.getElementsByTagName('glyph')
        for g in glyphs:
            name = g.attributes["glyph-name"].value
            code = g.attributes["unicode"].value
            self.name2unicode[name] = code
        doc.unlink()
        
    def glyph(self, glyphName):
        return self.name2unicode.get(glyphName, u'')
        
    def glyphs(self):
        return self.name2unicode.keys()

@ly.lazy
def emmentaler20(datadir):
    """
    Return the emmentaler-20 font, loaded and cached
    """
    font = os.path.join(datadir, "fonts", "svg", "emmentaler-20.svg")
    return os.path.exists(font) and SvgFont(font) or None

