<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
                xmlns:saxon="http://icl.com/saxon" saxon:trace="no">

<!--	XSL namespaces are in transition!  Tools are slow to catch up.
    ***	Edit the topmost stylesheet tag on line 2 of this file to match the xmlns namespace URI for your XSL tool. ***
	W3C:
	Saxon:           <xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
	IBM XSLEditor:   <xsl:stylesheet xmlns:xsl='http://www.w3.org/XSL/Transform/1.0'>
	IE 5:            <xsl:stylesheet xmlns:xsl='http://www.w3.org/TR/WD-xsl'>
	XT:              <xsl:stylesheet xmlns:xsl='http://www.w3.org/XSL/Transform'>
-->

<!--
  <Header>
   <meta name="filename"    content="X3dToVrml97.xsl" />
   <meta name="author"      content="Don Brutzman" />
   <meta name="revised"     content="6 May 2001" />
   <meta name="description" content="XSL stylesheet to convert X3D files to VRML 97 format, fourth draft matching x3d-compromise.dtd" />
   <meta name="url"         content="http://www.web3D.org/TaskGroups/x3d/translation/X3dToVrml97.xsl" />
  </Header>

Recommended tool:

-  SAXON XML Toolkit (and Instant Saxon) from Michael Kay of ICL, http://users.iclway.co.uk/mhkay/saxon

- Can also be used with Apache server

-->

<!-- Problems and bugs:

  - Script node content hardwired for javascript to eliminate problematic leading whitespace (which crashes CosmoPlayer)
  - still need to check KeySensor, StringSensor, GeoVRML attribute defaults
  - combine GeoVRML and H-Anim metadata attributes into a single string
  - ensure Double types get translated properly!

  -->

<xsl:strip-space elements="*" />
<xsl:output method="text" encoding="utf-8" media-type="model/vrml" indent="no" cdata-section-elements="Script"/>
<!-- omit-xml-declaration="yes" -->
<!-- indent handled as a passed parameter since output-tag indent ineffective -->


<!-- ****** root:  start of file ****** -->
<xsl:template match="/">
  <xsl:text>#VRML V2.0 utf8&#10;# X3D-to-VRML-97 XSL translation autogenerated by X3dToVrml97.xsl&#10;# http://www.web3D.org/TaskGroups/x3d/translation/X3dToVrml97.xsl&#10;&#10;</xsl:text>
  <!-- Insert GeoVrml EXTERNPROTO declarations, if not otherwise provided -->
  <xsl:if test="//GeoCoordinate and not(//ExternProtoDeclare[@name='GeoCoordinate']) and not(//ProtoDeclare[@name='GeoCoordinate'])">
    <xsl:text>EXTERNPROTO GeoCoordinate [&#10;</xsl:text>
    <xsl:text>  field  SFNode    geoOrigin    # NULL&#10;</xsl:text>
    <xsl:text>  field  MFString  geoSystem    # [ "GDC" ]&#10;</xsl:text>
    <xsl:text>  field  MFString  point        # []&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "C:\Program Files\GeoVRML\1.0\protos\GeoCoordinate.wrl#GeoCoordinate"&#10;</xsl:text>
    <xsl:text>    "file:///C|/Program Files/GeoVRML/1.0/protos/GeoCoordinate.wrl#GeoCoordinate"&#10;</xsl:text>
    <xsl:text>    "urn:web3d:geovrml:1.0/protos/GeoCoordinate.wrl#GeoCoordinate"&#10;</xsl:text>
    <xsl:text>    "http://www.geovrml.org/1.0/protos/GeoCoordinate.wrl#GeoCoordinate"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="//GeoElevationGrid and not(//ExternProtoDeclare[@name='GeoElevationGrid']) and not(//ProtoDeclare[@name='GeoElevationGrid'])">
    <xsl:text>EXTERNPROTO GeoElevationGrid [&#10;</xsl:text>
    <xsl:text>  field         SFNode    geoOrigin         # NULL&#10;</xsl:text>
    <xsl:text>  field         MFString  geoSystem         # [ "GDC" ]&#10;</xsl:text>
    <xsl:text>  field         SFString  geoGridOrigin     # "0 0 0"&#10;</xsl:text>
    <xsl:text>  field         SFInt32   xDimension        # 0&#10;</xsl:text>
    <xsl:text>  field         SFString  xSpacing          # "1.0"&#10;</xsl:text>
    <xsl:text>  field         SFInt32   zDimension        # 0&#10;</xsl:text>
    <xsl:text>  field         SFString  zSpacing          # "1.0"&#10;</xsl:text>
    <xsl:text>  field         SFFloat   yScale            # 1.0&#10;</xsl:text>
    <xsl:text>  field         MFFloat   height            # []&#10;</xsl:text>
    <xsl:text>  eventIn       SFFloat   set_yScale&#10;</xsl:text>
    <xsl:text>  eventIn       MFFloat   set_height&#10;</xsl:text>
    <xsl:text>  exposedField  SFNode    color             # NULL&#10;</xsl:text>
    <xsl:text>  exposedField  SFNode    texCoord          # NULL&#10;</xsl:text>
    <xsl:text>  exposedField  SFNode    normal            # NULL&#10;</xsl:text>
    <xsl:text>  field         SFBool    normalPerVertex   # TRUE&#10;</xsl:text>
    <xsl:text>  field         SFBool    ccw               # TRUE&#10;</xsl:text>
    <xsl:text>  field         SFBool    colorPerVertex    # TRUE&#10;</xsl:text>
    <xsl:text>  field         SFFloat   creaseAngle       # 0&#10;</xsl:text>
    <xsl:text>  field         SFBool    solid             # TRUE&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "C:\Program Files\GeoVRML\1.0\protos\GeoElevationGrid.wrl#GeoElevationGrid"&#10;</xsl:text>
    <xsl:text>    "file:///C|/Program Files/GeoVRML/1.0/protos/GeoElevationGrid.wrl#GeoElevationGrid"&#10;</xsl:text>
    <xsl:text>    "urn:web3d:geovrml:1.0/protos/GeoElevationGrid.wrl#GeoElevationGrid"&#10;</xsl:text>
    <xsl:text>    "http://www.geovrml.org/1.0/protos/GeoElevationGrid.wrl#GeoElevationGrid"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="//GeoInline and not(//ExternProtoDeclare[@name='GeoInline']) and not(//ProtoDeclare[@name='GeoInline'])">
    <xsl:text>EXTERNPROTO GeoInline [&#10;</xsl:text>
    <xsl:text>  field    MFString url           # []&#10;</xsl:text>
    <xsl:text>  eventIn  MFString set_url              &#10;</xsl:text>
    <xsl:text>  eventOut MFString url_changed&#10;</xsl:text>
    <xsl:text>  field    SFBool   load          # TRUE&#10;</xsl:text>
    <xsl:text>  eventIn  SFBool   set_load&#10;</xsl:text>
    <xsl:text>  eventOut SFBool   load_changed&#10;</xsl:text>
    <xsl:text>  field    SFVec3f  bboxCenter    # 0 0 0&#10;</xsl:text>
    <xsl:text>  field    SFVec3f  bboxSize      # -1 -1 -1&#10;</xsl:text>
    <xsl:text>  eventOut MFNode   children&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "C:\Program Files\GeoVRML\1.0\protos\GeoInline.wrl#GeoInline"&#10;</xsl:text>
    <xsl:text>    "file:///C|/Program Files/GeoVRML/1.0/protos/GeoInline.wrl#GeoInline"&#10;</xsl:text>
    <xsl:text>    "urn:web3d:geovrml:1.0/protos/GeoInline.wrl#GeoInline"&#10;</xsl:text>
    <xsl:text>    "http://www.geovrml.org/1.0/protos/GeoInline.wrl#GeoInline"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
   </xsl:if>
  <xsl:if test="//GeoLocation and not(//ExternProtoDeclare[@name='GeoLocation']) and not(//ProtoDeclare[@name='GeoLocation'])">
    <xsl:text>EXTERNPROTO GeoLocation [&#10;</xsl:text>
    <xsl:text>  field    SFNode    geoOrigin          # NULL&#10;</xsl:text>
    <xsl:text>  field    MFString  geoSystem          # [ "GDC" ]&#10;</xsl:text>
    <xsl:text>  field    SFString  geoCoords          # ""&#10;</xsl:text>
    <xsl:text>  eventIn  SFString  set_geoCoords&#10;</xsl:text>
    <xsl:text>  eventOut SFString  geoCoords_changed&#10;</xsl:text>
    <xsl:text>  field    MFNode    children           # []&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "C:\Program Files\GeoVRML\1.0\protos\GeoLocation.wrl#GeoLocation"&#10;</xsl:text>
    <xsl:text>    "file:///C|/Program Files/GeoVRML/1.0/protos/GeoLocation.wrl#GeoLocation"&#10;</xsl:text>
    <xsl:text>    "urn:web3d:geovrml:1.0/protos/GeoLocation.wrl#GeoLocation"&#10;</xsl:text>
    <xsl:text>    "http://www.geovrml.org/1.0/protos/GeoLocation.wrl#GeoLocation"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="//GeoLOD and not(//ExternProtoDeclare[@name='GeoLOD']) and not(//ProtoDeclare[@name='GeoLOD'])">
    <xsl:text>EXTERNPROTO GeoLOD [&#10;</xsl:text>
    <xsl:text> field     MFString rootUrl      # []&#10;</xsl:text>
    <xsl:text> field     MFNode   rootNode     # []&#10;</xsl:text>
    <xsl:text> field     MFString child1Url    # []&#10;</xsl:text>
    <xsl:text> field     MFString child2Url    # []&#10;</xsl:text>
    <xsl:text> field     MFString child3Url    # []&#10;</xsl:text>
    <xsl:text> field     MFString child4Url    # []&#10;</xsl:text>
    <xsl:text> field     SFFloat  range        # 10&#10;</xsl:text>
    <xsl:text> field     SFNode   geoOrigin    # NULL&#10;</xsl:text>
    <xsl:text> field     MFString geoSystem    # [ "GDC" ]&#10;</xsl:text>
    <xsl:text> field     SFString center       # ""&#10;</xsl:text>
    <xsl:text> eventOut  MFNode   children&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "C:\Program Files\GeoVRML\1.0\protos\GeoLOD.wrl#GeoLOD"&#10;</xsl:text>
    <xsl:text>    "file:///C|/Program Files/GeoVRML/1.0/protos/GeoLOD.wrl#GeoLOD"&#10;</xsl:text>
    <xsl:text>    "urn:web3d:geovrml:1.0/protos/GeoLOD.wrl#GeoLOD"&#10;</xsl:text>
    <xsl:text>    "http://www.geovrml.org/1.0/protos/GeoLOD.wrl#GeoLOD"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="//GeoMetadata and not(//ExternProtoDeclare[@name='GeoMetadata']) and not(//ProtoDeclare[@name='GeoMetadata'])">
    <xsl:text>EXTERNPROTO GeoMetadata [&#10;</xsl:text>
    <xsl:text>  exposedField MFString url        # []&#10;</xsl:text>
    <xsl:text>  exposedField MFString summary    # []&#10;</xsl:text>
    <xsl:text>  exposedField MFNode   data       # []&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "C:\Program Files\GeoVRML\1.0\protos\GeoMetadata.wrl#GeoMetadata"&#10;</xsl:text>
    <xsl:text>    "file:///C|/Program Files/GeoVRML/1.0/protos/GeoMetadata.wrl#GeoMetadata"&#10;</xsl:text>
    <xsl:text>    "urn:web3d:geovrml:1.0/protos/GeoMetadata.wrl#GeoMetadata"&#10;</xsl:text>
    <xsl:text>    "http://www.geovrml.org/1.0/protos/GeoMetadata.wrl#GeoMetadata"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="//GeoOrigin and not(//ExternProtoDeclare[@name='GeoOrigin']) and not(//ProtoDeclare[@name='GeoOrigin'])">
    <xsl:text>EXTERNPROTO GeoOrigin [&#10;</xsl:text>
    <xsl:text> exposedField  MFString  geoSystem    # [ "GDC" ]&#10;</xsl:text>
    <xsl:text> exposedField  SFString  geoCoords    # ""&#10;</xsl:text>
    <xsl:text> field         SFBool    rotateYUp    # FALSE&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "C:\Program Files\GeoVRML\1.0\protos\GeoOrigin.wrl#GeoOrigin"&#10;</xsl:text>
    <xsl:text>    "file:///C|/Program Files/GeoVRML/1.0/protos/GeoOrigin.wrl#GeoOrigin"&#10;</xsl:text>
    <xsl:text>    "urn:web3d:geovrml:1.0/protos/GeoOrigin.wrl#GeoOrigin"&#10;</xsl:text>
    <xsl:text>    "http://www.geovrml.org/1.0/protos/GeoOrigin.wrl#GeoOrigin"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="//GeoPositionInterpolator and not(//ExternProtoDeclare[@name='GeoPositionInterpolator']) and not(//ProtoDeclare[@name='GeoPositionInterpolator'])">
    <xsl:text>EXTERNPROTO GeoPositionInterpolator [&#10;</xsl:text>
    <xsl:text> field        SFNode   geoOrigin          # NULL&#10;</xsl:text>
    <xsl:text> field        MFString geoSystem          # [ "GDC" ]&#10;</xsl:text>
    <xsl:text> field        MFFloat  key                # []&#10;</xsl:text>
    <xsl:text> field        MFString keyValue           # []&#10;</xsl:text>
    <xsl:text> eventIn      SFFloat  set_fraction&#10;</xsl:text>
    <xsl:text> eventOut     SFVec3f  value_changed&#10;</xsl:text>
    <xsl:text> eventOut     SFString geovalue_changed&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "C:\Program Files\GeoVRML\1.0\protos\GeoPositionInterpolator.wrl#GeoPositionInterpolator"&#10;</xsl:text>
    <xsl:text>    "file:///C|/Program Files/GeoVRML/1.0/protos/GeoPositionInterpolator.wrl#GeoPositionInterpolator"&#10;</xsl:text>
    <xsl:text>    "urn:web3d:geovrml:1.0/protos/GeoPositionInterpolator.wrl#GeoPositionInterpolator"&#10;</xsl:text>
    <xsl:text>    "http://www.geovrml.org/1.0/protos/GeoPositionInterpolator.wrl#GeoPositionInterpolator"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="//GeoTouchSensor and not(//ExternProtoDeclare[@name='GeoTouchSensor']) and not(//ProtoDeclare[@name='GeoTouchSensor'])">
    <xsl:text>EXTERNPROTO GeoTouchSensor [&#10;</xsl:text>
    <xsl:text> field        SFNode   geoOrigin           # NULL&#10;</xsl:text>
    <xsl:text> field        MFString geoSystem           # [ "GDC" ]&#10;</xsl:text>
    <xsl:text> exposedField SFBool   enabled             # TRUE&#10;</xsl:text>
    <xsl:text> eventOut     SFVec3f  hitNormal_changed&#10;</xsl:text>
    <xsl:text> eventOut     SFVec3f  hitPoint_changed&#10;</xsl:text>
    <xsl:text> eventOut     SFVec2f  hitTexCoord_changed&#10;</xsl:text>
    <xsl:text> eventOut     SFBool   isActive&#10;</xsl:text>
    <xsl:text> eventOut     SFBool   isOver&#10;</xsl:text>
    <xsl:text> eventOut     SFTime   touchTime&#10;</xsl:text>
    <xsl:text> eventOut     SFString hitGeoCoord_changed&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "C:\Program Files\GeoVRML\1.0\protos\GeoTouchSensor.wrl#GeoTouchSensor"&#10;</xsl:text>
    <xsl:text>    "file:///C|/Program Files/GeoVRML/1.0/protos/GeoTouchSensor.wrl#GeoTouchSensor"&#10;</xsl:text>
    <xsl:text>    "urn:web3d:geovrml:1.0/protos/GeoTouchSensor.wrl#GeoTouchSensor"&#10;</xsl:text>
    <xsl:text>    "http://www.geovrml.org/1.0/protos/GeoTouchSensor.wrl#GeoTouchSensor"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="//GeoViewpoint and not(//ExternProtoDeclare[@name='GeoViewpoint']) and not(//ProtoDeclare[@name='GeoViewpoint'])">
    <xsl:text>EXTERNPROTO GeoViewpoint [&#10;</xsl:text>
    <xsl:text> field         SFNode      geoOrigin        # NULL&#10;</xsl:text>
    <xsl:text> field         MFString    geoSystem        # ["GDC"]&#10;</xsl:text>
    <xsl:text> field         SFString    position         # "0 0 100000"&#10;</xsl:text>
    <xsl:text> field         SFRotation  orientation      # 0 0 1 0&#10;</xsl:text>
    <xsl:text> exposedField  SFFloat     fieldOfView      # 0.785398&#10;</xsl:text>
    <xsl:text> exposedField  SFBool      jump             # TRUE&#10;</xsl:text>
    <xsl:text> exposedField  MFString    navType          # ["EXAMINE","ANY"]&#10;</xsl:text>
    <xsl:text> exposedField  SFBool      headlight        # TRUE&#10;</xsl:text>
    <xsl:text> field         SFString    description      # ""&#10;</xsl:text>
    <xsl:text> field         SFFloat     speed            # 1.0&#10;</xsl:text>
    <xsl:text> eventIn       SFString    set_position&#10;</xsl:text>
    <xsl:text> eventIn       SFString    set_orientation&#10;</xsl:text>
    <xsl:text> eventIn       SFBool      set_bind&#10;</xsl:text>
    <xsl:text> eventOut      SFTime      bindTime&#10;</xsl:text>
    <xsl:text> eventOut      SFBool      isBound&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "C:\Program Files\GeoVRML\1.0\protos\GeoViewpoint.wrl#GeoViewpoint"&#10;</xsl:text>
    <xsl:text>    "file:///C|/Program Files/GeoVRML/1.0/protos/GeoViewpoint.wrl#GeoViewpoint"&#10;</xsl:text>
    <xsl:text>    "urn:web3d:geovrml:1.0/protos/GeoViewpoint.wrl#GeoViewpoint"&#10;</xsl:text>
    <xsl:text>    "http://www.geovrml.org/1.0/protos/GeoViewpoint.wrl#GeoViewpoint"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <!-- H-Anim Humanoid Animation http://ece.uwaterloo.ca/~h-anim/spec1.1 -->
  <!-- standard www.web3D.org EXTERNPROTO URLs needed... -->
  <xsl:if test="(//Humanoid or //ProtoInstance[@name='Humanoid']) and not(//ExternProtoDeclare[@name='Humanoid']) and not(//ProtoDeclare[@name='Humanoid'])">
    <xsl:text>EXTERNPROTO Humanoid [&#10;</xsl:text>
    <xsl:text> field           SFVec3f    bboxCenter            # 0 0 0&#10;</xsl:text>
    <xsl:text> field           SFVec3f    bboxSize              # -1 -1 -1&#10;</xsl:text>
    <xsl:text> exposedField    SFVec3f    center                # 0 0 0&#10;</xsl:text>
    <xsl:text> exposedField    MFNode     humanoidBody          # [ ]&#10;</xsl:text>
    <xsl:text> exposedField    MFString   info                  # [ ]&#10;</xsl:text>
    <xsl:text> exposedField    MFNode     joints                # [ ]&#10;</xsl:text>
    <xsl:text> exposedField    SFString   name                  # ""&#10;</xsl:text>
    <xsl:text> exposedField    SFRotation rotation              # 0 0 1 0&#10;</xsl:text>
    <xsl:text> exposedField    SFVec3f    scale                 # 1 1 1&#10;</xsl:text>
    <xsl:text> exposedField    SFRotation scaleOrientation      # 0 0 1 0&#10;</xsl:text>
    <xsl:text> exposedField    MFNode     segments              # [ ]&#10;</xsl:text>
    <xsl:text> exposedField    MFNode     sites                 # [ ]&#10;</xsl:text>
    <xsl:text> exposedField    SFVec3f    translation           # 0 0 0&#10;</xsl:text>
    <xsl:text> exposedField    SFString   version               # "1.1"&#10;</xsl:text>
    <xsl:text> exposedField    MFNode     viewpoints            # [ ]&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "NancyProtosTranslated.wrl#Humanoid"&#10;</xsl:text>
    <xsl:text>    "C:/www.web3D.org/TaskGroups/x3d/translation/examples/HumanoidAnimation/NancyProtosTranslated.wrl#Humanoid"&#10;</xsl:text>
    <xsl:text>    "http://www.web3D.org/TaskGroups/x3d/translation/examples/HumanoidAnimation/NancyProtosTranslated.wrl#Humanoid"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="(//Displacer or //ProtoInstance[@name='Displacer']) and not(//ExternProtoDeclare[@name='Displacer']) and not(//ProtoDeclare[@name='Displacer'])">
    <xsl:text>EXTERNPROTO Displacer [&#10;</xsl:text>
    <xsl:text> exposedField MFInt32  coordIndex     # [ ]&#10;</xsl:text>
    <xsl:text> exposedField MFVec3f  displacements  # [ ]&#10;</xsl:text>
    <xsl:text> exposedField SFString name           # ""&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "NancyProtosTranslated.wrl#Displacer"&#10;</xsl:text>
    <xsl:text>    "C:/www.web3D.org/TaskGroups/x3d/translation/examples/HumanoidAnimation/NancyProtosTranslated.wrl#Displacer"&#10;</xsl:text>
    <xsl:text>    "http://www.web3D.org/TaskGroups/x3d/translation/examples/HumanoidAnimation/NancyProtosTranslated.wrl#Displacer"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="(//Joint or //ProtoInstance[@name='Joint']) and not(//ExternProtoDeclare[@name='Joint']) and not(//ProtoDeclare[@name='Joint'])">
    <xsl:text>EXTERNPROTO Joint [&#10;</xsl:text>
    <xsl:text> exposedField     SFVec3f      center              # 0 0 0&#10;</xsl:text>
    <xsl:text> exposedField     MFNode       children            # []&#10;</xsl:text>
    <xsl:text> exposedField     MFFloat      llimit              # []&#10;</xsl:text>
    <xsl:text> exposedField     SFRotation   limitOrientation    # 0 0 1 0&#10;</xsl:text>
    <xsl:text> exposedField     SFString     name                # ""&#10;</xsl:text>
    <xsl:text> exposedField     SFRotation   rotation            # 0 0 1 0&#10;</xsl:text>
    <xsl:text> exposedField     SFVec3f      scale               # 1 1 1&#10;</xsl:text>
    <xsl:text> exposedField     SFRotation   scaleOrientation    # 0 0 1 0&#10;</xsl:text>
    <xsl:text> exposedField     MFFloat      stiffness           # [ 0 0 0 ]&#10;</xsl:text>
    <xsl:text> exposedField     SFVec3f      translation         # 0 0 0&#10;</xsl:text>
    <xsl:text> exposedField     MFFloat      ulimit              # []&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "NancyProtosTranslated.wrl#Joint"&#10;</xsl:text>
    <xsl:text>    "C:/www.web3D.org/TaskGroups/x3d/translation/examples/HumanoidAnimation/NancyProtosTranslated.wrl#Joint"&#10;</xsl:text>
    <xsl:text>    "http://www.web3D.org/TaskGroups/x3d/translation/examples/HumanoidAnimation/NancyProtosTranslated.wrl#Joint"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="(//Segment or //ProtoInstance[@name='Segment']) and not(//ExternProtoDeclare[@name='Segment']) and not(//ProtoDeclare[@name='Segment'])">
    <xsl:text>EXTERNPROTO Segment [&#10;</xsl:text>
    <xsl:text> field           SFVec3f     bboxCenter        # 0 0 0&#10;</xsl:text>
    <xsl:text> field           SFVec3f     bboxSize          # -1 -1 -1&#10;</xsl:text>
    <xsl:text> exposedField    SFVec3f     centerOfMass      # 0 0 0&#10;</xsl:text>
    <xsl:text> exposedField    MFNode      children          # [ ]&#10;</xsl:text>
    <xsl:text> exposedField    SFNode      coord             # NULL&#10;</xsl:text>
    <xsl:text> exposedField    MFNode      displacers        # [ ]&#10;</xsl:text>
    <xsl:text> exposedField    SFFloat     mass              # 0 &#10;</xsl:text>
    <xsl:text> exposedField    MFFloat     momentsOfInertia  # [ 0 0 0 0 0 0 0 0 0 ]&#10;</xsl:text>
    <xsl:text> exposedField    SFString    name              # ""&#10;</xsl:text>
    <xsl:text> eventIn         MFNode      addChildren&#10;</xsl:text>
    <xsl:text> eventIn         MFNode      removeChildren&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "NancyProtosTranslated.wrl#Segment"&#10;</xsl:text>
    <xsl:text>    "C:/www.web3D.org/TaskGroups/x3d/translation/examples/HumanoidAnimation/NancyProtosTranslated.wrl#Segment"&#10;</xsl:text>
    <xsl:text>    "http://www.web3D.org/TaskGroups/x3d/translation/examples/HumanoidAnimation/NancyProtosTranslated.wrl#Segment"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="(//Site or //ProtoInstance[@name='Site']) and not(//ExternProtoDeclare[@name='Site']) and not(//ProtoDeclare[@name='Site'])">
    <xsl:text>EXTERNPROTO Site [&#10;</xsl:text>
    <xsl:text> exposedField    SFVec3f     center           # 0 0 0&#10;</xsl:text>
    <xsl:text> exposedField    MFNode      children         # []&#10;</xsl:text>
    <xsl:text> exposedField    SFString    name             # ""&#10;</xsl:text>
    <xsl:text> exposedField    SFRotation  rotation         # 0 0 1 0&#10;</xsl:text>
    <xsl:text> exposedField    SFVec3f     scale            # 1 1 1&#10;</xsl:text>
    <xsl:text> exposedField    SFRotation  scaleOrientation # 0 0 1 0&#10;</xsl:text>
    <xsl:text> exposedField    SFVec3f     translation      # 0 0 0&#10;</xsl:text>
    <xsl:text> eventIn         MFNode      addChildren &#10;</xsl:text>
    <xsl:text> eventIn         MFNode      removeChildren&#10;</xsl:text>
    <xsl:text>] [&#10;</xsl:text>
    <xsl:text>    "NancyProtosTranslated.wrl#Site"&#10;</xsl:text>
    <xsl:text>    "C:/www.web3D.org/TaskGroups/x3d/translation/examples/HumanoidAnimation/NancyProtosTranslated.wrl#Segment"&#10;</xsl:text>
    <xsl:text>    "http://www.web3D.org/TaskGroups/x3d/translation/examples/HumanoidAnimation/NancyProtosTranslated.wrl#Site"&#10;</xsl:text>
    <xsl:text>  ]&#10;</xsl:text>
  </xsl:if>
  <!-- DIS-Java-VRML http://www.web3D.org/WorkingGroups/vrtp/dis-java-vrml -->
  <xsl:if test="(//EspduTransform or //ProtoInstance[@name='EspduTransform']) and not(//ExternProtoDeclare[@name='EspduTransform'] or //ProtoDeclare[@name='EspduTransform'])">
    <xsl:text>EXTERNPROTO EspduTransform [&#10;</xsl:text>
    <xsl:text> eventOut 	SFTime		timestamp	# DIS timestamp in VRML units&#10;</xsl:text>
    <xsl:text> field		SFString	marking		# 0..11 character label for entity&#10;</xsl:text>
    <xsl:text> field		SFTime		readInterval	# seconds between read  updates, 0 means no reading&#10;</xsl:text>
    <xsl:text> field		SFTime		writeInterval	# seconds between write updates, 0 means no writing&#10;</xsl:text>
    <xsl:text> field		SFString	address		# multicast address or "localhost"&#10;</xsl:text>
    <xsl:text> field		SFInt32		port		# port number&#10;</xsl:text>
    <xsl:text> field		SFInt32		siteID		# EntityID triplet, first element&#10;</xsl:text>
    <xsl:text> field		SFInt32		applicationID	# EntityID triplet, second element&#10;</xsl:text>
    <xsl:text> field		SFInt32		entityID	# EntityID triplet, third element&#10;</xsl:text>
    <xsl:text> &#10;</xsl:text>
    <xsl:text> # Standard VRML Transform fields - - - - - - - - - - - - - - - - - - - - - - - - -&#10;</xsl:text>
    <xsl:text> exposedField	MFNode		children&#10;</xsl:text>
    <xsl:text> exposedField	SFVec3f		translation     # default prior to DIS update		&#10;</xsl:text>
    <xsl:text> exposedField	SFRotation	rotation        # default prior to DIS update&#10;</xsl:text>
    <xsl:text> exposedField	SFVec3f		scale&#10;</xsl:text>
    <xsl:text> exposedField	SFRotation	scaleOrientation&#10;</xsl:text>
    <xsl:text> field		SFVec3f		bboxCenter&#10;</xsl:text>
    <xsl:text> field		SFVec3f		bboxSize&#10;</xsl:text>
    <xsl:text> exposedField	SFVec3f		center&#10;</xsl:text>
    <xsl:text> eventIn  	MFNode		addChildren&#10;</xsl:text>
    <xsl:text> eventIn  	MFNode		removeChildren&#10;</xsl:text>
    <xsl:text> &#10;</xsl:text>
    <xsl:text> # Automatic MulticastRelayClient if no multicast heard - - - - - - - - - - - - - -&#10;</xsl:text>
    <xsl:text> field		SFString	multicastRelayHost&#10;</xsl:text>
    <xsl:text> field		SFInt32 	multicastRelayPort&#10;</xsl:text>
    <xsl:text> field		SFBool		rtpHeaderExpected	# whether RTP headers are prepended to DIS&#10;</xsl:text>
    <xsl:text> eventOut	SFBool		rtpHeaderHeard&#10;</xsl:text>
    <xsl:text> &#10;</xsl:text>
    <xsl:text> # Collision/Detonation/Fire PDU heard, or no active ESPDUs heard - - - - - - - - -&#10;</xsl:text>
    <xsl:text> eventOut	SFBool		active		# have we had an update recently?&#10;</xsl:text>
    <xsl:text> eventOut	SFBool		collided	# has a CollisionPDU reported a collision?&#10;</xsl:text>
    <xsl:text> eventOut	SFTime		collideTime	# when were we collided with?&#10;</xsl:text>
    <xsl:text> eventOut	SFBool		detonated	# has a DetonationPDU reported a detonation?&#10;</xsl:text>
    <xsl:text> eventOut	SFTime		detonateTime	# when were we detonated?&#10;</xsl:text>
    <xsl:text> eventOut	SFBool		fired1		# have we shot a Fire (weapon) PDU (primary)?&#10;</xsl:text>
    <xsl:text> eventOut	SFBool		fired2		# have we shot a Fire (weapon) PDU (secondary)?&#10;</xsl:text>
    <xsl:text> eventOut	SFTime		firedTime	# when did we shoot a Fire (weapon) PDU?&#10;</xsl:text>
    <xsl:text> eventOut	SFVec3f		munitionStartPoint # exercise coordinates&#10;</xsl:text>
    <xsl:text> eventOut	SFVec3f		munitionEndPoint # exercise coordinates&#10;</xsl:text>
    <xsl:text> &#10;</xsl:text>
    <xsl:text> # Articulated Parameter (user-defined payload) fields  - - - - - - - - - - - - - - - - - - - - - -&#10;</xsl:text>
    <xsl:text> eventOut	SFInt32		articulationParameterCount	# articulated parameters available&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue0	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue1	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue2	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue3	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue4	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue5	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue6	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue7	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue8	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue9	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue10	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue11	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue12	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue13	# user-defined payload value&#10;</xsl:text>
    <xsl:text> eventOut	SFFloat		articulationParameterValue14	# user-defined payload value&#10;</xsl:text>
    <xsl:text> &#10;</xsl:text>
    <xsl:text> # Trace fields - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -&#10;</xsl:text>
    <xsl:text> exposedField	SFColor		traceColor	# color of VRML trace text&#10;</xsl:text>
    <xsl:text> exposedField	SFVec3f		traceOffset	# VRML text position relative to entity&#10;</xsl:text>
    <xsl:text> exposedField	SFVec3f		traceSize	# VRML text scale&#10;</xsl:text>
    <xsl:text> field		SFBool		traceJava	# Java console tracing enabled?&#10;</xsl:text>
    <xsl:text> &#10;</xsl:text>
    <xsl:text> ] [#"EspduTransformPROTO.wrl#EspduTransform"	# local or remote URLs for the EXTERNPROTO&#10;</xsl:text>
    <xsl:text>  "file:///C:/vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "file:///D:/vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "file:///C|/vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "file:///D|/vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "file:///vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "file://vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "http://web.nps.navy.mil/~brutzman/vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "http://www.web3D.org/WorkingGroups/vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "C:\vrtp\mil\navy\nps\dis\EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "/vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../../mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../../vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../../../vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../../../../vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../../../../../vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../../../../../../vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../../vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../../../vrtp/mil/navy/nps/dis/EspduTransformPROTO.wrl#EspduTransform"&#10;</xsl:text>
    <xsl:text>   ]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="(//ReceiverPdu or //ProtoInstance[@name='ReceiverPdu']) and not(//ExternProtoDeclare[@name='ReceiverPdu'] or //ProtoDeclare[@name='ReceiverPdu'])">
    <xsl:text>EXTERNPROTO ReceiverPdu [&#10;</xsl:text>
    <xsl:text>  # nodeTypeHint Switch&#10;</xsl:text>
    <xsl:text>  # set whichGeometry to -1 for no geometry, 0 for text trace, 1 for default geometry&#10;</xsl:text>
    <xsl:text>  exposedField SFInt32 whichGeometry&#10;</xsl:text>
    <xsl:text>  # Initialization fields&#10;</xsl:text>
    <xsl:text>  field SFTime readInterval&#10;</xsl:text>
    <xsl:text>  field SFTime writeInterval&#10;</xsl:text>
    <xsl:text>  field SFInt32 siteID&#10;</xsl:text>
    <xsl:text>  field SFInt32 applicationID&#10;</xsl:text>
    <xsl:text>  field SFInt32 entityID&#10;</xsl:text>
    <xsl:text>  field SFString address&#10;</xsl:text>
    <xsl:text>  field SFInt32 port&#10;</xsl:text>
    <xsl:text>  field SFString multicastRelayHost&#10;</xsl:text>
    <xsl:text>  field SFInt32 multicastRelayPort&#10;</xsl:text>
    <xsl:text>  field SFBool rtpHeaderExpected&#10;</xsl:text>
    <xsl:text>  field SFBool traceJava&#10;</xsl:text>
    <xsl:text>  # Generic events&#10;</xsl:text>
    <xsl:text>  eventOut SFBool active&#10;</xsl:text>
    <xsl:text>  eventOut SFTime timestamp&#10;</xsl:text>
    <xsl:text>  eventOut SFBool rtpHeaderHeard&#10;</xsl:text>
    <xsl:text>  # RadioCommunicationsFamily events&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 radioID&#10;</xsl:text>
    <xsl:text>  # ReceiverPdu fields&#10;</xsl:text>
    <xsl:text>  eventOut SFFloat receiverPower&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 receiverState&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 transmitterSiteID&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 transmitterApplicationID&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 transmitterEntityID&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 transmitterRadioID&#10;</xsl:text>
    <xsl:text>][&#10;</xsl:text>
    <xsl:text>  "RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "http://web.nps.navy.mil/~brutzman/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "http://www.web3D.org/WorkingGroups/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "RadioCommunicationsPrototypes.xml#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "http://web.nps.navy.mil/~brutzman/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.xml#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "http://www.web3D.org/WorkingGroups/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.xml#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "file:///C:/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "file:///D:/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "file:///C|/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "file:///D|/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "file:///vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "file://vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "http://web.nps.navy.mil/~brutzman/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "http://www.web3D.org/WorkingGroups/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "C:\vrtp\mil\navy\nps\dis\RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../../mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#ReceiverPdu"&#10;</xsl:text>
    <xsl:text>]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="(//SignalPdu or //ProtoInstance[@name='SignalPdu']) and not(//ExternProtoDeclare[@name='SignalPdu'] or //ProtoDeclare[@name='SignalPdu'])">
    <xsl:text>EXTERNPROTO SignalPdu [&#10;</xsl:text>
    <xsl:text>  # nodeTypeHint Switch&#10;</xsl:text>
    <xsl:text>  # set whichGeometry to -1 for no geometry, 0 for text trace, 1 for default geometry&#10;</xsl:text>
    <xsl:text>  exposedField SFInt32 whichGeometry&#10;</xsl:text>
    <xsl:text>  # Initialization fields&#10;</xsl:text>
    <xsl:text>  field SFTime readInterval&#10;</xsl:text>
    <xsl:text>  field SFTime writeInterval&#10;</xsl:text>
    <xsl:text>  field SFInt32 siteID&#10;</xsl:text>
    <xsl:text>  field SFInt32 applicationID&#10;</xsl:text>
    <xsl:text>  field SFInt32 entityID&#10;</xsl:text>
    <xsl:text>  field SFString address&#10;</xsl:text>
    <xsl:text>  field SFInt32 port&#10;</xsl:text>
    <xsl:text>  field SFString multicastRelayHost&#10;</xsl:text>
    <xsl:text>  field SFInt32 multicastRelayPort&#10;</xsl:text>
    <xsl:text>  field SFBool rtpHeaderExpected&#10;</xsl:text>
    <xsl:text>  field SFBool traceJava&#10;</xsl:text>
    <xsl:text>  # Generic events&#10;</xsl:text>
    <xsl:text>  eventOut SFBool active&#10;</xsl:text>
    <xsl:text>  eventOut SFTime timestamp&#10;</xsl:text>
    <xsl:text>  eventOut SFBool rtpHeaderHeard&#10;</xsl:text>
    <xsl:text>  # RadioCommunicationsFamily events&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 radioID&#10;</xsl:text>
    <xsl:text>  # SignalPdu fields&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 encodingScheme&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 tdlType&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 sampleRate&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 samples&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 dataLength&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data00&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data01&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data02&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data03&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data04&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data05&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data06&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data07&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data08&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data09&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 data10&#10;</xsl:text>
    <xsl:text>][&#10;</xsl:text>
    <xsl:text>  "RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "http://web.nps.navy.mil/~brutzman/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "http://www.web3D.org/WorkingGroups/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "RadioCommunicationsPrototypes.xml#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "http://web.nps.navy.mil/~brutzman/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.xml#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "http://www.web3D.org/WorkingGroups/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.xml#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "file:///C:/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "file:///D:/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "file:///C|/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "file:///D|/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "file:///vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "file://vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "http://web.nps.navy.mil/~brutzman/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "http://www.web3D.org/WorkingGroups/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "C:\vrtp\mil\navy\nps\dis\RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../../mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#SignalPdu"&#10;</xsl:text>
    <xsl:text>]&#10;</xsl:text>
  </xsl:if>
  <xsl:if test="(//TransmitterPdu or //ProtoInstance[@name='TransmitterPdu']) and not(//ExternProtoDeclare[@name='TransmitterPdu'] or //ProtoDeclare[@name='TransmitterPdu'])">
    <xsl:text>EXTERNPROTO TransmitterPdu [&#10;</xsl:text>
    <xsl:text>  # nodeTypeHint Switch&#10;</xsl:text>
    <xsl:text>  # set whichGeometry to -1 for no geometry, 0 for text trace, 1 for default geometry&#10;</xsl:text>
    <xsl:text>  exposedField SFInt32 whichGeometry&#10;</xsl:text>
    <xsl:text>  # Initialization fields&#10;</xsl:text>
    <xsl:text>  field SFTime readInterval&#10;</xsl:text>
    <xsl:text>  field SFTime writeInterval&#10;</xsl:text>
    <xsl:text>  field SFInt32 siteID&#10;</xsl:text>
    <xsl:text>  field SFInt32 applicationID&#10;</xsl:text>
    <xsl:text>  field SFInt32 entityID&#10;</xsl:text>
    <xsl:text>  field SFString address&#10;</xsl:text>
    <xsl:text>  field SFInt32 port&#10;</xsl:text>
    <xsl:text>  field SFString multicastRelayHost&#10;</xsl:text>
    <xsl:text>  field SFInt32 multicastRelayPort&#10;</xsl:text>
    <xsl:text>  field SFBool rtpHeaderExpected&#10;</xsl:text>
    <xsl:text>  field SFBool traceJava&#10;</xsl:text>
    <xsl:text>  # Generic events&#10;</xsl:text>
    <xsl:text>  eventOut SFBool active&#10;</xsl:text>
    <xsl:text>  eventOut SFTime timestamp&#10;</xsl:text>
    <xsl:text>  eventOut SFBool rtpHeaderHeard&#10;</xsl:text>
    <xsl:text>  # RadioCommunicationsFamily events&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 radioID&#10;</xsl:text>
    <xsl:text>  # TransmitterPdu fields&#10;</xsl:text>
    <xsl:text>  eventOut SFVec3f antennaLocation&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 antennaPatternLength&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 antennaPatternType&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 cryptoKeyId&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 cryptoSytem&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 frequency&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 lengthOfModulationParameters&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 modulationTypeDetail&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 modulationTypeMajor&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 modulationTypeSpreadSpectrum&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 modulationTypeSystem&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 power&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 radioEntityTypeCategory&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 radioEntityTypeCountry&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 radioEntityTypeDomain&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 radioEntityTypeKind&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 radioEntityTypeNomenclature&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 radioEntityTypeNomenclatureVersion&#10;</xsl:text>
    <xsl:text>  eventOut SFVec3f relativeAntennaLocation&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 transmitFrequencyBandwidth&#10;</xsl:text>
    <xsl:text>  eventOut SFInt32 transmitState&#10;</xsl:text>
    <xsl:text>][&#10;</xsl:text>
    <xsl:text>  "RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "http://web.nps.navy.mil/~brutzman/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "http://www.web3D.org/WorkingGroups/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "RadioCommunicationsPrototypes.xml#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "http://web.nps.navy.mil/~brutzman/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.xml#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "http://www.web3D.org/WorkingGroups/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.xml#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "file:///C:/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "file:///D:/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "file:///C|/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "file:///D|/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "file:///vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "file://vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "http://web.nps.navy.mil/~brutzman/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "http://www.web3D.org/WorkingGroups/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "C:\vrtp\mil\navy\nps\dis\RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "/vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../../mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>  "../../../../../../../../../../vrtp/mil/navy/nps/dis/RadioCommunicationsPrototypes.wrl#TransmitterPdu"&#10;</xsl:text>
    <xsl:text>]&#10;</xsl:text>
  </xsl:if>
  <!-- continue with rest of scene, now that header and profile EXTERNPROTOs complete -->
  <xsl:apply-templates/>
</xsl:template>


<!-- ****** recurse through each of the tree node elements ****** -->
<xsl:template match="*">
  <xsl:param name="indent" select="0"/>
  <!-- <xsl:text># $indent=</xsl:text><xsl:value-of select="$indent"/><xsl:text>### &#10;</xsl:text> -->
  <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
  <!-- figure out node type for ProtoDeclared ProtoInstance, ExternProtoDeclared ProtoInstance and internal DTD declaration tag definitions -->
  <xsl:variable name="nodeName" select="./@name" />
  <xsl:variable name="nodeName2" select="local-name()" />
  <xsl:variable name="parentNodeName" select="../@name" />
  <xsl:variable name="parentNodeName2" select="local-name(..)" />
  <!-- ProtoDeclared ProtoInstance -->
  <xsl:variable name="nodeType" select="local-name(//ProtoDeclare[@name=$nodeName or @name=$nodeName2]/*[local-name()!='field'])" />
  <xsl:variable name="parentType" select="local-name(//ProtoDeclare[@name=$parentNodeName]/*[local-name()!='field'])" />
  <!-- ExternProtoDeclared ProtoInstance -->
  <xsl:variable name="EPnodeType" select="//ExternProtoDeclare[@name=$nodeName or @name=$nodeName2]/@nodeTypeHint" />
  <xsl:variable name="EPparentType" select="//ExternProtoDeclare[@name=$parentNodeName]/@nodeTypeHint" />
  <!-- debug diagnosis statements -->
    <!-- <xsl:text># parentNodeName </xsl:text><xsl:value-of select="$parentNodeName"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># parentNodeName2 </xsl:text><xsl:value-of select="$parentNodeName2"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># nodeName </xsl:text><xsl:value-of select="$nodeName"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># nodeName2 </xsl:text><xsl:value-of select="$nodeName2"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:if test="$nodeName"><xsl:text># $nodeName </xsl:text><xsl:value-of select="$nodeName"/><xsl:text>&#10;</xsl:text></xsl:if> -->
    <!-- <xsl:text># local-name() </xsl:text><xsl:value-of select="local-name()"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># nodeType </xsl:text><xsl:value-of select="$nodeType"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># parentType </xsl:text><xsl:value-of select="$parentType"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># EPnodeType </xsl:text><xsl:value-of select="$EPnodeType"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># EPparentType </xsl:text><xsl:value-of select="$EPparentType"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># @nodeTypeHint </xsl:text><xsl:value-of select="@nodeTypeHint"/><xsl:text>&#10;</xsl:text> -->
  <!-- if this is a non-(PROTO/field/fieldValue) child node, first output appropriate VRML 97 'field' name -->
  <xsl:if test="(local-name(..)!='Scene' and
                 local-name(..)!='ProtoDeclare' and
                 local-name(..)!='field' and
                 local-name(..)!='fieldValue')">
    <xsl:choose>
      <!-- 4-way node-type tests:  native VRML node, ProtoDeclared ProtoInstance, ExternProtoDeclared ProtoInstance, or internal DTD declaration by content -->
      <xsl:when test="local-name()='Appearance'        or $nodeType='Appearance'        or $EPnodeType='Appearance'        or @nodeTypeHint='Appearance'       "><xsl:text>appearance </xsl:text></xsl:when>
      <xsl:when test="local-name()='AudioClip'         or $nodeType='AudioClip'         or $EPnodeType='AudioClip'         or @nodeTypeHint='AudioClip'        "><xsl:text>source </xsl:text></xsl:when>
      <xsl:when test="local-name()='Box'               or $nodeType='Box'               or $EPnodeType='Box'               or @nodeTypeHint='Box'              "><xsl:text>geometry </xsl:text></xsl:when>
      <xsl:when test="local-name()='Color'             or $nodeType='Color'             or $EPnodeType='Color'             or @nodeTypeHint='Color'            "><xsl:text>color </xsl:text></xsl:when>
      <xsl:when test="local-name()='ColorNode'         or $nodeType='ColorNode'         or $EPnodeType='ColorNode'         or @nodeTypeHint='ColorNode'            "><xsl:text>color </xsl:text></xsl:when>
      <xsl:when test="local-name()='Coordinate'        or $nodeType='Coordinate'        or $EPnodeType='Coordinate'        or @nodeTypeHint='Coordinate' or
	              local-name()='GeoCoordinate'     or $nodeType='GeoCoordinate'     or $EPnodeType='GeoCoordinate'     or @nodeTypeHint='GeoCoordinate'    "><xsl:text>coord </xsl:text></xsl:when>
      <xsl:when test="local-name()='Cone'              or $nodeType='Cone'              or $EPnodeType='Cone'              or @nodeTypeHint='Cone'             "><xsl:text>geometry </xsl:text></xsl:when>
      <xsl:when test="local-name()='Cylinder'          or $nodeType='Cylinder'          or $EPnodeType='Cylinder'          or @nodeTypeHint='Cylinder'         "><xsl:text>geometry </xsl:text></xsl:when>
      <xsl:when test="local-name()='ElevationGrid'     or $nodeType='ElevationGrid'     or $EPnodeType='ElevationGrid'     or @nodeTypeHint='ElevationGrid' or
	              local-name()='GeoElevationGrid'  or $nodeType='GeoElevationGrid'  or $EPnodeType='GeoElevationGrid'  or @nodeTypeHint='GeoElevationGrid' "><xsl:text>geometry </xsl:text></xsl:when>
      <xsl:when test="local-name()='Extrusion'         or $nodeType='Extrusion'         or $EPnodeType='Extrusion'         or @nodeTypeHint='Extrusion'        "><xsl:text>geometry </xsl:text></xsl:when>
      <xsl:when test="local-name()='FontStyle'         or $nodeType='FontStyle'         or $EPnodeType='FontStyle'         or @nodeTypeHint='FontStyle'        "><xsl:text>fontStyle </xsl:text></xsl:when>
      <xsl:when test="local-name()='ImageTexture'      or $nodeType='ImageTexture'      or $EPnodeType='ImageTexture'      or @nodeTypeHint='ImageTexture'     "><xsl:text>texture </xsl:text></xsl:when>
      <xsl:when test="local-name()='IndexedFaceSet'    or $nodeType='IndexedFaceSet'    or $EPnodeType='IndexedFaceSet'    or @nodeTypeHint='IndexedFaceSet'   "><xsl:text>geometry </xsl:text></xsl:when>
      <xsl:when test="local-name()='IndexedLineSet'    or $nodeType='IndexedLineSet'    or $EPnodeType='IndexedLineSet'    or @nodeTypeHint='IndexedLineSet'   "><xsl:text>geometry </xsl:text></xsl:when>
      <xsl:when test="local-name()='Material'          or $nodeType='Material'          or $EPnodeType='Material'          or @nodeTypeHint='Material'         "><xsl:text>material </xsl:text></xsl:when>
      <xsl:when test="(local-name()='MovieTexture'     or $nodeType='MovieTexture'      or $EPnodeType='MovieTexture'      or @nodeTypeHint='MovieTexture')
                  and (local-name(..)='Appearance'     or $parentType='Appearance'      or $EPparentType='Appearance'      or ../@nodeTypeHint='Appearance' or
                       local-name(..)='texture')   "><xsl:text>texture </xsl:text></xsl:when>
      <xsl:when test="(local-name()='MovieTexture'     or $nodeType='MovieTexture'      or $EPnodeType='MovieTexture'      or @nodeTypeHint='MovieTexture')
                  and (local-name(..)='Sound'          or $parentType='Sound'           or $EPparentType='Sound'           or ../@nodeTypeHint='Sound'      or
                       local-name(..)='source')   "><xsl:text>source </xsl:text></xsl:when>
      <xsl:when test="local-name()='Normal'            or $nodeType='Normal'            or $EPnodeType='Normal'            or @nodeTypeHint='Normal'           "><xsl:text>normal </xsl:text></xsl:when>
      <xsl:when test="local-name()='PixelTexture'      or $nodeType='PixelTexture'      or $EPnodeType='PixelTexture'      or @nodeTypeHint='PixelTexture'     "><xsl:text>texture </xsl:text></xsl:when>
      <xsl:when test="local-name()='PointSet'          or $nodeType='PointSet'          or $EPnodeType='PointSet'          or @nodeTypeHint='PointSet'         "><xsl:text>geometry </xsl:text></xsl:when>
      <xsl:when test="local-name()='Sphere'            or $nodeType='Sphere'            or $EPnodeType='Sphere'            or @nodeTypeHint='Sphere'           "><xsl:text>geometry </xsl:text></xsl:when>
      <xsl:when test="local-name()='Text'              or $nodeType='Text'              or $EPnodeType='Text'              or @nodeTypeHint='Text'             "><xsl:text>geometry </xsl:text></xsl:when>
      <xsl:when test="local-name()='TextureCoordinate' or $nodeType='TextureCoordinate' or $EPnodeType='TextureCoordinate' or @nodeTypeHint='TextureCoordinate'"><xsl:text>texCoord </xsl:text></xsl:when>
      <xsl:when test="local-name()='TextureTransform'  or $nodeType='TextureTransform'  or $EPnodeType='TextureTransform'  or @nodeTypeHint='TextureTransform' "><xsl:text>textureTransform </xsl:text></xsl:when>
      <!-- regular VRML nodes not needing a preceding field name -->
      <!-- (split following test to avoid overflowing lotusxml/Xalan string buffer) -->
      <xsl:when test="
         contains(local-name(), 'Interpolator') or contains($nodeType, 'Interpolator') or contains($EPnodeType, 'Interpolator') or contains(@nodeTypeHint, 'Interpolator') or
         contains(local-name(), 'Light')        or contains($nodeType, 'Light')        or contains($EPnodeType, 'Light')        or contains(@nodeTypeHint, 'Light')        or
         contains(local-name(), 'Sensor')       or contains($nodeType, 'Sensor')       or contains($EPnodeType, 'Sensor')       or contains(@nodeTypeHint, 'Sensor')       or
         local-name()='NavigationInfo' or $nodeType='NavigationInfo' or $EPnodeType='NavigationInfo' or @nodeTypeHint='NavigationInfo' or
         local-name()='Anchor'        or $nodeType='Anchor'        or $EPnodeType='Anchor'        or @nodeTypeHint='Anchor'        or
         local-name()='Background'    or $nodeType='Background'    or $EPnodeType='Background'    or @nodeTypeHint='Background'    or
         local-name()='Billboard'     or $nodeType='Billboard'     or $EPnodeType='Billboard'     or @nodeTypeHint='Billboard'     or
         local-name()='Collision'     or $nodeType='Collision'     or $EPnodeType='Collision'     or @nodeTypeHint='Collision'     or
         local-name()='Fog'           or $nodeType='Fog'           or $EPnodeType='Fog'           or @nodeTypeHint='Fog'           or
         local-name()='Group'         or $nodeType='Group'         or $EPnodeType='Group'         or @nodeTypeHint='Group'         or
         local-name()='Inline'        or $nodeType='Inline'        or $EPnodeType='Inline'        or @nodeTypeHint='Inline'">
         <!-- appears to be a valid node, no warning required --></xsl:when>
      <xsl:when test="
         local-name()='LOD'           or $nodeType='LOD'           or $EPnodeType='LOD'           or @nodeTypeHint='LOD'           or
         local-name()='proxy'         or $nodeType='proxy'         or $EPnodeType='proxy'         or @nodeTypeHint='proxy'         or
         local-name()='Transform'     or $nodeType='Transform'     or $EPnodeType='Transform'     or @nodeTypeHint='Transform'     or
         local-name()='Script'        or $nodeType='Script'        or $EPnodeType='Script'        or @nodeTypeHint='Script'        or
         local-name()='Shape'         or $nodeType='Shape'         or $EPnodeType='Shape'         or @nodeTypeHint='Shape'         or
         local-name()='Sound'         or $nodeType='Sound'         or $EPnodeType='Sound'         or @nodeTypeHint='Sound'         or
         local-name()='Switch'        or $nodeType='Switch'        or $EPnodeType='Switch'        or @nodeTypeHint='Switch'        or
         local-name()='Viewpoint'     or $nodeType='Viewpoint'     or $EPnodeType='Viewpoint'     or @nodeTypeHint='Viewpoint'     or
         local-name()='WorldInfo'     or $nodeType='WorldInfo'     or $EPnodeType='WorldInfo'     or @nodeTypeHint='WorldInfo'">
         <!-- appears to be a valid node, no warning required --></xsl:when>
      <xsl:when test="
         local-name()='Displacer'     or $nodeType='Displacer'     or $EPnodeType='Displacer'     or @nodeTypeHint='Displacer'     or
         local-name()='Humanoid'      or $nodeType='Humanoid'      or $EPnodeType='Humanoid'      or @nodeTypeHint='Humanoid'      or
         local-name()='joint'         or $nodeType='joint'         or $EPnodeType='joint'         or @nodeTypeHint='Joint'         or
         local-name()='Segment'       or $nodeType='Segment'       or $EPnodeType='Segment'       or @nodeTypeHint='Segment'       or
         local-name()='Site'          or $nodeType='Site'          or $EPnodeType='Site'          or @nodeTypeHint='Site'      	   or
         local-name()='EspduTransform' or $nodeType='EspduTransform' or $EPnodeType='EspduTransform' or @nodeTypeHint='EspduTransform'	or
         local-name()='ReceiverPdu'    or $nodeType='ReceiverPdu'    or $EPnodeType='ReceiverPdu'    or @nodeTypeHint='ReceiverPdu'	or
         local-name()='SignalPdu'      or $nodeType='SignalPdu'      or $EPnodeType='SignalPdu'      or @nodeTypeHint='SignalPdu'	or
         local-name()='TransmitterPdu' or $nodeType='TransmitterPdu' or $EPnodeType='TransmitterPdu' or @nodeTypeHint='TransmitterPdu'">
         <!-- appears to be a valid node, no warning required --></xsl:when>
      <xsl:when test="$nodeType">
         <!-- appears to be a valid prototype or native tag node, output nodeTypeHint as field name -->
         <!-- <xsl:text># $nodeType&#10;</xsl:text> -->
         <xsl:value-of select="$nodeType"/><xsl:text> </xsl:text>
         </xsl:when>
      <xsl:when test="$EPnodeType">
         <!-- appears to be a valid prototype or native tag node, output nodeTypeHint as field name -->
         <!-- <xsl:text># $EPnodeType&#10;</xsl:text> -->
         <xsl:value-of select="$EPnodeType"/><xsl:text> </xsl:text>
         </xsl:when>
      <!-- bug in Xeena's XSL parser doesn't see @nodeTypeHint, add explicit checks for GeoVrml subnodes -->
      <xsl:when test="local-name()='GeoOrigin'">
         <xsl:text>geoOrigin </xsl:text>
         </xsl:when>
      <xsl:when test="local-name(..)='GeoLOD' and local-name()='rootNode'">
         <!-- no need to print rootNode out, just caught to avoid printing a warning -->
         </xsl:when>
      <xsl:when test="local-name(..)='Humanoid' and local-name()='humanoidBody'">
         <!-- no need to print humanoidBody out, just caught to avoid printing a warning -->
         </xsl:when>
      <xsl:when test="@nodeTypeHint">
         <!-- appears to be a valid prototype or native tag node, output nodeTypeHint as field name -->
         <!-- <xsl:text># @nodeTypeHint&#10;</xsl:text> -->
         <xsl:value-of select="@nodeTypeHint"/><xsl:text> </xsl:text>
         </xsl:when>
      <xsl:when test="local-name(.)='USE'">
         <!-- no action, better checks would be helpful here -->
         </xsl:when>
      <!-- otherwise report likely error condition on this EXTERNPROTO / internal-declaration node as pseudo fieldname -->
      <xsl:otherwise>
        <xsl:text>### XSL-translation warning:  nodeTypeHint unknown for </xsl:text>
        <xsl:value-of select="local-name()"/>
        <xsl:text>&#10;</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:if>
  <!-- DEF node name -->
  <xsl:if test="@DEF"><xsl:text>DEF </xsl:text><xsl:value-of select="@DEF"/><xsl:text> </xsl:text></xsl:if>
  <!-- output node name itself:  ensure not proxy; then output USE, or ProtoInstance name, or actual node name -->
  <xsl:choose>
    <xsl:when test="local-name()='proxy'"><!-- ignore, handled a few steps down --></xsl:when>
    <xsl:when test="(local-name()='USE' and @node)">
      <!-- don't forget the bloody wrapper tags!  children handled separately.  this section will need to be generalized for compact tagset form, or else have USE preclude wrapper-tag ignoring. -->
      <xsl:if test="local-name(..)='appearance' or local-name(..)='choice' or local-name(..)='color' or local-name(..)='coord' or 
		local-name(..)='fontStyle' or local-name(..)='geometry' or local-name(..)='level' or local-name(..)='material' or local-name(..)='normal' or 
		local-name(..)='source' or local-name(..)='texCoord' or local-name(..)='texture' or local-name(..)='textureTransform' or local-name(..)='sites'">
	<xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
	<xsl:value-of select="local-name(..)"/><xsl:text> </xsl:text><!-- output wrapper tag (except for children tag) -->
      </xsl:if>
      <xsl:text>USE </xsl:text><xsl:value-of select="@node"/>
      <xsl:text>&#10;</xsl:text>
    </xsl:when>
    <xsl:when test="(local-name()='USE')">
      <xsl:text>USE __??__ # XSL translator error:  node=&quot;DEFname&quot; not provided for USE&#10;</xsl:text>
    </xsl:when>
    <xsl:when test="@USE and *">
      <xsl:text>USE </xsl:text><xsl:value-of select="@USE"/>
      <xsl:text> # XSL-translation error:  no embedded node content allowed inside USE&#10;</xsl:text>
    </xsl:when>
    <xsl:when test="@USE">
      <xsl:text>USE </xsl:text>
      <xsl:value-of select="@USE"/>
      <xsl:text>&#10;</xsl:text>
    </xsl:when>
    <xsl:when test="local-name()='ProtoInstance'">
      <xsl:value-of select="@name"/>
      <xsl:text> {&#10;</xsl:text>
    </xsl:when>
    <xsl:when test="local-name()='ColorNode'">
      <xsl:text>Color {&#10;</xsl:text>
    </xsl:when>
    <!-- handle MFNode fields in supported profiles -->
    <xsl:when test="(local-name(..)='GeoLOD' and local-name()='rootNode') or
                    (local-name(..)='Segment' and local-name()='displacers') or
                    (local-name(..)='Humanoid' and
                      (local-name()='humanoidBody'))">
      <xsl:value-of select="local-name()"/>
      <xsl:choose>
        <xsl:when test="*">
          <xsl:text> [&#10;</xsl:text> <!-- # MFNode fields -->
        </xsl:when>
        <xsl:otherwise>
          <xsl:text> NULL&#10;</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <!-- take care of IS attribute definitions for SFNode/MFNode-type field declarations inside ProtoDeclarations -->
    <xsl:when test="@DEF and ancestor::*[local-name()='ProtoDeclare'] and not(local-name()='ProtoDeclare')">
      <xsl:value-of select="local-name ()"/>
      <xsl:text> {&#10;</xsl:text>
      <!-- pattern-match variables -->
      <xsl:variable name="DEFname" select="@DEF" />
      <!-- <xsl:variable name="fieldName" select="local-name()" /> -->
      <!-- <xsl:variable name="matchName" select="concat(@DEF,'.',local-name())" /> -->
      <!-- <xsl:text> # $DEFname   </xsl:text><xsl:value-of select="$DEFname"/><xsl:text>&#10;</xsl:text> -->
      <!-- <xsl:text> # $fieldName </xsl:text><xsl:value-of select="$fieldName"/><xsl:text>&#10;</xsl:text> -->
      <!-- <xsl:text> # $matchName </xsl:text><xsl:value-of select="$matchName"/><xsl:text>&#10;</xsl:text> -->
      <!-- <xsl:text> # ancestor PROTO field </xsl:text><xsl:value-of select="local-name(ancestor::*[local-name()='ProtoDeclare'])"/><xsl:text>&#10;</xsl:text> -->
      <!-- <xsl:text> # ProtoDeclare ancestor &quot;</xsl:text><xsl:value-of select="ancestor::*[local-name()='ProtoDeclare']/@name"/><xsl:text>&quot; found&#10;</xsl:text> -->
      <xsl:if test="local-name()!='Script'">
        <xsl:for-each select="ancestor::*[local-name()='ProtoDeclare']/field">
          <!-- <xsl:text> # node rule: @IS </xsl:text><xsl:value-of select="@IS"/><xsl:text>&#10;</xsl:text> -->
          <!-- <xsl:text> # (starts-with(@IS,concat($DEFname, '.')) </xsl:text><xsl:value-of select="starts-with(@IS,concat($DEFname, '.'))"/><xsl:text>&#10;</xsl:text> -->
          <!-- <xsl:text> # concat($DEFname, '.') </xsl:text><xsl:value-of select="concat($DEFname, '.')"/><xsl:text>&#10;</xsl:text> -->
          <!-- <xsl:text> # @type </xsl:text><xsl:value-of select="@type"/><xsl:text>&#10;</xsl:text> -->
          <!-- <xsl:text> # substring-after(@IS,'.') </xsl:text><xsl:value-of select="substring-after(@IS,'.')"/><xsl:text>&#10;</xsl:text> -->
          <xsl:if test="starts-with(@IS,concat($DEFname, '.')) or contains(@IS,concat(' ',$DEFname, '.'))">
             <!-- this choose rule seems to work when extracting appropriate substring when multiple IS references occur... -->
             <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
             <xsl:choose>
               <xsl:when test="contains(substring-after(@IS,concat($DEFname, '.')),' ')">
                 <xsl:value-of select="substring-before(substring-after(@IS,concat($DEFname, '.')),' ')"/>
               </xsl:when>
               <xsl:otherwise>
                 <xsl:value-of select="substring-after(@IS,concat($DEFname, '.'))"/>
               </xsl:otherwise>
             </xsl:choose>
             <xsl:text> IS </xsl:text>
             <xsl:value-of select="@name"/>
             <xsl:text>&#10;</xsl:text>
          </xsl:if>
        </xsl:for-each>
      </xsl:if>
    </xsl:when>
    <!-- take care of wrapper tags (type Node/Nodes) defined in ProtoDeclare or ExternProtoDeclare -->
    <xsl:when test="(//ProtoDeclare[@name=$parentNodeName or @name=$parentNodeName2]/field[@name=$nodeName and @type='Node']) or
                    (//ExternProtoDeclare[@name=$parentNodeName or @name=$parentNodeName2]/field[@name=$nodeName and @type='Node'])">
      <xsl:value-of select="local-name ()"/><xsl:text> </xsl:text>
    </xsl:when>
    <xsl:when test="(//ProtoDeclare[@name=$parentNodeName or @name=$parentNodeName2]/field[(@name=$nodeName or @name=$nodeName2) and @type='Nodes']) or
                    (//ExternProtoDeclare[@name=$parentNodeName or @name=$parentNodeName2]/field[(@name=$nodeName or @name=$nodeName2) and @type='Nodes'])">
      <xsl:value-of select="local-name ()"/><xsl:text> [</xsl:text>
    </xsl:when>
    <!-- not a proxy or a USE NodeDefName or a ProtoInstance:  so just output current node name and opening { -->
    <xsl:otherwise>
      <xsl:value-of select="local-name ()"/>
      <xsl:text> {&#10;</xsl:text> <!-- # *** otherwise clause -->
    </xsl:otherwise>
  </xsl:choose>
  <!-- ensure GeoOrigin handled before children, so that final close bracket ] doesn't encompass it -->
  <xsl:if test="(contains(local-name(),'Geo') or contains($nodeType,'Geo') or contains($EPnodeType,'Geo') or contains(nodeTypeHint,'Geo'))
  	and (GeoOrigin) and not(local-name()='GeoOrigin') ">
    <!-- <xsl:text># GeoOrigin found for </xsl:text><xsl:value-of select="local-name()"/><xsl:text>&#10;</xsl:text> -->
    <xsl:apply-templates select="GeoOrigin">
       <xsl:with-param name="indent" select="$indent + 2"/>
    </xsl:apply-templates>
  </xsl:if>
  <!-- ensure GeoLOD/rootNode handled before children, so that final close bracket ] doesn't encompass it -->
  <xsl:if test="(local-name()='GeoLOD' and './rootNode')">
    <!-- <xsl:text>&#10;# rootNode found for </xsl:text><xsl:value-of select="local-name()"/><xsl:text>&#10;</xsl:text> -->
    <xsl:apply-templates select="rootNode">
       <xsl:with-param name="indent" select="$indent + 2"/>
    </xsl:apply-templates>
  </xsl:if>
  <!-- match each of the attributes next, put this after children in case a referencing USE is employed -->
  <!-- get fields and sibling comment() nodes -->
  <xsl:apply-templates select="field | comment()[following-sibling::field]">
       <xsl:with-param name="indent" select="$indent + 2"/>
  </xsl:apply-templates>
  <xsl:apply-templates select="@*">
       <xsl:with-param name="indent" select="$indent + 2"/>
  </xsl:apply-templates>
  <!-- not working :(  <xsl:apply-templates select="fieldValue[not(@USE) and not(descendant-or-self::*/@USE)]"/> -->
  <!-- a check for implicit attributes in the matching IS tokens is needed here... -->
  <xsl:if test="local-name()='proxy'"><xsl:text>proxy </xsl:text></xsl:if>
  <!-- check if this node has children, if so add appropriate VRML 97 child-node indicator -->
  <xsl:if test="* or comment()">
    <xsl:choose>
      <!-- 4-way node-type tests:  native VRML node, ProtoDeclared ProtoInstance, ExternProtoDeclared ProtoInstance, or internal DTD declaration by content -->
      <xsl:when test="((local-name()='Anchor'    or $nodeType='Anchor'    or $EPnodeType='Anchor'    or @nodeTypeHint='Anchor'    or
                        local-name()='Billboard' or $nodeType='Billboard' or $EPnodeType='Billboard' or @nodeTypeHint='Billboard' or
                        local-name()='Collision' or $nodeType='Collision' or $EPnodeType='Collision' or @nodeTypeHint='Collision' or
                        local-name()='Group'     or $nodeType='Group'     or $EPnodeType='Group'     or @nodeTypeHint='Group'     or
                        local-name()='Transform' or $nodeType='Transform' or $EPnodeType='Transform' or @nodeTypeHint='Transform' or
                        local-name()='Contour2D' or $nodeType='Contour2D' or $EPnodeType='Contour2D' or @nodeTypeHint='Contour2D' or
                        local-name()='CoordinateDeformer' or $nodeType='CoordinateDeformer' or $EPnodeType='CoordinateDeformer' or @nodeTypeHint='CoordinateDeformer' or
                        local-name()='EspduTransform' 	or $nodeType='EspduTransform' or $EPnodeType='EspduTransform' or @nodeTypeHint='EspduTransform' or
                        local-name()='GeoInline'		or $nodeType='GeoInline' or $EPnodeType='GeoInline' or @nodeTypeHint='GeoInline' or
                        local-name()='GeoLocation'	or $nodeType='GeoLocation' or $EPnodeType='GeoLocation' or @nodeTypeHint='GeoLocation' or
                        local-name()='GeoLOD'		or $nodeType='GeoLOD' or $EPnodeType='GeoLOD' or @nodeTypeHint='GeoLOD' or
                        local-name()='Joint'		or $nodeType='Joint' or $EPnodeType='Joint' or @nodeTypeHint='Joint' or
                        local-name()='NurbsGroup' 	or $nodeType='NurbsGroup' or $EPnodeType='NurbsGroup' or @nodeTypeHint='NurbsGroup' or
                        local-name()='ReceiverPdu'	or $nodeType='ReceiverPdu' or $EPnodeType='ReceiverPdu' or @nodeTypeHint='ReceiverPdu' or
                        local-name()='Segment'		or $nodeType='Segment' or $EPnodeType='Segment' or @nodeTypeHint='Segment' or
                        local-name()='SignalPdu'		or $nodeType='SignalPdu' or $EPnodeType='SignalPdu' or @nodeTypeHint='SignalPdu' or
                        local-name()='Site'		or $nodeType='Site' or $EPnodeType='Site' or @nodeTypeHint='Site' or
                        local-name()='TransmitterPdu'	or $nodeType='TransmitterPdu' or $EPnodeType='TransmitterPdu' or @nodeTypeHint='TransmitterPdu')
                       and (children or ./*[local-name()!='proxy' and local-name()!='fieldValue' and local-name()!='GeoOrigin' and local-name()!='rootNode'])
                       and not (local-name()='ProtoInstance' and @name='Humanoid')
                      )
                      or children">
        <!-- consider various child and prototype cases.  must work wrapped or unwrapped!  -->
        <xsl:choose>
          <xsl:when test="children/*[local-name()!='proxy']">
            <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
            <xsl:text>children [&#10;</xsl:text>
            <xsl:apply-templates select="children/*[local-name()!='proxy']">
              <xsl:with-param name="indent" select="$indent + 2"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:when test="fieldValue[@name='children']/*">
            <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
            <xsl:text>children [</xsl:text>
            <xsl:text> # found fieldValue[@name='children']/* </xsl:text> <!-- -->
            <xsl:text>&#10;</xsl:text>
            <xsl:apply-templates select="fieldValue[@name='children']/*">
              <xsl:with-param name="indent" select="$indent + 2"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:when test="children">
            <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
            <xsl:text>children NULL&#10;</xsl:text>
          </xsl:when>
          <!-- unwrapped children -->
          <xsl:when test="*[local-name()!='proxy' and local-name()!='fieldValue' and local-name()!='GeoOrigin' and local-name()!='rootNode']">
            <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
            <xsl:text>children [</xsl:text>
            <!-- <xsl:text> # unwrapped children</xsl:text> -->
            <xsl:text>&#10;</xsl:text>
            <!-- <xsl:for-each select="*[local-name()!='proxy' and local-name()!='fieldValue' and local-name()!='GeoOrigin' and local-name()!='rootNode']"><xsl:text>&#10;#=== </xsl:text><xsl:value-of select="local-name()"/><xsl:text>&#10;</xsl:text></xsl:for-each> -->
            <xsl:apply-templates select="*[local-name()!='proxy' and local-name()!='fieldValue' and local-name()!='GeoOrigin' and local-name()!='rootNode']">
              <xsl:with-param name="indent" select="$indent + 2"/>
            </xsl:apply-templates>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="(local-name()='LOD'       or $nodeType='LOD'       or $EPnodeType='LOD'       or @nodeTypeHint='LOD')
                      and (level/* or *[local-name()!='fieldValue'])">
        <xsl:choose>
          <xsl:when test="level/*">
            <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
            <xsl:text>level [&#10;</xsl:text>
            <xsl:apply-templates select="level">
              <xsl:with-param name="indent" select="$indent + 2"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:when test="level">
            <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
            <xsl:text>level NULL&#10;</xsl:text>
            <xsl:apply-templates select="level">
              <xsl:with-param name="indent" select="$indent + 2"/>
            </xsl:apply-templates>
          </xsl:when>
          <!-- unwrapped children -->
          <xsl:when test="*[local-name()!='fieldValue']">
            <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
            <xsl:text>level [&#10;</xsl:text>
            <xsl:apply-templates select="*[local-name()!='fieldValue']">
              <xsl:with-param name="indent" select="$indent + 2"/>
            </xsl:apply-templates>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="(local-name()='Switch'    or $nodeType='Switch'    or $EPnodeType='Switch'    or @nodeTypeHint='Switch')
                      and (choice/* or *[local-name()!='fieldValue'])">
        <xsl:choose>
          <xsl:when test="choice/*">
            <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
            <xsl:text>choice [&#10;</xsl:text>
            <xsl:apply-templates select="choice">
              <xsl:with-param name="indent" select="$indent + 2"/>
            </xsl:apply-templates>
          </xsl:when>
          <xsl:when test="choice">
            <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
            <xsl:text>choice NULL&#10;</xsl:text>
            <xsl:apply-templates select="choice">
              <xsl:with-param name="indent" select="$indent + 2"/>
            </xsl:apply-templates>
          </xsl:when>
          <!-- unwrapped children -->
          <xsl:when test="*[local-name()!='fieldValue']">
            <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
            <xsl:text>choice [&#10;</xsl:text>
            <xsl:apply-templates select="*[local-name()!='fieldValue']">
              <xsl:with-param name="indent" select="$indent + 2"/>
            </xsl:apply-templates>
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <!-- recurse on non-proxy, non-fieldValue, non-children, non-level, non-range child nodes -->
        <!-- this rule is unnecessary for unwrapped compact-version tagset -->
        <!-- <xsl:text># ***** otherwise recurse on other tags&#10;</xsl:text> -->
        <xsl:apply-templates select="*[(local-name()!='proxy' and local-name()!='field' and local-name()!='fieldValue'
             and local-name()!='children' and local-name()!='level' and local-name()!='choice'
             and local-name()!='GeoOrigin' and local-name()!='rootNode' and local-name(..)!='Humanoid')]
             | comment()[not(following-sibling::field)]">
           <xsl:with-param name="indent" select="$indent + 2"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="*[local-name(..)='Humanoid' and local-name()='humanoidBody']">
           <xsl:with-param name="indent" select="$indent + 2"/>
        </xsl:apply-templates>
        </xsl:otherwise>
    </xsl:choose>
    <!-- check if this is a parent grouping node (and not a USE) then add children close ] -->
    <!-- 4-way node-type tests:  native VRML node, ProtoDeclared ProtoInstance, ExternProtoDeclared ProtoInstance, or internal DTD declaration by content -->
    <xsl:variable name="otherChildrenFoundTest1" select="not(@USE) and
               ((local-name()='GeoInline'      or $nodeType='GeoInline'      or $EPnodeType='GeoInline'      or @nodeTypeHint='GeoInline'   or
                 local-name()='GeoLocation'    or $nodeType='GeoLocation'    or $EPnodeType='GeoLocation'    or @nodeTypeHint='GeoLocation' or
                 local-name()='GeoLOD'         or $nodeType='GeoLOD'         or $EPnodeType='GeoLOD'         or @nodeTypeHint='GeoLOD' or
                 local-name()='Joint'          or $nodeType='Joint'          or $EPnodeType='Joint'          or @nodeTypeHint='Joint' or
                 local-name()='Segment'        or $nodeType='Segment'        or $EPnodeType='Segment'        or @nodeTypeHint='Segment' or
                 local-name()='Site'           or $nodeType='Site'           or $EPnodeType='Site'           or @nodeTypeHint='Site' or
                 local-name()='EspduTransform' or $nodeType='EspduTransform' or $EPnodeType='EspduTransform' or @nodeTypeHint='EspduTransform' or
                 local-name()='Contour2D' or $nodeType='Contour2D' or $EPnodeType='Contour2D' or @nodeTypeHint='Contour2D' or
                 local-name()='CoordinateDeformer' or $nodeType='CoordinateDeformer' or $EPnodeType='CoordinateDeformer' or @nodeTypeHint='CoordinateDeformer' or
                 local-name()='NurbsGroup'         or $nodeType='NurbsGroup' or $EPnodeType='NurbsGroup' or @nodeTypeHint='NurbsGroup' or
                 local-name()='ReceiverPdu'        or $nodeType='ReceiverPdu' or $EPnodeType='ReceiverPdu' or @nodeTypeHint='ReceiverPdu' or
                 local-name()='SignalPdu'          or $nodeType='SignalPdu' or $EPnodeType='SignalPdu' or @nodeTypeHint='SignalPdu' or
                 local-name()='TransmitterPdu'     or $nodeType='TransmitterPdu' or $EPnodeType='TransmitterPdu' or @nodeTypeHint='TransmitterPdu')
                 and *[local-name()!='GeoOrigin' and local-name()!='rootNode'])
                "/>
    <xsl:variable name="otherChildrenFoundTest2" select="not(@USE) and
               (((local-name(..)='GeoLOD' and local-name()='rootNode' and *) or
                 (local-name(..)='Segment') and local-name()='displacers' or
                 (local-name(..)='Humanoid' and
                      (local-name()='humanoidBody' or local-name()='joints' or
                       local-name()='segments'     or local-name()='sites'  or
                       local-name()='viewpoints'))
                ) and * )
                "/>
    <!-- <xsl:text> # $otherChildrenFoundTest1 </xsl:text><xsl:value-of select="$otherChildrenFoundTest1"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text> # $otherChildrenFoundTest2 </xsl:text><xsl:value-of select="$otherChildrenFoundTest2"/><xsl:text>&#10;</xsl:text> -->
    <xsl:if test="not(@USE) and
              (((local-name()='Anchor'         or $nodeType='Anchor'         or $EPnodeType='Anchor'         or @nodeTypeHint='Anchor'      or
                 local-name()='Billboard'      or $nodeType='Billboard'      or $EPnodeType='Billboard'      or @nodeTypeHint='Billboard'   or
                 local-name()='Collision'      or $nodeType='Collision'      or $EPnodeType='Collision'      or @nodeTypeHint='Collision'   or
                 local-name()='Group'          or $nodeType='Group'          or $EPnodeType='Group'          or @nodeTypeHint='Group'       or
                 local-name()='Transform'      or $nodeType='Transform'      or $EPnodeType='Transform'      or @nodeTypeHint='Transform'   or
                 local-name()='Inline'         or $nodeType='Inline'         or $EPnodeType='Inline'         or @nodeTypeHint='Inline')
                 and (children/* or *[local-name()!='proxy' and local-name()!='fieldValue' and local-name()!='GeoOrigin' and local-name()!='rootNode'])
                 and not (local-name()='ProtoInstance' and @name='Humanoid')) or
               ((local-name()='LOD'       or $nodeType='LOD'       or $EPnodeType='LOD'       or @nodeTypeHint='LOD')
                 and (level/*  or *[local-name()!='fieldValue'])) or
               ((local-name()='Switch'    or $nodeType='Switch'    or $EPnodeType='Switch'    or @nodeTypeHint='Switch')
                 and (choice/* or *[local-name()!='fieldValue'])) or
               (//ProtoDeclare[@name=$parentNodeName or @name=$parentNodeName2]/field[(@name=$nodeName or @name=$nodeName2) and @type='Nodes']) or
               (//ExternProtoDeclare[@name=$parentNodeName or @name=$parentNodeName2]/field[(@name=$nodeName or @name=$nodeName2) and @type='Nodes']) or
               $otherChildrenFoundTest1 or $otherChildrenFoundTest2)
                ">
      <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent + 2"/></xsl:call-template>
      <xsl:text>]</xsl:text>
      <!-- <xsl:text> # local-name()=</xsl:text><xsl:value-of select="local-name()"/> -->
      <xsl:text>&#10;</xsl:text>
    </xsl:if>
  </xsl:if>
  <!-- proxy test & output, put this after children in case a referencing USE is employed -->
  <xsl:if test="(local-name()='Collision' or $nodeType='Collision' or $EPnodeType='Collision' or @nodeTypeHint='Collision') and ./proxy">
    <xsl:apply-templates select="proxy">
      <xsl:with-param name="indent" select="$indent + 2"/>
    </xsl:apply-templates>
  </xsl:if>
  <!-- output fieldValues that contain @USE last in case USEd nodes are referenced in adjacent siblings. -->
  <xsl:apply-templates select="fieldValue"> <!-- [@name!='children'] -->
    <xsl:with-param name="indent" select="$indent + 2"/>
  </xsl:apply-templates>
  <!-- ensure Humanoid child nodes handled after children, so that USE values are available -->
  <xsl:if test="local-name()='Humanoid' ">
    <xsl:if test="joints/* or Joint">
      <xsl:text>joints [&#10;</xsl:text>
      <xsl:apply-templates select="joints/*"><xsl:with-param name="indent" select="$indent + 2"/></xsl:apply-templates>
      <xsl:apply-templates select="Joint"><xsl:with-param name="indent" select="$indent + 2"/></xsl:apply-templates>
      <xsl:text>]&#10;</xsl:text>
    </xsl:if>
    <xsl:if test="segments/* or Segment">
      <xsl:text>segments [&#10;</xsl:text>
      <xsl:apply-templates select="segments/*"><xsl:with-param name="indent" select="$indent + 2"/></xsl:apply-templates>
      <xsl:apply-templates select="Segment"><xsl:with-param name="indent" select="$indent + 2"/></xsl:apply-templates>
      <xsl:text>]&#10;</xsl:text>
    </xsl:if>
    <xsl:if test="sites/* or Site">
      <xsl:text>sites [&#10;</xsl:text>
      <xsl:apply-templates select="sites/*"><xsl:with-param name="indent" select="$indent + 2"/></xsl:apply-templates>
      <xsl:apply-templates select="Site"><xsl:with-param name="indent" select="$indent + 2"/></xsl:apply-templates>
      <xsl:text>]&#10;</xsl:text>
    </xsl:if>
    <xsl:if test="viewpoints/* or Viewpoint">
      <xsl:text>viewpoints [&#10;</xsl:text>
      <xsl:apply-templates select="viewpoints/*"><xsl:with-param name="indent" select="$indent + 2"/></xsl:apply-templates>
      <xsl:apply-templates select="Viewpoint"><xsl:with-param name="indent" select="$indent + 2"/></xsl:apply-templates>
      <xsl:text>]&#10;</xsl:text>
    </xsl:if>
  </xsl:if>
  <!-- contained content for Script node is scripting code, output as url -->
  <xsl:if test="(local-name()='Script' or $nodeType='Script' or $EPnodeType='Script' or @nodeTypeHint='Script') and *[not(field) and not(comment())]">
    <xsl:if test="@url and contains(.,'javascript:')"><xsl:text>### XSL-translation warning:  found url pointing to external script code and also contained code in CDATA section&#10;</xsl:text></xsl:if>
    <xsl:if test="not(@url)"><!-- need additional if-test here for existence of non-whitespace characters -->
      <xsl:text>url [ &quot;</xsl:text>
      <xsl:text>javascript:</xsl:text>
      <!-- CosmoPlayer url must start with javascript: or else it fails.  Update to handle other script language source when supported. -->
      <xsl:for-each select="text()">
        <xsl:choose>
<!-- extra-LF stripping not working.. -->
           <xsl:when test="local-name()='&#10;' and preceding::field"><xsl:text># stripped LF before&#10;</xsl:text></xsl:when>
           <xsl:when test="local-name()='&#10;' and following::field"><xsl:text># stripped LF after&#10;</xsl:text></xsl:when>
           <xsl:when test="substring-before(.,'javascript:') or 'j'=substring-before(.,'avascript:')"><xsl:value-of select="substring-after(.,'javascript:')" /></xsl:when>
           <xsl:otherwise><xsl:value-of select="translate(.,'javascript:','')" /></xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
      <xsl:text>&#10;&quot; ]&#10;</xsl:text>
    </xsl:if>
  </xsl:if>
  <!-- if not a USE or proxy, then add node close } -->
  <xsl:if test="not(@USE) and not(local-name()='USE') and not(local-name()='proxy') and
  	not(local-name(..)='GeoLOD'   and local-name()='rootNode') and 
  	not(local-name(..)='Segment'  and local-name()='displacers') and 
  	not(local-name(..)='Humanoid' and local-name()='humanoidBody')">
    <!-- <xsl:text># local-name()=</xsl:text><xsl:value-of select="local-name()"/><xsl:text>&#10;</xsl:text> -->
    <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
    <xsl:text>}&#10;</xsl:text>
  </xsl:if>
  <!-- done translating this node -->
</xsl:template>

<!-- ****** recurse through each of the attributes ****** -->
<xsl:template match="@*">
  <xsl:param name="indent" select="0"/>
  <!-- <xsl:text># $indent=</xsl:text><xsl:value-of select="$indent"/><xsl:text>### &#10;</xsl:text> -->
  <!-- eliminate default attribute values, otherwise they will _all_ appear in output  -->
  <!-- this block is used identically in X3dToVrml97.xsl X3dToHtml.xsl X3dUnwrap.xsl and X3dWrap.xsl -->
  <!-- check values with/without .0 suffix since these are string checks and autogenerated/DOM output might have either -->
  <!-- do not check ProtoInstances or natively defined nodes, since they might have different user-defined defaults -->
  <!-- tool-bug workaround:  split big boolean queries into pieces to avoid overloading the Xalan/lotusxml query buffer -->
  <xsl:variable name="notImplicitEvent"
	select="not(local-name(..)='AudioClip'	and	(local-name()='duration' or local-name()='isActive')) and
		not(contains(local-name(..),'Interpolator') and (local-name()='fraction' or local-name()='value')) and
		not(local-name(..)='Background'	and	(local-name()='bind' or local-name()='bindTime' or local-name()='isBound')) and
		not(local-name(..)='CylinderSensor' and	(local-name()='isActive' or local-name()='rotation' or local-name()='trackPoint')) and
		not(local-name(..)='Fog'		and	(local-name()='bind' or local-name()='bindTime' or local-name()='isBound')) and
		not(local-name(..)='IndexedLineSet' and	 local-name()='lineWidth') and
		not(local-name(..)='MovieTexture' and	(local-name()='duration' or local-name()='isActive')) and
		not(local-name(..)='NavigationInfo' and	(local-name()='bind' or local-name()='bindTime' or local-name()='isBound')) and
		not(local-name(..)='PointSet'	and	 local-name()='pointSize') and
		not(local-name(..)='PlaneSensor' and	(local-name()='isActive' or local-name()='translation' or local-name()='trackPoint')) and
		not(local-name(..)='ProximitySensor' and (local-name()='isActive' or local-name()='position' or local-name()='orientation' or
						 	 local-name()='enterTime' or local-name()='exitTime')) and
		not(local-name(..)='SphereSensor' and	(local-name()='isActive' or local-name()='rotation' or local-name()='trackPoint')) and
		not(local-name(..)='TimeSensor'	and	(local-name()='isActive' or local-name()='cycleTime' or local-name()='fraction' or
							 local-name()='time')) and
		not(local-name(..)='TouchSensor' and	(local-name()='isActive' or local-name()='isOver' or local-name()='hitNormal' or
							 local-name()='touchTime' or local-name()='hitPoint' or local-name()='hitTexCoord')) and
		not(local-name(..)='Viewpoint'	  and	(local-name()='bind' or local-name()='bindTime' or local-name()='isBound' or local-name()='examine')) and
		not(local-name(..)='GeoViewpoint' and	(local-name()='bind' or local-name()='bindTime' or local-name()='isBound' or local-name()='examine'))
		" />
  <xsl:variable name="notDefaultFieldValue1"
	select="not( local-name()='bboxCenter'	and	(.='0 0 0' or .='0.0 0.0 0.0')) and
		not( local-name()='bboxSize'	and	(.='-1 -1 -1' or .='-1.0 -1.0 -1.0')) and
		not( local-name(..)='AudioClip'	and
						((local-name()='loop' and .='false') or
						 (local-name()='pitch' and (.='1' or .='1.0')) or
						 (local-name()='startTime' and (.='0' or .='0.0')) or
						 (local-name()='stopTime' and (.='0 0 0' or .='0.0 0.0 0.0')))) and
		not( local-name(..)='Background' and local-name()='skyColor' and (.='0 0 0' or .='0.0 0.0 0.0')) and
		not( local-name(..)='Billboard'	and local-name()='axisOfRotation' and (.='0 1 0' or .='0.0 1.0 0.0')) and
		not( local-name(..)='Box'	and local-name()='size' and (.='2 2 2' or .='2.0 2.0 2.0')) and
		not( local-name(..)='Collision'	and local-name()='collide' and .='true') and
		not( local-name(..)='Cone' and	((local-name()='bottomRadius' and (.='1' or .='1.0')) or
						 (local-name()='height' and (.='2' or .='2.0')) or
						 (local-name()='side' and .='true') or
						 (local-name()='bottom' and .='true'))) and
		not( local-name(..)='Cylinder' and
						((local-name()='height' and (.='2' or .='2.0')) or
						 (local-name()='radius' and (.='1' or .='1.0')) or
						 (local-name()='bottom' and .='true') or
						 (local-name()='side' and .='true') or
						 (local-name()='top' and .='true'))) and
		not( local-name(..)='CylinderSensor' and
						((local-name()='autoOffset' and .='true') or
						 (local-name()='enabled' and .='true') or
						 (local-name()='diskAngle' and .='0.262') or
						 (local-name()='offset' and (.='0' or .='0.0')) or
						 (local-name()='maxAngle' and (.='-1' or .='-1.0')) or
						 (local-name()='minAngle' and (.='0' or .='0.0'))))" />
  <xsl:variable name="notDefaultFieldValue2"
	select="not( local-name(..)='DirectionalLight' and
						((local-name()='ambientIntensity' and (.='0' or .='0.0')) or
						 (local-name()='color' and (.='1 1 1' or .='1.0 1.0 1.0')) or
						 (local-name()='direction' and (.='0 0 -1' or .='0.0 0.0 -1.0')) or
						 (local-name()='intensity' and (.='1' or .='1.0')) or
						 (local-name()='on' and .='true'))) and
		not( (local-name(..)='ElevationGrid' or local-name(..)='GeoElevationGrid') and
						((local-name()='ccw' and .='true') or
						 (local-name()='colorPerVertex' and .='true') or
						 (local-name()='normalPerVertex' and .='true') or
						 (local-name()='solid' and .='true') or
						 (local-name()='xDimension' and (.='0' or .='0.0')) or
						 (local-name()='xSpacing' and (.='1' or .='1.0')) or
						 (local-name()='zDimension' and (.='0' or .='0.0')) or
						 (local-name()='zSpacing' and (.='1' or .='1.0')) or
						 (local-name()='creaseAngle' and (.='0' or .='0.0')))) and
		not( local-name(..)='Extrusion'	and
						((local-name()='beginCap' and .='true') or
						 (local-name()='ccw' and .='true') or
						 (local-name()='convex' and .='true') or
						 (local-name()='endCap' and .='true') or
						 (local-name()='solid' and .='true') or
						 (local-name()='creaseAngle' and (.='0' or .='0.0')) or
						 (local-name()='orientation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='scale' and (.='1 1' or .='1.0 1.0')) or
						 (local-name()='crossSection' and .='1 1, 1 -1, -1 -1, -1 1, 1  1') or
						 (local-name()='spine' and .='0 0 0, 0 1 0')))" />
  <xsl:variable name="notDefaultFieldValue3"
	select="not( local-name(..)='Fog' and
						((local-name()='color' and (.='1 1 1' or .='1.0 1.0 1.0')) or
						 (local-name()='visibilityRange' and (.='0' or .='0.0')) or
						 (local-name()='fogType' and .='&quot;LINEAR&quot;'))) and
		not( local-name(..)='FontStyle'	and
						((local-name()='horizontal' and .='true') or
						 (local-name()='leftToRight' and .='true') or
						 (local-name()='topToBottom' and .='true') or
						 (local-name()='size' and (.='1' or .='1.0')) or
						 (local-name()='spacing' and (.='1' or .='1.0')) or
						 (local-name()='family' and .='&quot;SERIF&quot;') or
						 (local-name()='justify' and .='&quot;BEGIN&quot;') or
						 (local-name()='family' and .='SERIF') or
						 (local-name()='justify' and .='BEGIN') or
						 (local-name()='style' and .='PLAIN'))) and
		not( local-name(..)='ImageTexture' and
						((local-name()='repeatS' and .='true') or
						 (local-name()='repeatT' and .='true'))) and
		not( local-name(..)='IndexedFaceSet' and
						((local-name()='ccw' and .='true') or
						 (local-name()='colorPerVertex' and .='true') or
						 (local-name()='convex' and .='true') or
						 (local-name()='normalPerVertex' and .='true') or
						 (local-name()='solid' and .='true') or
						 (local-name()='creaseAngle' and (.='0' or .='0.0')))) and
		not( local-name(..)='IndexedLineSet' and local-name()='colorPerVertex' and .='true') and
		not( local-name(..)='LOD'	and	 local-name()='center' and (.='0 0 0' or .='0.0 0.0 0.0')) and
		not( local-name(..)='Material'	and
						((local-name()='ambientIntensity' and .='0.2') or
						 (local-name()='diffuseColor' and .='0.8 0.8 0.8') or
						 (local-name()='emissiveColor' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='shininess' and .='0.2') or
						 (local-name()='specularColor' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='transparency' and (.='0' or .='0.0'))))" />
  <xsl:variable name="notDefaultFieldValue4"
	select="not( local-name(..)='MovieTexture' and
						((local-name()='loop' and .='false') or
						 (local-name()='speed' and (.='1' or .='1.0')) or
						 (local-name()='startTime' and (.='0' or .='0.0')) or
						 (local-name()='stopTime' and (.='0' or .='0.0')) or
						 (local-name()='repeatS' and .='true') or
						 (local-name()='repeatT' and .='true'))) and
		not( local-name(..)='NavigationInfo' and
						((local-name()='avatarSize' and .='0.25 1.6 0.75') or
						 (local-name()='headlight' and .='true') or
						 (local-name()='speed' and (.='1' or .='1.0')) or
						 (local-name()='visibilityLimit' and (.='0' or .='0.0')))) and
		not( local-name(..)='PixelTexture' and
						((local-name()='repeatS' and .='true') or
						 (local-name()='repeatT' and .='true') or
						 (local-name()='image' and (.='0 0 0' or .='0.0 0.0 0.0')))) and
		not( local-name(..)='PlaneSensor' and
						((local-name()='autoOffset' and .='true') or
						 (local-name()='enabled' and .='true') or
						 (local-name()='maxPosition' and (.='-1 -1' or .='-1.0 -1.0')) or
						 (local-name()='minPosition' and (.='0 0' or .='0.0 0.0')) or
						 (local-name()='offset' and (.='0 0 0' or .='0.0 0.0 0.0')))) and
		not( local-name(..)='PointLight' and
						((local-name()='ambientIntensity' and (.='0' or .='0.0'))or
						 (local-name()='attenuation' and (.='1 0 0' or .='1.0 0.0 0.0')) or
						 (local-name()='color' and (.='1 1 1' or .='1.0 1.0 1.0')) or
						 (local-name()='intensity' and (.='1' or .='1.0')) or
						 (local-name()='location' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='on' and .='true') or
						 (local-name()='radius' and (.='100' or .='100.0'))))" />
  <xsl:variable name="notDefaultFieldValue5"
	select="not( local-name(..)='ProximitySensor' and
						((local-name()='center' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='size' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='enabled' and .='true'))) and
		not( local-name(..)='Script' and ((local-name()='directOutput' and .='false') or
						 (local-name()='mustEvaluate' and .='false'))) and
		not( local-name(..)='Sound' and ((local-name()='direction' and (.='0 0 1' or .='0.0 0.0 1.0')) or
						 (local-name()='intensity' and (.='1' or .='1.0')) or
						 (local-name()='location' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='priority' and (.='0' or .='0.0')) or
						 (local-name()='maxBack' and (.='10' or .='10.0')) or
						 (local-name()='maxFront' and (.='10' or .='10.0')) or
						 (local-name()='minBack' and (.='1' or .='1.0'))  or
						 (local-name()='minFront' and (.='1' or .='1.0')) or
						 (local-name()='spatialize' and .='true'))) and
		not( local-name(..)='Sphere' and  local-name()='radius' and (.='1' or .='1.0')) and
		not( local-name(..)='SphereSensor' and
						((local-name()='autoOffset' and .='true') or
						 (local-name()='enabled' and .='true') or
						 (local-name()='offset' and (.='0 1 0 0' or .='0.0 1.0 0.0 0.0'))))" />
  <xsl:variable name="notDefaultFieldValue6"
	select="not( parent::SpotLight	and
						((local-name()='ambientIntensity' and (.='0' or .='0.0')) or
						 (local-name()='attenuation' and (.='1 0 0' or .='1.0 0.0 0.0')) or
						 (local-name()='beamwidth' and .='1.570796') or
						 (local-name()='color' and (.='1 1 1' or .='1.0 1.0 1.0')) or
						 (local-name()='cutOffAngle' and .='0.785398') or
						 (local-name()='direction' and (.='0 0 -1' or .='0.0 0.0 -1.0')) or
						 (local-name()='intensity' and (.='1' or .='1.0')) or
						 (local-name()='location' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='on' and .='true') or
						 (local-name()='radius' and (.='100' or .='100.0')))) and
		not( local-name(..)='Switch' and  local-name()='whichChoice' and (.='-1' or .='-1.0')) and
		not( local-name(..)='Text'   and  local-name()='maxExtent' and (.='0' or .='0.0')) and
		not( local-name(..)='TextureTransform' and
						((local-name()='center' and (.='0 0' or .='0.0 0.0')) or
						 (local-name()='rotation' and (.='0' or .='0.0')) or
						 (local-name()='scale ' and (.='1 1' or .='1.0 1.0')) or
						 (local-name()='translation' and (.='0 0' or .='0.0 0.0')))) and
		not( local-name(..)='Switch' and  local-name()='whichChoice' and (.='-1' or .='-1.0'))" />
  <xsl:variable name="notDefaultFieldValue7"
	select="not( local-name(..)='TimeSensor' and
						((local-name()='cycleInterval' and (.='1' or .='1.0')) or
						 (local-name()='enabled' and .='true') or
						 (local-name()='startTime' and (.='0' or .='0.0')) or
						 (local-name()='stopTime' and (.='0' or .='0.0')) or
						 (local-name()='loop' and .='false'))) and
		not( local-name(..)='TouchSensor' and
						  local-name()='enabled' and .='true') and
		not( local-name(..)='Transform' and
						((local-name()='center' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='rotation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='scale' and (.='1 1 1' or .='1.0 1.0 1.0')) or
						 (local-name()='scaleOrientation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='translation' and (.='0 0 0' or .='0.0 0.0 0.0')))) and
		not( (local-name(..)='Viewpoint' or local-name(..)='GeoViewpoint') and
						((local-name()='fieldOfView' and .='0.785398') or
						 (local-name()='jump' and .='true') or
						 (local-name()='orientation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='position' and (.='0 0 10' or .='0.0 0.0 10.0')))) and
		not( local-name(..)='VisibilitySensor' and
						((local-name()='center' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='enabled' and .='true') or
						 (local-name()='size' and (.='0 0 0' or .='0.0 0.0 0.0'))))" />
  <xsl:variable name="notDefaultHAnim"
	select="not( local-name(..)='Joint' and
						((local-name()='center' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='limitOrientation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='rotation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='scale' and (.='1 1 1' or .='1.0 1.0 1.0')) or
						 (local-name()='scaleOrientation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='stiffness' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='translation' and (.='0 0 0' or .='0.0 0.0 0.0')))) and
		not( local-name(..)='Segment' and
						((local-name()='bboxCenter' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='bboxSize' and (.='-1 -1 -1' or .='-1.0 -1.0 -1.0')) or
						 (local-name()='centerOfMass' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='mass' and (.='0' or .='0.0')) or
						 (local-name()='momentsOfInertia' and
						  (.='0 0 0 0 0 0 0 0 0' or .='0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0')))) and
		not( local-name(..)='Site' and
						((local-name()='center' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='rotation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='scale' and (.='1 1 1' or .='1.0 1.0 1.0')) or
						 (local-name()='scaleOrientation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='translation' and (.='0 0 0' or .='0.0 0.0 0.0')))) and
		not( local-name(..)='Humanoid' and
						((local-name()='bboxCenter' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='bboxSize' and (.='-1 -1 -1' or .='-1.0 -1.0 -1.0')) or
						 (local-name()='center' and (.='0 0 0' or .='0.0 0.0 0.0')) or
						 (local-name()='rotation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='scale' and (.='1 1 1' or .='1.0 1.0 1.0')) or
						 (local-name()='scaleOrientation' and (.='0 0 1 0' or .='0.0 0.0 1.0 0.0')) or
						 (local-name()='translation' and (.='0 0 0' or .='0.0 0.0 0.0'))))" />
  <!-- avoid outputting:  DEF, any fields whatsoever if USE found, ProtoInstance name, new VRML fields (pointSize etc.),
        hint attribute, implicitly specified VRML 97 eventIns/eventOuts, missing values or default values -->
  <xsl:if test="not(local-name()='DEF') and
                not(local-name()='nodeTypeHint') and
                not(local-name()='USE') and
                not(../@USE) and
                not(.='') and
                not(local-name(..)='ProtoInstance' and local-name()='name') and
                not( local-name(..)='IndexedLineSet' and local-name()='lineWidth') and
                not(local-name(..)='PointSet' and local-name()='pointSize') and
                not(local-name(..)='USE' and local-name()='node') and
                $notImplicitEvent and
                $notDefaultFieldValue1 and
                $notDefaultFieldValue2 and
                $notDefaultFieldValue3 and
                $notDefaultFieldValue4 and
                $notDefaultFieldValue5 and
                $notDefaultFieldValue6 and
                $notDefaultFieldValue7 and
                $notDefaultHAnim and
                not((local-name(..)='Script' or local-name(..)='field') and (local-name()='xml:space' or local-name()='space'))">
    <!-- valid field found by the preceding checks, now output accordingly -->
    <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
    <!-- <xsl:text> # attribute </xsl:text><xsl:value-of select="local-name()"/><xsl:text>&#10;</xsl:text> -->
    <!-- take care of IS attribute definitions for non-node fields inside ProtoDeclarations -->
    <xsl:variable name="PROTOdeclareAncestorName" select="ancestor::*[local-name()='ProtoDeclare']/@name" />
    <!-- <xsl:if test="$PROTOdeclareAncestorName"><xsl:text> # ProtoDeclare ancestor &quot;</xsl:text><xsl:value-of select="$PROTOdeclareAncestorName"/><xsl:text>&quot; found&#10;</xsl:text></xsl:if> -->
    <xsl:variable name="DEFname" select="../@DEF" />
    <xsl:variable name="fieldName" select="local-name()" />
    <xsl:variable name="matchName" select="concat(../@DEF,'.',local-name())" />
    <!-- <xsl:text> # $DEFname </xsl:text><xsl:value-of select="$DEFname"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text> # $fieldName </xsl:text><xsl:value-of select="$fieldName"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text> # $matchName </xsl:text><xsl:value-of select="$matchName"/><xsl:text>&#10;</xsl:text> -->
    <xsl:variable name="PROTOdeclareAncestorField" select="ancestor::*[local-name()='ProtoDeclare']/field" />
    <!-- <xsl:if test="$PROTOdeclareAncestorField"><xsl:text> # ProtoDeclare ancestor field &quot;</xsl:text><xsl:value-of select="$PROTOdeclareAncestorField"/><xsl:text>&quot; found&#10;</xsl:text></xsl:if> -->
    <!-- figure out node type for ProtoDeclared ProtoInstance, ExternProtoDeclared ProtoInstance and internal DTD declaration tag definitions -->
    <xsl:variable name="nodeName" select="../@name" />
    <xsl:variable name="nodeName2" select="local-name(..)" />
    <xsl:variable name="parentNodeName" select="../../@name" />
    <!-- ProtoDeclared ProtoInstance -->
    <xsl:variable name="nodeType" select="local-name(//ProtoDeclare[@name=$nodeName or @name=$nodeName2]/node()[local-name()!='field'])" />
    <xsl:variable name="parentType" select="local-name(//ProtoDeclare[@name=$parentNodeName]/node()[local-name()!='field'])" />
    <!-- ExternProtoDeclared ProtoInstance -->
    <xsl:variable name="EPnodeName" select="//ExternProtoDeclare[@name=$nodeName or @name=$nodeName2]/@name" />
    <xsl:variable name="EPnodeType" select="//ExternProtoDeclare[@name=$nodeName or @name=$nodeName2]/@nodeTypeHint" />
    <xsl:variable name="EPfieldType" select="//ExternProtoDeclare[@name=$nodeName or @name=$nodeName2]/field[@name=$fieldName]/@type" />
    <!-- debug diagnosis statements -->
    <!-- <xsl:if test="$nodeName"><xsl:text># $nodeName </xsl:text><xsl:value-of select="$nodeName"/><xsl:text>&#10;</xsl:text></xsl:if> -->
    <!-- <xsl:text># nodeName </xsl:text><xsl:value-of select="$nodeName"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># nodeName2 </xsl:text><xsl:value-of select="$nodeName2"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># local-name() </xsl:text><xsl:value-of select="local-name()"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># local-name(..) </xsl:text><xsl:value-of select="local-name(..)"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># EPnodeName </xsl:text><xsl:value-of select="$EPnodeName"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># parentNodeName </xsl:text><xsl:value-of select="$parentNodeName"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># nodeType </xsl:text><xsl:value-of select="$nodeType"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># parentType </xsl:text><xsl:value-of select="$parentType"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># EPnodeType </xsl:text><xsl:value-of select="$EPnodeType"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># EPparentType </xsl:text><xsl:value-of select="$EPparentType"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># @nodeTypeHint </xsl:text><xsl:value-of select="@nodeTypeHint"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># EPfieldType </xsl:text><xsl:value-of select="$EPfieldType"/><xsl:text>&#10;</xsl:text> -->
    <xsl:variable name="MFtypes"
		select="($nodeType  ='Booleans')  or ($nodeType  ='Colors') or ($nodeType  ='Floats')       or ($nodeType  ='Integers') or
			($nodeType  ='Rotations') or ($nodeType  ='Times')  or ($nodeType  ='Vector2FloatArray') or ($nodeType  ='Vector3FloatArray') or
			($EPnodeType='Booleans')  or ($EPnodeType='Colors') or ($EPnodeType='Floats')       or ($EPnodeType='Integers') or
			($EPnodeType='Rotations') or ($EPnodeType='Times')  or ($EPnodeType='Vector2FloatArray') or ($EPnodeType='Vector3FloatArray')" />
    <xsl:variable name="ExtensionMFtypes"
		select="
                      ((local-name(..)='GeoElevationGrid'	or $nodeType='GeoElevationGrid'	or $EPnodeType='GeoElevationGrid'	or @nodeTypeHint='GeoElevationGrid') and
      				    local-name()='height') or
        	      ((local-name(..)='GeoPositionInterpolator' or $nodeType='GeoPositionInterpolator' or $EPnodeType='GeoPositionInterpolator' or @nodeTypeHint='GeoPositionInterpolator') and
      				    local-name()='key') or
        	      ((local-name(..)='Joint'                   or $nodeType='Joint'           or $EPnodeType='Joint'                  or @nodeTypeHint='Joint') and
      				   (local-name()='llimit' or local-name()='stiffness' or local-name()='ulimit')) or
        	      ((local-name(..)='Segment'                 or $nodeType='Segment'         or $EPnodeType='Segment'                or @nodeTypeHint='Segment') and
      				    local-name()='momentsOfInertia')" />
    <xsl:variable name="GeoVrmlSFStringTypes"
		select="((local-name(..)='GeoElevationGrid'	or $nodeType='GeoElevationGrid'	or $EPnodeType='GeoElevationGrid' or @nodeTypeHint='GeoElevationGrid') and
      				    (local-name()='geoGridOrigin' or local-name()='xSpacing' or local-name()='zSpacing')) or
        	      ((local-name(..)='GeoLocation'		or $nodeType='GeoLocation'    	or $EPnodeType='GeoLocation'	or @nodeTypeHint='GeoLocation') and
      				    local-name()='geoCoords') or
        	      ((local-name(..)='GeoLOD'			or $nodeType='GeoLOD'    	or $EPnodeType='GeoLOD'	or @nodeTypeHint='GeoLOD') and
      				    local-name()='center') or
        	      ((local-name(..)='GeoMetadata'		or $nodeType='GeoMetadata'    	or $EPnodeType='GeoMetadata'	or @nodeTypeHint='GeoMetadata') and
      				    not(local-name()='url') and not(local-name()='data') and not(local-name()='summary')) or
        	      ((local-name(..)='GeoOrigin'		or $nodeType='GeoOrigin'    	or $EPnodeType='GeoOrigin'	or @nodeTypeHint='GeoOrigin') and
      				    local-name()='geoCoords') or
        	      ((local-name(..)='GeoPositionInterpolator' or $nodeType='GeoPositionInterpolator' or $EPnodeType='GeoPositionInterpolator' or @nodeTypeHint='GeoPositionInterpolator') and
      				    local-name()='geoValue') or
        	      ((local-name(..)='GeoTouchSensor'		or $nodeType='GeoTouchSensor'	or $EPnodeType='GeoTouchSensor'	or @nodeTypeHint='GeoTouchSensor') and
      				    (local-name()='hitNormal' or local-name()='hitGeoCoordinate' or local-name()='hitTexCoord')) or
        	      ((local-name(..)='GeoViewpoint'		or $nodeType='GeoViewpoint'    	or $EPnodeType='GeoViewpoint'	or @nodeTypeHint='GeoViewpoint') and
      				    (local-name()='position' or local-name()='description'))" />
    <xsl:variable name="GeoVrmlMFStringTypes"
		select="((local-name(..)='GeoCoordinate'	or $nodeType='GeoCoordinate'    or $EPnodeType='GeoCoordinate'	or @nodeTypeHint='GeoCoordinate') and
      				    (local-name()='geoSystem' or local-name()='point')) or
        	      ((local-name(..)='GeoElevationGrid'	or $nodeType='GeoElevationGrid'	or $EPnodeType='GeoElevationGrid' or @nodeTypeHint='GeoElevationGrid') and
      				    local-name()='geoSystem') or
        	      ((local-name(..)='GeoInline'		or $nodeType='GeoInline'    	or $EPnodeType='GeoInline'	or @nodeTypeHint='GeoInline') and
      				    local-name()='url') or
        	      ((local-name(..)='GeoLocation'		or $nodeType='GeoLocation'    	or $EPnodeType='GeoLocation'	or @nodeTypeHint='GeoLocation') and
      				    local-name()='geoSystem') or
        	      ((local-name(..)='GeoLOD'			or $nodeType='GeoLOD'    	or $EPnodeType='GeoLOD'		or @nodeTypeHint='GeoLOD') and
      				    (contains(local-name(),'Url') or local-name()='geoSystem')) or
        	      ((local-name(..)='GeoMetadata'		or $nodeType='GeoMetadata'    	or $EPnodeType='GeoMetadata'	or @nodeTypeHint='GeoMetadata') and
      				    (local-name()='url' or local-name()='summary')) or
        	      ((local-name(..)='GeoOrigin'		or $nodeType='GeoOrigin'    	or $EPnodeType='GeoOrigin'	or @nodeTypeHint='GeoOrigin') and
      				    local-name()='geoSystem') or
        	      ((local-name(..)='GeoPositionInterpolator' or $nodeType='GeoPositionInterpolator' or $EPnodeType='GeoPositionInterpolator' or @nodeTypeHint='GeoPositionInterpolator') and
      				    (local-name()='geoSystem' or local-name()='keyValue')) or
        	      ((local-name(..)='GeoTouchSensor'		or $nodeType='GeoTouchSensor'	or $EPnodeType='GeoTouchSensor'	or @nodeTypeHint='GeoTouchSensor') and
      				    local-name()='geoSystem') or
        	      ((local-name(..)='GeoViewpoint'		or $nodeType='GeoViewpoint'	or $EPnodeType='GeoViewpoint'	or @nodeTypeHint='GeoViewpoint') and
      				    (local-name()='geoSystem' or local-name()='navType'))" />
    <xsl:variable name="HAnimSFStringTypes"
		select="((local-name(..)='Joint'	or $nodeType='Joint'	or $EPnodeType='Joint' or @nodeTypeHint='Joint') and
      				     local-name()='name') or
        	      ((local-name(..)='Segment'		or $nodeType='Segment'    	or $EPnodeType='Segment'	or @nodeTypeHint='Segment') and
      				     local-name()='name') or
        	      ((local-name(..)='Site'			or $nodeType='Site'    	or $EPnodeType='Site'	or @nodeTypeHint='Site') and
      				     local-name()='name') or
        	      ((local-name(..)='Displacer'		or $nodeType='Displacer'    	or $EPnodeType='Displacer'	or @nodeTypeHint='Displacer') and
      				     local-name()='name') or
        	      ((local-name(..)='Humanoid'		or $nodeType='Humanoid'    	or $EPnodeType='Humanoid'	or @nodeTypeHint='Humanoid') and
      				    (local-name()='name' or local-name()='version'))" />
    <xsl:variable name="HAnimMFStringTypes"
		select="((local-name(..)='Humanoid'	or $nodeType='Humanoid'    or $EPnodeType='Humanoid'	or @nodeTypeHint='') and
      				     local-name()='info')" />
    <xsl:variable name="DisJavaVrmlSFStringTypes"
		select="((local-name(..)='EspduTransform'	or $nodeType='EspduTransform'	or $EPnodeType='EspduTransform' or @nodeTypeHint='EspduTransform' or
		          local-name(..)='ReceiverPdu'		or $nodeType='ReceiverPdu'	or $EPnodeType='ReceiverPdu'	or @nodeTypeHint='ReceiverPdu' or
		          local-name(..)='SignalPdu'		or $nodeType='SignalPdu'	or $EPnodeType='SignalPdu'	or @nodeTypeHint='SignalPdu' or
		          local-name(..)='TransmitterPdu'	or $nodeType='TransmitterPdu'	or $EPnodeType='TransmitterPdu' or @nodeTypeHint='TransmitterPdu') and
      				     (local-name()='marking' or local-name()='address' or local-name()='multicastRelayHost' or local-name()='address'))" />
    <xsl:choose>
      <!-- take care of SFString fields by wrapping &quot; quotation marks &quot; -->
      <xsl:when test="((local-name(..)='Anchor'     or $nodeType='Anchor'	or $EPnodeType='Anchor'		or @nodeTypeHint='Anchor') and
      				    local-name()='description') or
                      ((local-name(..)='AudioClip'  or $nodeType='AudioClip'	or $EPnodeType='AudioClip'	or @nodeTypeHint='AudioClip') and
      				    local-name()='description') or
                      ((local-name(..)='Fog'        or $nodeType='Fog'		or $EPnodeType='Fog'		or @nodeTypeHint='Fog') and
      				    local-name()='fogType')     or
                      ((local-name(..)='FontStyle'  or $nodeType='FontStyle'	or $EPnodeType='FontStyle'	or @nodeTypeHint='FontStyle') and
      				   (local-name()='language' or local-name()='style'))       or
                      ((local-name(..)='Viewpoint'  or $nodeType='Viewpoint'	or $EPnodeType='Viewpoint'	or @nodeTypeHint='Viewpoint') and
      				    local-name()='description') or
                      ((local-name(..)='WorldInfo'  or $nodeType='WorldInfo'	or $EPnodeType='WorldInfo'	or @nodeTypeHint='WorldInfo') and
      				    local-name()='title') or
      				    	$GeoVrmlSFStringTypes or
      				    	$HAnimSFStringTypes or
      				    	$DisJavaVrmlSFStringTypes or
        				($nodeType    = 'String') or
        				($EPnodeType  = 'String') or
        				($EPfieldType = 'String')
                     ">
        <xsl:choose>
          <!-- output SFString.  wrap quotes if string-length 0 -->
          <xsl:when test="not(.)"><xsl:value-of select="local-name()"/><xsl:text> &quot;&quot;&#10;</xsl:text></xsl:when>
          <!-- output SFString.  no need to wrap quotes -->
          <xsl:when test="starts-with(normalize-space(.),'&quot;')"><xsl:value-of select="local-name()"/><xsl:text> </xsl:text><xsl:value-of select="." /><xsl:text>&#10;</xsl:text></xsl:when>
          <xsl:when test='starts-with(.,"&apos;")'><xsl:value-of select="local-name()"/><xsl:text> </xsl:text><xsl:value-of select="." /><xsl:text>&#10;</xsl:text></xsl:when>
          <!-- output SFString with wrapped quotes since it doesn't have any-->
          <xsl:otherwise><xsl:value-of select="local-name()"/><xsl:text> &quot;</xsl:text><xsl:value-of select="." /><xsl:text>&quot;&#10;</xsl:text></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- take care of some special MFString types by adding enclosing &quot; &quot; marks -->
      <xsl:when test="((local-name(..)='FontStyle'		or $nodeType='FontStyle'    	or $EPnodeType='FontStyle'  	or @nodeTypeHint='FontStyle') and
      				   (local-name()='family' or local-name()='justify')) or
                      ((local-name(..)='NavigationInfo'	or $nodeType='NavigationInfo'	or $EPnodeType='NavigationInfo' or @nodeTypeHint='NavigationInfo') and
      				    local-name()='type')">
        <xsl:choose>
          <!-- output MFString.  wrap quotes if string-length 0 -->
          <xsl:when test="not(.)"><xsl:value-of select="local-name()"/><xsl:text> [ &quot;&quot; ]&#10;</xsl:text></xsl:when>
          <!-- output MFString.  don't modify quotes if some are there already -->
          <xsl:when test="contains(.,'&quot;')"><xsl:value-of select="local-name()"/><xsl:text> [ </xsl:text><xsl:value-of select="." /><xsl:text> ] &#10;</xsl:text></xsl:when> <!-- ### quotes found... -->
          <!-- output MFString with wrapped quotes around token values -->
          <xsl:otherwise>
            <xsl:value-of select="local-name()"/>
            <!-- <xsl:text> ### inputString sent: &quot;</xsl:text><xsl:value-of select="concat(normalize-space(translate(.,'&quot;',' ')),' ')"/><xsl:text>&quot;&#10;</xsl:text> -->
            <xsl:text> [</xsl:text>            
            <xsl:call-template name="wrap-quotes-around-tokens">
              <xsl:with-param name="inputString" select="concat(normalize-space(translate(.,'&quot;',' ')),' ')"/>
            </xsl:call-template>
            <xsl:text> ]&#10;</xsl:text> <!-- ### inserted quotes around tokens... -->
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- take care of MFString types by wrapping [ ]
           (if necessary, ensure contained SFString elements wrapped overall in &quot; &quot;) -->
      <xsl:when test="((local-name(..)='Anchor'		or $nodeType='Anchor'		or $EPnodeType='Anchor'		or @nodeTypeHint='Anchor') and
      				   (local-name()='parameter' or local-name()='url')) or
                      ((local-name(..)='AudioClip'	or $nodeType='AudioClip'	or $EPnodeType='AudioClip'	or @nodeTypeHint='AudioClip') and
      				    local-name()='url') or
                      ((local-name(..)='Background'	or $nodeType='Background'	or $EPnodeType='Background'	or @nodeTypeHint='Background') and
      				    contains(local-name(),'Url'))	or
                      ((local-name(..)='ImageTexture'	or $nodeType='ImageTexture'	or $EPnodeType='ImageTexture'	or @nodeTypeHint='ImageTexture') and
      				    local-name()='url') or
                      ((local-name(..)='Inline'		or $nodeType='Inline'		or $EPnodeType='Inline'		or @nodeTypeHint='Inline') and
      				    local-name()='url') or
                      ((local-name(..)='MovieTexture'	or $nodeType='MovieTexture'	or $EPnodeType='MovieTexture'	or @nodeTypeHint='MovieTexture') and
      				    local-name()='url') or
                      ((local-name(..)='Script'		or $nodeType='Script'		or $EPnodeType='Script'		or @nodeTypeHint='Script') and
      				    local-name()='url') or
                      ((local-name(..)='Text'		or $nodeType='Text'		or $EPnodeType='Text'		or @nodeTypeHint='Text') and
      				    local-name()='string') or
                      ((local-name(..)='WorldInfo'	or $nodeType='WorldInfo'    	or $EPnodeType='WorldInfo'	or @nodeTypeHint='WorldInfo') and
      				    local-name()='info') or
      				    	$GeoVrmlMFStringTypes or
      				    	$HAnimMFStringTypes or
        				($nodeType    = 'Strings') or
        				($EPnodeType  = 'Strings') or
        				($EPfieldType = 'Strings')">
        <xsl:choose>
          <!-- output MFString.  wrap quotes if string-length 0 -->
          <xsl:when test="not(.)"><xsl:value-of select="local-name()"/><xsl:text> [ &quot;&quot; ]&#10;</xsl:text></xsl:when>
          <!-- output MFString.  no need to wrap quotes -->
          <xsl:when test="starts-with(normalize-space(.),'&quot;')"><xsl:value-of select="local-name()"/><xsl:text> [ </xsl:text><xsl:value-of select="." /><xsl:text> ]&#10;</xsl:text></xsl:when>
          <xsl:when test='starts-with(.,"&apos;")'><xsl:value-of select="local-name()"/><xsl:text> [ </xsl:text><xsl:value-of select="." /><xsl:text> ]&#10;</xsl:text></xsl:when>
          <!-- output MFString with wrapped quotes since it doesn't have any-->
          <xsl:otherwise><xsl:value-of select="local-name()"/><xsl:text> [ &quot;</xsl:text><xsl:value-of select="." /><xsl:text>&quot; ]&#10;</xsl:text></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- take care of other MF field types by wrapping [ ] -->
      <xsl:when test="(contains(local-name(..),'Interpolator') and contains(local-name(),'key')) or
                      ( local-name(..)='Background'		or $nodeType='Background'	or $EPnodeType='Background'		or @nodeTypeHint='Background') or
                      ((local-name(..)='ColorNode'		or $nodeType='ColorNode'	or $EPnodeType='ColorNode'		or @nodeTypeHint='ColorNode' or
                        local-name(..)='Color'    		or $nodeType='Color'    	or $EPnodeType='Color'    		or @nodeTypeHint='Color'    ) and
      				    local-name()='color') or
                      ((local-name(..)='Coordinate'		or $nodeType='Coordinate'	or $EPnodeType='Coordinate'		or @nodeTypeHint='Coordinate') and
      				    local-name()='point') or
                      ((local-name(..)='ElevationGrid'		or $nodeType='ElevationGrid'	or $EPnodeType='ElevationGrid'		or @nodeTypeHint='ElevationGrid') and
      				    local-name()='height') or
                      ((local-name(..)='Extrusion'		or $nodeType='Extrusion'	or $EPnodeType='Extrusion'		or @nodeTypeHint='Extrusion') and
      				   (local-name()='crossSection' or local-name()='orientation' or local-name()='scale' or local-name()='spine')) or
                      ((local-name(..)='IndexedFaceSet'		or $nodeType='IndexedFaceSet'	or $EPnodeType='IndexedFaceSet'		or @nodeTypeHint='IndexedFaceSet') and
      				    contains(local-name(),'Index')) or
                      ((local-name(..)='IndexedLineSet'		or $nodeType='IndexedLineSet'	or $EPnodeType='IndexedLineSet'		or @nodeTypeHint='IndexedLineSet') and
      				    contains(local-name(),'Index')) or
                      ((local-name(..)='LOD'			or $nodeType='LOD'		or $EPnodeType='LOD'			or @nodeTypeHint='LOD') and
      				    local-name()='range') or
                      ((local-name(..)='NavigationInfo'		or $nodeType='NavigationInfo'	or $EPnodeType='NavigationInfo'		or @nodeTypeHint='NavigationInfo') and
      				    local-name()='avatarSize') or
                      ((local-name(..)='Normal'			or $nodeType='Normal'		or $EPnodeType='Normal'			or @nodeTypeHint='Normal') and
      				    local-name()='vector') or
                      ((local-name(..)='Text'			or $nodeType='Text'		or $EPnodeType='Text'			or @nodeTypeHint='Text') and
      				    local-name()='length') or
                      ((local-name(..)='TextureCoordinate'	or $nodeType='TextureCoordinate' or $EPnodeType='TextureCoordinate' 	or @nodeTypeHint='TextureCoordinate') and
      				    local-name()='point') or
      				  $ExtensionMFtypes or
        			  $MFtypes
                     ">
        <!-- could put traps here to eliminate default-valued fields -->
        <!-- ?? is a local construct needed here to check and wrap quotes around individual string elements in MFString, if content didn't comply?? -->
        <xsl:value-of select="local-name()"/><xsl:text> [ </xsl:text><xsl:value-of select="."/>
        <xsl:if test="contains(.,'#')">
          <xsl:text>&#10;### XSL-translation warning:  embedded VRML comments (anything following a # symbol) may get mangled by XML and hide data!</xsl:text>
          <xsl:text>&#10;### recommendation:  use separate XML comments, instead of error-prone embedded VRML comments in attribute fields.&#10;</xsl:text>
        </xsl:if>
        <xsl:text> ]&#10;</xsl:text>
      </xsl:when>
      <!-- take care of IDREF, IDREFS for node referrals -->
      <xsl:when test="((local-name(..)='GeoMetadata' or $nodeType='GeoMetadata' or $EPnodeType='GeoMetadata' or @nodeTypeHint='GeoMetadata') and
      			 local-name()='data') or
        		($nodeType    = 'Nodes') or
        		($EPnodeType  = 'Nodes') or
        		($EPfieldType = 'Nodes')
                     ">
        <!-- need to loop through each IDREF'ed node name, also add separate IDREF case -->
        <xsl:value-of select="local-name()"/><xsl:text> [ USE </xsl:text><xsl:value-of select="."/><xsl:text> ]&#10;</xsl:text>
      </xsl:when>
      <!-- take care of boolean value capitalization - watch out, no discrimination! -->
      <xsl:when test=".='true'">
        <xsl:value-of select="local-name()"/><xsl:text> TRUE&#10;</xsl:text>
      </xsl:when>
      <xsl:when test=".='false'">
        <xsl:value-of select="local-name()"/><xsl:text> FALSE&#10;</xsl:text>
      </xsl:when>
      <!-- default field output is merely standalone value(s), if there is an error it should be flagged -->
      <xsl:otherwise>
        <xsl:if test=".">
          <xsl:value-of select="local-name()"/><xsl:text> </xsl:text><xsl:value-of select="."/><xsl:text>&#10;</xsl:text></xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>


<!-- ****** XML comments ****** -->
<xsl:template match="comment()[ancestor::X3D]">
<!-- template match constraint [ancestor::X3D] filters out DTD comments -->
  <xsl:param name="indent" select="0"/>
  <!-- <xsl:text># $indent=</xsl:text><xsl:value-of select="$indent"/><xsl:text>### &#10;</xsl:text> -->
  <xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
  <!-- having trouble translating line breaks properly, changing them to spaces (which avoids runtime errors, at least).  also meta tag.  -->
  <xsl:text># </xsl:text><xsl:value-of select="normalize-space(.)"/> <!-- translate(.,'&#10;',' ') -->
  <xsl:if test="not(local-name(..)='field')">
    <xsl:text>&#10;</xsl:text>
  </xsl:if>
</xsl:template>


<!-- ****** XML processing instructions ****** -->
<xsl:template match="processing-instruction()">
<xsl:text># </xsl:text><xsl:value-of select="."/><xsl:text>&#10;</xsl:text>
</xsl:template>


<!-- ****** X3D:  comment the X3D tag, recurse ****** -->
<xsl:template match="X3D">
  <xsl:text># [X3D]&#10;</xsl:text>
  <xsl:apply-templates/>
</xsl:template>


<!-- JAS ****** head:  comment the head tag, recurse ****** -->
<xsl:template match="head">
  <xsl:text># [head]</xsl:text><!-- <xsl:value-of select="."/><xsl:text> </xsl:text> -->
<xsl:apply-templates/>
</xsl:template>


<!-- ****** Header:  comment the Header tag, recurse ****** -->
<xsl:template match="Header">
  <xsl:text># [Header]</xsl:text><!-- <xsl:value-of select="."/><xsl:text> </xsl:text> -->
<xsl:apply-templates/>
</xsl:template>


<!-- ****** meta:  comment the meta tag's name and content ****** -->
<xsl:template match="meta">
  <xsl:text>&#10;# [meta] </xsl:text>
  <xsl:value-of select="@name"/>
  <xsl:text>: </xsl:text>
  <!-- having trouble translating line breaks properly, changing them to spaces (which avoids runtime errors, at least).  also comment tag.  -->
  <xsl:value-of select="translate(@content,'&#10;',' ')"/>
  <!-- <xsl:text><xsl:value-of select="@content"/>-->
</xsl:template>


<!-- ****** Scene:  comment the Scene tag, recurse ****** -->
<xsl:template match="Scene"><xsl:text>&#10;# [Scene]&#10;&#10;</xsl:text>
  <xsl:apply-templates>
    <xsl:with-param name="indent" select="0"/>
  </xsl:apply-templates>
</xsl:template>


<!-- ****** ROUTE ****** -->
<xsl:template match="ROUTE">
<xsl:param name="indent" select="0"/>
<!-- <xsl:text># $indent=</xsl:text><xsl:value-of select="$indent"/><xsl:text>### &#10;</xsl:text> -->
<xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
<xsl:text>ROUTE </xsl:text>
<xsl:value-of select="@fromNode" /><xsl:text>.</xsl:text>
<xsl:value-of select="@fromField"/><xsl:text> TO </xsl:text>
<xsl:value-of select="@toNode"   /><xsl:text>.</xsl:text>
<xsl:value-of select="@toField"  />
<xsl:text>&#10;</xsl:text>
<!-- extra blank line at end of file -->
<xsl:if test="position()=last() and not(local-name(..)='ProtoDeclare')"><xsl:text>&#10;</xsl:text></xsl:if>
</xsl:template>


<!-- ****** fieldValue overrides default field values inside a ProtoInstance ****** -->
<xsl:template match="fieldValue">
<xsl:param name="indent" select="0"/>
<!-- <xsl:text># $indent=</xsl:text><xsl:value-of select="$indent"/><xsl:text>### &#10;</xsl:text> -->
<xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
<xsl:value-of select="@name"/><xsl:text> </xsl:text>
<xsl:variable name="fieldName" select="@name" />
<xsl:variable name="nodeTypeHint" select="../@nodeTypeHint" />
<!-- <xsl:text> # $fieldName </xsl:text><xsl:value-of select="$fieldName"/><xsl:text>&#10;</xsl:text> -->
<!-- <xsl:text> # $nodeTypeHint </xsl:text><xsl:value-of select="$nodeTypeHint"/><xsl:text>&#10;</xsl:text> -->
<xsl:choose>
  <!-- overload check -->
  <xsl:when test="@value and *">
    <xsl:value-of select="@value" /><xsl:text>&#10;### XSL-translation warning:  ignoring contained Node/Nodes content, since simple-type value provided&#10;</xsl:text>
  </xsl:when>
  <!-- if value is provided for Node types, then it should be a USEname -->
  <xsl:when test="@value and
      (../@nodeTypeHint or //*[local-name()='ProtoDeclare']/field[@name=$fieldName and (@type='Node' or @type='Nodes')])">
    <xsl:text> USE </xsl:text><xsl:value-of select="@value" /><xsl:text>&#10;</xsl:text>
  </xsl:when>
  <!-- Node/Nodes initializations:  recurse on children/comments -->
  <!-- SFNode -->
  <xsl:when test="(not(@value) and count(*)=1) or comment()">
    <xsl:text> </xsl:text>
    <xsl:apply-templates select="* | comment()">
      <xsl:with-param name="indent" select="$indent + 2"/>
    </xsl:apply-templates>
  </xsl:when>
  <!-- MFNode -->
  <xsl:when test="not(@value) and count(*)>1">
    <xsl:text> [&#10;</xsl:text>
    <xsl:apply-templates select="*">
     <xsl:with-param name="indent" select="$indent + 2"/>
    </xsl:apply-templates>
    <xsl:text> ]&#10;</xsl:text>
  </xsl:when>
  <!-- simple-type values -->
  <xsl:when test="@value">
    <!-- figure out node type for ProtoDeclared ProtoInstance, ExternProtoDeclared ProtoInstance and internal DTD declaration tag definitions -->
    <xsl:variable name="nodeName" select="../@name" />
    <xsl:variable name="nodeName2" select="local-name(..)" />
    <!-- ProtoDeclared ProtoInstance -->
    <xsl:variable name="nodeType" select="//ProtoDeclare[@name=$nodeName or @name=$nodeName2]/field[@name=$fieldName]/@type" />
    <!-- ExternProtoDeclared ProtoInstance -->
    <xsl:variable name="EPnodeType" select="//ExternProtoDeclare[@name=$nodeName or @name=$nodeName2]/field[@name=$fieldName]/@type" />
    <!-- debug diagnosis statements -->
    <!-- <xsl:text># fieldName </xsl:text><xsl:value-of select="$fieldName"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># nodeName </xsl:text><xsl:value-of select="$nodeName"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># nodeName2 </xsl:text><xsl:value-of select="$nodeName2"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># nodeType </xsl:text><xsl:value-of select="$nodeType"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># EPnodeType </xsl:text><xsl:value-of select="$EPnodeType"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># @nodeTypeHint </xsl:text><xsl:value-of select="@nodeTypeHint"/><xsl:text>&#10;</xsl:text> -->
    <xsl:variable name="MFtypes"
		select="($nodeType  ='Booleans')  or ($nodeType  ='Colors') or ($nodeType  ='Floats')       or ($nodeType  ='Integers') or
			($nodeType  ='Rotations') or ($nodeType  ='Times')  or ($nodeType  ='Vector2FloatArray') or ($nodeType  ='Vector3FloatArray') or
			($EPnodeType='Booleans')  or ($EPnodeType='Colors') or ($EPnodeType='Floats')       or ($EPnodeType='Integers') or
			($EPnodeType='Rotations') or ($EPnodeType='Times')  or ($EPnodeType='Vector2FloatArray') or ($EPnodeType='Vector3FloatArray')" />
    <xsl:variable name="DisJavaVrmlBooleanTypes"
		select="(($nodeName='EspduTransform'	or $nodeName2='EspduTransform'  or
		          $nodeName='ReceiverPdu'	or $nodeName2='ReceiverPdu'	or 
		          $nodeName='SignalPdu'		or $nodeName2='SignalPdu'	or
		          $nodeName='TransmitterPdu'	or $nodeName2='TransmitterPdu') and
      				     ($fieldName='traceJava' or $fieldName='rtpHeaderExpected'))" />
    <!-- <xsl:text># MFtypes </xsl:text><xsl:value-of select="$MFtypes"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text># DisJavaVrmlBooleanTypes </xsl:text><xsl:value-of select="$DisJavaVrmlBooleanTypes"/><xsl:text>&#10;</xsl:text> -->
    <xsl:choose>
      <!-- take care of boolean value capitalization -->
      <xsl:when test="(($nodeType  ='Boolean') or ($EPnodeType='Boolean') or ($DisJavaVrmlBooleanTypes='true')) and @value='true'">
        <xsl:text> TRUE&#10;</xsl:text>
      </xsl:when>
      <xsl:when test="(($nodeType  ='Boolean') or ($EPnodeType='Boolean') or ($DisJavaVrmlBooleanTypes='true')) and @value='false'">
        <xsl:text> FALSE&#10;</xsl:text>
      </xsl:when>
      <!-- take care of SFString fields by wrapping &quot; quotation marks &quot; -->
      <xsl:when test="((local-name(..)='Anchor'     or $nodeType='Anchor'	or $EPnodeType='Anchor'		or @nodeTypeHint='Anchor') and
      				    local-name()='description') or
                      ((local-name(..)='AudioClip'  or $nodeType='AudioClip'	or $EPnodeType='AudioClip'	or @nodeTypeHint='AudioClip') and
      				    local-name()='description') or
                      ((local-name(..)='Fog'        or $nodeType='Fog'	or $EPnodeType='Fog'		or @nodeTypeHint='Fog') and
      				    local-name()='fogType')     or
                      ((local-name(..)='FontStyle'  or $nodeType='FontStyle'	or $EPnodeType='FontStyle'	or @nodeTypeHint='FontStyle') and
      				   (local-name()='language' or local-name()='style'))       or
                      ((local-name(..)='Viewpoint'  or $nodeType='Viewpoint'	or $EPnodeType='Viewpoint'	or @nodeTypeHint='Viewpoint') and
      				    local-name()='description') or
                      ((local-name(..)='WorldInfo'  or $nodeType='WorldInfo'	or $EPnodeType='WorldInfo'	or @nodeTypeHint='WorldInfo') and
      				    local-name()='title') or
      		($nodeType   = 'String') or
      		($EPnodeType = 'String')
                     ">
        <xsl:choose>
          <!-- output SFString.  wrap quotes (null string) if string-length 0 -->
          <xsl:when test="not(@value)"><xsl:text> &quot;&quot;&#10;</xsl:text></xsl:when>
          <!-- output SFString.  no need to wrap quotes -->
          <xsl:when test="starts-with(normalize-space(@value),'&quot;')"><xsl:text> </xsl:text><xsl:value-of select="@value" /><xsl:text>&#10;</xsl:text></xsl:when>
          <xsl:when test='starts-with(@value,"&apos;")'><xsl:text> </xsl:text><xsl:value-of select="@value" /><xsl:text>&#10;</xsl:text></xsl:when>
          <!-- output SFString with wrapped quotes since it doesn't have any-->
          <xsl:otherwise><xsl:text> &quot;</xsl:text><xsl:value-of select="@value" /><xsl:text>&quot;&#10;</xsl:text></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- take care of some special MFString types by adding enclosing &quot; &quot; marks -->
      <xsl:when test="((local-name(..)='FontStyle'		or $nodeType='FontStyle'    	or $EPnodeType='FontStyle'  	or @nodeTypeHint='FontStyle') and
      				   (local-name()='family' or local-name()='justify')) or
      		      ((local-name(..)='NavigationInfo'		or $nodeType='NavigationInfo' 	or $EPnodeType='NavigationInfo' or @nodeTypeHint='NavigationInfo') and
      				    local-name()='type')">
        <xsl:choose>
          <!-- output MFString.  wrap quotes if string-length 0 -->
          <xsl:when test="not(@value)"><xsl:text> [ &quot;&quot; ]&#10;</xsl:text></xsl:when>
          <!-- output MFString.  don't modify quotes if some are there already -->
          <xsl:when test="contains(@value,'&quot;')"><xsl:text> [ </xsl:text><xsl:value-of select="@value" /><xsl:text> ]&#10;</xsl:text></xsl:when> <!-- ### quotes found... -->
          <!-- output MFString with wrapped quotes around token values -->
          <xsl:otherwise>
            <!-- <xsl:text> ### inputString &quot;</xsl:text><xsl:value-of select="concat(normalize-space(translate(@value,'&quot;',' ')),' ')"/><xsl:text>&quot;&#10;</xsl:text> -->
            <xsl:text> [</xsl:text>
            <xsl:call-template name="wrap-quotes-around-tokens">
              <xsl:with-param name="inputString" select="concat(normalize-space(translate(@value,'&quot;',' ')),' ')"/>
            </xsl:call-template>
            <xsl:text> ]&#10;</xsl:text> <!-- ### inserted quotes around tokens... -->
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- take care of MFString types by wrapping [ ]
           (if necessary, ensure contained SFString elements wrapped in &quot; &quot;) -->
      <xsl:when test="((local-name(..)='Anchor'			or $nodeType='Anchor'		or $EPnodeType='Anchor'		or @nodeTypeHint='Anchor') and
      				   (local-name()='parameter'	or local-name()='url')) or
                      ((local-name(..)='AudioClip'		or $nodeType='AudioClip'	or $EPnodeType='AudioClip'	or @nodeTypeHint='AudioClip') and
      				    local-name()='url') or
                      ((local-name(..)='Background'		or $nodeType='Background'	or $EPnodeType='Background' 	or @nodeTypeHint='Background') and
      				    contains(local-name(),'Url'))	or
                      ((local-name(..)='ImageTexture'		or $nodeType='ImageTexture' 	or $EPnodeType='ImageTexture'	or @nodeTypeHint='ImageTexture') and
      				    local-name()='url') or
                      ((local-name(..)='Inline'			or $nodeType='Inline'		or $EPnodeType='Inline'		or @nodeTypeHint='Inline') and
      				    local-name()='url') or
                      ((local-name(..)='MovieTexture'		or $nodeType='MovieTexture'	or $EPnodeType='MovieTexture'	or @nodeTypeHint='MovieTexture') and
      				    local-name()='url') or
                      ((local-name(..)='Script'			or $nodeType='Script'		or $EPnodeType='Script'		or @nodeTypeHint='Script') and
      				    local-name()='url') or
                      ((local-name(..)='Text'			or $nodeType='Text'		or $EPnodeType='Text'		or @nodeTypeHint='Text') and
      				    local-name()='string') or
                      ((local-name(..)='WorldInfo'		or $nodeType='WorldInfo'    	or $EPnodeType='WorldInfo'	or @nodeTypeHint='WorldInfo') and
      				    local-name()='info') or
      				($nodeType   = 'Strings') or
      				($EPnodeType = 'Strings')">
        <xsl:choose>
          <!-- output MFString.  wrap quotes if string-length 0 -->
          <xsl:when test="not(@value)"><xsl:text> [ &quot;&quot; ]&#10;</xsl:text></xsl:when>
          <!-- output MFString.  no need to wrap quotes -->
          <xsl:when test="starts-with(normalize-space(@value),'&quot;')"><xsl:text> [ </xsl:text><xsl:value-of select="@value" /><xsl:text> ]&#10;</xsl:text></xsl:when>
          <xsl:when test='starts-with(@value,"&apos;")'><xsl:text> [ </xsl:text><xsl:value-of select="@value" /><xsl:text> ]&#10;</xsl:text></xsl:when>
          <!-- output MFString with wrapped quotes since it doesn't have any-->
          <xsl:otherwise><xsl:text> [ &quot;</xsl:text><xsl:value-of select="@value" /><xsl:text>&quot; ]&#10;</xsl:text></xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- take care of other MF field types by wrapping [ ] -->
      <xsl:when test="(contains(local-name(..),'Interpolator') and contains(local-name(),'key')) or
                      ( local-name(..)='Background'			or $nodeType='Background'	or $EPnodeType='Background'	or @nodeTypeHint='Background') or
                      ((local-name(..)='ColorNode'			or $nodeType='ColorNode'	or $EPnodeType='ColorNode'	or @nodeTypeHint='ColorNode' or
                        local-name(..)='Color'    		or $nodeType='Color'    	or $EPnodeType='Color'    		or @nodeTypeHint='Color'    ) and
      				    local-name()='color') or
                      ((local-name(..)='Coordinate'			or $nodeType='Coordinate'	or $EPnodeType='Coordinate'	or @nodeTypeHint='Coordinate') and
      				    local-name()='point') or
                      ((local-name(..)='ElevationGrid'		or $nodeType='ElevationGrid'	or $EPnodeType='ElevationGrid'	or @nodeTypeHint='ElevationGrid') and
      				    local-name()='height') or
                      ((local-name(..)='Extrusion'			or $nodeType='Extrusion'	or $EPnodeType='Extrusion'	or @nodeTypeHint='Extrusion') and
      				   (local-name()='crossSection' or local-name()='orientation' or local-name()='scale' or local-name()='spine')) or
                      ((local-name(..)='IndexedFaceSet'		or $nodeType='IndexedFaceSet'	or $EPnodeType='IndexedFaceSet'	or @nodeTypeHint='IndexedFaceSet') and
      				    contains(local-name(),'Index')) or
                      ((local-name(..)='IndexedLineSet'		or $nodeType='IndexedLineSet'	or $EPnodeType='IndexedLineSet'	or @nodeTypeHint='IndexedLineSet') and
      				    contains(local-name(),'Index')) or
                      ((local-name(..)='LOD'				or $nodeType='LOD'		or $EPnodeType='LOD'		or @nodeTypeHint='LOD') and
      				    local-name()='range') or
                      ((local-name(..)='NavigationInfo'		or $nodeType='NavigationInfo'	or $EPnodeType='NavigationInfo'	or @nodeTypeHint='NavigationInfo') and
      				    local-name()='avatarSize') or
                      ((local-name(..)='Normal'			or $nodeType='Normal'		or $EPnodeType='Normal'		or @nodeTypeHint='Normal') and
      				    local-name()='vector') or
                      ((local-name(..)='Text'				or $nodeType='Text'		or $EPnodeType='Text'		or @nodeTypeHint='Text') and
      				    local-name()='length') or
                      ((local-name(..)='TextureCoordinate'		or $nodeType='TextureCoordinate' or $EPnodeType='TextureCoordinate' or @nodeTypeHint='TextureCoordinate') and
      				    local-name()='point') or
      			    $MFtypes
      			">
        <!-- could put traps here to eliminate default-valued fields -->
        <!-- ?? is a local construct needed here to check and wrap quotes around individual string elements in MFString, if content didn't comply?? -->
        <xsl:text> [ </xsl:text><xsl:value-of select="@value"/><xsl:text> ]&#10;</xsl:text>
      </xsl:when>
      <!-- default field output is merely standalone value(s) -->
      <xsl:otherwise>
        <xsl:if test="."><xsl:text> </xsl:text><xsl:value-of select="@value"/><xsl:text>&#10;</xsl:text></xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:when>
  <xsl:otherwise>
    <xsl:text> ### XSL-translation warning:  improper fieldValue initialization&#10;</xsl:text>
  </xsl:otherwise>
</xsl:choose>
</xsl:template>



<!-- ****** field:  used inside Script, ProtoDeclare, ExternProtoDeclare. ****** -->
<xsl:template match="field">
<xsl:param name="indent" select="0"/>
<!-- <xsl:text># $indent=</xsl:text><xsl:value-of select="$indent"/><xsl:text>### &#10;</xsl:text> -->
<xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
  <!-- first, field type -->
  <xsl:choose>
    <xsl:when test="@vrml97Hint='eventIn'      "><xsl:text>eventIn      </xsl:text></xsl:when>
    <xsl:when test="@vrml97Hint='eventOut'     "><xsl:text>eventOut     </xsl:text></xsl:when>
    <xsl:when test="@vrml97Hint='field'        "><xsl:text>field        </xsl:text></xsl:when>
    <xsl:when test="not(local-name(..)='Script') and @vrml97Hint='exposedField' "><xsl:text>exposedField </xsl:text></xsl:when>
    <xsl:when test="local-name(..)='Script' and @vrml97Hint='exposedField' ">
       <xsl:text>&#10;### XSL-translation warning: &apos;exposedField&apos; not allowed in VRML 97 Script, used &apos;field&apos; instead&#10;field </xsl:text></xsl:when>
    <!-- unspecified or unknown:  defaults to semantics most similar to X3D fields -->
    <!-- Scripts cannot contain exposedField so default becomes VRML 97 field -->
    <xsl:when test="local-name(..)='Script'    "><xsl:text>field </xsl:text></xsl:when>
    <xsl:otherwise><xsl:text>exposedField </xsl:text></xsl:otherwise>
  </xsl:choose>
  <!-- next, base type -->
  <xsl:choose>
    <xsl:when test="@type='Boolean'      "><xsl:text>SFBool	</xsl:text></xsl:when>
    <xsl:when test="@type='Booleans'     "><xsl:text>MFBool	</xsl:text></xsl:when>
    <xsl:when test="@type='Color'        "><xsl:text>SFColor	</xsl:text></xsl:when>
    <xsl:when test="@type='Colors'       "><xsl:text>MFColor	</xsl:text></xsl:when>
    <xsl:when test="@type='Float'        "><xsl:text>SFFloat	</xsl:text></xsl:when>
    <xsl:when test="@type='Floats'       "><xsl:text>MFFloat	</xsl:text></xsl:when>
    <xsl:when test="@type='Image'        "><xsl:text>SFImage	</xsl:text></xsl:when>
    <xsl:when test="@type='Integer'      "><xsl:text>SFInt32	</xsl:text></xsl:when>
    <xsl:when test="@type='Integers'     "><xsl:text>MFInt32	</xsl:text></xsl:when>
    <xsl:when test="@type='Node'         "><xsl:text>SFNode     </xsl:text></xsl:when>
    <xsl:when test="@type='Nodes'        "><xsl:text>MFNode	</xsl:text></xsl:when>
    <xsl:when test="@type='Rotation'     "><xsl:text>SFRotation	</xsl:text></xsl:when>
    <xsl:when test="@type='Rotations'    "><xsl:text>MFRotation	</xsl:text></xsl:when>
    <xsl:when test="@type='String'       "><xsl:text>SFString	</xsl:text></xsl:when>
    <xsl:when test="@type='Strings'      "><xsl:text>MFString	</xsl:text></xsl:when>
    <xsl:when test="@type='Time'         "><xsl:text>SFTime	</xsl:text></xsl:when>
    <xsl:when test="@type='Times'        "><xsl:text>MFTime	</xsl:text></xsl:when>
    <xsl:when test="@type='Vector2Float'      "><xsl:text>SFVec2f	</xsl:text></xsl:when>
    <xsl:when test="@type='Vector2FloatArray' "><xsl:text>MFVec2f	</xsl:text></xsl:when>
    <xsl:when test="@type='Vector3Float'      "><xsl:text>SFVec3f	</xsl:text></xsl:when>
    <xsl:when test="@type='Vector3FloatArray' "><xsl:text>MFVec3f	</xsl:text></xsl:when>
    <!-- unknown or previously unspecified type -->
    <xsl:when test="not(@type)           "><xsl:text>absentTypeError # XSL-translation error:  type is required for field variables&#10;</xsl:text></xsl:when>
    <xsl:otherwise><xsl:value-of select="@type"/><xsl:text> </xsl:text></xsl:otherwise>
  </xsl:choose>
  <!-- next, field name -->
  <xsl:value-of select="@name"/>
  <!-- next, IS name -->
  <xsl:variable name="DEFname" select="../@DEF" />
  <xsl:variable name="fieldName" select="@name" />
  <xsl:variable name="matchName" select="concat($DEFname, '.', $fieldName)" />
  <xsl:if test="local-name(..)='Script' and ../@DEF">
    <!-- pattern-match variables -->
    <!-- <xsl:text> # $DEFname   </xsl:text><xsl:value-of select="$DEFname"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text> # $fieldName </xsl:text><xsl:value-of select="$fieldName"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text> # $matchName </xsl:text><xsl:value-of select="$matchName"/><xsl:text>&#10;</xsl:text> -->
    <!-- <xsl:text> # ancestor PROTO field </xsl:text><xsl:value-of select="local-name(ancestor::*[local-name()='ProtoDeclare'])"/><xsl:text>&#10;</xsl:text> -->
    <xsl:for-each select="ancestor::*[local-name()='ProtoDeclare']/field">
      <!-- <xsl:text> # node rule: @IS </xsl:text><xsl:value-of select="@IS"/><xsl:text>&#10;</xsl:text> -->
      <!-- <xsl:text> # (starts-with(@IS,concat($DEFname, '.')) </xsl:text><xsl:value-of select="starts-with(@IS,concat($DEFname, '.'))"/><xsl:text>&#10;</xsl:text> -->
      <!-- <xsl:text> # concat($DEFname, '.') </xsl:text><xsl:value-of select="concat($DEFname, '.')"/><xsl:text>&#10;</xsl:text> -->
      <!-- <xsl:text> # @type </xsl:text><xsl:value-of select="@type"/><xsl:text>&#10;</xsl:text> -->
      <!-- <xsl:text> # substring-after(@IS,'.') </xsl:text><xsl:value-of select="substring-after(@IS,'.')"/><xsl:text>&#10;</xsl:text> -->
      <xsl:if test="@IS=$matchName or
                    starts-with(@IS,concat($matchName,' ')) or
                    contains(@IS,concat(' ',$matchName,' ')) or
                    (contains(@IS,concat(' ',$matchName)) and string-length(substring-after(@IS,concat(' ',$matchName)))=0)">
         <xsl:text> IS </xsl:text><xsl:value-of select="@name"/>
      </xsl:if>
    </xsl:for-each>
  </xsl:if>
  <!-- check that @value is not provided as initializing value for fields of type Node/Nodes-->
  <xsl:if test="(@type='Node' or @type='Nodes') and @value and @value!='NULL'">
    <xsl:text>&#10;# XSL-translation error:  cannot initialize field of type Node/Nodes with @value - initialize with contained content or @USE instead&#10;</xsl:text>
  </xsl:if>
  <!-- check that @USE only appears as initializing value for fields of type Node/Nodes-->
  <xsl:if test="@USE and not(@type='Node' or @type='Nodes')">
    <xsl:text>&#10;### XSL-translation warning:  ignoring @USE since it is only allowed to initialize fields of type Node/Nodes&#10;</xsl:text>
  </xsl:if>
  <!-- check that both @USE and contained content not provided simultaneously as initializing value for fields of type Node/Nodes-->
  <xsl:if test="@USE and (@type='Node' or @type='Nodes') and *">
    <xsl:text>&#10;### XSL-translation warning:  ignoring @USE since initializing with contained content nodes&#10;</xsl:text>
  </xsl:if>
  <!-- last, provide initializing value (if appropriate) -->
  <xsl:choose>
    <!-- no initial value for IS fields -->
    <xsl:when test="(local-name(..)='Script' or local-name(..)='ExternProtoDeclare') and @IS">
       <xsl:text> ### XSL-translation warning:  IS declarations not allowed for Script or ExternProtoDeclare, ignoring IS value </xsl:text><xsl:value-of select="@value" /><xsl:text>&#10;</xsl:text>
    </xsl:when>
    <xsl:when test="@value and local-name(..)='Script' and ../@DEF and ancestor::*[local-name()='ProtoDeclare']/field[@name=$fieldName and contains(@IS,concat($DEFname, '.', $fieldName))]">
       <xsl:text> ### XSL-translation warning:  initialization values not allowed for IS declarations, ignoring initial value </xsl:text><xsl:value-of select="@value" />
    </xsl:when>
    <!-- properly declared Script field with corresponding IS in prototype declaration - no action required --> 
    <xsl:when test="local-name(..)='Script' and ../@DEF and ancestor::*[local-name()='ProtoDeclare']/field[@name=$fieldName and contains(@IS,concat($DEFname, '.', $fieldName))]"></xsl:when>
    <!-- no initial value for ExternProtoDeclare fields -->
    <xsl:when test="@value and local-name(..)='ExternProtoDeclare'"><xsl:text> ### XSL-translation warning:  initialization values not allowed inside EXTERNPROTO field declarations, ignoring initial value </xsl:text><xsl:value-of select="@value" /></xsl:when>
    <xsl:when test="local-name(..)='ExternProtoDeclare'"><!-- ignore, no value is the correct case for ExternProtoDeclare --></xsl:when>
    <!-- eventIn, eventOut -->
    <xsl:when test="@vrml97Hint='eventIn'      and @value"><!-- <xsl:text> ### XSL-translation warning:  ignoring initial value for eventIn </xsl:text><xsl:value-of select="@value" /> --></xsl:when>
    <xsl:when test="@vrml97Hint='eventOut'     and @value"><!-- <xsl:text> ### XSL-translation warning:  ignoring initial value for eventOut </xsl:text><xsl:value-of select="@value" /> --></xsl:when>
    <xsl:when test="@vrml97Hint='eventIn' or @vrml97Hint='eventOut'"><!-- no value required --></xsl:when>
    <!-- wrap SFStrings in quotes -->
    <xsl:when test="@type='String'"><xsl:text> &quot;</xsl:text><xsl:value-of select="@value" /><xsl:text>&quot;</xsl:text></xsl:when>
    <!-- output MFString.  wrap quotes if string-length 0 or 1 -->
    <xsl:when test="(@type='Strings' and
                     (string-length(@value)=0 or string-length(@value)=1))"><xsl:text> [&#10;&quot;</xsl:text><xsl:value-of select="@value" /><xsl:text>&quot;&#10;]</xsl:text></xsl:when>
    <xsl:when test="(@type='Strings' and starts-with(@value,'&quot;'))"><xsl:text> [&#10;</xsl:text><xsl:value-of select="@value" /><xsl:text>&#10;]</xsl:text></xsl:when>
    <xsl:when test='(@type="Strings" and starts-with(@value,"&apos;"))'><xsl:text> [&#10;</xsl:text><xsl:value-of select="@value" /><xsl:text>&#10;]</xsl:text></xsl:when>
    <!-- output MFString with wrapped quotes when it doesn't have any-->
    <xsl:when test="(@type='Strings')">
                     <xsl:text> [ &quot;</xsl:text><xsl:value-of select="@value" /><xsl:text>&quot; ]</xsl:text></xsl:when>
    <!-- output SFNode if initializing child present -->
    <xsl:when test="@type='Node' and *">
      <xsl:text> </xsl:text>
      <xsl:apply-templates select="*">
        <xsl:with-param name="indent" select="$indent + 2"/>
      </xsl:apply-templates>
    </xsl:when>
    <!-- output MFNode if initializing children present -->
    <xsl:when test="@type='Nodes' and *">
      <xsl:text> [&#10;</xsl:text>
      <xsl:apply-templates select="*">
        <xsl:with-param name="indent" select="$indent + 2"/>
      </xsl:apply-templates>
      <xsl:text>]</xsl:text>
    </xsl:when>
    <!-- straightforward output cases follow, check whether SF (single field) or MF (multiple field) values -->
    <!-- error:  embedded SFNode/MFNode when USE present -->
    <xsl:when test="@USE and *">
      <xsl:text> USE </xsl:text>
      <xsl:value-of select="@USE"/>
      <xsl:text> # XSL-translation error, no embedded node content allowed </xsl:text>
      <xsl:apply-templates select="comment()">
        <xsl:with-param name="indent" select="$indent + 2"/>
      </xsl:apply-templates>
    </xsl:when>
    <!-- error:  incorrect field type when USE present -->
    <xsl:when test="@USE and not(@type='Node' or @type='Nodes')">
      <xsl:text> USE </xsl:text><xsl:value-of select="@USE"/>
      <xsl:text> # XSL-translation error, mismatched type for USE=nodeName </xsl:text>
      <xsl:apply-templates select="comment()">
        <xsl:with-param name="indent" select="$indent + 2"/>
      </xsl:apply-templates>
    </xsl:when>
    <!-- output SFNode/MFNode name if USE present -->
    <xsl:when test="@USE and (@type='Node' or @type='Nodes')">
      <xsl:text> USE </xsl:text>
      <xsl:value-of select="@USE"/>
      <xsl:apply-templates select="comment()">
        <xsl:with-param name="indent" select="$indent + 2"/>
      </xsl:apply-templates>
    </xsl:when>
    <xsl:when test="@value">
      <xsl:choose>
        <!-- output Boolean values -->
        <xsl:when test="@type='Boolean' and @value='true'"><xsl:text> TRUE</xsl:text></xsl:when>
        <xsl:when test="@type='Boolean' and @value='false'"><xsl:text> FALSE</xsl:text></xsl:when>
        <!-- if Booleans is ever supported as a native type, will need to auto-capitalize the following values... -->
        <xsl:when test="@type='Booleans'"><xsl:text> [ </xsl:text><xsl:value-of select="@value" /><xsl:text> ]</xsl:text></xsl:when>
        <!-- output other SF values (Node  is possible, might contain NULL) -->
        <xsl:when test="(@type='Color' or @type='Float'   or @type='Image' or @type='Integer' or @type='Node' or @type='Rotation' or @type='String' or
                         @type='Time'  or @type='Vector2Float' or @type='Vector3Float' )"><xsl:text> </xsl:text><xsl:value-of select="@value" /></xsl:when>
        <!-- output other MF values (Nodes is possible, might contain NULL) -->
        <xsl:when test="(@type='Colors'  or @type='Floats' or @type='Integers' or @type='Nodes' or @type='Rotations' or @type='Strings' or
                         @type='Times' or @type='Vector2FloatArray' or @type='Vector3FloatArray' )"><xsl:text> [ </xsl:text><xsl:value-of select="@value" /><xsl:text> ]</xsl:text></xsl:when>
        <xsl:otherwise><xsl:text> </xsl:text><xsl:value-of select="@value" /><xsl:text> # unknown type!</xsl:text></xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <!-- no value provided for field or exposedField, or no Node/Nodes children, or no hint provided, must determine default value -->
    <xsl:otherwise>
      <xsl:choose>
        <xsl:when test="@type='Node'         "><xsl:text> NULL</xsl:text></xsl:when>
        <xsl:when test="@type='Nodes'        "><xsl:text> [ ]</xsl:text></xsl:when>
        <xsl:when test="@type='Boolean'      "><xsl:text> FALSE</xsl:text></xsl:when>
        <xsl:when test="@type='Booleans'     "><xsl:text> [ ]</xsl:text></xsl:when>
        <xsl:when test="@type='Color'        "><xsl:text> 0 0 0</xsl:text></xsl:when>
        <xsl:when test="@type='Colors'       "><xsl:text> [ ]</xsl:text></xsl:when>
        <xsl:when test="@type='Float'        "><xsl:text> 0.0</xsl:text></xsl:when>
        <xsl:when test="@type='Floats'       "><xsl:text> [ ]</xsl:text></xsl:when>
        <xsl:when test="@type='Image'        "><xsl:text> 0 0 0</xsl:text></xsl:when>
        <xsl:when test="@type='Integer'      "><xsl:text> 0</xsl:text></xsl:when>
        <xsl:when test="@type='Integers'     "><xsl:text> [ ]</xsl:text></xsl:when>
        <xsl:when test="@type='Rotation'     "><xsl:text> 0 0 1 0</xsl:text></xsl:when>
        <xsl:when test="@type='Rotations'    "><xsl:text> [ ]</xsl:text></xsl:when>
        <xsl:when test="@type='String'       "><xsl:text> ""</xsl:text></xsl:when>
        <xsl:when test="@type='Strings'      "><xsl:text> [ ]</xsl:text></xsl:when>
        <xsl:when test="@type='Time'         "><xsl:text> -1</xsl:text></xsl:when>
        <xsl:when test="@type='Times'        "><xsl:text> [ ]</xsl:text></xsl:when>
        <xsl:when test="@type='Vector2Float'      "><xsl:text> 0 0</xsl:text></xsl:when>
        <xsl:when test="@type='Vector2FloatArray' "><xsl:text> [ ]</xsl:text></xsl:when>
        <xsl:when test="@type='Vector3Float'      "><xsl:text> 0 0 0</xsl:text></xsl:when>
        <xsl:when test="@type='Vector3FloatArray' "><xsl:text> [ ]</xsl:text></xsl:when>
        <!-- unknown or previously unspecified type -->
        <xsl:when test="not(@type)           "><!-- ignore, no further action required --></xsl:when>
        <xsl:otherwise><xsl:value-of select="@type"/><!-- ignore, no further action required --></xsl:otherwise>
      </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="@IS">
    <xsl:choose>
      <xsl:when test="local-name(..)='ExternProtoDeclare' ">
        <xsl:text> ### XSL-translation warning:  IS references not allowed inside EXTERNPROTO field declarations, ignored</xsl:text>
        <xsl:text> ### IS </xsl:text><xsl:value-of select="@IS" />
      </xsl:when>
      <xsl:when test="local-name(..)='ProtoDeclare'">
        <xsl:text> # IS </xsl:text><xsl:value-of select="@IS" />
      </xsl:when>
      <xsl:when test="local-name(..)='Script'">
        <xsl:text>&#10;### XSL-translation warning:  field </xsl:text>
        <xsl:value-of select="@name" />
        <xsl:text> IS="</xsl:text>
        <xsl:value-of select="@IS" />
        <xsl:text>" definition not allowed inside Script node, ignored.&#10;</xsl:text>
        <xsl:text>### IS definitions belong in ProtoDeclare field definitions, pointing to contained Script node fields.</xsl:text>
      </xsl:when>
      <xsl:otherwise><xsl:text> ### XSL-translation warning:  why an IS reference here?  # IS </xsl:text><xsl:value-of select="@IS" /></xsl:otherwise>
    </xsl:choose>
  </xsl:if>
  <xsl:if test="comment()">
    <xsl:text>&#10;</xsl:text>
    <xsl:apply-templates select="comment()">
      <xsl:with-param name="indent" select="$indent + 2"/>
    </xsl:apply-templates>
  </xsl:if>
  <!-- finished with this field -->
  <xsl:text>&#10;</xsl:text>
</xsl:template>


<!-- ****** ExternProtoDeclare ****** -->
<xsl:template match="ExternProtoDeclare">
<xsl:param name="indent" select="0"/>
<!-- <xsl:text># $indent=</xsl:text><xsl:value-of select="$indent"/><xsl:text>### &#10;</xsl:text> -->
<xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
<xsl:text>EXTERNPROTO </xsl:text>
<xsl:value-of select="@name" />
<xsl:text> [&#10;</xsl:text>
<xsl:if test="@nodeTypeHint"><xsl:text># nodeTypeHint </xsl:text><xsl:value-of select="@nodeTypeHint" /><xsl:text>&#10;</xsl:text></xsl:if>
<!-- ExternProtoDeclare is only allowed to contain X3D field tags, no initializations or IS statements, check each -->
<xsl:apply-templates select="field | comment()">
  <xsl:with-param name="indent" select="$indent + 2"/>
</xsl:apply-templates>
<!-- finish with URLs -->
<xsl:text>][&#10;</xsl:text>
<xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
<xsl:choose>
  <!-- output url MFString.  wrap quotes if necessary -->
  <xsl:when test="not(@url)"><xsl:text>&quot;&quot; # error, no URL(s) provided for EXTERNPROTO&#10;</xsl:text></xsl:when>
  <xsl:when test="string-length(@url)=1"><xsl:text>  &quot;</xsl:text><xsl:value-of select="@url" /><xsl:text>&quot;</xsl:text></xsl:when>
  <xsl:when test="starts-with(@url,'&quot;')"><xsl:text>  </xsl:text><xsl:value-of select="@url" /></xsl:when>
  <xsl:when test='starts-with(@url,"&apos;")'><xsl:text>  </xsl:text><xsl:value-of select="@url" /></xsl:when>
  <!-- output MFString with wrapped quotes since it doesn't have any (but could still be multiple URLs, which is bad!) -->
  <xsl:otherwise><xsl:text>  &quot;</xsl:text><xsl:value-of select="@url" /><xsl:text>&quot;</xsl:text></xsl:otherwise>
</xsl:choose>
<xsl:text>&#10;</xsl:text>
<xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
<xsl:text> ]&#10;</xsl:text>
</xsl:template>


<!-- ****** ProtoDeclare ****** -->
<xsl:template match="ProtoDeclare">
<xsl:param name="indent" select="0"/>
<!-- <xsl:text># $indent=</xsl:text><xsl:value-of select="$indent"/><xsl:text>### &#10;</xsl:text> -->
<xsl:call-template name="print-indent"><xsl:with-param name="indent" select="$indent"/></xsl:call-template>
<xsl:text>PROTO </xsl:text><xsl:value-of select="@name" /><xsl:text> [&#10;</xsl:text>
<!-- ProtoDeclare is allowed to contain X3D field tags and content, check each field tag first -->
<xsl:apply-templates select="field | comment()[following-sibling::field]">
  <xsl:with-param name="indent" select="$indent + 2"/>
</xsl:apply-templates>
<!-- now handle embedded content -->
<xsl:text>] {&#10;</xsl:text>
<!-- recurse on non-field-tag children -->
<xsl:apply-templates select="*[local-name()!='field'] | comment()[not(following-sibling::field)]">
  <xsl:with-param name="indent" select="$indent + 2"/>
</xsl:apply-templates>
<xsl:text>}&#10;</xsl:text>
</xsl:template>


<!-- ****** children:  ignore wrapper tags (since redundant with VRML definitions) ****** -->

<xsl:template match="appearance[local-name(..)='Shape'] |
                     children[local-name(..)='Anchor'      or
                              local-name(..)='Billboard'   or
                              local-name(..)='Collision'   or
                              local-name(..)='Group'       or
                              local-name(..)='Transform'   or
                              local-name(..)='GeoInline'   or
                              local-name(..)='GeoLocation' or
                              local-name(..)='GeoLOD'      or
                              local-name(..)='Joint'       or
                              local-name(..)='Segment'     or
                              local-name(..)='Site'        or
                              local-name(..)='EspduTransform' or
                              local-name(..)='ProtoInstance' or
                              local-name(..)] |
                     choice[local-name(..)='Switch'] |
                     color[local-name(..)='ElevationGrid'    or 
                           local-name(..)='GeoElevationGrid' or 
                           local-name(..)='IndexedFaceSet'   or
                           local-name(..)='IndexedLineSet'   or
                           local-name(..)='PointSet'] |
                     coord[local-name(..)='IndexedFaceSet' or
                           local-name(..)='IndexedLineSet' or
                           local-name(..)='PointSet'] |
                     fontStyle[local-name(..)='Text'] |
                     geometry[local-name(..)='Shape'] |
                     level[local-name(..)='LOD'] |
                     material[local-name(..)='Appearance'] |
                     normal[local-name(..)='ElevationGrid'    or
                            local-name(..)='GeoElevationGrid' or
                            local-name(..)='IndexedFaceSet'] |
                     source[local-name(..)='Sound'] |
                     texCoord[local-name(..)='ElevationGrid'    or
                              local-name(..)='GeoElevationGrid' or
                              local-name(..)='IndexedFaceSet'] |
                     texture[local-name(..)='Appearance'] |
                     textureTransform[local-name(..)='Appearance'] |
                     sites[local-name(..)='Humanoid' and not(*)]">
<xsl:param name="indent" select="0"/>
<!-- <xsl:text># $indent=</xsl:text><xsl:value-of select="$indent"/><xsl:text>### &#10;</xsl:text> -->
  <!--
  <xsl:text># wrapper tag:  </xsl:text>
  <xsl:value-of select="local-name()"/>
  <xsl:text>&#10;</xsl:text>
-->
  <xsl:apply-templates>
    <xsl:with-param name="indent" select="$indent"/>
  </xsl:apply-templates>

</xsl:template>

<xsl:template name="print-indent">
  <xsl:param name="indent" select="0"/>
  <xsl:if test="$indent > 0">
    <xsl:text> </xsl:text>
    <xsl:call-template name="print-indent">
      <xsl:with-param name="indent" select="$indent - 1"/>
    </xsl:call-template>
  </xsl:if>
</xsl:template>

<xsl:template name="wrap-quotes-around-tokens">
  <xsl:param name="inputString" select="0"/>
  <!-- <xsl:text> ### inputString received: </xsl:text><xsl:value-of select="$inputString"/><xsl:text>&#10;</xsl:text> -->
  <xsl:if test="contains($inputString,' ')">
    <xsl:text> &quot;</xsl:text>
    <xsl:value-of select="substring-before($inputString,' ')"/>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="substring-after($inputString,' ')">
      <xsl:call-template name="wrap-quotes-around-tokens">
        <xsl:with-param name="inputString" select="substring-after($inputString,' ')"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:if>
</xsl:template>

</xsl:stylesheet>
