#define CONSTRUCT

#include <GL/glut.h>
#include <stdlib.h>
#include <stdio.h>
#include <vector>
#include <math.h>
#include <string>

#include "LinearAlgebra.h"

#include "Collision.h"




/*false constructor, for personal ease*/
struct pt pt(double ax=0., double ay=0., double az=0.)
{
    struct pt tmp = {ax,ay,az};
    return tmp;
}


using namespace std;

/* modifyable points */
vector<struct pt> pts;
vector<int> activepts;

vector<struct pt> debugpts;
vector<int> debugcolors;
vector<string> debugptsinfo;
int debugpt = 0;
int debugsurface = 0;
int facemask = 7;
int rotcenter = 0;

//#define DEBUGPTS
#include "Collision.cpp"

struct VRML_PolyRep polyrep;

struct pt  iv, jv, kv;

enum eslideplane {pxy=0,pyz=1,pzx=2,rot=3};

eslideplane slide = pxy;
bool perspective = true;



void init(void)
{    

    glClearColor (0.0, 0.0, 0.0, 0.0);
    glShadeModel(GL_FLAT);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_POINT_SMOOTH);

//    glEnable(GL_CULL_FACE);
//    glCullFace(GL_BACK);
    glPolygonMode(GL_BACK,GL_LINE);

    glPointSize(4.0);

/*    pts.push_back(pt(1,1,1));
    pts.push_back(pt(1,-1,1));
    pts.push_back(pt(0,0,1));
    pts.push_back(pt(0,-1,1));
    pts.push_back(pt(1,1,2));*/
    pts.push_back(pt(0,0,0));



    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glTranslatef(0.0, 0.0, -3.6);
     
}

void displayhandles(void) {
    glBegin(GL_POINTS);
    glColor3f(0.,1.,0.);
    //active handles
    for(int i=0; i < activepts.size(); i++) {
	glVertex3dv(&pts[activepts[i]].x);
	printf("#%d:(%f,%f,%f)\n",activepts[i],pts[activepts[i]].x,pts[activepts[i]].y,pts[activepts[i]].z);
    }
    //extra points 
    //debugfocus
    if(debugpt > 0 && debugpt < debugpts.size()) {
	glPointSize(6.0);
	glColor3f(1.,1.,1.);
	glVertex3dv(&debugpts[debugpt].x);
	glPointSize(4.0);
    }
    for(int i=0; i < debugpts.size(); i++) {
	if(i < debugcolors.size()) 
	    glColor3f(debugcolors[i]& (1<<0) ? 1.:.4,debugcolors[i]&(1<<1)? 1.:.4,debugcolors[i]&(1<<2)? 1.:.4);
	else 
	    glColor3f(1.,0,0);
	glVertex3dv(&debugpts[i].x);
    }
    //handles.
    glColor3f(0.,.5,.5);
    for(int i=0; i < pts.size(); i++) {
	glVertex3dv(&pts[i].x);
    }
    printf("\n");	
    glEnd();

    /*draw axis oriented pointers*/
    glBegin(GL_LINES);

    for(int i=0; i < activepts.size(); i++) {

	glColor3f(.5,0,0);
	glVertex3dv(&pts[activepts[i]].x);
	glVertex3f(0,pts[activepts[i]].y,pts[activepts[i]].z);

	glColor3f(0,.5,0);
	glVertex3dv(&pts[activepts[i]].x);
	glVertex3f(pts[activepts[i]].x,0,pts[activepts[i]].z);

	glColor3f(0,0,.5);
	glVertex3dv(&pts[activepts[i]].x);
	glVertex3f(pts[activepts[i]].x,pts[activepts[i]].y,0);
     
    }
    glEnd();
     
     
}

void displayaxis(void) {
    glBegin(GL_LINES);

    glColor3f(1,0,0);
    glVertex3f(0,0,0);
    glVertex3f(1,0,0);

    glColor3f(0,1,0);
    glVertex3f(0,0,0);
    glVertex3f(0,1,0);

    glColor3f(0,0,1);
    glVertex3f(0,0,0);
    glVertex3f(0,0,1);
     
    glEnd();

}

VRML_PolyRep makepolyrep(struct pt p1, struct pt p2, struct pt p3, struct pt p4, struct pt p5) {
    static int cindex[18];
    static float coord[15];
    static int colindex[18];
    static float color[18];

    int cindext[18] = {0,1,2, 3,2,1, 3,4,2, 3,1,4, 0,2,4, 0,4,1};
    float coordt[15] = {p1.x,p1.y,p1.z,
			p2.x,p2.y,p2.z,
			p3.x,p3.y,p3.z,
			p4.x,p4.y,p4.z,
			p5.x,p5.y,p5.z };
    int colindext[18] = {0,1,2, 3,4,5, 1,2,3, 4,5,0, 2,3,4, 5,0,1};
    float colort[18] = {.2,.4,.6,
			 .3,.5,.7,
			 .4,.6,.8,
			 .5,.7,.1,
			 .6,.8,.2,
			 .7,.1,.3};
    VRML_PolyRep pr = {0,6,6,cindex,coord,colindex,color,NULL,NULL,NULL,NULL};
    memcpy(cindex,cindext,sizeof(cindex));
    memcpy(coord,coordt,sizeof(coord));
    memcpy(colindex,colindext,sizeof(colindex));
    memcpy(color,colort,sizeof(color));
    return pr;
    
} 
/*
VRML_PolyRep makepolyrep() {
static int cindex[66];
static float coord[39];
 int cindext[66] = {0,1,2,2,3,4,2,4,5,2,5,6,0,2,6,12,11,10,12,10,9,12,9,8,0,12,8,0,8,7,0,7,1,1,7,8,1,8,2,2,8,9,2,9,3,3,9,10,3,10,4,4,10,11,4,11,5,5,11,12,5,12,6,6,12,0};
 float coordt[39] = {0.000000,0.000000,0.000000,5.500000,5.000000,0.880000,4.000000,5.500000,0.968000,7.000000,8.000000,1.408000,4.000000,9.000000,1.584000,1.000000,5.000000,0.880000,2.500000,4.500000,0.792000,5.500000,5.000000,-0.880000,4.000000,5.500000,-0.968000,7.000000,8.000000,-1.408000,4.000000,9.000000,-1.584000,1.000000,5.000000,-0.880000,2.500000,4.500000,-0.792000};
VRML_PolyRep pr = {0,22,16,cindex,coord,NULL,NULL,NULL,NULL,NULL,NULL};
memcpy(cindex,cindext,sizeof(cindex));
memcpy(coord,coordt,sizeof(coord));
return pr; }
*/

VRML_PolyRep makepolyrep() {
static int cindex[675];
static float coord[2025];
 int cindext[675] = {0,40,41,42,43,44,44,45,46,46,47,48,48,49,34,34,35,36,36,37,38,40,0,1,1,2,3,3,4,5,5,6,7,5,7,8,5,8,9,3,5,9,1,3,9,1,9,10,40,1,10,40,10,11,40,11,12,40,12,13,40,13,14,40,14,15,40,15,16,40,16,17,40,17,18,39,40,18,38,39,18,38,18,19,36,38,19,36,19,20,36,20,21,36,21,22,34,36,22,34,22,23,34,23,24,48,34,24,48,24,25,48,25,26,46,48,26,46,26,27,44,46,27,44,27,28,44,28,29,44,29,30,42,44,30,42,30,31,42,31,32,41,42,32,41,32,33,0,41,33,53,54,55,57,58,59,59,60,61,62,63,64,64,65,66,66,67,68,68,69,70,70,71,72,68,70,72,66,68,72,64,66,72,64,72,73,62,64,73,62,73,74,62,74,75,62,75,76,61,62,76,61,76,77,61,77,78,59,61,78,59,78,79,57,59,79,56,57,79,56,79,80,55,56,80,55,80,81,53,55,81,52,53,81,51,52,81,50,51,81,50,81,82,50,82,83,50,83,84,85,122,123,115,116,117,117,118,119,121,122,85,121,85,86,121,86,87,87,88,89,89,90,91,91,92,93,93,94,95,91,93,95,89,91,95,89,95,96,89,96,97,89,97,98,87,89,98,87,98,99,87,99,100,87,100,101,87,101,102,87,102,103,87,103,104,87,104,105,87,105,106,87,106,107,107,108,109,107,109,110,107,110,111,112,113,114,111,112,114,114,85,123,121,87,107,120,121,107,119,120,107,119,107,111,117,119,111,115,117,111,123,115,111,123,111,114,124,125,126,124,126,127,124,127,128,124,128,129,124,129,130,124,130,131,124,131,132,132,133,134,132,134,135,132,135,136,124,132,136,124,136,137,124,137,138,124,138,139,124,139,140,124,140,141,124,141,142,124,142,143,145,146,147,144,145,147,143,144,147,143,147,148,124,143,148,124,148,149,124,149,150,124,150,151,124,151,152,124,152,153,124,153,154,124,154,155,124,155,156,124,156,157,158,159,160,158,160,161,158,161,162,158,162,163,165,166,167,167,168,169,169,170,171,167,169,171,165,167,171,165,171,172,165,172,173,164,165,173,163,164,173,163,173,174,163,174,175,158,163,175,158,175,176,158,176,177,158,177,178,158,178,179,158,179,180,158,180,181,158,181,182,158,182,183,158,183,184,188,189,190,190,191,192,192,193,194,196,197,198,198,199,200,200,201,202,202,203,204,200,202,204,198,200,204,196,198,204,195,196,204,195,204,205,195,205,206,195,206,207,194,195,207,194,207,208,194,208,209,192,194,209,190,192,209,209,210,211,209,211,212,212,213,214,212,214,215,212,215,216,212,216,217,212,217,218,212,218,219,212,219,220,212,220,221,212,221,222,212,222,223,212,223,224,209,212,224,209,224,225,209,225,226,209,226,227,190,209,227,190,227,228,188,190,228,187,188,228,186,187,228,185,186,228,185,228,229,185,229,230,185,230,231,185,231,232};
 float coordt[2025] = {0.561220,-0.123790,0.000000,0.572878,-0.132117,0.000000,0.587310,-0.137113,0.000000,0.601743,-0.142109,0.000000,0.613401,-0.142109,0.000000,0.617842,-0.142109,0.000000,0.638381,-0.139334,0.000000,0.659475,-0.136558,0.000000,0.675018,-0.135448,0.000000,0.633940,-0.160428,0.000000,0.606739,-0.168755,0.000000,0.579539,-0.177636,0.000000,0.555669,-0.177636,0.000000,0.540681,-0.177636,0.000000,0.526248,-0.174861,0.000000,0.511815,-0.172085,0.000000,0.495162,-0.160428,0.000000,0.273116,-0.004996,0.000000,0.158763,0.012213,0.000000,0.097145,0.093259,0.000000,0.035527,0.174306,0.000000,0.035527,0.298651,0.000000,0.035527,0.441316,0.000000,0.112133,0.522362,0.000000,0.188739,0.603964,0.000000,0.322521,0.603964,0.000000,0.445756,0.603964,0.000000,0.517366,0.525693,0.000000,0.589531,0.447977,0.000000,0.589531,0.314194,0.000000,0.589531,0.191514,0.000000,0.533464,0.108247,0.000000,0.477398,0.024980,0.000000,0.376367,0.003886,0.000000,0.226486,0.568437,0.000000,0.177081,0.499602,0.000000,0.127676,0.430768,0.000000,0.127676,0.311419,0.000000,0.127676,0.182632,0.000000,0.177636,0.108802,0.000000,0.228152,0.035527,0.000000,0.313639,0.035527,0.000000,0.399127,0.035527,0.000000,0.447977,0.104361,0.000000,0.497382,0.173751,0.000000,0.497382,0.293655,0.000000,0.497382,0.421887,0.000000,0.447422,0.495162,0.000000,0.397462,0.568437,0.000000,0.311419,0.568437,0.000000,0.829895,0.461855,0.000000,0.815462,0.440760,0.000000,0.808801,0.426327,0.000000,0.802695,0.412450,0.000000,0.802695,0.403013,0.000000,0.802695,0.399682,0.000000,0.803805,0.393576,0.000000,0.805470,0.387469,0.000000,0.809911,0.373037,0.000000,0.890958,0.102141,0.000000,1.004756,0.461855,0.000000,1.043614,0.461855,0.000000,1.160188,0.096035,0.000000,1.236239,0.374702,0.000000,1.239569,0.386914,0.000000,1.241235,0.396906,0.000000,1.243455,0.406898,0.000000,1.243455,0.412450,0.000000,1.243455,0.421331,0.000000,1.237904,0.432989,0.000000,1.232353,0.445201,0.000000,1.220140,0.461855,0.000000,1.350037,0.461855,0.000000,1.311179,0.420221,0.000000,1.278982,0.332513,0.000000,1.278982,0.331958,0.000000,1.160188,0.000000,0.000000,1.112448,0.000000,0.000000,1.005866,0.330293,0.000000,0.899284,0.000000,0.000000,0.847104,0.000000,0.000000,0.710546,0.362489,0.000000,0.710546,0.363044,0.000000,0.690562,0.416891,0.000000,0.639491,0.461855,0.000000,1.477713,0.248691,0.000000,1.477713,0.245915,0.000000,1.477713,0.137668,0.000000,1.524343,0.086598,0.000000,1.570972,0.035527,0.000000,1.670338,0.035527,0.000000,1.691987,0.035527,0.000000,1.715857,0.038858,0.000000,1.740282,0.042189,0.000000,1.761931,0.048295,0.000000,1.730290,0.021094,0.000000,1.686436,0.010547,0.000000,1.643137,0.000000,0.000000,1.590401,0.000000,0.000000,1.501028,0.000000,0.000000,1.443296,0.053291,0.000000,1.385564,0.106582,0.000000,1.385564,0.215384,0.000000,1.385564,0.269230,0.000000,1.400552,0.312529,0.000000,1.416095,0.355828,0.000000,1.446072,0.390245,0.000000,1.477158,0.424107,0.000000,1.515461,0.442981,0.000000,1.553764,0.461855,0.000000,1.593732,0.461855,0.000000,1.674779,0.461855,0.000000,1.718077,0.407454,0.000000,1.761931,0.353052,0.000000,1.761931,0.248691,0.000000,1.669783,0.363044,0.000000,1.648133,0.394686,0.000000,1.627039,0.426327,0.000000,1.584850,0.426327,0.000000,1.537110,0.426327,0.000000,1.507134,0.386914,0.000000,1.477713,0.347501,0.000000,1.477713,0.275336,0.000000,1.669783,0.300317,0.000000,1.975095,0.429658,0.000000,2.010623,0.446867,0.000000,2.035603,0.454083,0.000000,2.061138,0.461855,0.000000,2.083342,0.461855,0.000000,2.089449,0.461855,0.000000,2.097775,0.460745,0.000000,2.106657,0.459634,0.000000,2.117204,0.457414,0.000000,2.117204,0.385804,0.000000,2.096665,0.405788,0.000000,2.071685,0.415780,0.000000,2.046705,0.426327,0.000000,2.019504,0.426327,0.000000,2.007292,0.426327,0.000000,1.996189,0.426327,0.000000,1.985087,0.426327,0.000000,1.975095,0.422997,0.000000,1.975095,0.153767,0.000000,1.975095,0.100476,0.000000,1.982312,0.067169,0.000000,1.990083,0.034417,0.000000,2.006181,0.000000,0.000000,1.850195,0.000000,0.000000,1.867403,0.035527,0.000000,1.875175,0.068834,0.000000,1.882946,0.102696,0.000000,1.882946,0.154322,0.000000,1.882946,0.358048,0.000000,1.882946,0.386914,0.000000,1.874064,0.410784,0.000000,1.865738,0.435209,0.000000,1.847419,0.450197,0.000000,1.975095,0.465185,0.000000,2.294841,0.461855,0.000000,2.415856,0.461855,0.000000,2.415856,0.426327,0.000000,2.294841,0.426327,0.000000,2.294841,0.140999,0.000000,2.294841,0.073830,0.000000,2.312049,0.054401,0.000000,2.329258,0.035527,0.000000,2.379218,0.035527,0.000000,2.390875,0.035527,0.000000,2.406419,0.037193,0.000000,2.422517,0.038858,0.000000,2.451383,0.042189,0.000000,2.404753,0.020539,0.000000,2.373112,0.009992,0.000000,2.341470,0.000000,0.000000,2.308163,0.000000,0.000000,2.254873,0.000000,0.000000,2.228782,0.019429,0.000000,2.202692,0.038858,0.000000,2.202692,0.127676,0.000000,2.202692,0.426327,0.000000,2.131637,0.426327,0.000000,2.178822,0.462410,0.000000,2.221011,0.504043,0.000000,2.263754,0.546232,0.000000,2.294841,0.586755,0.000000,2.619027,0.461855,0.000000,2.606260,0.444091,0.000000,2.599598,0.430213,0.000000,2.593492,0.416891,0.000000,2.593492,0.405788,0.000000,2.593492,0.399127,0.000000,2.598488,0.382473,0.000000,2.599598,0.378033,0.000000,2.600153,0.376922,0.000000,2.690082,0.101031,0.000000,2.765577,0.377477,0.000000,2.768353,0.388025,0.000000,2.769463,0.396906,0.000000,2.771128,0.405788,0.000000,2.771128,0.411895,0.000000,2.771128,0.420776,0.000000,2.766132,0.432434,0.000000,2.761692,0.444091,0.000000,2.749479,0.461855,0.000000,2.877710,0.461855,0.000000,2.857171,0.441316,0.000000,2.841628,0.416335,0.000000,2.826640,0.391355,0.000000,2.813872,0.355273,0.000000,2.673984,-0.056067,0.000000,2.651779,-0.123790,0.000000,2.619582,-0.150436,0.000000,2.587386,-0.177636,0.000000,2.542977,-0.177636,0.000000,2.531319,-0.177636,0.000000,2.516886,-0.175971,0.000000,2.503008,-0.174861,0.000000,2.486910,-0.172085,0.000000,2.486910,-0.078271,0.000000,2.539091,-0.128231,0.000000,2.546307,-0.134338,0.000000,2.553524,-0.138223,0.000000,2.560740,-0.142109,0.000000,2.565736,-0.142109,0.000000,2.587386,-0.142109,0.000000,2.609590,-0.104361,0.000000,2.631795,-0.066614,0.000000,2.652889,0.005551,0.000000,2.525768,0.359159,0.000000,2.524658,0.360824,0.000000,2.522993,0.365820,0.000000,2.500788,0.426883,0.000000,2.451383,0.461855,0.000000,0.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000,-1.000000,0.000000,0.000000};
VRML_PolyRep pr = {0,225,0,cindex,coord,NULL,NULL,NULL,NULL,NULL,NULL};
memcpy(cindex,cindext,sizeof(cindex));
memcpy(coord,coordt,sizeof(coord));
return pr; }


float clamp(float f) {
    f = f - (int)f;
    if(f < 0) f = -f;
//    if(f < 0.3) f += 0.5;
    return f;
}

void display_polyrep(VRML_PolyRep pr) {
    glBegin(GL_TRIANGLES);
    for(int i = 0; i < pr.ntri*3; i++) {
	if(pr.colindex && pr.color) 
	    glColor4f(pr.color[pr.colindex[i]*3],pr.color[pr.colindex[i]*3+1],pr.color[pr.colindex[i]*3+2],0.5);
	else
	    glColor4f(clamp(pr.coord[pr.cindex[i]*3]),
		      clamp(pr.coord[pr.cindex[i]*3+1]),
		      clamp(pr.coord[pr.cindex[i]*3+2]),0.5);
	glVertex3fv(pr.coord+ pr.cindex[i]*3);
    }
    glEnd();
}
/*void getmatrix(GLdouble* mat) {
mat[0] = -0.731221;
mat[1] = 0.148913;
mat[2] = -0.665685;
mat[3] = 0.000000;
mat[4] = 0.664668;
mat[5] = -0.063910;
mat[6] = -0.744390;
mat[7] = 0.000000;
mat[8] = -0.153389;
mat[9] = -0.986775;
mat[10] = -0.052261;
mat[11] = 0.000000;
mat[12] = -0.017169;
mat[13] = 0.002585;
mat[14] = -0.225434;
mat[15] = 1.000000;
}

//COLLISION_IFS: ref1 (-0.017169 0.002585 -0.225434) (0.048021 -0.043701 0.015917)
*/
/*
void getmatrix(GLdouble* mat,struct pt trans) {
mat[0] = 0.680112;
mat[1] = 0.269340;
mat[2] = -0.681836;
mat[3] = 0.000000;
mat[4] = -0.702454;
mat[5] = -0.026701;
mat[6] = -0.711226;
mat[7] = 0.000000;
mat[8] = -0.209767;
mat[9] = 0.962674;
mat[10] = 0.171039;
mat[11] = 0.000000;
mat[12] = 0.691816+trans.x;
mat[13] = 0.179929+trans.y;
mat[14] = 1.286911+trans.z;
mat[15] = 1.000000;
}*/
/*
COLLISION_IFS: ref173 (0.686824 0.178589 1.267539) (-0.004988 -0.001324 0.001336)
COLLISION_IFS: ref174 (0.691816 0.179929 1.286911) (0.139200 -0.415191 -0.018517)
COLLISION_IFS: ref175 (0.552450 0.595075 1.305162) (0.000014 -0.000039 -0.000002)
*/
void getmatrix(GLdouble* mat,struct pt trans) {
mat[0] = 0.819553;
mat[1] = 0.053174;
mat[2] = -0.570529;
mat[3] = 0.000000;
mat[4] = -0.572030;
mat[5] = 0.133874;
mat[6] = -0.809233;
mat[7] = 0.000000;
mat[8] = 0.033350;
mat[9] = 0.989570;
mat[10] = 0.140134;
mat[11] = 0.000000;
mat[12] = 0.500680+trans.x;
mat[13] = -0.650880+trans.y;
mat[14] = 1.586645+trans.z;
mat[15] = 1.000000;
}
//COLLISION_IFS: ref0 (0.500680 -0.650880 1.586645) (0.117216 0.844841 0.247117)

/*
//ref405:
void getmatrix(GLdouble* mat,struct pt trans) {
mat[0] = 0.133220;
mat[1] = -0.032780;
mat[2] = -0.990541;
mat[3] = 0.000000;
mat[4] = -0.991071;
mat[5] = -0.009264;
mat[6] = -0.132988;
mat[7] = 0.000000;
mat[8] = -0.004814;
mat[9] = 0.999417;
mat[10] = -0.033724;
mat[11] = 0.000000;
mat[12] = 4.029228+trans.x;
mat[13] = -0.046689+trans.y;
mat[14] = 2.675783+trans.z;
mat[15] = 1.000000;
}
//COLLISION_IFS: ref405 (4.029228 -0.046689 2.675783) (-0.000919 0.000239 0.007211)
*/
void display(void)
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    GLUquadricObj* qo = gluNewQuadric();
    gluQuadricDrawStyle(qo,GLU_SILHOUETTE);

    double r = 0.25;
    double y1 = -2*1.6/3;
    double y2 = 1.6/3;
    double bradius;

    debugpts.clear();
    debugptsinfo.clear();
    debugsurface = 0;

    GLdouble mat[16] = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
    getmatrix(mat,pts[0]);

     
    polyrep = makepolyrep();//(pts[0],pts[1],pts[2],pts[3],pts[4]);
//    polyrep.ntri = min(polyrep.ntri,facemask);

    glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
    glPushMatrix();
    glMultMatrixd(mat);
    display_polyrep(polyrep);
    glPopMatrix();
    glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
    glPolygonMode(GL_BACK,GL_LINE);

    struct pt disp = planar_polyrep_disp(y1,y2,y1,r,polyrep,mat,0,pt(0,0,0));
    printf("disp = (%f,%f,%f)\n",disp.x,disp.y,disp.z);
 


    /* draw cylinder */
    glPushMatrix();
    glColor3f(0.4,0.4,0.4);
    glRotated(90,-1,0,0);
    glTranslatef(0,0,y1);
    gluCylinder(qo,r,r,y2-y1,32,1);
    glPopMatrix();


    displayhandles();
    displayaxis();

/*  draw transparent result */
//    glEnable(GL_BLEND);
    glEnable(GL_DEPTH_TEST);
//     glDisable(GL_DEPTH_TEST);
    glBlendFunc(GL_SRC_ALPHA,GL_ONE);
    glPushMatrix();
    glTranslatef(disp.x,disp.y,disp.z);
    glMultMatrixd(mat);
    display_polyrep(polyrep);
    glPopMatrix();

    glDisable(GL_BLEND);

    glFlush();
    gluDeleteQuadric(qo);
}















void reshape(int nw=0, int nh=0)
{
    static int w,h;
    if(nw) w = nw;
    if(nh) h = nh;
    glViewport(0, 0, (GLsizei) w, (GLsizei) h);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    if(perspective) {
	gluPerspective(60.0, (GLfloat) w/(GLfloat) h, 1.0, 30.0);
    } else
	glOrtho(-1,1,-1,1,-1000,1000);

    glMatrixMode(GL_MODELVIEW);
}

void keyboard (unsigned char key, int x, int y)
{
    GLdouble premat[16] = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
    GLdouble postmat[16] = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
    const GLdouble ident[16] = {1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1};
    static double speed = 0.2;
    static double rspeed = 5;
    static bool examine = true;

    if(examine) {
	memcpy(postmat,ident,sizeof(ident));
	glGetDoublev(GL_MODELVIEW_MATRIX,premat);
    }
    else {
	glGetDoublev(GL_MODELVIEW_MATRIX,postmat);
	memcpy(premat,ident,sizeof(ident));
    }
     

    switch (key) {
    case '=':
    case '+':
	activepts.resize(1);
	activepts[0] = (activepts[0]+1) % pts.size();
	break;
    case '.':
	activepts.push_back((activepts.back()+1) % pts.size());
	break;
    case '-':
	activepts.resize(1);
	activepts[0] = (activepts[0]-1) % pts.size();
	break;
    case '[':
	debugpt = (debugpt-1)%debugpts.size();
	cout << "debugpt=" << debugpt << endl;
	break;
    case ']':
	debugpt = (debugpt+1)%debugpts.size();
	cout << "debugpt=" << debugpt << endl;
	break;
    case '<':
	facemask = (facemask-1)%8;
	cout << "facemask=" << facemask << endl;
	break;
    case '>':
	facemask = (facemask+1)%8;
	cout << "facemask=" << facemask << endl;
	break;
    case 'x':
	slide = eslideplane(((int)(slide) +1) % 4);
	switch( slide ) {
	case pxy:
	    printf("sliding on xy axis\n");
	    break;
	case pyz:
	    printf("sliding on yz axis\n");
	    break;
	case pzx:
	    printf("sliding on zx axis\n");
	    break;
	case rot:
	    printf("rotating around pt#%d ('r' to change)\n",rotcenter);
	    break;
	}
	break;
    case 'r':
	if(activepts.size() > 0 )
	    rotcenter = activepts[0];
	printf("rotation center is now %d\n",rotcenter);
	break;
    case 'l':
	examine = !examine;
	printf(examine ? "switching to examine mode\n" : "switching to freelook mode\n");
	break;
    case 'p':
	perspective = !perspective;
	printf(perspective ? "perspecive view\n" : "orthogonal view ('/','*' for zooming)\n");
	reshape();
	break;
    case 'q':
    case 27:
	exit(0);
	break;
	  
    case '*':
	glLoadMatrixd(premat);
	glScalef(sqrt(2.),sqrt(2.),sqrt(2.));
	glMultMatrixd(postmat);
	break;
    case '/':
	glLoadMatrixd(premat);
	glScalef(sqrt(2.)/2,sqrt(2.)/2,sqrt(2.)/2);
	glMultMatrixd(postmat);
	break;
    case 'd':
	glLoadMatrixd(premat);
	glTranslatef(0,0,speed);
	glMultMatrixd(postmat);
	break;
    case 'c':
	glLoadMatrixd(premat);
	glTranslatef(0,0,-speed);
	glMultMatrixd(postmat);
	break;
    case 'a':
	glLoadMatrixd(premat);
	glTranslatef(speed,0,0);
	glMultMatrixd(postmat);
	break;
    case 's':
	glLoadMatrixd(premat);
	glTranslatef(-speed,0,0);
	glMultMatrixd(postmat);
	break;
    case 'f':
	glLoadMatrixd(premat);
	glTranslatef(0,-speed,0);
	glMultMatrixd(postmat);
	break;
    case 'v':
	glLoadMatrixd(premat);
	glTranslatef(0,speed,0);
	glMultMatrixd(postmat);
	break;
    case '4':
	glLoadMatrixd(premat);
	glRotatef(rspeed,0,-1,0);
	glMultMatrixd(postmat);
	break;
    case '6':
	glLoadMatrixd(premat);
	glRotatef(rspeed,0,1,0);
	glMultMatrixd(postmat);
	break;
    case '8':
	glLoadMatrixd(premat);
	glRotatef(rspeed,1,0,0);
	glMultMatrixd(postmat);
	break;
    case '5':
    case '2':
	glLoadMatrixd(premat);
	glRotatef(rspeed,-1,0,0);
	glMultMatrixd(postmat);
	break;
    case '7':
	glLoadMatrixd(premat);
	glRotatef(rspeed,0,0,-1);
	glMultMatrixd(postmat);
	break;
    case '9':
	glLoadMatrixd(premat);
	glRotatef(rspeed,0,0,1);
	glMultMatrixd(postmat);
	break;
	  
	  


	  

    default:
	break;
    }
    glutPostRedisplay();
}


void mouse (int button, int state, int x, int y){
	
    static int ox,oy;
    static double scale = 0.01;	
    static double rscale = 0.01;

    y = -y;

    printf("button=%d, state=%d, (%d,%d)\n",button,state,x,y);

    if(button == GLUT_LEFT_BUTTON && state == GLUT_DOWN) {
	ox = x;
	oy = y;	
    }
    if(button == GLUT_LEFT_BUTTON && state == GLUT_UP) {
	GLdouble mat[16];
	  
	if(rotcenter < pts.size() && slide == rot) {
	    GLdouble matr[16];
	    GLdouble matt1[16] = {1,0,0,0,0,1,0,0,0,0,1,0,pts[rotcenter].x,pts[rotcenter].y,pts[rotcenter].z };
	    GLdouble matt2[16] = {1,0,0,0,0,1,0,0,0,0,1,0,-pts[rotcenter].x,-pts[rotcenter].y,-pts[rotcenter].z };
	    matrotate(matr,(y-oy) *rscale, 1,0,0);
	    matmultiply(mat,matt1,matr);
	    matrotate(matr,(x-ox) *rscale, 0,1,0);
	    matmultiply(mat,mat,matr);
	    matmultiply(mat,mat,matt2);
	}
	for(vector<int>::iterator i = activepts.begin(); i != activepts.end(); i++) {
	    switch( slide ) {
	    case pxy:
		pts[*i].x += (x-ox) *scale;
		pts[*i].y += (y-oy) *scale;
		break;
	    case pyz:
		pts[*i].y += (x-ox) *scale;
		pts[*i].z += (y-oy) *scale;
		break;
	    case pzx:
		pts[*i].z += (x-ox) *scale;
		pts[*i].x += (y-oy) *scale;
		break;
	    case rot:
		transform(&pts[*i],&pts[*i],mat);
		break;
	    }
	       
	}
	glutPostRedisplay();
    }
}


int main(int argc, char** argv)
{
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB | GLUT_DEPTH);
    glutInitWindowSize(250, 250);
    glutInitWindowPosition(100, 100);
    glutCreateWindow(argv[0]);
    init();
    glutDisplayFunc(display);
    glutReshapeFunc(reshape);
    glutKeyboardFunc(keyboard);
    glutMouseFunc(mouse);
    glutMainLoop();
    return 0; 
}
