/*
 * Decompiled with CFR 0.152.
 */
package vrml.external.FreeWRLEAI;

import vrml.external.BrowserGlobals;
import vrml.external.FreeWRLEAI.EAIAsyncMessage;
import vrml.external.FreeWRLEAI.EAIAsyncQueue;
import vrml.external.FreeWRLEAI.WriterThreadObserver;
import vrml.external.field.EventOut;
import vrml.external.field.EventOutMFNode;
import vrml.external.field.EventOutSFBool;
import vrml.external.field.EventOutSFRotation;
import vrml.external.field.EventOutSFTime;
import vrml.external.field.EventOutSFVec3f;

public class EAIAsyncThread
extends Thread {
    private EAIAsyncQueue EAIMessages = new EAIAsyncQueue();
    private boolean running;
    private boolean timerSet;
    private long timeout;
    private static final long TIMEOUT = 100L;
    private WriterThreadObserver observer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                EAIAsyncMessage eAIAsyncMessage;
                EAIAsyncThread eAIAsyncThread = this;
                synchronized (eAIAsyncThread) {
                    this.wait(50L);
                }
                while ((eAIAsyncMessage = this.EAIMessages.dequeue()) != null) {
                    this.sendEAIAsyncMessage(eAIAsyncMessage);
                }
            }
            catch (InterruptedException interruptedException) {
                this.running = false;
            }
        }
    }

    public synchronized void send(String string, int n) {
        EAIAsyncMessage eAIAsyncMessage = new EAIAsyncMessage(string, n);
        this.EAIMessages.enqueue(eAIAsyncMessage);
        this.notify();
    }

    public synchronized void stopThread() {
        System.out.println("stopping EAIAsyncThread");
        this.running = false;
        this.notify();
    }

    private void sendEAIAsyncMessage(EAIAsyncMessage eAIAsyncMessage) {
        EventOut eventOut;
        float[] fArray = new float[4];
        boolean bl = false;
        if (BrowserGlobals.EVtype[eAIAsyncMessage.EventNumber] == 18) {
            eventOut = new EventOutSFVec3f();
        } else if (BrowserGlobals.EVtype[eAIAsyncMessage.EventNumber] == 12) {
            eventOut = new EventOutSFRotation();
        } else if (BrowserGlobals.EVtype[eAIAsyncMessage.EventNumber] == 11) {
            eventOut = new EventOutMFNode();
        } else if (BrowserGlobals.EVtype[eAIAsyncMessage.EventNumber] == 3) {
            eventOut = new EventOutSFTime();
        } else if (BrowserGlobals.EVtype[eAIAsyncMessage.EventNumber] == 1) {
            eventOut = new EventOutSFBool();
        } else {
            System.out.println(" EAIASyncThread: handling something funny here, " + BrowserGlobals.EVtype[eAIAsyncMessage.EventNumber]);
            eventOut = new EventOut();
        }
        eventOut.RLreturn = eAIAsyncMessage.value;
        if (BrowserGlobals.EVObserver[eAIAsyncMessage.EventNumber] != null) {
            BrowserGlobals.EVObserver[eAIAsyncMessage.EventNumber].callback(eventOut, 0.0, BrowserGlobals.EVObject[eAIAsyncMessage.EventNumber]);
        } else {
            System.out.println("WARNING - EAIAsyncThread.callback - thread callback null, discarding");
        }
    }
}

