/*
 * Decompiled with CFR 0.152.
 */
package vrml;

import java.io.UnsupportedEncodingException;
import vrml.BaseNode;

public class FWHelper {
    static String base64alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-.";
    static byte[] revBase64 = new byte[123];

    public static String base64encode(String string) {
        int n;
        byte[] byArray;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.toString());
        }
        StringBuffer stringBuffer = new StringBuffer((byArray.length + 2) / 3 * 4);
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2 - 2) {
            n = (byArray[n3] & 0xFF) << 16 | (byArray[n3 + 1] & 0xFF) << 8 | byArray[n3 + 2] & 0xFF;
            stringBuffer.append(base64alphabet.charAt(n >> 18)).append(base64alphabet.charAt(n >> 12 & 0x3F)).append(base64alphabet.charAt(n >> 6 & 0x3F)).append(base64alphabet.charAt(n & 0x3F));
            n3 += 3;
        }
        if (n3 < n2) {
            n = byArray[n3++] & 0xFF;
            stringBuffer.append(base64alphabet.charAt(n >> 2));
            if (n3 < n2) {
                n = (n << 8) + (byArray[n3++] & 0xFF);
                stringBuffer.append(base64alphabet.charAt(n >> 4 & 0x3F));
                stringBuffer.append(base64alphabet.charAt(n << 2 & 0x3F));
            } else {
                stringBuffer.append(base64alphabet.charAt(n << 4 & 0x3F));
                stringBuffer.append('=');
            }
            stringBuffer.append('=');
        }
        return stringBuffer.toString();
    }

    public static String base64decode(String string) {
        int n = string.length();
        if ((n & 3) != 0) {
            throw new IllegalArgumentException("Not Base64: " + string);
        }
        int n2 = string.indexOf(61, n - 3);
        int n3 = n2 == -1 ? 0 : n - n2;
        byte[] byArray = new byte[n / 4 * 3];
        int n4 = 0;
        while (n4 < n / 4) {
            int n5 = (revBase64[string.charAt(4 * n4)] << 18) + (revBase64[string.charAt(4 * n4 + 1)] << 12) + (revBase64[string.charAt(4 * n4 + 2)] << 6) + revBase64[string.charAt(4 * n4 + 3)];
            byArray[3 * n4 + 0] = (byte)(n5 >> 16);
            byArray[3 * n4 + 1] = (byte)(n5 >> 8);
            byArray[3 * n4 + 2] = (byte)n5;
            ++n4;
        }
        try {
            return new String(byArray, 0, byArray.length - n3, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(unsupportedEncodingException.toString());
        }
    }

    public static String quote(String string) {
        StringBuffer stringBuffer = new StringBuffer("\"");
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\u0000': {
                    stringBuffer.append("\\0");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                default: {
                    stringBuffer.append(string.charAt(n));
                }
            }
            ++n;
        }
        return stringBuffer.append("\"").toString();
    }

    public static String nodeToString(BaseNode baseNode) {
        return baseNode.getType() + "{" + "}";
    }

    static {
        int n = 0;
        while (n < 64) {
            FWHelper.revBase64[FWHelper.base64alphabet.charAt((int)n)] = (byte)n;
            ++n;
        }
    }
}

