#include <sys/time.h>

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

#include <math.h>
#include <string.h>

#include <pthread.h>
#include <sched.h>
#include <sys/mman.h>

#include "fweelin_core.h"
#include "fweelin_fluidsynth.h"
#include "fweelin_browser.h"

Browser::~Browser() {
  if (app != 0) {
    app->getEMG()->UnlistenEvent(this,0,T_EV_BrowserMoveToItem);
    app->getEMG()->UnlistenEvent(this,0,T_EV_BrowserSelectItem);
  }

  ClearAllItems(); 
};

void Browser::Setup(Fweelin *a, BrowserCallback *c) {
  app = a;
  callback = c;
  
  app->getEMG()->ListenEvent(this,0,T_EV_BrowserMoveToItem);
  app->getEMG()->ListenEvent(this,0,T_EV_BrowserSelectItem);
};

// Add divisions between browser items using the Compare function-
// whenever two neighbouring items have difference greater than maxdelta,
// a division is inserted. In browsing files, for example, this allows us
// to group files that where created close to one another in time
void Browser::AddDivisions(int maxdelta) {
  if (first != 0) {
    BrowserItem *cur = first;
    char go = 1;
    do {
      while (cur->next != 0 && cur->next->Compare(cur) < maxdelta) 
	cur = cur->next;
      if (cur->next != 0) {
	// Add a division between cur and cur->next
	BrowserItem *div = new BrowserDivision();
	div->prev = cur;
	div->next = cur->next;
	cur->next->prev = div;
	cur->next = div;

	cur = div->next;
      } else
	// Done
	go = 0;
    } while (go);
  }
};

void Browser::MoveTo(int adjust, int jumpadjust) {
  if (cur == 0)
    cur = first;

  if (cur != 0) {
    // Jump by jumpadjust
    int adjdir = (jumpadjust >= 0 ? 1 : -1),
      adjmag = (adjdir == 1 ? abs(jumpadjust) : abs(jumpadjust)+1);
    BrowserItem *prev = cur;
    for (int i = 0; cur != 0 && i < adjmag; i++) {
      prev = cur;

      while (cur != 0 && cur->GetType() != B_Division) 
	cur = (adjdir == 1 ? cur->next : cur->prev);
      if (cur != 0)
	// We are on the division, skip over it which way?
	cur = (adjdir == 1 || i+1 >= adjmag ? cur->next : cur->prev);
      if (cur == 0) {
	if (adjdir == -1 && i+1 >= adjmag) {
	  // Going back to beginning of list
	  cur = first;
	} else
	  // Went too far, go back
	  cur = prev;
      }
    }

    // Move by adjust
    adjdir = (adjust >= 0 ? 1 : -1);
    adjmag = abs(adjust);
    for (int i = 0; cur != 0 && i < adjmag; i++) {
      prev = cur;
      cur = (adjdir == 1 ? cur->next : cur->prev);
      if (cur != 0 && cur->GetType() == B_Division)
	i--; // Don't count divisions
    }
    if (cur == 0)
      cur = prev;
  } else {
    printf("BROWSER: No elements to move to for browser '%s'\n",
	   GetTypeName(GetType()));
  }

  if (cur != 0 && callback != 0)
    callback->ItemBrowsed(cur);
};

void Browser::Select() {
  if (cur != 0 && callback != 0)
    callback->ItemSelected(cur);
};

void Browser::ReceiveEvent(Event *ev, EventProducer *from) {
  switch (ev->GetType()) {
  case T_EV_BrowserMoveToItem :
    {
      BrowserMoveToItemEvent *bev = (BrowserMoveToItemEvent *) ev;
      
      // Meant for this browser?
      if (bev->browserid == id) {
	if (CRITTERS)
	  printf("BROWSER: Received BrowserMoveToItem "
		 "(browser id: %d, adjust: %d, jumpadjust: %d)\n",
		 bev->browserid, bev->adjust, bev->jumpadjust);
	
	MoveTo(bev->adjust, bev->jumpadjust);
      }
    }
    break;

  case T_EV_BrowserSelectItem :
    {
      BrowserSelectItemEvent *bev = (BrowserSelectItemEvent *) ev;
      
      // Meant for this browser?
      if (bev->browserid == id) {
	if (CRITTERS)
	  printf("BROWSER: Received BrowserSelectItem\n");
	
	Select();
      }
    }
    break;

  default:
    break;
  }
}
