#ifndef __FWEELIN_AUDIOIO_H
#define __FWEELIN_AUDIOIO_H

extern "C"
{
#include <jack/jack.h>
}

typedef jack_default_audio_sample_t sample_t;
typedef jack_nframes_t nframes_t;

class Fweelin;
class Processor;

// **************** SYSTEM LEVEL AUDIO

class AudioIO {
public:
  AudioIO(Fweelin *app) : app(app) {};

  // Open up system level audio
  int open ();

  // Activate system level audio
  int activate (Processor *rp);

  // Close system level audio
  void close ();

  // Get realtime buffer size
  nframes_t getbufsz();

  // **Callbacks**

  // Realtime process function.. the beginning of the DSP chain
  static int process (nframes_t nframes, void *arg);
  
  // Sampling rate change callback
  static int srate_callback (nframes_t nframes, void *arg);

  // Callback for audio shutdown
  static void audio_shutdown (void *arg);

  // Get current sampling rate
  inline nframes_t get_srate() { return srate; };

  // Get approximate audio CPU load
  inline float GetAudioCPULoad() { return cpuload; };
  
  inline float GetTimeScale() { return timescale; };

  // Audio system client
  jack_client_t *client;

  // Inputs and outputs- stereo pairs
  jack_port_t **iport[2], **oport[2];

  float cpuload; // Current approximate audio CPU load
  float timescale; // fragment length/sample rate = length (s) of one fragment
  nframes_t srate; // Sampling rate

  // Pointer to the main app
  Fweelin *app;
  // Processor which is basically the root of the signal flow
  Processor *rp; 
};

#endif
