/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#ifndef _H_EVENT_
#define _H_EVENT_

/* Common area */

#include <config.h>

/*
 * Events
 */
#define EVENT_INCREASE_RESOLUTION SDLK_KP_PLUS
#define EVENT_DECREASE_RESOLUTION SDLK_KP_MINUS
#define EVENT_TOGGLE_FULLSCREEN   SDLK_TAB
#define EVENT_TOGGLE_MESSAGES     SDLK_m
#define EVENT_QUIT                SDLK_q


/* Global Functions */

/**
 * Init event handler. It will launch a thread that handle SDL events.
 *
 * @return 0 on success, -1 otherwise
 */
int event_init();

/**
 * Stop the event handler thread and clean up things.
 */
void event_quit();


#ifndef _C_EVENT_


#else // _C_EVENT_

/*
 * Local Area: use only in event.c 
 */

#include <SDL.h>
#include <SDL/SDL_ttf.h>
#include <SDL_thread.h>
#include <stdio.h>
#include <unistd.h>
#include <mpav.h>
#include <screen.h>
#include <render.h>

#define CHKINTERVAL 250000  /**< Interval between checks, in micro seconds */

/* Local Vars */
static SDL_Thread *event_thread = NULL; /**< event thread pointer */

/* Local functions */

/**
 * Function to be launched as thread. Handle SDL events
 */
void __event_thread_func();

#endif // _C_EVENT_

#endif // _H_EVENT_
