/*
 *  Freeplane - mind map editor
 *  Copyright (C) 2008 Dimitry Polivaev
 *
 *  This file author is Dimitry Polivaev
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.freeplane.core.undo;

import java.awt.event.ActionListener;

import javax.swing.event.ChangeListener;

public interface IUndoHandler {
	void addActor(IActor actor);

	boolean canRedo();

	boolean canUndo();

	void addChangeListener(ChangeListener listener);

	void removeChangeListener(ChangeListener listener);

	void commit();

	String getLastDescription();

	ActionListener getRedoAction();

	ActionListener getUndoAction();

	boolean isUndoActionRunning();

	void redo();

	public void resetRedo();

	void rollback();

	void startTransaction();

	void undo();

	void deactivate();

	public void delayedCommit();

	public void delayedRollback();
}
