/*
---------------------------------------------------------------------------
 $Id: log.c,v 1.4 2003/08/11 15:18:22 jfboud Exp $
---------------------------------------------------------------------------
Copyright (c) 2001-2003 Hexago Inc. All rights reserved.

     The contents of this file are subject to the Hexago
     Public License Version 1.0 (the "License"); you may not
     use this file except in compliance with the License.

     Software distributed under the License is distributed on
     an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either
     express or implied. See the License for the specific
     language governing rights and limitations under the
     License.

     The Original Code is _source code of the tunnel server
     protocol-client side_.

     The Initial Developer of the Original Code is Hexago .

     All Rights Reserved.

     Contributor(s): ______________________________________.

---------------------------------------------------------------------------
*/

#include <stdarg.h>
#include <stdio.h>
#include <time.h>
#include <syslog.h>

#define LOG_IT

#define TEST 0

#include "log.h"

static FILE *Logfp;
static char *Ident;

static int prio[] = {
  LOG_EMERG,
  LOG_ALERT,
  LOG_CRIT,
  LOG_ERR,
  LOG_WARNING,
  LOG_NOTICE,
  LOG_INFO,
  LOG_DEBUG
};

int LogInit(char *Identity, char *Filename)
{
  if ((Filename != NULL) && (strlen(Filename) > 0)) {

    if((Logfp = fopen(Filename, "a")) == NULL) {
      fprintf(stderr, "%s: LogInit: Cannot open log file %s\n", Identity, Filename);
      perror(Identity);
      return 1;
    }

    /* LogPrintf(ELInfo, "LogInit", "-------------------------------------\n"); */
    /* LogPrintf(ELInfo, "LogInit", "Log Start\n"); */

  } else {

    Logfp = NULL;
  }

  Ident = Identity;

  openlog(Identity, 0, 0);
  
  return 0;
}

void LogClose(void)
{
  if (Logfp != NULL) {
    fclose(Logfp);
    Logfp = NULL;
  }

  closelog();
}

int LogFPrintf(enum tErrorLevel ErrorLevel, char *FunctionName, char *Format, ...)
{
  va_list     argp;
  time_t      t;
  struct  tm *tm;

  va_start(argp, Format);

  if (Logfp != NULL) {

    t = time(NULL);
    tm = localtime(&t);

    fprintf(Logfp, 
	    "%04d/%02d/%02d %02d:%02d:%02d %s: %s: ",
	    (tm->tm_year+1900), 
	    (tm->tm_mon+1), 
	    tm->tm_mday,
	    tm->tm_hour, 
	    tm->tm_min, 
	    tm->tm_sec,
            Ident == NULL ? "" : Ident,
	    FunctionName == NULL ? "" : FunctionName);

    vfprintf(Logfp, Format, argp);

    fputs("\n", Logfp);

    fflush(Logfp);
  }

  va_end(argp);

  return 0;
}

int LogPrintf(enum tErrorLevel ErrorLevel, char *FunctionName, char *Format, ...)
{
  va_list     argp;
  time_t      t;
  struct  tm *tm;

  static char str[5000];
  static char fmt[5000];


  va_start(argp, Format);
  vsnprintf(fmt, sizeof fmt, Format, argp);
  va_end(argp);
  if (Logfp != NULL) {

    t = time(NULL);
    tm = localtime(&t);

    fprintf(Logfp, 
	    "%04d/%02d/%02d %02d:%02d:%02d %s: %s: ",
	    (tm->tm_year+1900), 
	    (tm->tm_mon+1), 
	    tm->tm_mday,
	    tm->tm_hour, 
	    tm->tm_min, 
	    tm->tm_sec,
            Ident == NULL ? "" : Ident,
	    FunctionName == NULL ? "" : FunctionName);

    fprintf(Logfp, fmt);

    fputs("\n", Logfp);

    fflush(Logfp);
  }

  snprintf(str, sizeof str,  " %s: %s", FunctionName, fmt);  

  syslog(prio[ErrorLevel], str);


  return 0;
}

int vLogPrintf(enum tErrorLevel ErrorLevel, char *FunctionName, char *Format, va_list argp)
{
  time_t      t;
  struct  tm *tm;

  static char str[5000];
  static char fmt[5000];

  vsnprintf(fmt, sizeof fmt, Format, argp);

  if (Logfp != NULL) {

    t = time(NULL);
    tm = localtime(&t);

    fprintf(Logfp, 
	    "%04d/%02d/%02d %02d:%02d:%02d %s: %s: ",
	    (tm->tm_year+1900), 
	    (tm->tm_mon+1), 
	    tm->tm_mday,
	    tm->tm_hour, 
	    tm->tm_min, 
	    tm->tm_sec,
            Ident == NULL ? "" : Ident,
	    FunctionName == NULL ? "" : FunctionName);

    fprintf(Logfp, fmt);

    fputs("\n", Logfp);

    fflush(Logfp);
  }

  snprintf(str, sizeof str, "%s : %s", FunctionName, Format);  

  syslog(prio[ErrorLevel], str);

  return 0;
}

#if TEST


main()
{
  LogInit("TestLog", "testlog.txt");
  LogPrintf(ELNotice, "main", "Petit test avec valeur = %d", 31);
  LogClose();
}

#endif

/*----- log.c -----------------------------------------------------------------------*/
