#!/usr/local/bin/freej -j
// freej script example by Mr.Goil
// this one can tile a seamless image and pan a plane with it
// $Id: $
kbd = new KeyboardController();
register_controller(kbd);
kbd.released_q = function() { quit(); }
geo = new GeometryLayer();
add_layer(geo);

w=geo.get_width();
h=geo.get_height();
padding=8;
max_tile_x=128;
max_tile_y=128;

echo("Geo: " + w + "x" + h); 
geo.rectangle_fill(0,0,w,h,0xff0000ff);

txt="";
echo("txt beginn");
try {
    txt = new TextLayer();
} catch (e) {
    echo("txt layer failed " + e);
    quit();
}
txt.size(12);
txt.font("/usr/share/fonts/truetype/freefont/FreeSans.ttf");
//txt.font("arial.ttf");
txt.print("lol");
add_layer(txt);
txt.set_position(padding, h-padding-12);
txt.up();

echo("img beginn");
//images = scandir("brain/cut/mjpeg");
images = scandir("brain/pics");

curr_img=0;
x=y=padding;

data = new Array();
nr=0;
for (img_nr = 0; img_nr < images.length; img_nr++) {
    d = new Object();
    i = 0;
    try {
        i = new ImageLayer(images[img_nr]);
    } catch (e) {
        echo("no IMG " + images[img_nr] + ": " + e);
    }
    try {
        i = new MovieLayer(images[img_nr]);
    } catch (e) {
        echo("no VID " + images[img_nr] + ": " + e);
    }
    if (!i) continue;

    iw = i.get_width();
    ih = i.get_height();

    scale = Math.min(max_tile_x / iw, max_tile_y / ih);
    echo("\nimg " + img_nr + " "+ images[img_nr] + " " + x + ":"+y + " "  + iw + "x" + ih + " scale " + scale);

    i.zoom(scale, scale);
    i.set_position(x, y);
    i.activate();
    add_layer(i);
    i.up();

    d.x = x; d.y = y; d.w = Math.floor(iw * scale); d.h = Math.floor(ih * scale);
    d.file = images[img_nr];
    d.layer = i;

    echo("nr: "+nr+" i:" + i);
    data[nr++] = d;

    x+= max_tile_x  + padding;
    if (x + max_tile_x > w) {
        x=padding;
        y+= max_tile_y + padding;
        if (y + max_tile_y > h) {
            echo("finish");
            break;
        }
    }
}
echo("img end" + data[2]);

sel_id = 0;
hi_img(data[sel_id]);

echo("end");

kbd.released_right = function() {
    sel_id += 1;
    if (sel_id > data.length - 1)
        sel_id=0;
    hi_img(data[sel_id]);
    echo("sel:"+sel_id);
}
kbd.released_left = function() {
    sel_id -= 1;
    if (sel_id < 0)
        sel_id = data.length - 1;
    hi_img(data[sel_id]);
    echo("sel:"+sel_id+"/"+data.length);
}

function hi_img(d) {
    geo.rectangle_fill(0,0,w,h,0x0000ffff);
    geo.rectangle_fill(
        d.x - padding/2, 
        d.y - padding/2,
        d.x + d.w + padding/2,
        d.y + d.h + padding/2,
        0x00ff00ff
    );
    txt.print(" " + d.file + " w:"+d.layer.get_width() + " h:" + d.layer.get_height() + " ");
}
echo("script end");
/*


max_m=Math.ceil(w/tile_x) * 2;
max_n=Math.ceil(h/tile_y) * 2;

i.open(images[curr_img]);
//images = scandir("/home/chris/Software/FREEJ/brain/uncut/Tesa interpol layer 3steps zwei");

imgs;
function init() {
    imgs = new Array();
    for (m=0; m<max_m; m++) {
        imgs[m] = new Array()
        for (n=0; n<max_n; n++) {
            i = new ImageLayer(tile_x,tile_y);
            i.open(images[curr_img]);
            add_layer(i);
            i.set_position(tile_x*m, tile_y*n);
            i.activate();
            imgs[m][n] = i;
            echo ("size " + i.get_width() + "x" + i.get_height() );
        }
    }
}
kbd = new KeyboardController();
register_controller(kbd);
kbd.released_q = function() { quit(); }
kbd.released_a = next_img;
kbd.released_z = prev_img;

function next_img() {
    //curr_img++;
    if (++curr_img>images.length-1)
        curr_img=0;
    //init();
    clean_up();
}

function prev_img () {
    //curr_img++;
    if (--curr_img<0)
        curr_img=images.length-1;
    //init();
    clean_up();
}
/*
dx=dy=0;
sx=sy=1;
bx = max_m * tile_x / 2;
by = max_n * tile_y / 2;

tr=new TriggerController();
register_controller(tr);
tr.frame = function() {
	for (m=0; m<max_m; m++) {
		for (n=0; n<max_n; n++) {
			i = imgs[m][n];
			i.set_position ( tile_x*m - dx, tile_y*n - dy);
//echo ( "set " + m  + "," + n + "to" + (tile_x*m - dx) + " " + (tile_y*n - dy) );
		}
	}
	dx += Math.floor(sx);
	dy += Math.floor(sy);
	dx = dx % bx
	dy = dy % by;
	if (dx < 0)
		dx += bx;
	if (dy < 0)
		dy += by;
    for (which=0; which <= last_js.length; which++) {
//echo("whch " + which);
        if (last_js[which]) {
            for (axis=0; axis <= (last_js[which]).length; axis++) {
//echo("axis " + axis);
                value = last_js[which][axis];
                if ((value) && (value !=0)) {
//echo("val " + last_js[which][axis]);
                       axismotion(which, axis, value); 
               }
            }
        }
    }
}

jc = new JoystickController();
register_controller(jc);

last_js = new Array();
jc.axismotion = function (which, axis, value) {
    value = value/100000; //equilaze
    //value = Math.floor(value/1000); //equilaze
    if(!last_js[which]) {
        last_js[which] = new Array();
    }
    last_js[which][axis] = value;
//    axismotion(which, axis, value);
}
jc.button = function (which, button, state) {
    if(state==1)
        switch (button) {
            case 6:
                prev_img();
            break;

            case 7:
                next_img();
            break;
    }
}

function axismotion(which, axis, value) {
    if (which==0) return;
//    if (which==0) value=-value;
    switch(axis) {
        case 0:
            sx -= value;
            break;
        case 1:
            sy -= value;
            break;
        case 3:
            g=data[1];
            g.sx += value;
            break;
        case 4:
            g=data[1];
            g.sy += value;
            break;

    }
    max_speed();
}
max_s=100;
function max_speed () {
    if (sx > max_s) sx=max_s;
    if (sx < -max_s) sx=-max_s;
    if (sy > max_s) sy=max_s;
    if (sy < -max_s) sy=-max_s;
}


function clean_up() {
	for (m=0; m<max_m; m++) {
		for (n=0; n<max_n; n++) {
			var i = imgs[m][n];
            i.open(images[curr_img]);
        }
    }
}


init();
*/
