/***************************************************************************
 *   Copyright (c) 2002 Jrgen Riegel (juergen.riegel@web.de)              *
 *                                                                         *
 *   This file is part of the FreeCAD CAx development system.              *
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Library General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2 of the License, or (at your option) any later version.      *
 *                                                                         *
 *   This library  is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Library General Public License for more details.                  *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this library; see the file COPYING.LIB. If not,    *
 *   write to the Free Software Foundation, Inc., 59 Temple Place,         *
 *   Suite 330, Boston, MA  02111-1307, USA                                *
 *                                                                         *
 ***************************************************************************/


#include "PreCompiled.h"
#ifndef _PreComp_
#endif

#include <Base/Exception.h>
#include <App/Document.h>
#include <Gui/Application.h>
#include <Gui/MainWindow.h>
#include <Gui/Command.h>
#include <Gui/FileDialog.h>


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
using Gui::FileDialog;

//===========================================================================
// Import_Box
//===========================================================================
DEF_STD_CMD_A(FCCmdImportReadBREP);

FCCmdImportReadBREP::FCCmdImportReadBREP()
   : Command("Import_ReadBREP")
{
    sAppModule      = "Import";
    sGroup          = "Import";
    sMenuText       = "Read BREP";
    sToolTipText    = "Read a BREP file";
    sWhatsThis      = sToolTipText;
    sStatusTip      = sToolTipText;
    sPixmap         = "Std_Tool1";
    iAccel          = 0;
}

void FCCmdImportReadBREP::activated(int iMsg)
{
    openCommand("Read BREP");
    QString fn = Gui::FileDialog::getOpenFileName(Gui::getMainWindow(), QString(), QString(), QLatin1String("BREP (*.brep *.rle)"));
    if (fn.isEmpty()) {
        abortCommand();
        return;
    }

    doCommand(Doc,"TopoShape = Import.ReadBREP(\"%s\")",(const char*)fn.toUtf8());
    commitCommand();
}

bool FCCmdImportReadBREP::isActive(void)
{
    return getGuiApplication()->activeDocument() != 0;
}

//===========================================================================
// PartImportStep
//===========================================================================
DEF_STD_CMD_A(ImportStep);

ImportStep::ImportStep()
  : Command("Part_ImportStep")
{
    sAppModule      = "Part";
    sGroup          = "Part";
    sMenuText       = "Import STEP";
    sToolTipText    = "Create or change a Import STEP feature";
    sWhatsThis      = sToolTipText;
    sStatusTip      = sToolTipText;
    sPixmap         = "Save";
    iAccel          = 0;
}


void ImportStep::activated(int iMsg)
{
    QString fn = Gui::FileDialog::getOpenFileName(Gui::getMainWindow(), QString(), QString(), QLatin1String("STEP (*.stp *.step)"));
    if (!fn.isEmpty()) {
        openCommand("Part ImportSTEP Create");
        doCommand(Doc,"f = App.document().addObject(\"ImportStep\",\"ImportStep\")");
        doCommand(Doc,"f.FileName = \"%s\"",(const char*)fn.toUtf8());
        commitCommand();
        updateActive();
    }
}

bool ImportStep::isActive(void)
{
    if (getActiveGuiDocument())
        return true;
    else
        return false;
}


//===========================================================================
// ImportIges
//===========================================================================
DEF_STD_CMD_A(ImportIges);

ImportIges::ImportIges()
  : Command("Import_Iges")
{
    sAppModule      = "Import";
    sGroup          = "Part";
    sMenuText       = "Import IGES";
    sToolTipText    = "Create or change a Import IGES feature";
    sWhatsThis      = sToolTipText;
    sStatusTip      = sToolTipText;
    sPixmap         = "Save";
    iAccel          = 0;
}

void ImportIges::activated(int iMsg)
{
    QString fn = Gui::FileDialog::getOpenFileName(Gui::getMainWindow(), QString(), QString(), QLatin1String("IGES (*.igs *.iges)"));
    if (!fn.isEmpty()) {
        openCommand("ImportIGES Create");
        doCommand(Doc,"f = App.document().addObject(\"ImportIges\",\"ImportIges\")");
        doCommand(Doc,"f.FileName = \"%s\"",(const char*)fn.toUtf8());
        commitCommand();
        updateActive();
    }
}

bool ImportIges::isActive(void)
{
    if (getActiveGuiDocument())
        return true;
    else
        return false;
}


void CreateImportCommands(void)
{
    Gui::CommandManager &rcCmdMgr = Gui::Application::Instance->commandManager();
    rcCmdMgr.addCommand(new FCCmdImportReadBREP());
}



