/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#define __REVERB_H

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif

#ifndef __MIX_H
  #include "mixer.h"
#endif

#ifndef __DELAY_H
 #include "delay.h"
#endif

#ifndef __ALL_PASS_H
 #include "all_pass.h"
#endif

#define NUM_COMBS 6 
typedef struct reverb{
  sample *(* get_buffer)(struct reverb *);
  void (*next_buffer)(struct reverb *);
  sample_producer **(*get_children)(struct reverb *);
  char **(*get_header)(struct reverb *);
  char **(*get_code)(struct reverb *);
  char **(*get_footer)(struct reverb *);
  all_pass *ap_2;
  sample_producer *unused; /* dummy to terminate list */
  sample_producer *input;
  all_pass* ap_1;
  mixer *comb_mixer;
  delay *combs[NUM_COMBS + 1];
}reverb;


reverb *reverb_new(sample_producer *input);
sample *reverb_get_buffer(reverb *this);
void reverb_next_buffer(reverb *this);


#define C1_INIT_D 11
#define C1_INIT_F (MAX_FEEDBACK * .8)
#define C2_INIT_D 13
#define C2_INIT_F (MAX_FEEDBACK * .8)
#define C3_INIT_D 17
#define C3_INIT_F (MAX_FEEDBACK * .8)
#define C4_INIT_D 19
#define C4_INIT_F (MAX_FEEDBACK * .8)
#define C5_INIT_D 23
#define C5_INIT_F (MAX_FEEDBACK * .8)
#define C6_INIT_D 29
#define C6_INIT_F (MAX_FEEDBACK * .8)

#define AP1_INIT_D 17
#define AP1_INIT_F (MAX_FEEDBACK * .8)
#define AP2_INIT_D 5
#define AP2_INIT_F (MAX_FEEDBACK * .8)



#define MAX_REVERB_DLY 75

/*
  Local Variables:
  mode: font-lock
  End:
*/
