/* FIGARO'S PASSWORD MANAGER (FPM)
 * Copyright (C) 2000 John Conneely
 * 
 * FPM is open source / free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * FPM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * gpg_trans.h
 * I use blowfish.c from GNU PG.  This header file is a hack to get it
 * to compile.
 */

#include <gtk/gtk.h>

/* From types.h: */
typedef guint32 u32; /* GPG used complex method to ensure 32 bit unsigned int.
		      * Since this is a gnome app, we can take use guint32!
		      */
typedef unsigned char byte;

/* From errors.h: */
#define G10ERR_SELFTEST_FAILED 50
#define G10ERR_WEAK_KEY       43

const char *
blowfish_get_info( int algo, size_t *keylen,
                   size_t *blocksize, size_t *contextsize,
                   int  (**setkeyf)( void *c, byte *key, unsigned keylen ),
                   void (**encryptf)( void *c, byte *outbuf, byte *inbuf ),
                   void (**decryptf)( void *c, byte *outbuf, byte *inbuf )
                 );

byte* md5(byte *buf, size_t nbytes);

size_t blowfish_contextsize(void);
