/********************************************************************************
*                                                                               *
*       S i n g l e - P r e c i s i o n   4 - E l e m e n t   V e c t o r       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1994,2004 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXVec4f.cpp,v 1.4 2004/02/08 17:29:07 fox Exp $                          *
********************************************************************************/
#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXObject.h"
#include "FXVec2f.h"
#include "FXVec3f.h"
#include "FXVec4f.h"

using namespace FX;

/*******************************************************************************/

namespace FX {

FXVec4f::FXVec4f(FXColor color){
  x=0.003921568627f*FXREDVAL(color);
  y=0.003921568627f*FXGREENVAL(color);
  z=0.003921568627f*FXBLUEVAL(color);
  w=0.003921568627f*FXALPHAVAL(color);
  }


FXVec4f& FXVec4f::operator=(FXColor color){
  x=0.003921568627f*FXREDVAL(color);
  y=0.003921568627f*FXGREENVAL(color);
  z=0.003921568627f*FXBLUEVAL(color);
  w=0.003921568627f*FXALPHAVAL(color);
  return *this;
  }


FXVec4f::operator FXColor() const {
  return FXRGBA((x*255.0f),(y*255.0f),(z*255.0f),(w*255.0f));
  }


FXVec4f normalize(const FXVec4f& a){
  register FXfloat t=len(a);
  if(t>0.0f){ return FXVec4f(a.x/t,a.y/t,a.z/t,a.w/t); }
  return FXVec4f(0.0f,0.0f,0.0f,0.0f);
  }


FXStream& operator<<(FXStream& store,const FXVec4f& v){
  store << v.x << v.y << v.z << v.w;
  return store;
  }

FXStream& operator>>(FXStream& store,FXVec4f& v){
  store >> v.x >> v.y >> v.z >> v.w;
  return store;
  }

}
