/*=====================| FluxConf | FluxKeys | FluxMenu |=======================
  
 A tool for Configuring the fluxbox window manager 

by Fabien Devaux
<fab@gcu.info>

Of course it's GPL
Don't blame me for the pure Gruik style please

***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/
/* XPM */
#include "dalogo.h"
#include "fc_menu.xpm"
#include "fc_conf.xpm"
#include "fc_keys.xpm"
#include<gtk/gtk.h>
#include<stdlib.h>              /* gentenv */
#include<string.h>              /* strcat */
#include<ctype.h>               /* toupper */
#include<stdio.h>
/* chmod */
#include <sys/types.h>
#include <sys/stat.h>
#include "actions.h"            /* actions for the Keys file */

#define NB 20 /* number of items */
#define KEYLEN 30
#define ACTLEN 30
#define EXELEN 200
#define MAXKEYCOUNT 100

#define MAXLINELEN 1024

#define MAXMENUDEPTH 10
/* STRUCTURE ABOUT WIDGETS :

   1) Spin (variable numrical values
   2) TRUE/FALSE buttons
   3) Multiple litteral choices
*/
#ifdef GTK2
GtkSizeGroup *size_group;
#endif

void makesplash(void);

#define QCM_START 7             /* first TRUE/FALSE position */
#define QCM_STOP 10             /* first NON TRUE/FALSE position */
#define LIT_START 16

struct {
    int val;
    char *value;
    int l;
    GtkWidget *wid;
} s[NB];

int nblignes;
GList *actlist = NULL;
GtkWidget *mainvbox;
char **msgs;

#include "spegtk2.h"

#define ERRFLUXKEYS _("\
Unable to write the key file\n\
Make a copy of the original file to a place you can write\n\
Please, run 'fluxconf' to change the location of this file to one you can write.\n")

/* change the screen for dual screen confs */

int fluxconf(int argc, char **argv,int );
int fluxmenu(int argc, char **argv, int);
int fluxkeys(int argc, char **argv, int);
void makeitems(char screen) {
    char *orig[] = {
        "session.screen0.tab.height",   /* first ;) */
        "session.screen0.tab.width",
        "session.screen0.edgeSnapThreshold",
        "session.screen0.toolbar.widthPercent",
        "session.screen0.workspaces",
        "session.autoRaiseDelay",
        "session.doubleClickInterval",
        "session.screen0.toolbar.onTop",    /* first TRUE/FALSE */
        "session.screen0.slit.onTop",
        "session.screen0.slit.autoHide",
        "session.screen0.slit.placement",   /* first QCM */
        "session.screen0.slit.direction",
        "session.screen0.rowPlacementDirection",
        "session.screen0.colPlacementDirection",
        "session.screen0.windowPlacement",
        "session.screen0.focusModel",
        "session.keyFile", /* first litteral */
        "session.menuFile",
        "session.styleFile",
        "session.screen0.strftimeFormat"
    };
    int n;
    msgs=malloc(sizeof(char*)*NB);
    for(n=0;n<NB;n++) {
        msgs[n]=malloc(sizeof(char)*(strlen(orig[n])+1));
        strcpy(msgs[n],orig[n]);
        if(!strncmp("session.screen0",msgs[n],15)) msgs[n][14]=screen;
    }
}
void checkptr(void *ptr)
{
    if (ptr == NULL) {
        g_print(_("No more memory :(\n"));
        exit(1);
    }
}

/* spinboxes maker */
GtkWidget *newparam(char *lbl, int val, int max, char *tipmsg, GtkTooltips * tips)
{
    GtkWidget *box, *label, *spin;
    GtkAdjustment *adj;

    box = gtk_hbox_new(FALSE, 5);
    label = gtk_label_new(lbl);
    gtk_misc_set_alignment(GTK_MISC(label),1.0,0.5);
    adj = (GtkAdjustment *) gtk_adjustment_new(val, /*value */
                                               0.0, /*lower */
                                               max, /*upper */
                                               1.0, /*step inc */
                                               5.0, /*page inc */
                                               5.0);    /*page size */
    spin = gtk_spin_button_new(adj, 0, 0);

    gtk_tooltips_set_tip(tips, spin, tipmsg, NULL);

    gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 1);
    gtk_box_pack_start(GTK_BOX(box), spin, FALSE, FALSE, 1);
    return box;
}

/* combobox maker */
GtkWidget *newchoice(char *lbl, char *val, GList * liste, char *tipmsg, GtkTooltips * tips)
{
    GtkWidget *box, *label, *combo;

    box = gtk_hbox_new(FALSE, 5);
    label = gtk_label_new(lbl);
    gtk_misc_set_alignment(GTK_MISC(label),1.0,0.5);
    combo = gtk_combo_new();
    gtk_combo_set_popdown_strings(GTK_COMBO(combo), liste);
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), val);
    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry), FALSE);

    gtk_tooltips_set_tip(tips, GTK_COMBO(combo)->entry, tipmsg, NULL);

#ifdef GTK2
    gtk_size_group_add_widget(size_group,combo);
#endif
    gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 1);
    gtk_box_pack_start(GTK_BOX(box), combo, FALSE, FALSE, 1);
    return box;
}

GtkWidget *newlitteral(char *lbl,char *val, char *tipmsg, GtkTooltips *tips)
{
    GtkWidget *box, *label, *entry;
    label=gtk_label_new(lbl);
    gtk_misc_set_alignment(GTK_MISC(label),1.0,0.5);
    box = gtk_hbox_new(FALSE, 5);
    entry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(entry),val);
    gtk_tooltips_set_tip(tips,entry,tipmsg,NULL);
#ifdef GTK2
    gtk_size_group_add_widget(size_group,entry);
#endif
    gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 1);
    gtk_box_pack_start(GTK_BOX(box), entry, FALSE, FALSE, 1);
    return box;
}

/* expands the given filename, possibly destroys old pointer */
char *expandFilename(char * filename) {
    /* if it starts with ~/, replace with $HOME */
    if (strncmp("~/",filename,2) == 0) {
        int homelen = strlen(getenv("HOME"));
        int len = strlen(filename) + homelen + 1;
        char * newname = malloc(/*filename,*/ len * sizeof(char));
        checkptr(newname);
        strncpy(newname,getenv("HOME"), homelen);
        strcpy(newname+homelen,filename+1);
        free(filename);
        return newname;
    } else {
        return filename;
    }
}



void superchmod(GtkButton * button)
{
    char *fullpath;
    fullpath = malloc(sizeof(char) * 100);
    sprintf(fullpath, "%s/.fluxbox/init", getenv("HOME"));
    chmod(fullpath, S_IRUSR | S_IWUSR);
    free(fullpath);
}

/* save the state */
void sauver(GtkButton * button, char **laliste)
{
    int n, x;
    char *fullpath;
    FILE *file;
    GList *widlist;
    GtkWidget *tmpwid, *smallwin;
#ifndef GTK2
    GtkWidget *smalllbl;
#endif
    GtkBoxChild *mome;
    fullpath = malloc(100 * sizeof(char));
    sprintf(fullpath, "%s/.fluxbox/init", getenv("HOME"));
    chmod(fullpath, S_IRUSR | S_IWUSR);
    file = fopen(fullpath, "r+");

    for (n = 0; n < nblignes + 1; n++) {    /* scan all lines */
        for (x = 0; x < NB; x++) {  /* if some of them correspond to a widget... */
            if (s[x].l == n) {
                if (x < QCM_START) {    /* if spinbut */
                    widlist = GTK_BOX(s[x].wid)->children;
                    mome = widlist->next->data;
                    tmpwid = mome->widget;
                    sprintf(laliste[n], "%s:\t%d\n", msgs[x],
                            gtk_spin_button_get_value_as_int((GtkSpinButton *) tmpwid));
                } else if (x > QCM_START - 1 && x < QCM_STOP) { /* if TRUE/FALSE */
                    sprintf(laliste[n], "%s:\t%s\n", msgs[x],
                            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(s[x].wid)) ? "true" :
                            "false");
                } else if(x<LIT_START) {        /* if QCM */
                    widlist = GTK_BOX(s[x].wid)->children;
                    mome = widlist->next->data;
                    tmpwid = mome->widget;
                    sprintf(laliste[n], "%s:\t%s\n", msgs[x],
                            gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(tmpwid)->entry)));
                }
                else { /* if Litteral entry */
                    widlist = GTK_BOX(s[x].wid)->children;
                    mome = widlist->next->data;
                    tmpwid = mome->widget;
                    sprintf(laliste[n],"%s:\t%s\n",msgs[x],
                            gtk_entry_get_text(GTK_ENTRY(tmpwid)));
 
                }
            }
        }
#ifdef DEBUG
        g_print("%s", laliste[n]);
#else
        fputs(laliste[n], file);
#endif
    }

    fclose(file);
    chmod(fullpath, S_IRUSR);
    free(fullpath);
#ifndef GTK2        
    smallwin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    smalllbl =
        gtk_label_new
        (_("Now you must restart fluxbox\n(using the root menu, not killing X).\nDon't forget to press \"Let fluxbox change the conf\" before exiting."));
    gtk_container_add(GTK_CONTAINER(smallwin), smalllbl);
    gtk_widget_set_usize(smallwin, 400, 100);
    gtk_label_set_line_wrap(GTK_LABEL(smalllbl), TRUE);
    gtk_widget_show_all(smallwin);
#else
    smallwin=gtk_message_dialog_new(NULL,GTK_DIALOG_DESTROY_WITH_PARENT,GTK_MESSAGE_WARNING,GTK_BUTTONS_CLOSE,_("Now you must restart fluxbox (using the root menu, not killing X). Don't forget to press \"Let fluxbox change the conf\" before exiting."));
    gtk_dialog_run(GTK_DIALOG(smallwin));
    gtk_widget_destroy(smallwin);
#endif
}

int show(GtkWidget * wid)
{
    gtk_widget_show_all(wid);
    return 0;
}

int hide(GtkWidget * wid)
{
    gtk_widget_hide(wid);
    return 0;
}

void makesplash(void)
{
#ifndef DEBUG
    GtkWidget *logowin, *popuplogo;
    GdkPixmap *logo;

    logowin = gtk_window_new(GTK_WINDOW_POPUP);
    gtk_widget_realize(logowin);
    logo = gdk_pixmap_create_from_xpm_d(logowin->window, NULL, NULL, fluxconf_xpm);
    popuplogo = gtk_pixmap_new(logo, NULL);
    gtk_container_add(GTK_CONTAINER(logowin), popuplogo);
    gtk_window_set_position(GTK_WINDOW(logowin), GTK_WIN_POS_CENTER);

    gtk_widget_show_all(logowin);
    gtk_timeout_add(100, (GtkFunction) show, logowin);  /* show the logo */
    gtk_timeout_add(3500, (GtkFunction) hide, logowin); /* hide the logo */
#endif
}


char *firstword(char *mot, int *offset)
{
    int deb, fin, len;
    char *final;

    len = strlen(mot);
    for (deb = 0; mot[deb] < 33; deb++);
    for (fin = deb + 1; mot[fin] > 32; fin++);
    final = (char *) malloc((fin - deb + 1) * sizeof(char));
    memset(final, 0, fin - deb + 1);
    strncpy(final, mot + deb, fin - deb);
    *offset = deb;
    return final;
}

char *getthings(char *mot, int *mod, char *thekey)
{
    char *rest;
    int x, max = 1, seek = 0;

    *mod = 0;
    rest = (char *) malloc(KEYLEN * sizeof(char));
    memset(thekey, 0, 10);

    for (max = 0; mot[max] != ':'; max++);  /* max is the last "before action" parameter */
    while (seek < max) {
        rest = firstword(mot + seek, &x);
/*		g_print("(%s)[%d]\n",rest,seek); */
        seek += x;
        seek += strlen(rest);
        if      (!strcasecmp(rest, "Control")) *mod |= 1;
        else if (!strcasecmp(rest, "Mod1"))    *mod |= 2;
        else if (!strcasecmp(rest, "Shift"))   *mod |= 4;
        else if (!strcasecmp(rest, "Mod4"))    *mod |= 8;
        else if (!strcasecmp(rest, "None"));
        else if (seek < max) {
            strncpy(thekey, rest, strlen(rest));
        }
    }
    free(rest);
    return mot + max + 1;
}
void start_it(GtkButton * button, char what)
{
    switch (what) {
        case 0:
            fluxconf(0,NULL,0);
            break;
        case 1:
            fluxkeys(0,NULL,0);
            break;
#ifdef GTK2
        case 2:
            fluxmenu(0,NULL,0);
            break;
#endif
    }
}

int fluxconf(int argc, char **argv, int standalone)
{
    GtkWidget *win, *vbox1, *vbox2, *mainhbox, *mainvbox, *title, *butbox, *but;
    GtkWidget *vsplit, *hsplit;
    GdkFont *head;
    GtkTooltips *tip;
    GList *items = NULL;
    char *initpath, *buf, **config;
    FILE *file;

#ifndef GTK2
    GtkStyle *monstyle;
#endif
    int i = 1, y;
    config = (char **) malloc(sizeof(char *));
    checkptr(config);
    gtk_init(&argc, &argv);

    /* A few changes to try to fix #148542, 
     * that is, anyway, obsoleted by the use of GTK2 in 0.8.x
     */
    head = gdk_font_load("-*-lucida-bold-i-*-*-*-180-*-*-*-*-*");
    if (!head)
      head = gdk_font_load("-*-helvetica-bold-i-*-*-*-180-*-*-*-*-*-*");
    /* end fix */

    buf = getenv("HOME");
    initpath = malloc(sizeof(char) * 200);
    sprintf(initpath, "%s/.fluxbox/init", buf);
    chmod(initpath, S_IRUSR | S_IWUSR);
    file = fopen(initpath, "r");
    if (file == NULL) {
        g_print("Can't open %s\n", initpath);
        exit(1);
    }
    buf = (char *) malloc(MAXLINELEN * sizeof(char));
    checkptr(buf);
/* get all lines */
    while (fgets(buf, MAXLINELEN, file)) {
        config = realloc(config, 1 + i * sizeof(char *));
        checkptr(config);
        config[i - 1] = (char *) malloc(30 + strlen(buf) * sizeof(char));   /* I get some unused space for bigger numbers, etc... */
        checkptr(config[i - 1]);
        strcpy(config[i - 1], buf);
        for (y = 0; y < NB; y++) {
            if (!strncmp(config[i - 1], msgs[y], strlen(msgs[y]))) {
/*				g_print("msg(%d)=%s",y,config[i-1]); */
                s[y].l = i - 1;
                if (y < QCM_START)
                    s[y].val = atoi(config[i - 1] + strlen(msgs[y]) + 2);   /* < 7 are spinboxes */
                else if (y > QCM_START - 1 && y < QCM_STOP) {   /* TRUE or FALSE */
                    if (toupper(config[i - 1][strlen(msgs[y]) + 2]) == 'F')
                        s[y].val = 0;
                    else
                        s[y].val = 1;
                } else if (y < LIT_START) {        /* multiple choice boxes */
                    s[y].value = (char *) malloc(30 * sizeof(char));
                    checkptr(s[y].value);
                    strncpy(s[y].value, config[i - 1] + strlen(msgs[y]) + 2,30);
                    s[y].value[strlen(s[y].value) - 1] = '\0';  /* del the "\n" */
                } else { /* Literals */
                    s[y].value = (char *) malloc((EXELEN + 1) * sizeof(char));
                    checkptr(s[y].value);
                    strncpy(s[y].value, config[i - 1] + strlen(msgs[y]) + 2,EXELEN+1);
                    s[y].value[strlen(s[y].value) - 1] = '\0';  /* del the "\n" */
                }
            }
        }
        i++;
    }
    fclose(file);
    free(initpath);
    nblignes = i - 2;

    tip = gtk_tooltips_new();   /* create the tooltip */
/* main win */
    win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(win), "Fluxbox Configuration Tool");

#ifndef GTK2
    title = gtk_label_new("Fluxbox Conf. Tool");
    if (head) {
        monstyle = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(title)));
        monstyle->font = head;
        gtk_widget_set_style(GTK_WIDGET(title), monstyle);
    }
#else
    title = gtk_label_new("<span size=\"18000\" weight=\"bold\">Fluxbox Configuration Tool</span>");
    gtk_label_set_use_markup(GTK_LABEL(title), TRUE);
#endif
    hsplit = gtk_hseparator_new();
    vsplit = gtk_vseparator_new();
    vbox1 = gtk_vbox_new(TRUE, 4);
    vbox2 = gtk_vbox_new(TRUE, 4);
    mainvbox = gtk_vbox_new(FALSE, 2);
    mainhbox = gtk_hbox_new(FALSE, 2);
    butbox = gtk_hbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(win), mainvbox);
    gtk_box_pack_start(GTK_BOX(mainvbox), title, FALSE, FALSE, 4);
    gtk_box_pack_start(GTK_BOX(mainvbox), mainhbox, FALSE, FALSE, 4);
    title = gtk_label_new(_("(*) is screen independant."));
    /* not working */
    gtk_label_set_justify(GTK_LABEL(title),GTK_JUSTIFY_RIGHT);
    gtk_box_pack_start(GTK_BOX(mainvbox), title, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(mainvbox), hsplit, FALSE, FALSE, 0); /* new */
    gtk_box_pack_start(GTK_BOX(mainvbox), butbox, FALSE, FALSE, 4);
    gtk_box_pack_start(GTK_BOX(mainhbox), vbox1, TRUE, FALSE, 4);
    gtk_box_pack_start(GTK_BOX(mainhbox), vsplit, TRUE, FALSE, 0);  /* new */
    gtk_box_pack_start(GTK_BOX(mainhbox), vbox2, TRUE, FALSE, 4);
    gtk_window_set_policy(GTK_WINDOW(win), 0, 0, 1);    /* user can't resize */
    gtk_signal_connect(GTK_OBJECT(win), "destroy", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
    gtk_container_set_border_width(GTK_CONTAINER(win), 5);
#ifdef GTK2
    size_group=gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
#endif
/* spinboxes */
    s[0].wid = newparam(_("Tab height"), s[0].val, 100, _("Set the tab's height"), tip);
    gtk_box_pack_start(GTK_BOX(vbox2), s[0].wid, FALSE, FALSE, 0);

    s[1].wid = newparam(_("Tab width"), s[1].val, 300, _("Set the tab's width"), tip);
    gtk_box_pack_start(GTK_BOX(vbox2), s[1].wid, FALSE, FALSE, 0);

    s[2].wid =
        newparam(_("Edges snap threshold"), s[2].val, 100, _("How many pixels will be magnetic"), tip);
    gtk_box_pack_start(GTK_BOX(vbox2), s[2].wid, FALSE, FALSE, 0);

    s[3].wid = newparam(_("Toolbar width (%)"), s[3].val, 100, _("Set the toolbar width"), tip);
    gtk_box_pack_start(GTK_BOX(vbox2), s[3].wid, FALSE, FALSE, 0);

    s[4].wid = newparam(_("Workspaces"), s[4].val, 1024, _("How many workspaces do you want"), tip);
    gtk_box_pack_start(GTK_BOX(vbox2), s[4].wid, FALSE, FALSE, 0);

    s[5].wid =
        newparam(_("Autoraise delay (*)"), s[5].val, 4000, _("Set the delay for windows to raise"), tip);
    gtk_box_pack_start(GTK_BOX(vbox2), s[5].wid, FALSE, FALSE, 0);

    s[6].wid = newparam(_("Double click interval (*)"), s[6].val, 2000, _("Hum... so explicit ;)"), tip);
    gtk_box_pack_start(GTK_BOX(vbox2), s[6].wid, FALSE, FALSE, 0);
/* TRUE FALSE stuffs */
    s[7].wid = gtk_toggle_button_new_with_label(_("Toolbar on top"));
    gtk_tooltips_set_tip(tip, s[7].wid, _("Toolbar will always stay on top"), NULL);
    if (s[7].val)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(s[7].wid), 1);
    gtk_box_pack_start(GTK_BOX(vbox2), s[7].wid, FALSE, FALSE, 0);

    s[8].wid = gtk_toggle_button_new_with_label(_("Slit on top"));
    gtk_tooltips_set_tip(tip, s[8].wid, _("The dockbar will stay on top"), NULL);
    if (s[8].val)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(s[8].wid), 1);
    gtk_box_pack_start(GTK_BOX(vbox2), s[8].wid, FALSE, FALSE, 0);

    s[9].wid = gtk_toggle_button_new_with_label(_("Slit auto hide"));
    gtk_tooltips_set_tip(tip, s[9].wid, _("The dockbar will autohide"), NULL);
    if (s[9].val)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(s[9].wid), 1);
    gtk_box_pack_start(GTK_BOX(vbox2), s[9].wid, FALSE, FALSE, 0);
/* Combobox */
    items = g_list_append(items, "TopLeft");
    items = g_list_append(items, "CenterLeft");
    items = g_list_append(items, "BottomLeft");
    items = g_list_append(items, "TopCenter");
    items = g_list_append(items, "BottomCenter");
    items = g_list_append(items, "TopRight");
    items = g_list_append(items, "BottomRight");
    items = g_list_append(items, "CenterRight");
    s[10].wid =
        newchoice(_("Slit placement"), s[10].value, items, _("Change the dockbar placement"), tip);
    gtk_box_pack_start(GTK_BOX(vbox1), s[10].wid, FALSE, FALSE, 0);
    items = NULL;

    items = g_list_append(items, "Horizontal");
    items = g_list_append(items, "Vertical");
    s[11].wid =
        newchoice(_("Slit direction"), s[11].value, items, _("Change the dockbar orientation"), tip);
    gtk_box_pack_start(GTK_BOX(vbox1), s[11].wid, FALSE, FALSE, 0);
    items = NULL;

items = g_list_append(items, "LeftToRight");
    items = g_list_append(items, "RightToLeft");
    s[12].wid =
        newchoice(_("Row direction"), s[12].value, items, _("Set the window placement direction"), tip);
    gtk_box_pack_start(GTK_BOX(vbox1), s[12].wid, FALSE, FALSE, 0);
    items = NULL;

    items = g_list_append(items, "TopToBottom");
    items = g_list_append(items, "BottomToTop");
    s[13].wid =
        newchoice(_("Col direction"), s[13].value, items, _("Set the window placement direction"), tip);
    gtk_box_pack_start(GTK_BOX(vbox1), s[13].wid, FALSE, FALSE, 0);
    items = NULL;

    items = g_list_append(items, "CascadePlacement");
    items = g_list_append(items, "ColSmartPlacement");
    items = g_list_append(items, "RowSmartPlacement");
    s[14].wid =
        newchoice(_("Window placement"), s[14].value, items, _("Change the way windows are placed"), tip);
    gtk_box_pack_start(GTK_BOX(vbox1), s[14].wid, FALSE, FALSE, 0);
    items = NULL;

    items = g_list_append(items, "AutoRaiseSloppyFocus");
    items = g_list_append(items, "SloppyFocus");
    items = g_list_append(items, "AutoRaiseSemiSloppyFocus");
    items = g_list_append(items, "SemiSloppyFocus");
    items = g_list_append(items, "ClickToFocus");
    s[15].wid = newchoice(_("Focus model"), s[15].value, items, _("Change the focus method"), tip);
    gtk_box_pack_start(GTK_BOX(vbox1), s[15].wid, FALSE, FALSE, 0);


    s[16].wid=newlitteral(_("Key file location (*)"),s[16].value,_("Change the location of the keybinds file"),tip);
    gtk_box_pack_start(GTK_BOX(vbox1), s[16].wid, FALSE, FALSE, 0);
    s[17].wid=newlitteral(_("Menu file location (*)"),s[17].value,_("Change the location of the menu file"),tip);
    gtk_box_pack_start(GTK_BOX(vbox1), s[17].wid, FALSE, FALSE, 0);
    s[18].wid=newlitteral(_("Theme file location (*)"),s[18].value,_("Change the location of the theme file"),tip);
    gtk_box_pack_start(GTK_BOX(vbox1), s[18].wid, FALSE, FALSE, 0);
    s[19].wid=newlitteral(_("Time format"),s[19].value,_("%y:year(YY)\n%Y:year(YYYY)\n%m:month\n%d:day\n%H:hour(24)\n%h:hour(12)\n%M:minutes\n%p:meridian"),tip);
    gtk_box_pack_start(GTK_BOX(vbox1), s[19].wid, FALSE, FALSE, 0);
        
    items = NULL;
/* some buttons */
    but = gtk_button_new_with_label(_("Save"));
    gtk_box_pack_start(GTK_BOX(butbox), but, TRUE, TRUE, 2);
    gtk_tooltips_set_tip(tip, but, _("Save the state, You'll need to RESTART fluxbox using the menu"),
                         NULL);
    gtk_signal_connect(GTK_OBJECT(but), "clicked", GTK_SIGNAL_FUNC(sauver), config);

    but = gtk_button_new_with_label(_("Let fluxbox change the conf"));
    gtk_box_pack_start(GTK_BOX(butbox), but, TRUE, TRUE, 2);
    gtk_tooltips_set_tip(tip, but, _("Once changes take effect, press this before quitting"), NULL);
    gtk_signal_connect(GTK_OBJECT(but), "clicked", GTK_SIGNAL_FUNC(superchmod), NULL);
/*
    but = gtk_button_new_with_label("Start fluxkeys");
    gtk_box_pack_start(GTK_BOX(butbox), but, TRUE, TRUE, 2);
    gtk_tooltips_set_tip(tip, but, "Start fluxkeys", NULL);
    gtk_signal_connect(GTK_OBJECT(but), "clicked", GTK_SIGNAL_FUNC(start_it), (gpointer) 1);
#ifdef GTK2
    but = gtk_button_new_with_label("Start fluxmenu");
    gtk_box_pack_start(GTK_BOX(butbox), but, TRUE, TRUE, 2);
    gtk_tooltips_set_tip(tip, but, "Start fluxmenu", NULL);
    gtk_signal_connect(GTK_OBJECT(but), "clicked", GTK_SIGNAL_FUNC(start_it), (gpointer)2);
#endif
*/

    if(standalone) {
        but = gtk_button_new_with_label("Quit");
        gtk_box_pack_start(GTK_BOX(butbox), but, FALSE, FALSE, 2);
        gtk_signal_connect(GTK_OBJECT(but), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
        gtk_tooltips_set_tip(tip, but, _("This one is useless...   ;)"), NULL);
        gtk_button_set_relief(GTK_BUTTON(but), GTK_RELIEF_NONE);
        makesplash();
    }
    gtk_widget_show_all(win);
    gtk_main();
    return 0;
}

void delkey(GtkButton *button, gpointer data)
{
    nblignes--;
    gtk_widget_destroy (data);
}

GtkWidget *newkey(int Ctrl, int Alt, int Shift, int Win, GList * liste, char *value, char *touche,
                  char *execcmd)
{
    GtkWidget *hbox, *m1, *m2, *m3,*m4, *combo, *entry, *key, *del;

    hbox = gtk_hbox_new(FALSE, 1);

    m1 = gtk_toggle_button_new_with_label("Control");
    m2 = gtk_toggle_button_new_with_label("Mod1");
    m3 = gtk_toggle_button_new_with_label("Shift");
    m4 = gtk_toggle_button_new_with_label("Mod4");

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m1), Ctrl);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m2), Alt);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m3), Shift);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(m4), Win);

    combo = gtk_combo_new();
    gtk_combo_set_popdown_strings(GTK_COMBO(combo), liste);
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), value);
    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry), FALSE);

    entry = gtk_entry_new_with_max_length(EXELEN);
    gtk_entry_set_text(GTK_ENTRY(entry), execcmd);
    key = gtk_entry_new_with_max_length(KEYLEN);
    gtk_entry_set_text(GTK_ENTRY(key), touche);

    del = gtk_button_new_with_label("Del");
    g_signal_connect (G_OBJECT(del), "clicked", G_CALLBACK(delkey), hbox);

    gtk_box_pack_start(GTK_BOX(hbox), m1, FALSE, FALSE, 1);
    gtk_box_pack_start(GTK_BOX(hbox), m2, FALSE, FALSE, 1);
    gtk_box_pack_start(GTK_BOX(hbox), m3, FALSE, FALSE, 1);
    gtk_box_pack_start(GTK_BOX(hbox), m4, FALSE, FALSE, 1);
    gtk_box_pack_start(GTK_BOX(hbox), key, FALSE, FALSE, 1);
    gtk_box_pack_start(GTK_BOX(hbox), combo, FALSE, FALSE, 1);
    gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 1);
    gtk_box_pack_start(GTK_BOX(hbox), del, FALSE, FALSE, 1);
    
    return hbox;

}

void savekeys(GtkButton * but, GtkBox ** boites)
{
    GtkBoxChild *child;
    GtkWidget *wid;
    int mod,n;
    char *initpath, *buf;

#ifdef GTK2
    G_CONST_RETURN gchar *key, *action, *execact;
#else
    gchar *key, *action, *execact;
#endif
    int x = 0;
    FILE *file;
    initpath = malloc(200 * sizeof(char));
    buf = malloc(200 * sizeof(char));

/* find the right file to open */
    sprintf(initpath, "%s/.fluxbox/init", getenv("HOME"));
    file=fopen(initpath,"r");
    if(file==NULL) {
        g_print(_("Can't open %s\n"), initpath);
        g_print(_("Make sure you installed fluxbox with this user.\n"));
        exit(1);
    }
    while(fgets(buf,200,file)) {
        if(!strncasecmp(buf,"session.keyFile:",strlen("session.keyFile:")))
        {
            for(n=strlen("session.keyFile:")+1;buf[n]<33;n++);
            buf[strlen(buf)-1]=0;
            strncpy(initpath,buf+n,200);
        }
    }
    fclose(file);
    free(buf);
    initpath = expandFilename(initpath);
    file = fopen(initpath, "w");
    if (file == NULL) {
        g_print(_("Can't open %s for writing\n"), initpath);
        g_print(ERRFLUXKEYS);
        exit(1);
    }

    /*
     * key= (char*)malloc(KEYLEN*sizeof(char));
     * action=  (char*)malloc(ACTLEN*sizeof(char));
     * execact=(char*)malloc(EXELEN*sizeof(char));
     */
#ifndef DEBUG
    fprintf(file, _("# File generated by FluxConf\n"));
#else
    g_print(_("# File generated by FluxConf\n"));
#endif
    for (x = 0; x < nblignes + 1; x++) {
        mod = 0;
        child = boites[x]->children->data;
        wid = child->widget;
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wid)))
            mod |= 1;
        child = boites[x]->children->next->data;
        wid = child->widget;
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wid)))
            mod |= 2;
        child = boites[x]->children->next->next->data;
        wid = child->widget;
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wid)))
            mod |= 4;
        child = boites[x]->children->next->next->next->data;
        wid = child->widget;
        if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(wid)))
            mod |= 8;
        /*
         * all modifiers are ok 
         */
        child = boites[x]->children->next->next->next->next->data;
        wid = child->widget;
          key = gtk_entry_get_text(GTK_ENTRY(wid)); /* get the key entry */
        child = boites[x]->children->next->next->next->next->next->data;
        wid = child->widget;
          action = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(wid)->entry));    /* get the action entry */
        child = boites[x]->children->next->next->next->next->next->next->data;
        wid = child->widget;
          execact = gtk_entry_get_text(GTK_ENTRY(wid)); /* get the exec action entry */
        if (strlen(key)) {
            if (!mod)
#ifndef DEBUG
                fprintf(file, "None ");
#else
                g_print("None ");
#endif
            else {
                if (mod & 1)
#ifndef DEBUG
                    fprintf(file, "Control ");
#else
                    g_print("Control ");
#endif
                if (mod & 2)
#ifndef DEBUG
                    fprintf(file, "Mod1 ");
#else
                    g_print("Mod1 ");
#endif
                if (mod & 4)
#ifndef DEBUG
                    fprintf(file, "Shift ");
#else
                    g_print("Shift ");
#endif

                if (mod & 8)
#ifndef DEBUG
                    fprintf(file, "Mod4 ");
#else
                    g_print("Mod4 ");
#endif
            }
#ifndef DEBUG
            fprintf(file, "%s ", key);
            fprintf(file, ":%s", action);
            if (!strcasecmp("ExecCommand", action))
                fprintf(file, " %s", execact);
            fprintf(file, "\n");
#else
            g_print("%s ", key);
            g_print(":%s", action);
            if (!strcasecmp("ExecCommand", action))
                g_print(" %s", execact);
            g_print("\n");
#endif
        }
    }
    fclose(file);
    free(initpath);
}

void addkey(GtkButton * but, GtkWidget ** boites)
{
    if (nblignes > MAXKEYCOUNT - 2)
        return;
    nblignes++;
    /*
     * boites=realloc(boites,(nblignes+1)*sizeof(GtkWidget*));
     */
    checkptr(boites);
    boites[nblignes] = newkey(FALSE, FALSE, FALSE,FALSE, actlist, "", "", "");
    gtk_box_pack_start(GTK_BOX(mainvbox), boites[nblignes], FALSE, FALSE, 0);
    gtk_widget_show_all(boites[nblignes]);
}
GtkWidget * CreateIco(GdkWindow *win, char *label,gchar **zexpm, char prog_number)
{
    GtkWidget *but,*vbox,*lbl,*wico;
    GdkPixmap *ico;

    but = gtk_button_new();
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(but),vbox);
    lbl=gtk_label_new(label);
    ico = gdk_pixmap_create_from_xpm_d(win, NULL, NULL, zexpm);
    wico = gtk_pixmap_new(ico, NULL);
    gtk_box_pack_start(GTK_BOX(vbox),wico,TRUE,TRUE,2);
    gtk_box_pack_start(GTK_BOX(vbox),lbl,TRUE,TRUE,2);
    gtk_signal_connect(GTK_OBJECT(but), "clicked", GTK_SIGNAL_FUNC(start_it), prog_number);
    return but;
}
int fluxbare(int argc, char **argv)
{
    GtkWidget *win,*butbox,*but;
    
    gtk_init(&argc,&argv);

    win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(win), "FluxConf launcher");
    butbox = gtk_hbox_new(FALSE, 2);

    gtk_container_add(GTK_CONTAINER(win), butbox);

    gtk_widget_realize(win);

    but=CreateIco(win->window,"fluxconf",fc_conf_xpm,0);
    gtk_box_pack_start(GTK_BOX(butbox), but, TRUE, TRUE, 2);
    but=CreateIco(win->window,"fluxkeys",fc_keys_xpm,1);
    gtk_box_pack_start(GTK_BOX(butbox), but, TRUE, TRUE, 2);
    but=CreateIco(win->window,"fluxmenu",fc_menu_xpm,2);
    gtk_box_pack_start(GTK_BOX(butbox), but, TRUE, TRUE, 2);

    gtk_signal_connect(GTK_OBJECT(win), "destroy", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

    gtk_widget_show_all(win);
    gtk_main();
    return 0;
}
int fluxkeys(int argc, char **argv,int standalone)
{
    GtkWidget *scrw, *pbox, *butbox, *win, *hsplit, *title, *but, **boxes;
    GdkFont *head;
    GtkTooltips *tip;
    char *initpath, *buf, **config, *touche, *tmp;
    FILE *file;

    /*
    void killme(GtkButton * button, GtkWidget *what) { gtk_widget_destroy(what); }
    */
#ifndef GTK2
    GtkStyle *monstyle;
#endif
    int i = 1,n, modifiers, x = 0;

    config = (char **) malloc(sizeof(char *));

    checkptr(config);

    gtk_init(&argc, &argv);
    tip = gtk_tooltips_new();   /* create the tooltip */

    initpath = malloc(sizeof(char) * EXELEN);
    
    /* A few changes to try to fix #148542, 
     * that is, anyway, obsoleted by the use of GTK2 in 0.8.x
     */
    head = gdk_font_load("-*-lucida-bold-i-*-*-*-180-*-*-*-*-*");
    if (!head)
      head = gdk_font_load("-*-helvetica-bold-i-*-*-*-180-*-*-*-*-*-*");
    /* end fix */

    buf = (char *) malloc((KEYLEN + ACTLEN + EXELEN) * sizeof(char));
    checkptr(buf);

/* find the right file to open */
    sprintf(initpath, "%s/.fluxbox/init", getenv("HOME"));
    file=fopen(initpath,"r");
    if(file==NULL) {
        g_print(_("Can't open %s\n"), initpath);
        g_print(_("Make sure you installed fluxbox with this user.\n"));
        exit(1);
    }
    while(fgets(buf,200,file)) {
        if(!strncasecmp(buf,"session.keyFile:",strlen("session.keyFile:")))
        {
            for(n=strlen("session.keyFile:")+1;buf[n]<33;n++);
            buf[strlen(buf)-1]=0;
            strncpy(initpath,buf+n,200);
        }
    }
    fclose(file);
    initpath = expandFilename(initpath);
    file = fopen(initpath, "r");
    if (file == NULL) {
        g_print(_("Can't open %s\n"), initpath);
        g_print(ERRFLUXKEYS);
        exit(1);
    }

    /*
     * read the config 
     */
    while (fgets(buf, KEYLEN+ACTLEN+EXELEN, file)) {
        config = realloc(config, (1 + i) * sizeof(char *));
        checkptr(config);
        config[i - 1] = (char *) malloc(10 + strlen(buf) * sizeof(char));
        checkptr(config[i - 1]);
        if (strlen(buf) > 10 && buf[0] != '#') {
            strcpy(config[i - 1], buf);
            i++;
        }
/* just stop operations if more than max lines */
        if (i > MAXKEYCOUNT)
            break;
    }
    fclose(file);
    free(initpath);
    nblignes = i - 2;

    boxes = (GtkWidget **) malloc(MAXKEYCOUNT * sizeof(GtkWidget *));
    for (i = 0; i < actnb; i++)
        actlist = g_list_append(actlist, actions[i]);

    win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(win), "Fluxbox Configuration Tool");
    gtk_window_set_default_size(GTK_WINDOW(win), 700, 500);
#ifndef GTK2
    title = gtk_label_new("Fluxbox Conf. Tool");
    if (head) {
        monstyle = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(title)));
        monstyle->font = head;
        gtk_widget_set_style(GTK_WIDGET(title), monstyle);
    }
#else
    title = gtk_label_new("<span size=\"18000\" weight=\"bold\">Fluxbox Configuration Tool</span>");
    gtk_label_set_use_markup(GTK_LABEL(title), TRUE);
#endif
    hsplit = gtk_hseparator_new();
    pbox = gtk_vbox_new(FALSE, 2);
    scrw = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrw),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    mainvbox = gtk_vbox_new(FALSE, 2);
    butbox = gtk_hbox_new(FALSE, 2);
    gtk_container_add(GTK_CONTAINER(win), pbox);
    gtk_box_pack_start(GTK_BOX(pbox), title, FALSE, FALSE, 4);
    gtk_box_pack_start(GTK_BOX(pbox), scrw, TRUE, TRUE, 4);
    gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrw), mainvbox);
/**********************************************************************/
    gtk_box_pack_end(GTK_BOX(pbox), butbox, FALSE, FALSE, 4); /* make it at end */

    but = gtk_button_new_with_label(_("Save"));
    gtk_box_pack_start(GTK_BOX(butbox), but, TRUE, TRUE, 2);
    gtk_signal_connect(GTK_OBJECT(but), "clicked", GTK_SIGNAL_FUNC(savekeys), boxes);

    but = gtk_button_new_with_label(_("Add"));
    gtk_box_pack_start(GTK_BOX(butbox), but, TRUE, TRUE, 2);
    gtk_signal_connect(GTK_OBJECT(but), "clicked", GTK_SIGNAL_FUNC(addkey), boxes);

    if(standalone) {
        but = gtk_button_new_with_label(_("Quit"));
        gtk_box_pack_start(GTK_BOX(butbox), but, FALSE, FALSE, 2);
        gtk_signal_connect(GTK_OBJECT(but), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), boxes);
        gtk_button_set_relief(GTK_BUTTON(but), GTK_RELIEF_NONE);
    }

/********************************************************************************************************/
    touche = (char *) malloc(KEYLEN * sizeof(char));    /* init the ptr */
    tmp = (char *) malloc(ACTLEN * sizeof(char));   /* init the ptr */
    checkptr(touche);
    for (i = 0; i < nblignes + 1; i++) {
        buf = getthings(config[i], &modifiers, touche);
        tmp = firstword(buf, &x);
        buf[strlen(buf) - 1] = '\0';    /* remove the \n */
        if (!strcasecmp(tmp, "ExecCommand")) {
            for (x = strlen(tmp); buf[x] < 33; x++);
            boxes[i] =
                newkey(modifiers & 1, modifiers & 2, modifiers & 4, modifiers & 8, actlist, tmp, touche, buf + x);
        } else
            boxes[i] =
                newkey(modifiers & 1, modifiers & 2, modifiers & 4, modifiers & 8, actlist, buf, touche, "");
        gtk_box_pack_start(GTK_BOX(mainvbox), boxes[i], FALSE, FALSE, 0);
    }

/********************************************************************************************************/


    gtk_signal_connect(GTK_OBJECT(win), "destroy", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

    gtk_widget_show_all(win);
    
    if(standalone) {
        makesplash();
    }
    gtk_main();
    return 0;
}

int main(int argc, char **argv)
{
    bindtextdomain("fluxconf",LOCALEDIR);
    textdomain("fluxconf");
    if(argc==2) {
        if(strlen(argv[1])==3) {
            if(argv[1][1]=='s' && argv[1][2]<='9' && argv[1][2]>='0') makeitems(argv[1][2]);
            else {
                fprintf(stderr,_("Syntax: %s [-sN]\nwhere N is the screen number. (default is 0)\n"),argv[0]);
                exit(1);
            }
        } else {
            fprintf(stderr,_("Syntax: %s [-sN]\nwhere N is the screen number. (default is 0)\n"),argv[0]);
            exit(1);
        }
    } else {
        makeitems('0');
    }
    if (!strcmp("fluxconf", argv[0] + strlen(argv[0]) - 8))
        fluxconf(argc, argv,1);
    else if (!strcmp("fluxkeys", argv[0] + strlen(argv[0]) - 8))
        fluxkeys(argc, argv,1);
#ifdef GTK2
    else if (!strcmp("fluxmenu", argv[0] + strlen(argv[0]) - 8))
        fluxmenu(argc, argv,1);
#endif
    else if (!strcmp("fluxbare", argv[0] + strlen(argv[0]) - 8))
        fluxbare(argc,argv);
    else
        g_print(_("Unknown executable name \"%s\" !\n"), argv[0]);
    return 0;
}
