/********************************************************************************
 *										*
 *		File		: configuration.h				*
 *										*
 *		Title		: Flink email monitoring applet for GNOME 2	*
 *										*
 *		Description	: Most configuration -(GConf)- related in here	*
 *										*
 *		Authors		: Marcus Leyman, 2002 <marcus@leyman.nu>	*
 *										*
 *		License		: GPL						*
 *										*
 *		Date		: 27 May 2002					*
 *										*
 ********************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <panel-applet.h>
/* Account structure, holds all account-specific configuration data */
typedef struct {
  gint		type;
  gchar		*title;
  gint		id;
  gchar		*hostname;
  gint		port;
  gchar		*username;
  gchar		*password;
  gchar		*path;
  gchar		*folder;
  gint		interval;	
  gint		new_mail;
  
  GError	*err;
} Account;

/* FlinkConfig structure, holds general configuration data */
typedef struct {
  gboolean		beep;
  gboolean		sound;
  gchar			*soundfile;
	
  gboolean 		ext_prog_run_auto;
  gchar			*ext_prog_file;
	
  gchar			*mail_file;
  gchar			*nomail_file;
  GError		*err;
  gint			accounts;
} FlinkConfig;

/* Flink structure, holds critical visual widgets */
typedef struct {
  PanelAppletOrient  	orientation;
  GtkWidget 		*applet;
  GtkWidget		*status_frame;
  GtkWidget		*status_table;
  GtkWidget		*status_indicator;
  GtkWidget		*status_image_nomail;
  GtkWidget		*status_image_mail;
  GtkWidget		*popup_menu;
} Flink;

/* FlinkTree structure, holds the configuration list in Preferences */
typedef struct {
  GtkListStore 		*model;
  GtkTreeViewColumn 	*column1;
  GtkTreeViewColumn	*column2;
  GtkTreeViewColumn	*column3;
  GtkCellRenderer 	*cell;
  GtkTreeSelection 	*selection;
} FlinkTree;



void flink_config_delete_account(Account *acc);

Account *flink_config_create_template_account();

void flink_config_add_new_account(Account *acc);

void flink_config_create_new_account(Account *acc);	

Account *flink_config_get_account_from_path(gchar *path);
