// SwiftAircraft.h - Class representing an aircraft generated by swift 
// 
// Copyright (C) 2019 - swift Project Community / Contributors (http://swift-project.org/)
// Adapted to Flightgear by Lars Toenning <dev@ltoenning.de>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#ifndef FGSWIFTAIRCRAFT_H
#define FGSWIFTAIRCRAFT_H
#pragma once
#include <osg/ref_ptr>
#include <string>

#include <simgear/constants.h>
#include <simgear/misc/sg_path.hxx>
#include <simgear/props/tiedpropertylist.hxx>
#include <simgear/scene/model/placement.hxx>
#include <simgear/sg_inlines.h>
#include <simgear/structure/SGReferenced.hxx>
#include <simgear/structure/SGSharedPtr.hxx>
#include <simgear/math/sg_geodesy.hxx>


namespace osg {
class PagedLOD;
}


class FGSwiftAircraft
{
public:
    FGSwiftAircraft(const std::string& callsign, const std::string& modelpath, SGPropertyNode_ptr p);
    bool updatePosition(SGGeod newPosition, SGVec3d orientation, double groundspeed, bool initPos);
    ~FGSwiftAircraft();
    std::string getName() { return _model->getName(); };
    double      getLatDeg() const;
    double      getLongDeg() const;
    double      getGroundElevation(const SGGeod& pos) const;
    double      getFudgeFactor() const;

private:
    bool initPos = false;
    SGGeod position;
    SGPropertyNode_ptr props;
    osg::ref_ptr<osg::Node> _model;
    SGModelPlacement aip;
	inline bool operator<(const std::string& extCallsign);
};
#endif