// NullFDM.hxx -- a do-nothing flight model, used as a placeholder if the
//                action is externally driven.
// Written by Curtis Olson, started November 1999.
//
// Copyright (C) 1999 - 2001  Curtis L. Olson  - curt@flightgear.org
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: NullFDM.cxx,v 1.3 2003/02/03 21:57:07 curt Exp $


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "NullFDM.hxx"


FGNullFDM::FGNullFDM( double dt ) {
//     set_delta_t( dt );
}


FGNullFDM::~FGNullFDM() {
}


// Initialize the NullFDM flight model, dt is the time increment
// for each subsequent iteration through the EOM
void FGNullFDM::init() {
    // cout << "FGNullFDM::init()" << endl;
    set_inited( true );
}


// Run an iteration of the EOM.  This is a NOP here because the flight
// model values are getting filled in elsewhere (most likely from some
// external source.)
void FGNullFDM::update( double dt ) {
    // cout << "FGNullFDM::update()" << endl;
}
