/*
 *  FL-COW by Davide Libenzi ( File Links Copy On Write )
 *  Copyright (C) 2003  Davide Libenzi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Davide Libenzi <davidel@xmailserver.org>
 *
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <time.h>



#define DUMMY_DATA1 "FLCOW Test Data Before"
#define DUMMY_DATA2 "FLCOW Test Data After"


static int create_file(char const *name, char const *data) {
	int fd;

	if ((fd = open(name, O_WRONLY | O_CREAT, 0666)) == -1) {
		perror(name);
		return -1;
	}
	write(fd, data, strlen(data));
	close(fd);

	return 0;
}



int main(int argc, char **argv) {
	struct stat stb1, stb2;
	char buf[512], name1[512], name2[512];

	getcwd(buf, sizeof(buf) - 1);
	setenv("FLCOW_PATH", buf, 1);

	sprintf(name1, ",,flcow-test1++.%u", getpid());
	if (create_file(name1, DUMMY_DATA1) < 0) {
		fprintf(stdout, "Test Result\t\t[ FAILED ]\n");
		return 1;
	}
	fprintf(stdout, "File Creation\t\t[ OK ]\n");

	sprintf(name2, ",,flcow-test2++.%u", getpid());
	if (link(name1, name2) < 0) {
		unlink(name1);
		fprintf(stdout, "Test Result\t\t[ FAILED ]\n");
		return 2;
	}
	fprintf(stdout, "Link Creation\t\t[ OK ]\n");

	stat(name1, &stb1);
	stat(name2, &stb2);
	if (stb1.st_nlink < 2 || stb2.st_nlink < 2) {
		unlink(name2);
		unlink(name1);
		fprintf(stdout, "Link Check\t\t[ FAILED ]\n");
		return 3;
	}
	fprintf(stdout, "Link Check\t\t[ OK ]\n");

	if (create_file(name1, DUMMY_DATA2) < 0) {
		unlink(name2);
		unlink(name1);
		fprintf(stdout, "File Rewrite\t\t[ FAILED ]\n");
		return 4;
	}
	fprintf(stdout, "File Rewrite\t\t[ OK ]\n");

	stat(name1, &stb1);
	stat(name2, &stb2);
	if (stb1.st_nlink > 1 || stb2.st_nlink > 1) {
		unlink(name2);
		unlink(name1);
		fprintf(stdout, "COW Check\t\t[ FAILED ]\n");
		return 5;
	}
	fprintf(stdout, "COW Check\t\t[ OK ]\n");

	unlink(name2);
	unlink(name1);

	fprintf(stdout, "Test Result\t\t[ OK ]\n");

	return 0;
}

